/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.KeyEventTranslator;

public abstract class EnhancedDialog
extends JDialog {
    protected KeyHandler keyHandler;
    protected boolean enterEnabled;

    protected EnhancedDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this._init();
    }

    protected EnhancedDialog(Dialog parent, String title, boolean modal) {
        super(parent, title, modal);
        this._init();
    }

    public boolean getEnterEnabled() {
        return this.enterEnabled;
    }

    public void setEnterEnabled(boolean enterEnabled) {
        this.enterEnabled = enterEnabled;
    }

    public abstract void ok();

    public abstract void cancel();

    private void _init() {
        this.getLayeredPane().addContainerListener(new ContainerHandler());
        this.getContentPane().addContainerListener(new ContainerHandler());
        this.keyHandler = new KeyHandler();
        this.addKeyListener(this.keyHandler);
        this.addWindowListener(new WindowHandler());
        this.setDefaultCloseOperation(0);
        this.enterEnabled = true;
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            EnhancedDialog.this.cancel();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            Component comp;
            if (evt.isConsumed()) {
                return;
            }
            if (evt.getKeyCode() == 10 && EnhancedDialog.this.enterEnabled) {
                for (comp = EnhancedDialog.this.getFocusOwner(); comp != null; comp = comp.getParent()) {
                    Object selected;
                    if (!(comp instanceof JComboBox)) continue;
                    JComboBox combo = (JComboBox)comp;
                    if (combo.isEditable() && (selected = combo.getEditor().getItem()) != null) {
                        combo.setSelectedItem(selected);
                    }
                    if (combo.isPopupVisible()) {
                        evt.consume();
                        combo.setPopupVisible(false);
                    }
                    return;
                }
                evt.consume();
                EnhancedDialog.this.ok();
            } else if (evt.getKeyCode() == 27 || this.isCloseBufferShortcut(evt)) {
                evt.consume();
                if (comp instanceof JComboBox) {
                    JComboBox combo = (JComboBox)comp;
                    if (combo.isPopupVisible()) {
                        combo.setPopupVisible(false);
                    } else {
                        EnhancedDialog.this.cancel();
                    }
                } else {
                    EnhancedDialog.this.cancel();
                }
            }
        }

        private boolean isCloseBufferShortcut(KeyEvent evt) {
            String shortcut = GUIUtilities.getShortcutLabel("close-buffer", false);
            if (shortcut == null) {
                return false;
            }
            String[] s = shortcut.split(" or ");
            if (s.length == 1) {
                if (s[0].contains(" ")) {
                    return false;
                }
                return KeyEventTranslator.parseKey(s[0]).equals(KeyEventTranslator.translateKeyEvent(evt));
            }
            boolean altmatch = false;
            boolean primarymatch = false;
            if (!s[0].contains(" ")) {
                primarymatch = KeyEventTranslator.parseKey(s[0]).equals(KeyEventTranslator.translateKeyEvent(evt));
            }
            if (!primarymatch && !s[1].contains(" ")) {
                altmatch = KeyEventTranslator.parseKey(s[1]).equals(KeyEventTranslator.translateKeyEvent(evt));
            }
            return primarymatch || altmatch;
        }
    }

    class ContainerHandler
    extends ContainerAdapter {
        ContainerHandler() {
        }

        @Override
        public void componentAdded(ContainerEvent evt) {
            this.componentAdded(evt.getChild());
        }

        @Override
        public void componentRemoved(ContainerEvent evt) {
            this.componentRemoved(evt.getChild());
        }

        private void componentAdded(Component comp) {
            comp.addKeyListener(EnhancedDialog.this.keyHandler);
            if (comp instanceof Container) {
                Component[] comps;
                Container cont = (Container)comp;
                cont.addContainerListener(this);
                for (Component comp1 : comps = cont.getComponents()) {
                    this.componentAdded(comp1);
                }
            }
        }

        private void componentRemoved(Component comp) {
            comp.removeKeyListener(EnhancedDialog.this.keyHandler);
            if (comp instanceof Container) {
                Component[] comps;
                Container cont = (Container)comp;
                cont.removeContainerListener(this);
                for (Component comp1 : comps = cont.getComponents()) {
                    this.componentRemoved(comp1);
                }
            }
        }
    }
}

