/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Bytes$;
import isabelle.Components;
import isabelle.Components$Archive$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Library$;
import isabelle.No_Progress$;
import isabelle.Options;
import isabelle.Options$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$Family$;
import isabelle.Progress;
import isabelle.SHA1$;
import isabelle.SSH;
import isabelle.SSH$;
import isabelle.SSH$Target$;
import isabelle.Url$;
import isabelle.Word$;
import isabelle.package$;
import java.io.File;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

public final class Components$ {
    public static Components$ MODULE$;
    private final Path default_components_base;
    private final Path components_sha1;
    private final List<String> relevant_options;
    private final Isabelle_Tool isabelle_tool;

    static {
        new Components$();
    }

    public Path default_components_base() {
        return this.default_components_base;
    }

    public Path admin(Path dir) {
        return dir.$plus(Path$.MODULE$.explode("Admin/components"));
    }

    public Path contrib(Path dir, String name) {
        return dir.$plus(Path$.MODULE$.explode("contrib")).$plus(Path$.MODULE$.explode(name));
    }

    public Path contrib$default$1() {
        return Path$.MODULE$.current();
    }

    public String contrib$default$2() {
        return "";
    }

    public String unpack(Path dir, Path archive, Progress progress) {
        String name = Components$Archive$.MODULE$.get_name(archive.file_name());
        progress.echo(new StringBuilder(10).append("Unpacking ").append(name).toString());
        Isabelle_System$.MODULE$.gnutar(new StringBuilder(5).append("-xzf ").append(File$.MODULE$.bash_path(archive)).toString(), dir, Isabelle_System$.MODULE$.gnutar$default$3(), Isabelle_System$.MODULE$.gnutar$default$4()).check();
        return name;
    }

    public Progress unpack$default$3() {
        return No_Progress$.MODULE$;
    }

    public void resolve(Path base_dir, List<String> names, Option<Path> target_dir, Option<Path> copy_dir, Progress progress) {
        Isabelle_System$.MODULE$.mkdirs(base_dir);
        names.foreach((Function1 & Serializable & scala.Serializable)name -> {
            String archive_name = Components$Archive$.MODULE$.apply((String)name);
            Path archive = base_dir.$plus(Path$.MODULE$.explode(archive_name));
            if (!archive.is_file()) {
                String remote = new StringBuilder(1).append(Isabelle_System$.MODULE$.getenv("ISABELLE_COMPONENT_REPOSITORY", Isabelle_System$.MODULE$.getenv$default$2())).append("/").append(archive_name).toString();
                progress.echo(new StringBuilder(8).append("Getting ").append(remote).toString());
                Bytes$.MODULE$.write(archive, Url$.MODULE$.read_bytes(Url$.MODULE$.apply(remote)));
            }
            copy_dir.foreach((Function1 & Serializable & scala.Serializable)dir -> {
                Components$.$anonfun$resolve$2(archive, dir);
                return BoxedUnit.UNIT;
            });
            return MODULE$.unpack((Path)target_dir.getOrElse((Function0 & Serializable & scala.Serializable)() -> base_dir), archive, progress);
        });
    }

    public Option<Path> resolve$default$3() {
        return None$.MODULE$;
    }

    public Option<Path> resolve$default$4() {
        return None$.MODULE$;
    }

    public Progress resolve$default$5() {
        return No_Progress$.MODULE$;
    }

    public void purge(Path dir, Enumeration.Value platform) {
        Set set;
        Enumeration.Value value = platform;
        Enumeration.Value value2 = Platform$Family$.MODULE$.linux();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            set = Components$.purge_platforms$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"darwin", "cygwin", "windows"}));
        } else {
            Enumeration.Value value4 = Platform$Family$.MODULE$.macos();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                set = Components$.purge_platforms$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"linux", "cygwin", "windows"}));
            } else {
                Enumeration.Value value6 = Platform$Family$.MODULE$.windows();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    set = Components$.purge_platforms$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"linux", "darwin"}));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        Set purge_set = set;
        File$.MODULE$.find_files(dir.file(), (Function1<File, Object>)(Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)Components$.$anonfun$purge$2(purge_set, file)), true, File$.MODULE$.find_files$default$4()).foreach((Function1 & Serializable & scala.Serializable)root -> {
            Isabelle_System$.MODULE$.rm_tree(root);
            return BoxedUnit.UNIT;
        });
    }

    public Path settings(Path dir) {
        return dir.$plus(Path$.MODULE$.explode("etc/settings"));
    }

    public Path settings$default$1() {
        return Path$.MODULE$.current();
    }

    public Path components(Path dir) {
        return dir.$plus(Path$.MODULE$.explode("etc/components"));
    }

    public Path components$default$1() {
        return Path$.MODULE$.current();
    }

    public boolean check_dir(Path dir) {
        return this.settings(dir).is_file() || this.components(dir).is_file();
    }

    public List<String> read_components(Path dir) {
        return (List)((TraversableLike)package$.MODULE$.split_lines().apply((Object)File$.MODULE$.read(this.components(dir)))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Components$.$anonfun$read_components$1(x$1)));
    }

    public void write_components(Path dir, List<String> lines) {
        File$.MODULE$.write(this.components(dir), (CharSequence)package$.MODULE$.terminate_lines().apply(lines));
    }

    public Path components_sha1() {
        return this.components_sha1;
    }

    public List<Components.SHA1_Digest> read_components_sha1(List<String> lines) {
        return (List)((List)package$.MODULE$.proper_list(lines).getOrElse((Function0 & Serializable & scala.Serializable)() -> (List)package$.MODULE$.split_lines().apply((Object)File$.MODULE$.read(MODULE$.components_sha1())))).flatMap((Function1 & Serializable & scala.Serializable)line -> {
            Iterable iterable;
            List<String> list = Word$.MODULE$.explode((String)line);
            if (Nil$.MODULE$.equals(list)) {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else {
                Some some = List$.MODULE$.unapplySeq(list);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    String sha1 = (String)((LinearSeqOptimized)some.get()).apply(0);
                    String name = (String)((LinearSeqOptimized)some.get()).apply(1);
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Components.SHA1_Digest(sha1, name)));
                } else {
                    iterable = (Iterable)package$.MODULE$.error().apply((Object)new StringBuilder(27).append("Bad components.sha1 entry: ").append(package$.MODULE$.quote().apply(line)).toString());
                }
            }
            return iterable;
        }, List$.MODULE$.canBuildFrom());
    }

    public List<String> read_components_sha1$default$1() {
        return Nil$.MODULE$;
    }

    public void write_components_sha1(List<Components.SHA1_Digest> entries) {
        File$.MODULE$.write(this.components_sha1(), (CharSequence)((TraversableOnce)entries.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.file_name(), (Ordering)Ordering.String$.MODULE$)).mkString("", "\n", "\n"));
    }

    public void build_components(Options options, List<Path> components, Progress progress, boolean publish, boolean force, boolean update_components_sha1) {
        List archives = (List)components.map((Function1 & Serializable & scala.Serializable)path -> {
            Path path2;
            String string = path.file_name();
            Option<String> option = Components$Archive$.MODULE$.unapply(string);
            if (!option.isEmpty()) {
                path2 = path;
            } else {
                Path path3;
                if (!path.is_dir()) {
                    path3 = (Path)package$.MODULE$.error().apply((Object)new StringBuilder(25).append("Bad component directory: ").append(path).toString());
                } else if (!MODULE$.check_dir((Path)path)) {
                    path3 = (Path)package$.MODULE$.error().apply((Object)new StringBuilder(49).append("Malformed component directory: ").append(path).append("\n  (requires ").append(MODULE$.settings(MODULE$.settings$default$1())).append(" or ").append(MODULE$.components(MODULE$.components$default$1())).append(")").toString());
                } else {
                    String archive_name;
                    Path component_path = path.expand();
                    Path archive_dir = component_path.dir();
                    Path archive = archive_dir.$plus(Path$.MODULE$.explode(archive_name = Components$Archive$.MODULE$.apply(string)));
                    Object object = archive.is_file() && !force ? package$.MODULE$.error().apply((Object)new StringBuilder(34).append("Component archive already exists: ").append(archive).toString()) : BoxedUnit.UNIT;
                    progress.echo(new StringBuilder(10).append("Packaging ").append(archive_name).toString());
                    Isabelle_System$.MODULE$.gnutar(new StringBuilder(6).append("-czf ").append(File$.MODULE$.bash_path(archive)).append(" ").append(Bash$.MODULE$.string(string)).toString(), archive_dir, Isabelle_System$.MODULE$.gnutar$default$3(), Isabelle_System$.MODULE$.gnutar$default$4()).check();
                    path3 = archive;
                }
                path2 = path3;
            }
            return path2;
        }, List$.MODULE$.canBuildFrom());
        if (publish && archives.nonEmpty() || update_components_sha1) {
            String string = options.string().apply("isabelle_components_server");
            Option<List<String>> option = SSH$Target$.MODULE$.unapplySeq(string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                String user = (String)((LinearSeqOptimized)option.get()).apply(0);
                String host = (String)((LinearSeqOptimized)option.get()).apply(1);
                BoxedUnit boxedUnit = (BoxedUnit)package$.MODULE$.using(SSH$.MODULE$.open_session(options, host, user, SSH$.MODULE$.open_session$default$4(), SSH$.MODULE$.open_session$default$5(), SSH$.MODULE$.open_session$default$6(), SSH$.MODULE$.open_session$default$7(), SSH$.MODULE$.open_session$default$8()), (Function1 & Serializable & scala.Serializable)ssh -> {
                    Components$.$anonfun$build_components$2(options, progress, publish, force, update_components_sha1, archives, ssh);
                    return BoxedUnit.UNIT;
                });
            } else {
                BoxedUnit boxedUnit = (BoxedUnit)package$.MODULE$.error().apply((Object)new StringBuilder(32).append("Bad isabelle_components_server: ").append(package$.MODULE$.quote().apply((Object)string)).toString());
            }
        }
        List new_entries = (List)archives.map((Function1 & Serializable & scala.Serializable)archive -> {
            String file_name = archive.file_name();
            progress.echo(new StringBuilder(16).append("Digesting local ").append(file_name).toString());
            String sha1 = SHA1$.MODULE$.digest((Path)archive).rep();
            return new Components.SHA1_Digest(sha1, file_name);
        }, List$.MODULE$.canBuildFrom());
        Set new_names = ((TraversableOnce)new_entries.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.file_name(), List$.MODULE$.canBuildFrom())).toSet();
        List list = new_entries;
        this.write_components_sha1((List<Components.SHA1_Digest>)((List)this.read_components_sha1(this.read_components_sha1$default$1()).filterNot((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)new_names.contains((Object)entry.file_name())))).$colon$colon$colon(list));
    }

    public Progress build_components$default$3() {
        return No_Progress$.MODULE$;
    }

    public boolean build_components$default$4() {
        return false;
    }

    public boolean build_components$default$5() {
        return false;
    }

    public boolean build_components$default$6() {
        return false;
    }

    private List<String> relevant_options() {
        return this.relevant_options;
    }

    public Isabelle_Tool isabelle_tool() {
        return this.isabelle_tool;
    }

    public static final /* synthetic */ void $anonfun$resolve$2(Path archive$2, Path dir) {
        Isabelle_System$.MODULE$.mkdirs(dir);
        File$.MODULE$.copy(archive$2, dir);
    }

    private static final Set purge_platforms$1(Seq platforms) {
        return (Set)((TraversableOnce)platforms.flatMap((Function1 & Serializable & scala.Serializable)name -> new .colon.colon((Object)new StringBuilder(4).append("x86-").append((String)name).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("x86_64_32-").append((String)name).toString(), (List)new .colon.colon((Object)new StringBuilder(7).append("x86_64-").append((String)name).toString(), (List)Nil$.MODULE$))), Seq$.MODULE$.canBuildFrom())).toSet().$plus((Object)"ppc-darwin");
    }

    public static final /* synthetic */ boolean $anonfun$purge$2(Set purge_set$1, File file) {
        return file.isDirectory() && purge_set$1.apply((Object)file.getName());
    }

    public static final /* synthetic */ boolean $anonfun$read_components$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$build_components$3(SSH.Session ssh$1, Path dir) {
        return !ssh$1.is_dir(dir);
    }

    public static final /* synthetic */ boolean $anonfun$build_components$6(String name$1, Path archive$3, Path tmp_dir) {
        Isabelle_System$.MODULE$.gnutar(new StringBuilder(5).append("-xzf ").append(File$.MODULE$.bash_path(archive$3)).toString(), tmp_dir, Isabelle_System$.MODULE$.gnutar$default$3(), Isabelle_System$.MODULE$.gnutar$default$4()).check();
        return MODULE$.check_dir(tmp_dir.$plus(Path$.MODULE$.explode(name$1)));
    }

    public static final /* synthetic */ boolean $anonfun$build_components$7(SSH.Dir_Entry entry) {
        return entry.is_file() && entry.name().endsWith(Components$Archive$.MODULE$.suffix());
    }

    public static final /* synthetic */ void $anonfun$build_components$2(Options options$1, Progress progress$2, boolean publish$1, boolean force$1, boolean update_components_sha1$1, List archives$1, SSH.Session ssh) {
        block1: {
            Path components_dir = Path$.MODULE$.explode(options$1.string().apply("isabelle_components_dir"));
            Path contrib_dir = Path$.MODULE$.explode(options$1.string().apply("isabelle_components_contrib_dir"));
            new .colon.colon((Object)components_dir, (List)new .colon.colon((Object)contrib_dir, (List)Nil$.MODULE$)).withFilter((Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)Components$.$anonfun$build_components$3(ssh, dir))).foreach((Function1 & Serializable & scala.Serializable)dir -> (Nothing$)package$.MODULE$.error().apply((Object)new StringBuilder(22).append("Bad remote directory: ").append(dir).toString()));
            if (publish$1) {
                archives$1.foreach((Function1 & Serializable & scala.Serializable)archive -> {
                    Object object;
                    String archive_name = archive.file_name();
                    String name = Components$Archive$.MODULE$.get_name(archive_name);
                    Path remote_component = components_dir.$plus(archive.base());
                    Path remote_contrib = contrib_dir.$plus(Path$.MODULE$.explode(name));
                    Object object2 = ssh.is_file(remote_component) && !force$1 ? package$.MODULE$.error().apply((Object)new StringBuilder(41).append("Remote component archive already exists: ").append(remote_component).toString()) : BoxedUnit.UNIT;
                    progress$2.echo(new StringBuilder(10).append("Uploading ").append(archive_name).toString());
                    ssh.write_file(remote_component, (Path)archive);
                    boolean is_standard_component = BoxesRunTime.unboxToBoolean(Isabelle_System$.MODULE$.with_tmp_dir("component", (Function1 & Serializable & scala.Serializable)tmp_dir -> BoxesRunTime.boxToBoolean((boolean)Components$.$anonfun$build_components$6(name, archive, tmp_dir))));
                    if (is_standard_component) {
                        Object object3;
                        if (ssh.is_dir(remote_contrib)) {
                            if (force$1) {
                                ssh.rm_tree(remote_contrib);
                                object3 = BoxedUnit.UNIT;
                            } else {
                                object3 = package$.MODULE$.error().apply((Object)new StringBuilder(43).append("Remote component directory already exists: ").append(remote_contrib).toString());
                            }
                        } else {
                            object3 = BoxedUnit.UNIT;
                        }
                        progress$2.echo(new StringBuilder(17).append("Unpacking remote ").append(archive_name).toString());
                        object = ssh.execute(new StringBuilder(13).append("tar -C ").append(ssh.bash_path(contrib_dir)).append(" -xzf ").append(ssh.bash_path(remote_component)).toString(), ssh.execute$default$2(), ssh.execute$default$3(), ssh.execute$default$4()).check();
                    } else {
                        progress$2.echo_warning(new StringBuilder(40).append("No unpacking of non-standard component: ").append(archive_name).toString());
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                });
            }
            if (!update_components_sha1$1) break block1;
            List lines = (List)ssh.read_dir(components_dir).withFilter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)Components$.$anonfun$build_components$7(entry))).map((Function1 & Serializable & scala.Serializable)entry -> {
                progress$2.echo(new StringBuilder(17).append("Digesting remote ").append(entry.name()).toString());
                return Library$.MODULE$.trim_line(ssh.execute(new StringBuilder(13).append("cd ").append(ssh.bash_path(components_dir)).append("; sha1sum ").append(Bash$.MODULE$.string(entry.name())).toString(), ssh.execute$default$2(), ssh.execute$default$3(), ssh.execute$default$4()).check().out());
            }, List$.MODULE$.canBuildFrom());
            MODULE$.write_components_sha1(MODULE$.read_components_sha1((List<String>)lines));
        }
    }

    private static final String show_options$1(ObjectRef options$2) {
        return (String)package$.MODULE$.cat_lines().apply(MODULE$.relevant_options().map((Function1 & Serializable & scala.Serializable)name -> ((Options.Opt)((Options)options$2.elem).options().apply(name)).print(), List$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ void $anonfun$isabelle_tool$1(List args) {
        BooleanRef publish = BooleanRef.create((boolean)false);
        BooleanRef update_components_sha1 = BooleanRef.create((boolean)false);
        BooleanRef force = BooleanRef.create((boolean)false);
        ObjectRef options = ObjectRef.create((Object)Options$.MODULE$.init(Options$.MODULE$.init$default$1(), Options$.MODULE$.init$default$2()));
        Getopts getopts = Getopts$.MODULE$.apply(new StringBuilder(476).append("\nUsage: isabelle build_components [OPTIONS] ARCHIVES... DIRS...\n\n  Options are:\n    -P           publish on SSH server (see options below)\n    -f           force: overwrite existing component archives and directories\n    -o OPTION    override Isabelle system OPTION (via NAME=VAL or NAME)\n    -u           update all SHA1 keys in Isabelle repository Admin/components\n\n  Build and publish Isabelle components as .tar.gz archives on SSH server,\n  depending on system options:\n\n").append(Library$.MODULE$.prefix_lines("  ", Components$.show_options$1(options))).append("\n").toString(), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"P"), (Function1 & Serializable & scala.Serializable)x$5 -> {
            publish.elem = true;
            return BoxedUnit.UNIT;
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f"), (Function1 & Serializable & scala.Serializable)x$6 -> {
            force.elem = true;
            return BoxedUnit.UNIT;
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"o:"), (Function1 & Serializable & scala.Serializable)arg -> {
            options.elem = ((Options)options.elem).$plus(arg);
            return BoxedUnit.UNIT;
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"u"), (Function1 & Serializable & scala.Serializable)x$7 -> {
            update_components_sha1.elem = true;
            return BoxedUnit.UNIT;
        })}));
        List<String> more_args = getopts.apply((List<String>)args);
        if (more_args.isEmpty() && !update_components_sha1.elem) {
            throw getopts.usage();
        }
        Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2());
        MODULE$.build_components((Options)options.elem, (List<Path>)((List)more_args.map((Function1 & Serializable & scala.Serializable)str -> Path$.MODULE$.explode((String)str), List$.MODULE$.canBuildFrom())), progress, publish.elem, force.elem, update_components_sha1.elem);
    }

    private Components$() {
        MODULE$ = this;
        this.default_components_base = Path$.MODULE$.explode("$ISABELLE_COMPONENTS_BASE");
        this.components_sha1 = Path$.MODULE$.explode("~~/Admin/components/components.sha1");
        this.relevant_options = new .colon.colon((Object)"isabelle_components_server", (List)new .colon.colon((Object)"isabelle_components_dir", (List)new .colon.colon((Object)"isabelle_components_contrib_dir", (List)Nil$.MODULE$)));
        this.isabelle_tool = new Isabelle_Tool("build_components", "build and publish Isabelle components", (Function1<List<String>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)args -> {
            Components$.$anonfun$isabelle_tool$1(args);
            return BoxedUnit.UNIT;
        });
    }
}

