/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Build_JDK;
import isabelle.Components$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.No_Progress$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.Process_Result;
import isabelle.Progress;
import isabelle.package$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class Build_JDK$ {
    public static Build_JDK$ MODULE$;
    private final List<Build_JDK.JDK_Platform> jdk_platforms;
    private final String settings;
    private final Isabelle_Tool isabelle_tool;

    static {
        new Build_JDK$();
    }

    public String detect_version(String s) {
        String version;
        String string;
        Regex Version_Dir_Entry = new StringOps(Predef$.MODULE$.augmentString("^jdk-([0-9.]+\\+\\d+)$")).r();
        Option option = Version_Dir_Entry.unapplySeq((CharSequence)(string = s));
        String string2 = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 ? (version = (String)((LinearSeqOptimized)option.get()).apply(0)) : (String)package$.MODULE$.error().apply((Object)new StringBuilder(31).append("Cannot detect JDK version from ").append(package$.MODULE$.quote().apply((Object)s)).toString());
        return string2;
    }

    public List<Build_JDK.JDK_Platform> jdk_platforms() {
        return this.jdk_platforms;
    }

    public String readme(String version) {
        return new StringBuilder(277).append("This is OpenJDK ").append(version).append(" as required for Isabelle.\n\nSee https://adoptopenjdk.net for the original downloads, which are covered\nthe GPL2 (with various liberal exceptions, see legal/*).\n\nLinux, Windows, Mac OS X all work uniformly, depending on certain\nplatform-specific subdirectories.\n").toString();
    }

    public String settings() {
        return this.settings;
    }

    private boolean suppress_name(String name) {
        return name.startsWith("._");
    }

    public Tuple2<String, Build_JDK.JDK_Platform> extract_archive(Path dir, Path archive) {
        Tuple2 tuple2;
        try {
            String s;
            Path tmp_dir = dir.$plus(Path$.MODULE$.explode("tmp"));
            Isabelle_System$.MODULE$.mkdirs(tmp_dir);
            String string = archive.get_ext();
            String string2 = "zip";
            Process_Result process_Result = !(string != null ? !string.equals(string2) : string2 != null) ? Isabelle_System$.MODULE$.bash(new StringBuilder(9).append("unzip -x ").append(File$.MODULE$.bash_path(archive.absolute())).toString(), tmp_dir.file(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9()).check() : Isabelle_System$.MODULE$.gnutar(new StringBuilder(5).append("-xzf ").append(File$.MODULE$.bash_path(archive)).toString(), tmp_dir, Isabelle_System$.MODULE$.gnutar$default$3(), Isabelle_System$.MODULE$.gnutar$default$4()).check();
            List list = (List)File$.MODULE$.read_dir(tmp_dir).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Build_JDK$.MODULE$.suppress_name(x$1)));
            Some some = List$.MODULE$.unapplySeq((Seq)list);
            String string3 = !some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 ? (s = (String)((LinearSeqOptimized)some.get()).apply(0)) : (String)package$.MODULE$.error().apply((Object)"Archive contains multiple directories");
            String dir_entry = string3;
            String version = this.detect_version(dir_entry);
            Path jdk_dir = tmp_dir.$plus(Path$.MODULE$.explode(dir_entry));
            Build_JDK.JDK_Platform platform = (Build_JDK.JDK_Platform)this.jdk_platforms().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.detect(jdk_dir))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)package$.MODULE$.error().apply((Object)"Failed to detect JDK platform"));
            Path platform_dir = dir.$plus(Path$.MODULE$.explode(platform.name()));
            Object object = platform_dir.is_dir() ? package$.MODULE$.error().apply((Object)new StringBuilder(26).append("Directory already exists: ").append(platform_dir).toString()) : BoxedUnit.UNIT;
            File$.MODULE$.link(Path$.MODULE$.current(), jdk_dir.$plus(Path$.MODULE$.explode(platform.home())).$plus(Path$.MODULE$.explode("jre")), File$.MODULE$.link$default$3());
            File$.MODULE$.move(jdk_dir, platform_dir);
            tuple2 = new Tuple2((Object)version, (Object)platform);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<String> option = package$.MODULE$.ERROR().unapply(throwable2);
            if (!option.isEmpty()) {
                String msg = (String)option.get();
                throw package$.MODULE$.cat_error((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{msg, new StringBuilder(32).append("The error(s) above occurred for ").append(archive).toString()}));
            }
            throw throwable;
        }
        return tuple2;
    }

    public void build_jdk(List<Path> archives, Progress progress, Path target_dir) {
        Object object = Platform$.MODULE$.is_windows() ? package$.MODULE$.error().apply((Object)"Cannot build jdk on Windows") : BoxedUnit.UNIT;
        Isabelle_System$.MODULE$.with_tmp_dir("jdk", (Function1 & Serializable & scala.Serializable)dir -> {
            String version;
            progress.echo("Extracting ...");
            List extracted = (List)archives.map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.extract_archive((Path)dir, (Path)x$3), List$.MODULE$.canBuildFrom());
            List list = ((TraversableOnce)extracted.map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4._1(), List$.MODULE$.canBuildFrom())).toSet().toList();
            Some some = List$.MODULE$.unapplySeq((Seq)list);
            String string = !some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 ? (version = (String)((LinearSeqOptimized)some.get()).apply(0)) : (Nil$.MODULE$.equals(list) ? (String)package$.MODULE$.error().apply((Object)"No archives") : (String)package$.MODULE$.error().apply((Object)new StringBuilder(40).append("Archives contain multiple JDK versions: ").append(package$.MODULE$.commas_quote().apply((Object)list)).toString()));
            String version2 = string;
            List missing_platforms = (List)MODULE$.jdk_platforms().filterNot((Function1 & Serializable & scala.Serializable)p1 -> BoxesRunTime.boxToBoolean((boolean)extracted.exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Build_JDK$.$anonfun$build_jdk$5(p1, x0$1)))));
            Object object = missing_platforms.nonEmpty() ? package$.MODULE$.error().apply((Object)new StringBuilder(19).append("Missing platforms: ").append(package$.MODULE$.commas_quote().apply(missing_platforms.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), List$.MODULE$.canBuildFrom()))).toString()) : BoxedUnit.UNIT;
            String jdk_name = new StringBuilder(4).append("jdk-").append(version2).toString();
            Path jdk_path = Path$.MODULE$.explode(jdk_name);
            Path component_dir = dir.$plus(jdk_path);
            Isabelle_System$.MODULE$.mkdirs(component_dir.$plus(Path$.MODULE$.explode("etc")));
            File$.MODULE$.write(Components$.MODULE$.settings(component_dir), (CharSequence)MODULE$.settings());
            File$.MODULE$.write(component_dir.$plus(Path$.MODULE$.explode("README")), (CharSequence)MODULE$.readme(version2));
            extracted.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Build_JDK$.$anonfun$build_jdk$7(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                Build_JDK$.$anonfun$build_jdk$8(component_dir, dir, x$6);
                return BoxedUnit.UNIT;
            });
            File x$11 = component_dir.file();
            boolean x$12 = true;
            Function1<File, Object> x$13 = File$.MODULE$.find_files$default$2();
            boolean x$14 = File$.MODULE$.find_files$default$4();
            File$.MODULE$.find_files(x$11, x$13, x$12, x$14).foreach((Function1 & Serializable & scala.Serializable)file -> {
                Object object;
                java.nio.file.Path path = file.toPath();
                Set<PosixFilePermission> perms = Files.getPosixFilePermissions(path, new LinkOption[0]);
                perms.add(PosixFilePermission.OWNER_READ);
                perms.add(PosixFilePermission.GROUP_READ);
                perms.add(PosixFilePermission.OTHERS_READ);
                perms.add(PosixFilePermission.OWNER_WRITE);
                if (file.isDirectory()) {
                    perms.add(PosixFilePermission.OWNER_WRITE);
                    perms.add(PosixFilePermission.OWNER_EXECUTE);
                    perms.add(PosixFilePermission.GROUP_EXECUTE);
                    object = BoxesRunTime.boxToBoolean((boolean)perms.add(PosixFilePermission.OTHERS_EXECUTE));
                } else {
                    object = BoxedUnit.UNIT;
                }
                return Files.setPosixFilePermissions(path, perms);
            });
            File$.MODULE$.find_files(component_dir.$plus(Path$.MODULE$.explode("x86_64-darwin")).file(), (Function1<File, Object>)(Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)Build_JDK$.MODULE$.suppress_name(file.getName())), File$.MODULE$.find_files$default$3(), File$.MODULE$.find_files$default$4()).foreach((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.delete()));
            progress.echo("Sharing ...");
            List list2 = (List)MODULE$.jdk_platforms().map((Function1 & Serializable & scala.Serializable)platform -> component_dir.$plus(Path$.MODULE$.explode(platform.name())).file().toPath(), List$.MODULE$.canBuildFrom());
            if (!(list2 instanceof .colon.colon)) {
                throw new MatchError((Object)list2);
            }
            .colon.colon colon2 = (.colon.colon)list2;
            java.nio.file.Path main_dir = (java.nio.file.Path)colon2.head();
            List other_dirs = colon2.tl$access$1();
            Tuple2 tuple2 = new Tuple2((Object)main_dir, (Object)other_dirs);
            Tuple2 tuple22 = tuple2;
            java.nio.file.Path main_dir2 = (java.nio.file.Path)tuple22._1();
            List other_dirs2 = (List)tuple22._2();
            File$.MODULE$.find_files(main_dir2.toFile(), File$.MODULE$.find_files$default$2(), File$.MODULE$.find_files$default$3(), File$.MODULE$.find_files$default$4()).iterator().map((Function1 & Serializable & scala.Serializable)file1 -> {
                java.nio.file.Path path1 = file1.toPath();
                return new Tuple2(file1, (Object)path1);
            }).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                Build_JDK$.$anonfun$build_jdk$14(main_dir2, other_dirs2, x$9);
                return BoxedUnit.UNIT;
            });
            progress.echo("Archiving ...");
            return Isabelle_System$.MODULE$.gnutar(new StringBuilder(6).append("-czf ").append(File$.MODULE$.bash_path(target_dir.$plus(jdk_path.ext("tar.gz")))).append(" ").append(jdk_name).toString(), (Path)dir, Isabelle_System$.MODULE$.gnutar$default$3(), Isabelle_System$.MODULE$.gnutar$default$4()).check();
        });
    }

    public Progress build_jdk$default$2() {
        return No_Progress$.MODULE$;
    }

    public Path build_jdk$default$3() {
        return Path$.MODULE$.current();
    }

    public Isabelle_Tool isabelle_tool() {
        return this.isabelle_tool;
    }

    public static final /* synthetic */ boolean $anonfun$build_jdk$5(Build_JDK.JDK_Platform p1$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Build_JDK.JDK_Platform p2 = (Build_JDK.JDK_Platform)tuple2._2();
        String string = p1$1.name();
        String string2 = p2.name();
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$build_jdk$7(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$build_jdk$8(Path component_dir$1, Path dir$1, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Build_JDK.JDK_Platform platform = (Build_JDK.JDK_Platform)tuple2._2();
        File$.MODULE$.move(dir$1.$plus(Path$.MODULE$.explode(platform.name())), component_dir$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$build_jdk$14(java.nio.file.Path main_dir$1, List other_dirs$1, Tuple2 x$9) {
        Tuple2 tuple2 = x$9;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File file1 = (File)tuple2._1();
        java.nio.file.Path path1 = (java.nio.file.Path)tuple2._2();
        other_dirs$1.iterator().foreach((Function1 & Serializable & scala.Serializable)dir2 -> {
            Object object;
            java.nio.file.Path path2 = dir2.resolve(main_dir$1.relativize(path1));
            File file2 = path2.toFile();
            if (!Files.isSymbolicLink(path2) && file2.isFile() && File$.MODULE$.eq_content(file1, file2)) {
                file2.delete();
                object = Files.createLink(path2, path1);
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$isabelle_tool$1(List args) {
        ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
        Getopts getopts = Getopts$.MODULE$.apply("\nUsage: isabelle build_jdk [OPTIONS] ARCHIVES...\n\n  Options are:\n    -D DIR       target directory (default \".\")\n\n  Build jdk component from tar.gz archives, with original jdk archives\n  for x86_64 Linux, Windows, Mac OS X.\n", (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"D:"), (Function1 & Serializable & scala.Serializable)arg -> {
            target_dir.elem = Path$.MODULE$.explode(arg);
            return BoxedUnit.UNIT;
        })}));
        List<String> more_args = getopts.apply((List<String>)args);
        if (more_args.isEmpty()) {
            throw getopts.usage();
        }
        List archives = (List)more_args.map((Function1 & Serializable & scala.Serializable)x$10 -> Path$.MODULE$.explode((String)x$10), List$.MODULE$.canBuildFrom());
        Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2());
        MODULE$.build_jdk((List<Path>)archives, progress, (Path)target_dir.elem);
    }

    private Build_JDK$() {
        MODULE$ = this;
        this.jdk_platforms = new .colon.colon((Object)new Build_JDK.JDK_Platform("x86_64-linux", ".", "bin/java", new StringOps(Predef$.MODULE$.augmentString(".*ELF 64-bit.*x86[-_]64.*")).r()), (List)new .colon.colon((Object)new Build_JDK.JDK_Platform("x86_64-windows", ".", "bin/java.exe", new StringOps(Predef$.MODULE$.augmentString(".*PE32\\+ executable.*x86[-_]64.*")).r()), (List)new .colon.colon((Object)new Build_JDK.JDK_Platform("x86_64-darwin", "Contents/Home", "Contents/Home/bin/java", new StringOps(Predef$.MODULE$.augmentString(".*Mach-O 64-bit.*x86[-_]64.*")).r()), (List)Nil$.MODULE$)));
        this.settings = "# -*- shell-script -*- :mode=shellscript:\n\ncase \"$ISABELLE_PLATFORM_FAMILY\" in\n  linux)\n    ISABELLE_JAVA_PLATFORM=\"$ISABELLE_PLATFORM64\"\n    ISABELLE_JDK_HOME=\"$COMPONENT/$ISABELLE_JAVA_PLATFORM\"\n    ;;\n  windows)\n    ISABELLE_JAVA_PLATFORM=\"$ISABELLE_WINDOWS_PLATFORM64\"\n    ISABELLE_JDK_HOME=\"$COMPONENT/$ISABELLE_JAVA_PLATFORM\"\n    ;;\n  macos)\n    ISABELLE_JAVA_PLATFORM=\"$ISABELLE_PLATFORM64\"\n    ISABELLE_JDK_HOME=\"$COMPONENT/$ISABELLE_JAVA_PLATFORM/Contents/Home\"\n    ;;\nesac\n";
        this.isabelle_tool = new Isabelle_Tool("build_jdk", "build Isabelle jdk component from original archives", (Function1<List<String>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)args -> {
            Build_JDK$.$anonfun$isabelle_tool$1(args);
            return BoxedUnit.UNIT;
        });
    }
}

