/*
 * Decompiled with CFR 0.152.
 */
package code2html.generic;

import code2html.Code2HTMLPlugin;
import java.awt.Color;

public abstract class GenericGutter {
    protected int gutterSize;
    protected char gutterBorder = (char)58;
    protected int gutterBorderSize = 1;
    protected String bgColor;
    protected String fgColor;
    protected Color bg;
    protected Color fg;
    protected String highlightColor;
    protected int highlightInterval;
    protected String spacer;

    protected GenericGutter() {
        this("#ffffff", "#000000", "#8080c0", 5);
    }

    public GenericGutter(String bgColor, String fgColor, String highlightColor, int highlightInterval) {
        this(4, bgColor, fgColor, highlightColor, highlightInterval);
    }

    public GenericGutter(int gutterSize, String bgColor, String fgColor, String highlightColor, int highlightInterval) {
        this.setGutterSize(gutterSize);
        this.bgColor = bgColor;
        this.fgColor = fgColor;
        this.bg = Code2HTMLPlugin.decode(bgColor);
        this.fg = Code2HTMLPlugin.decode(fgColor);
        this.highlightColor = highlightColor;
        this.highlightInterval = highlightInterval;
    }

    public boolean isHighlighted(int lineNumber) {
        return this.highlightInterval > 0 && lineNumber % this.highlightInterval == 0;
    }

    public String gutterStyle(int lineNumber) {
        return this.isHighlighted(lineNumber) ? "gutterH" : "gutter";
    }

    public String getColorString(int lineNumber) {
        return this.isHighlighted(lineNumber) ? this.highlightColor : this.fgColor;
    }

    public int getGutterBorderSize() {
        return this.gutterBorderSize;
    }

    public int getGutterSize() {
        return this.gutterSize;
    }

    public int getSize() {
        return this.getGutterSize() + this.getGutterBorderSize();
    }

    public abstract String format(int var1);

    public abstract String formatEmpty(int var1);

    public abstract String style();

    public void setGutterSize(int gutterSize) {
        this.gutterSize = gutterSize;
        this.spacer = this.getSpacer();
    }

    public abstract String getSpaceString();

    public String getSpacer(int size) {
        String space = this.getSpaceString();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            buf.append(space);
        }
        return buf.toString();
    }

    public String getSpacer() {
        return this.getSpacer(this.gutterSize);
    }

    public String wrapText(int lineNumber) {
        StringBuffer buf = new StringBuffer();
        String s = Integer.toString(lineNumber);
        String spaces = this.getSpacer(this.getGutterSize() - s.length());
        buf.append(spaces).append(s);
        return buf.toString();
    }
}

