/*
 * Decompiled with CFR 0.152.
 */
package code2html.generic;

import code2html.generic.GenericDocument;
import code2html.generic.GenericGutter;
import code2html.generic.GenericPainter;
import code2html.generic.Style;
import code2html.services.LinkProvider;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;

public abstract class GenericExporter {
    protected Selection[] selection = null;
    protected Buffer buffer;
    protected Style style = null;
    protected GenericGutter gutter = null;
    protected GenericPainter painter = null;
    protected GenericDocument document = null;
    protected LinkProvider linkProvider = null;

    public GenericExporter(Buffer buffer, SyntaxStyle[] syntaxStyle, Selection[] selection) {
        this.buffer = buffer;
        this.selection = selection;
        Object lp = ServiceManager.getService((String)"code2html.services.LinkProvider", (String)buffer.getMode().toString());
        if (lp != null) {
            this.linkProvider = (LinkProvider)lp;
        }
    }

    public Buffer getDocumentBuffer() {
        return this.makeBuffer(this.getDocumentString(), this.getMode());
    }

    public Buffer getContentBuffer() {
        return this.makeBuffer(this.getContentString(), this.getMode());
    }

    public Buffer getStyleBuffer() {
        return this.makeBuffer(this.getDocumentString(), this.style.getMode());
    }

    private Buffer makeBuffer(String str, String mode) {
        if (str == null) {
            return null;
        }
        Buffer newBuffer = jEdit.newFile((View)jEdit.getActiveView());
        newBuffer.insert(0, str);
        if (mode != null) {
            newBuffer.setMode(mode);
        }
        return newBuffer;
    }

    public GenericGutter getGutter() {
        return this.gutter;
    }

    public GenericPainter getPainter() {
        return this.painter;
    }

    public GenericDocument getDocument() {
        return this.document;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
        this.style.setLinkProvider(this.linkProvider);
    }

    public abstract String getMode();

    public String getContentString() {
        StringWriter sw = new StringWriter();
        GenericDocument document = this.getDocument();
        try {
            BufferedWriter out = new BufferedWriter(sw);
            document.beforeContent(out);
            this.writeContent(out);
            document.afterContent(out);
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            Log.log((int)9, (Object)this, (Object)ioe);
            return null;
        }
        return sw.toString();
    }

    public String getStyleString() {
        StringWriter sw = new StringWriter();
        GenericDocument document = this.getDocument();
        try {
            BufferedWriter out = new BufferedWriter(sw);
            document.openStyle(out);
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            Log.log((int)9, (Object)this, (Object)ioe);
            return null;
        }
        return sw.toString();
    }

    public String getDocumentString() {
        StringWriter sw = new StringWriter();
        GenericDocument document = this.getDocument();
        try {
            BufferedWriter out = new BufferedWriter(sw);
            document.open(out);
            document.beforeContent(out);
            this.writeContent(out);
            document.afterContent(out);
            document.close(out);
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            Log.log((int)9, (Object)this, (Object)ioe);
            return null;
        }
        return sw.toString();
    }

    private void writeContent(Writer out) throws IOException {
        int physicalFirst = 0;
        int physicalLast = this.buffer.getLineCount() - 1;
        if (this.selection == null) {
            this.text(out, physicalFirst, physicalLast);
        } else {
            int last = 0;
            for (int i = 0; i < this.selection.length; ++i) {
                if (this.selection[i].getEndLine() <= last) continue;
                last = this.selection[i].getEndLine();
            }
            Arrays.sort(this.selection, new SelectionStartLineComparator());
            if (this.getGutter() != null) {
                this.getGutter().setGutterSize(Integer.toString(last + 1).length());
            }
            int lastLine = -1;
            for (int i = 0; i < this.selection.length; ++i) {
                physicalFirst = this.selection[i].getStartLine();
                physicalLast = this.selection[i].getEndLine();
                if (physicalLast <= lastLine) continue;
                this.text(out, Math.max(physicalFirst, lastLine + 1), physicalLast);
                lastLine = physicalLast;
            }
        }
    }

    protected void text(Writer out, int first, int last) throws IOException {
        long start = System.currentTimeMillis();
        this.paintLines(out, this.buffer, first, last);
        long end = System.currentTimeMillis();
    }

    protected void paintLines(Writer out, Buffer buffer, int first, int last) throws IOException {
        Segment line = new Segment();
        Token tokens = null;
        for (int i = first; i <= last; ++i) {
            buffer.getLineText(i, line);
            GenericPainter painter_ = this.getPainter();
            painter_.setPos(0);
            tokens = this.getTokens(i, buffer);
            painter_.paintSyntaxLine(out, i + 1, line, tokens);
            out.write(painter_.newLine());
        }
    }

    private Token getTokens(int i, Buffer buffer) {
        DefaultTokenHandler list = new DefaultTokenHandler();
        buffer.markTokens(i, (TokenHandler)list);
        return list.getTokens();
    }

    private class SelectionStartLineComparator
    implements Comparator {
        private SelectionStartLineComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            Selection s1 = (Selection)obj1;
            Selection s2 = (Selection)obj2;
            int diff = s1.getStartLine() - s2.getStartLine();
            if (diff == 0) {
                return 0;
            }
            if (diff > 0) {
                return 1;
            }
            return -1;
        }
    }
}

