/*
 * Decompiled with CFR 0.152.
 */
package code2html;

import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class NumberTextField
extends JTextField {
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;

    public NumberTextField() {
        this.addFilter();
    }

    public NumberTextField(String text, int columns) {
        super(text, columns);
        this.addFilter();
    }

    public void setMaxValue(int value) {
        this.maxValue = value;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(int value) {
        this.minValue = value;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getValue() {
        String text = this.getText();
        if (text == null || text.length() == 0) {
            text = "0";
        }
        return Integer.parseInt(this.getText());
    }

    public void setValue(int value) {
        this.setText(String.valueOf(value));
    }

    private void addFilter() {
        ((AbstractDocument)this.getDocument()).setDocumentFilter(new NumericDocumentFilter());
    }

    class NumericDocumentFilter
    extends DocumentFilter {
        NumericDocumentFilter() {
        }

        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (string == null) {
                return;
            }
            if (this.isNumeric(string) && this.inRange(new StringBuilder(NumberTextField.this.getText()).insert(offset, string))) {
                super.insertString(fb, offset, string, attr);
            }
        }

        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            super.remove(fb, offset, length);
        }

        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (text == null) {
                return;
            }
            if (this.isNumeric(text) && this.inRange(new StringBuilder(NumberTextField.this.getText()).replace(offset, offset + length, text))) {
                super.replace(fb, offset, length, text, attrs);
            }
        }

        private boolean isNumeric(String string) {
            for (char c : string.toCharArray()) {
                if (Character.isDigit(c)) continue;
                return false;
            }
            return true;
        }

        private boolean inRange(CharSequence string) {
            int value = Integer.parseInt(string.toString());
            return value <= NumberTextField.this.maxValue && value >= NumberTextField.this.minValue;
        }
    }
}

