/*
 * Decompiled with CFR 0.152.
 */
package sidekick.util;

import sidekick.util.Location;

public class Range {
    public int startLine = 0;
    public int startColumn = 0;
    public int endLine = 0;
    public int endColumn = 0;

    public Range() {
        this(new Location(0, 0), new Location(0, 0));
    }

    public Range(Location start, Location end) {
        Location first = start.compareTo(end) <= 0 ? start : end;
        Location second = first.equals(start) ? end : start;
        this.startLine = first.line;
        this.startColumn = first.column;
        this.endLine = second.line;
        this.endColumn = second.column;
    }

    public Location getStartLocation() {
        return new Location(this.startLine, this.startColumn);
    }

    public void setStartLocation(Location location) {
        if (location == null) {
            throw new IllegalArgumentException("start location may not be null");
        }
        this.startLine = location.line;
        this.startColumn = location.column;
    }

    public Location getEndLocation() {
        return new Location(this.endLine, this.endColumn);
    }

    public void setEndLocation(Location location) {
        if (location == null) {
            throw new IllegalArgumentException("end location may not be null");
        }
        this.endLine = location.line;
        this.endColumn = location.column;
    }

    public String toString() {
        return "Range:[startLine=" + this.startLine + ",startColumn=" + this.startColumn + ",endLine=" + this.endLine + ",endColumn=" + this.endColumn + "]";
    }
}

