/*
 * Decompiled with CFR 0.152.
 */
package GraphBrowser;

import GraphBrowser.GraphView;
import GraphBrowser.TreeNode;
import GraphBrowser.Vertex;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class TreeBrowser
extends Canvas
implements MouseListener {
    TreeNode t;
    TreeNode selected;
    GraphView gv;
    long timestamp;
    Dimension size;
    boolean parent_needs_layout;
    Font font;

    public TreeBrowser(TreeNode treeNode, GraphView graphView, Font font) {
        this.t = treeNode;
        this.gv = graphView;
        this.font = font;
        this.size = new Dimension(0, 0);
        this.parent_needs_layout = true;
        this.addMouseListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        TreeNode treeNode = this.t.lookup(mouseEvent.getY());
        if (treeNode != null) {
            if (treeNode.select()) {
                Vector vector = new Vector(10, 10);
                this.t.collapsedDirectories(vector);
                this.gv.collapseDir(vector);
                this.gv.relayout();
            } else {
                Vertex vertex = this.gv.getGraph().getVertexByNum(treeNode.getNumber());
                this.gv.focusToVertex(treeNode.getNumber());
                vertex = this.gv.getOriginalGraph().getVertexByNum(treeNode.getNumber());
                if (mouseEvent.getWhen() - this.timestamp < 400L && !vertex.getPath().equals("")) {
                    this.gv.getBrowser().viewFile(vertex.getPath());
                }
                this.timestamp = mouseEvent.getWhen();
            }
            this.selected = treeNode;
            this.parent_needs_layout = true;
            this.repaint();
        }
    }

    public void selectNode(TreeNode treeNode) {
        Vector vector = new Vector(10, 10);
        treeNode.select();
        this.t.collapsedDirectories(vector);
        this.gv.collapseDir(vector);
        this.gv.relayout();
        this.selected = treeNode;
        this.parent_needs_layout = true;
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setFont(this.font);
        Dimension dimension = this.t.draw(graphics, 5, 5, this.selected);
        if (this.parent_needs_layout) {
            this.size = new Dimension(5 + dimension.width, 5 + dimension.height);
            this.parent_needs_layout = false;
            this.getParent().doLayout();
        }
    }
}

