/*
 * Decompiled with CFR 0.152.
 */
package GraphBrowser;

import GraphBrowser.Directory;
import GraphBrowser.Graph;
import GraphBrowser.GraphBrowser;
import GraphBrowser.TreeBrowser;
import GraphBrowser.Vertex;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.ScrollPane;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class GraphView
extends Canvas
implements MouseListener,
MouseMotionListener {
    Graph gra;
    Graph gra2;
    GraphBrowser browser;
    Vertex v = null;
    Vector collapsed = new Vector(10, 10);
    Vector collapsedDirs = new Vector(10, 10);
    TreeBrowser tb;
    long timestamp;
    Vertex highlighted = null;
    Dimension size;
    boolean parent_needs_layout;
    Font font;

    public void setTreeBrowser(TreeBrowser treeBrowser) {
        this.tb = treeBrowser;
    }

    public GraphBrowser getBrowser() {
        return this.browser;
    }

    public Graph getGraph() {
        return this.gra;
    }

    public Graph getOriginalGraph() {
        return this.gra2;
    }

    public GraphView(Graph graph, GraphBrowser graphBrowser, Font font) {
        this.gra2 = graph;
        this.browser = graphBrowser;
        this.gra = (Graph)this.gra2.clone();
        this.parent_needs_layout = true;
        this.size = new Dimension(0, 0);
        this.font = font;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void PS(String string, boolean bl) throws IOException {
        Graph graph = (Graph)this.gra.clone();
        graph.layout(null);
        graph.PS(string, bl);
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setFont(this.font);
        this.gra.draw(graphics);
        if (this.highlighted != null) {
            this.highlighted.drawBox(graphics, Color.white);
        }
        this.size = new Dimension(this.gra.max_x - this.gra.min_x, this.gra.max_y - this.gra.min_y);
        if (this.parent_needs_layout) {
            this.parent_needs_layout = false;
            this.getParent().doLayout();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() + this.gra.min_x;
        int n2 = mouseEvent.getY() + this.gra.min_y;
        Vertex vertex = this.gra.vertexAt(n, n2);
        Graphics graphics = this.getGraphics();
        graphics.setFont(this.font);
        graphics.translate(-this.gra.min_x, -this.gra.min_y);
        if (this.highlighted != null) {
            this.highlighted.drawBox(graphics, Color.lightGray);
            this.highlighted = null;
        }
        if (vertex != this.v) {
            if (this.v != null) {
                this.v.removeButtons(graphics);
            }
            if (vertex != null) {
                vertex.drawButtons(graphics);
            }
            this.v = vertex;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    void uncollapse(Vector vector) {
        this.collapsed.removeElement(vector);
        this.collapseNodes();
    }

    public void collapseDir(Vector vector) {
        this.collapsedDirs = vector;
        this.collapseNodes();
    }

    public void inflateNode(Vector vector) {
        Object object;
        Enumeration enumeration = this.collapsedDirs.elements();
        while (enumeration.hasMoreElements()) {
            object = (Directory)enumeration.nextElement();
            if (((Directory)object).collapsed != vector) continue;
            this.tb.selectNode(((Directory)object).getNode());
            return;
        }
        this.collapsed.removeElement(vector);
        enumeration = this.gra2.getVertices();
        while (enumeration.hasMoreElements()) {
            object = (Vertex)enumeration.nextElement();
            if (((Vertex)object).getUp() == vector) {
                ((Vertex)object).setUp(null);
            }
            if (((Vertex)object).getDown() != vector) continue;
            ((Vertex)object).setDown(null);
        }
        this.collapseNodes();
        this.relayout();
    }

    public void relayout() {
        Graphics graphics = this.getGraphics();
        graphics.setFont(this.font);
        this.browser.showWaitMessage();
        this.highlighted = null;
        this.gra.layout(graphics);
        this.v = null;
        this.parent_needs_layout = true;
        this.update(graphics);
        this.browser.showReadyMessage();
    }

    public void focusToVertex(int n) {
        Vertex vertex = this.gra.getVertexByNum(n);
        if (vertex != null) {
            ScrollPane scrollPane = (ScrollPane)this.getParent();
            Dimension dimension = scrollPane.getViewportSize();
            int n2 = vertex.getX() - this.gra.min_x;
            int n3 = vertex.getY() - this.gra.min_y;
            int n4 = Math.min(scrollPane.getHAdjustable().getMaximum(), Math.max(0, n2 - dimension.width / 2));
            int n5 = Math.min(scrollPane.getVAdjustable().getMaximum(), Math.max(0, n3 - dimension.height / 2));
            Graphics graphics = this.getGraphics();
            graphics.setFont(this.font);
            graphics.translate(-this.gra.min_x, -this.gra.min_y);
            if (this.highlighted != null) {
                this.highlighted.drawBox(graphics, Color.lightGray);
            }
            vertex.drawBox(graphics, Color.white);
            this.highlighted = vertex;
            scrollPane.setScrollPosition(n4, n5);
        }
    }

    public void collapseNodes() {
        Vector vector;
        Object object;
        Enumeration enumeration = this.collapsed.elements();
        this.gra = (Graph)this.gra2.clone();
        while (enumeration.hasMoreElements()) {
            object = (Vector)enumeration.nextElement();
            vector = this.gra.decode((Vector)object);
            if (vector.isEmpty()) continue;
            this.gra.collapse(vector, "[. . . .]", (Vector)object);
        }
        enumeration = this.collapsedDirs.elements();
        while (enumeration.hasMoreElements()) {
            object = (Directory)enumeration.nextElement();
            vector = this.gra.decode(((Directory)object).getCollapsed());
            if (vector.isEmpty()) continue;
            this.gra.collapse(vector, "[" + ((Directory)object).getName() + "]", ((Directory)object).getCollapsed());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Vector vector = null;
        int n = mouseEvent.getX() + this.gra.min_x;
        int n2 = mouseEvent.getY() + this.gra.min_y;
        if (this.v != null) {
            int n3 = this.v.getNumber();
            Vertex vertex = this.gra2.getVertexByNum(n3);
            if (this.v.leftButton(n, n2)) {
                if (this.v.getUp() != null) {
                    vector = this.v.getUp();
                    vertex.setUp(null);
                    this.v = null;
                    this.uncollapse(vector);
                    this.relayout();
                    this.focusToVertex(n3);
                } else {
                    Vector vector2 = vertex.getPreds();
                    vector = this.gra2.encode(vector2);
                    this.v.setUp(vector);
                    vertex.setUp(vector);
                    this.v = null;
                    this.collapsed.insertElementAt(vector, 0);
                    this.collapseNodes();
                    this.relayout();
                    this.focusToVertex(n3);
                }
            } else if (this.v.rightButton(n, n2)) {
                if (this.v.getDown() != null) {
                    vector = this.v.getDown();
                    vertex.setDown(null);
                    this.v = null;
                    this.uncollapse(vector);
                    this.relayout();
                    this.focusToVertex(n3);
                } else {
                    Vector vector3 = vertex.getSuccs();
                    vector = this.gra2.encode(vector3);
                    this.v.setDown(vector);
                    vertex.setDown(vector);
                    this.v = null;
                    this.collapsed.insertElementAt(vector, 0);
                    this.collapseNodes();
                    this.relayout();
                    this.focusToVertex(n3);
                }
            } else if (this.v.getInflate() != null) {
                this.inflateNode(this.v.getInflate());
                this.v = null;
            } else {
                if (mouseEvent.getWhen() - this.timestamp < 400L && !this.v.getPath().equals("")) {
                    this.browser.viewFile(this.v.getPath());
                }
                this.timestamp = mouseEvent.getWhen();
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraphics();
        graphics.setFont(this.font);
        graphics.translate(-this.gra.min_x, -this.gra.min_y);
        if (this.highlighted != null) {
            this.highlighted.drawBox(graphics, Color.lightGray);
            this.highlighted = null;
        }
        if (this.v != null) {
            this.v.removeButtons(graphics);
        }
        this.v = null;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

