/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.util.Log;

class ScreenLineManager {
    private final JEditBuffer buffer;
    private char[] screenLines;

    ScreenLineManager(JEditBuffer buffer) {
        this.buffer = buffer;
        if (!buffer.isLoading()) {
            this.reset();
        }
    }

    boolean isScreenLineCountValid(int line) {
        if (this.screenLines == null || line < 0 || line >= this.screenLines.length) {
            return false;
        }
        return this.screenLines[line] > '\u0000';
    }

    int getScreenLineCount(int line) {
        assert (this.isScreenLineCountValid(line));
        return this.screenLines[line];
    }

    void setScreenLineCount(int line, int count) {
        assert (count > 0) : "New line count is bogus!";
        if (count > Short.MAX_VALUE) {
            count = Short.MAX_VALUE;
            Log.log(9, this, new Exception("Max screen line count hit!"));
        }
        if (Debug.SCREEN_LINES_DEBUG) {
            Log.log(1, this, new Exception("setScreenLineCount(" + line + ',' + count + ')'));
        }
        if (this.screenLines == null) {
            this.reset();
        }
        this.screenLines[line] = (char)count;
    }

    void invalidateScreenLineCounts() {
        int lineCount = this.buffer.getLineCount();
        for (int i = 0; i < lineCount; ++i) {
            this.invalidateScreenLineCount(i);
        }
    }

    private void invalidateScreenLineCount(int physicalLineNo) {
        this.screenLines[physicalLineNo] = '\u0000';
    }

    void reset() {
        this.screenLines = new char[this.buffer.getLineCount()];
    }

    public void contentInserted(int startLine, int numLines) {
        int endLine = startLine + numLines;
        this.invalidateScreenLineCount(startLine);
        int lineCount = this.buffer.getLineCount();
        if (numLines > 0) {
            if (this.screenLines.length <= lineCount) {
                char[] screenLinesN = new char[lineCount + 1 << 1];
                System.arraycopy(this.screenLines, 0, screenLinesN, 0, this.screenLines.length);
                this.screenLines = screenLinesN;
            }
            System.arraycopy(this.screenLines, startLine, this.screenLines, endLine, lineCount - endLine);
            for (int i = 0; i < numLines; ++i) {
                this.screenLines[startLine + i] = '\u0000';
            }
        }
    }

    public void contentRemoved(int startLine, int numLines) {
        int endLine = startLine + numLines;
        this.invalidateScreenLineCount(startLine);
        if (numLines > 0 && endLine != this.screenLines.length) {
            System.arraycopy(this.screenLines, endLine + 1, this.screenLines, startLine + 1, this.screenLines.length - endLine - 1);
        }
    }
}

