/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.PageRanges;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.print.BufferPrinter1_7;
import org.gjt.sp.jedit.print.PrintPreviewModel;
import org.gjt.sp.jedit.print.PrintPreviewPane;
import org.gjt.sp.jedit.print.Range;
import org.gjt.sp.jedit.print.Reverse;

public class PrintPreview
extends EnhancedDialog {
    private View view;
    private Buffer buffer;
    private JComboBox<Integer> pages;
    private JButton nextPage;
    private JButton prevPage;
    private JButton zoomIn;
    private JButton zoomOut;
    private JButton fullWidth;
    private JButton fullPage;
    private PrintPreviewPane printPreviewPane;
    private JButton cancelButton;
    private HashMap<Integer, Range> pageRanges;
    private PrintRequestAttributeSet attributes;
    private PrintService printService;
    private PrintPreviewModel model;
    private float zoomLevel = 1.0f;

    public PrintPreview(View view, Buffer buffer, PrintService printService, PrintRequestAttributeSet attributes) {
        super(view, jEdit.getProperty("printpreview.dialog.title"), true);
        this.view = view;
        this.buffer = buffer;
        this.printService = printService;
        this.attributes = attributes;
        this.installComponents();
        this.installListeners();
        this.init();
        this.pack();
        this.setLocationRelativeTo(jEdit.getActiveView().getTextArea());
        this.setVisible(true);
        this.repaint();
    }

    private void installComponents() {
        this.pages = new JComboBox();
        this.nextPage = new JButton(GUIUtilities.loadIcon("22x22/actions/go-next.png"));
        this.nextPage.setToolTipText(jEdit.getProperty("printpreview.dialog.nextPage", "Next Page"));
        this.prevPage = new JButton(GUIUtilities.loadIcon("22x22/actions/go-previous.png"));
        this.prevPage.setToolTipText(jEdit.getProperty("printpreview.dialog.prevPage", "Previous Page"));
        this.zoomIn = new JButton(GUIUtilities.loadIcon("22x22/actions/zoom-in.png"));
        this.zoomIn.setToolTipText(jEdit.getProperty("printpreview.dialog.zoomin", "Zoom In"));
        this.zoomOut = new JButton(GUIUtilities.loadIcon("22x22/actions/zoom-out.png"));
        this.zoomOut.setToolTipText(jEdit.getProperty("printpreview.dialog.zoomout", "Zoom Out"));
        this.fullWidth = new JButton(GUIUtilities.loadIcon("22x22/actions/resize-horisontal.png"));
        this.fullWidth.setToolTipText(jEdit.getProperty("printpreview.dialog.pageWidth", "Show page full width"));
        this.fullPage = new JButton(GUIUtilities.loadIcon("22x22/actions/resize-vertical.png"));
        this.fullPage.setToolTipText(jEdit.getProperty("printpreview.dialog.fullPage", "Show full page"));
        JPanel toolbar = new JPanel();
        toolbar.setLayout(new FlowLayout(0, 6, 6));
        toolbar.add(new JLabel("Page "));
        toolbar.add(this.pages);
        toolbar.add(this.prevPage);
        toolbar.add(this.nextPage);
        this.printPreviewPane = new PrintPreviewPane();
        this.cancelButton = new JButton(jEdit.getProperty("common.cancel"));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(2, 6, 11));
        bottomPanel.add(this.cancelButton);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        content.add((Component)toolbar, "North");
        content.add((Component)this.printPreviewPane, "Center");
        content.add((Component)bottomPanel, "South");
        this.setContentPane(content);
    }

    private void installListeners() {
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PrintPreview.this.cancel();
            }
        });
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(40, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(38, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(39, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(37, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(225, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(224, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(227, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(226, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(34, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(33, 0, false), "none");
        this.pages.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                int selectedIndex = PrintPreview.this.pages.getSelectedIndex();
                switch (ke.getKeyCode()) {
                    case 34: 
                    case 39: 
                    case 40: 
                    case 225: 
                    case 227: {
                        selectedIndex = ++selectedIndex >= PrintPreview.this.pages.getItemCount() ? 0 : selectedIndex;
                        break;
                    }
                    case 33: 
                    case 37: 
                    case 38: 
                    case 224: 
                    case 226: {
                        selectedIndex = --selectedIndex < 0 ? PrintPreview.this.pages.getItemCount() - 1 : selectedIndex;
                        break;
                    }
                    case 49: {
                        selectedIndex = 0;
                        break;
                    }
                    case 50: {
                        selectedIndex = 1;
                        break;
                    }
                    case 51: {
                        selectedIndex = 2;
                        break;
                    }
                    case 52: {
                        selectedIndex = 3;
                        break;
                    }
                    case 53: {
                        selectedIndex = 4;
                        break;
                    }
                    case 54: {
                        selectedIndex = 5;
                        break;
                    }
                    case 55: {
                        selectedIndex = 6;
                        break;
                    }
                    case 56: {
                        selectedIndex = 7;
                        break;
                    }
                    case 57: {
                        selectedIndex = 8;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                PrintPreview.this.pages.setSelectedIndex(selectedIndex);
                int selectedPage = (Integer)PrintPreview.this.pages.getSelectedItem();
                PrintPreview.this.model.setPageNumber(selectedPage - 1);
                PrintPreview.this.model.setPageRanges(PrintPreview.this.pageRanges);
                PrintPreview.this.model.setZoomLevel(PrintPreview.this.zoomLevel);
                PrintPreview.this.attributes.add(new PageRanges(selectedPage));
                PrintPreview.this.printPreviewPane.setModel(PrintPreview.this.model);
            }
        });
        this.pages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent me) {
                if (PrintPreview.this.model != null) {
                    int selectedPage = (Integer)PrintPreview.this.pages.getSelectedItem();
                    PrintPreview.this.model.setPageNumber(selectedPage - 1);
                    PrintPreview.this.model.setPageRanges(PrintPreview.this.pageRanges);
                    PrintPreview.this.model.setZoomLevel(PrintPreview.this.zoomLevel);
                    PrintPreview.this.attributes.add(new PageRanges(selectedPage));
                    PrintPreview.this.printPreviewPane.setModel(PrintPreview.this.model);
                }
            }
        });
        this.prevPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int selectedIndex = PrintPreview.this.pages.getSelectedIndex();
                selectedIndex = selectedIndex <= 0 ? PrintPreview.this.pages.getItemCount() - 1 : --selectedIndex;
                PrintPreview.this.pages.setSelectedIndex(selectedIndex);
                int selectedPage = (Integer)PrintPreview.this.pages.getSelectedItem();
                PrintPreview.this.model.setPageNumber(selectedPage - 1);
                PrintPreview.this.model.setPageRanges(PrintPreview.this.pageRanges);
                PrintPreview.this.model.setZoomLevel(PrintPreview.this.zoomLevel);
                PrintPreview.this.attributes.add(new PageRanges(selectedPage));
                PrintPreview.this.printPreviewPane.setModel(PrintPreview.this.model);
            }
        });
        this.nextPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int selectedIndex = PrintPreview.this.pages.getSelectedIndex();
                selectedIndex = selectedIndex + 1 == PrintPreview.this.pages.getItemCount() ? 0 : ++selectedIndex;
                PrintPreview.this.pages.setSelectedIndex(selectedIndex);
                int selectedPage = (Integer)PrintPreview.this.pages.getSelectedItem();
                PrintPreview.this.model.setPageNumber(selectedPage - 1);
                PrintPreview.this.model.setPageRanges(PrintPreview.this.pageRanges);
                PrintPreview.this.model.setZoomLevel(PrintPreview.this.zoomLevel);
                PrintPreview.this.attributes.add(new PageRanges(selectedPage));
                PrintPreview.this.printPreviewPane.setModel(PrintPreview.this.model);
            }
        });
        this.zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PrintPreview.this.zoomLevel = PrintPreview.this.zoomLevel + 0.1f;
                int selectedPage = (Integer)PrintPreview.this.pages.getSelectedItem();
                PrintPreview.this.model.setZoomLevel(PrintPreview.this.zoomLevel);
                PrintPreview.this.model.setPageNumber(selectedPage - 1);
                PrintPreview.this.model.setPageRanges(PrintPreview.this.pageRanges);
                PrintPreview.this.model.setZoom(PrintPreviewModel.Zoom.IN);
                PrintPreview.this.attributes.add(new PageRanges(selectedPage));
                PrintPreview.this.printPreviewPane.setModel(PrintPreview.this.model);
            }
        });
        this.zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PrintPreview.this.zoomLevel = PrintPreview.this.zoomLevel - 0.1f;
                if (PrintPreview.this.zoomLevel <= 0.0f) {
                    PrintPreview.this.zoomLevel = 0.1f;
                }
                int selectedPage = (Integer)PrintPreview.this.pages.getSelectedItem();
                PrintPreview.this.model.setZoomLevel(PrintPreview.this.zoomLevel);
                PrintPreview.this.model.setPageNumber(selectedPage - 1);
                PrintPreview.this.model.setPageRanges(PrintPreview.this.pageRanges);
                PrintPreview.this.model.setZoom(PrintPreviewModel.Zoom.OUT);
                PrintPreview.this.attributes.add(new PageRanges(selectedPage));
                PrintPreview.this.printPreviewPane.setModel(PrintPreview.this.model);
            }
        });
        this.fullWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int selectedPage = (Integer)PrintPreview.this.pages.getSelectedItem();
                PrintPreview.this.model.setPageNumber(selectedPage);
                PrintPreview.this.model.setPageRanges(PrintPreview.this.pageRanges);
                PrintPreview.this.model.setZoom(PrintPreviewModel.Zoom.WIDTH);
                PrintPreview.this.attributes.add(new PageRanges(selectedPage));
                PrintPreview.this.printPreviewPane.setModel(PrintPreview.this.model);
            }
        });
        this.fullPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int selectedPage = (Integer)PrintPreview.this.pages.getSelectedItem();
                PrintPreview.this.model.setPageNumber(selectedPage);
                PrintPreview.this.model.setPageRanges(PrintPreview.this.pageRanges);
                PrintPreview.this.model.setZoom(PrintPreviewModel.Zoom.PAGE);
                PrintPreview.this.attributes.add(new PageRanges(selectedPage));
                PrintPreview.this.printPreviewPane.setModel(PrintPreview.this.model);
            }
        });
    }

    private void init() {
        this.pageRanges = BufferPrinter1_7.getPageRanges(this.view, this.buffer, this.attributes);
        DefaultComboBoxModel<Integer> pagesModel = new DefaultComboBoxModel<Integer>();
        boolean reverse = this.attributes.containsKey(Reverse.class);
        StringBuilder pr = new StringBuilder();
        for (Integer i : this.pageRanges.keySet()) {
            Integer pageNo = reverse ? this.pageRanges.size() - i + 1 : i;
            pagesModel.addElement(pageNo);
            pr.append(i).append(',');
        }
        pr.deleteCharAt(pr.length() - 1);
        this.pages.setModel(pagesModel);
        this.pages.setSelectedIndex(0);
        this.nextPage.setEnabled(pagesModel.getSize() > 1);
        this.prevPage.setEnabled(pagesModel.getSize() > 1);
        this.model = new PrintPreviewModel(this.view, this.buffer, this.printService, this.attributes, this.pageRanges);
        int firstPage = (Integer)this.pages.getSelectedItem();
        this.model.setPageNumber(firstPage - 1);
        this.model.setPageRanges(this.pageRanges);
        this.model.setZoomLevel(this.zoomLevel);
        this.attributes.add(new PageRanges(firstPage));
        this.printPreviewPane.setModel(this.model);
    }

    @Override
    public void ok() {
    }

    @Override
    public void cancel() {
        this.setVisible(false);
        this.dispose();
    }
}

