/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.DocAttribute;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.print.BufferPrintable1_7;
import org.gjt.sp.jedit.print.PrintPreviewModel;
import org.gjt.sp.jedit.print.PrintRangeType;
import org.gjt.sp.jedit.print.PrinterDialog;
import org.gjt.sp.jedit.print.Range;
import org.gjt.sp.jedit.print.Reverse;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

public class BufferPrinter1_7 {
    private static PrintRequestAttributeSet format;
    private static DocPrintJob job;

    public static void pageSetup(View view) {
        BufferPrinter1_7.loadPrintSpec();
        PrinterDialog printerDialog = new PrinterDialog(view, format, true);
        if (!printerDialog.isCanceled()) {
            format = printerDialog.getAttributes();
            BufferPrinter1_7.savePrintSpec();
            EditBus.send(new PropertiesChanged(null));
        }
    }

    public static void print(final View view, Buffer buffer) {
        Attribute[] attributes;
        Log.log(1, BufferPrinter1_7.class, "print buffer " + buffer.getPath());
        BufferPrinter1_7.loadPrintSpec();
        String jobName = MiscUtilities.abbreviateView(buffer.getPath());
        format.add(new JobName(jobName, null));
        PrinterDialog printerDialog = new PrinterDialog(view, format, false);
        if (printerDialog.isCanceled()) {
            Log.log(1, BufferPrinter1_7.class, "print dialog canceled");
            return;
        }
        PrintService printService = printerDialog.getPrintService();
        if (printService != null) {
            try {
                job = printService.createPrintJob();
                job.addPrintJobListener(new JobListener(view));
                format = printerDialog.getAttributes();
                BufferPrinter1_7.savePrintSpec();
                EditBus.send(new PropertiesChanged(null));
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(view, jEdit.getProperty("print-error.message", new String[]{e.getMessage()}), jEdit.getProperty("print-error.title"), 0);
                return;
            }
        } else {
            JOptionPane.showMessageDialog(view, jEdit.getProperty("print-error.message", new String[]{"Invalid print service."}), jEdit.getProperty("print-error.title"), 0);
            return;
        }
        Buffer tempBuffer = buffer;
        PrintRangeType printRangeType = (PrintRangeType)format.get(PrintRangeType.class);
        if (PrintRangeType.SELECTION.equals(printRangeType)) {
            tempBuffer = BufferPrinter1_7.getSelectionBuffer(view, buffer);
        }
        HashDocAttributeSet docAttributes = new HashDocAttributeSet();
        for (Attribute attribute : attributes = format.toArray()) {
            boolean isDocAttr = attribute instanceof DocAttribute;
            if (!isDocAttr) continue;
            docAttributes.add(attribute);
        }
        BufferPrintable1_7 printable = new BufferPrintable1_7(format, view, tempBuffer);
        final SimpleDoc doc = new SimpleDoc(printable, DocFlavor.SERVICE_FORMATTED.PRINTABLE, docAttributes);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    job.print(doc, format);
                }
                catch (PrintException e) {
                    JOptionPane.showMessageDialog(view, jEdit.getProperty("print-error.message", new String[]{e.getMessage()}), jEdit.getProperty("print-error.title"), 0);
                }
            }
        };
        ThreadUtilities.runInBackground(runner);
    }

    private static Buffer getSelectionBuffer(View view, Buffer buffer) {
        int[] selectedLines = view.getTextArea().getSelectedLines();
        String path = buffer.getPath();
        String parent = path.substring(0, path.lastIndexOf(System.getProperty("file.separator")));
        Buffer temp = jEdit.openTemporary(view, parent, path + ".prn", true);
        temp.setMode(buffer.getMode());
        for (int i : selectedLines) {
            String line = buffer.getLineText(i) + '\n';
            temp.insert(temp.getLength(), line);
        }
        temp.setProperty("printingLineNumbers", selectedLines);
        return temp;
    }

    protected static void printPage(PrintPreviewModel model) {
        PrintService printService;
        String jobName = MiscUtilities.abbreviateView(model.getBuffer().getPath());
        PrintRequestAttributeSet attrs = model.getAttributes();
        attrs.add(new JobName(jobName, null));
        Reverse reverse = (Reverse)attrs.get(Reverse.class);
        if (reverse != null) {
            attrs.remove(Reverse.class);
        }
        if ((printService = model.getPrintService()) == null) {
            printService = PrintServiceLookup.lookupDefaultPrintService();
        }
        if (printService != null) {
            try {
                job = printService.createPrintJob();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(model.getView(), jEdit.getProperty("print-error.message", new String[]{e.getMessage()}), jEdit.getProperty("print-error.title"), 0);
                return;
            }
        } else {
            JOptionPane.showMessageDialog(model.getView(), jEdit.getProperty("print-error.message", new String[]{"Invalid print service."}), jEdit.getProperty("print-error.title"), 0);
            return;
        }
        Buffer buffer = model.getBuffer();
        PrintRangeType printRangeType = (PrintRangeType)attrs.get(PrintRangeType.class);
        if (PrintRangeType.SELECTION.equals(printRangeType)) {
            buffer = BufferPrinter1_7.getSelectionBuffer(model.getView(), buffer);
        }
        BufferPrintable1_7 printable = new BufferPrintable1_7(attrs, model.getView(), buffer);
        printable.setPages(model.getPageRanges());
        int pageNumber = model.getPageNumber();
        try {
            printable.print(model.getGraphics(), model, pageNumber);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (reverse != null) {
            attrs.add(reverse);
        }
    }

    public static HashMap<Integer, Range> getPageRanges(View view, Buffer buffer, PrintRequestAttributeSet attributes) {
        BufferPrinter1_7.loadPrintSpec();
        format.addAll(attributes);
        BufferPrintable1_7 printable = new BufferPrintable1_7(format, view, buffer);
        return BufferPrinter1_7.getPageRanges(printable, format);
    }

    private static HashMap<Integer, Range> getPageRanges(BufferPrintable1_7 printable, PrintRequestAttributeSet attributes) {
        PageFormat pageFormat = BufferPrinter1_7.createPageFormat(attributes);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        BufferedImage image = new BufferedImage(new Double(pageFormat.getImageableWidth()).intValue(), new Double(pageFormat.getImageableHeight()).intValue(), 1);
        Graphics2D graphics = ge.createGraphics(image);
        Paper paper = pageFormat.getPaper();
        Rectangle2D.Double clipRegion = new Rectangle2D.Double(paper.getImageableX(), paper.getImageableY(), paper.getImageableWidth(), paper.getImageableHeight());
        graphics.setClip(clipRegion);
        try {
            HashMap<Integer, Range> pageLineRanges = printable.calculatePages(graphics, pageFormat);
            PageRanges pr = (PageRanges)attributes.get(PageRanges.class);
            if (pr == null) {
                pr = new PageRanges(1, 1000);
            }
            HashMap<Integer, Range> newLineRanges = new HashMap<Integer, Range>();
            for (Integer i : pageLineRanges.keySet()) {
                if (!pr.contains(i)) continue;
                newLineRanges.put(i, pageLineRanges.get(i));
            }
            return newLineRanges;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HashMap<Integer, Range> getCurrentPageRange(View view, Buffer buffer, PrintRequestAttributeSet attributes) {
        if (attributes == null) {
            BufferPrinter1_7.loadPrintSpec();
            attributes = format;
        }
        BufferPrintable1_7 printable = new BufferPrintable1_7(attributes, view, buffer);
        HashMap<Integer, Range> pages = BufferPrinter1_7.getPageRanges(printable, attributes);
        HashMap<Integer, Range> answer = new HashMap<Integer, Range>();
        int caretLine = view.getTextArea().getCaretLine();
        for (Integer i : pages.keySet()) {
            Range range = pages.get(i);
            if (!range.contains(caretLine)) continue;
            answer.put(i, range);
            break;
        }
        return answer;
    }

    public static PageFormat getDefaultPageFormat(PrintRequestAttributeSet attributes) {
        return BufferPrinter1_7.createPageFormat(attributes);
    }

    private static PageFormat createPageFormat(PrintRequestAttributeSet attributes) {
        Paper paper = new Paper();
        MediaPrintableArea mpa = (MediaPrintableArea)attributes.get(MediaPrintableArea.class);
        int units = 25400;
        double dpi = 72.0;
        double x = (double)mpa.getX(units) * dpi;
        double y = (double)mpa.getY(units) * dpi;
        double w = (double)mpa.getWidth(units) * dpi;
        double h = (double)mpa.getHeight(units) * dpi;
        paper.setImageableArea(x, y, w, h);
        int orientation = 1;
        OrientationRequested or = (OrientationRequested)attributes.get(OrientationRequested.class);
        if (OrientationRequested.LANDSCAPE.equals(or) || OrientationRequested.REVERSE_LANDSCAPE.equals(or)) {
            orientation = 0;
        }
        PageFormat pageFormat = new PageFormat();
        pageFormat.setPaper(paper);
        pageFormat.setOrientation(orientation);
        return pageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPrintSpec() {
        MediaPrintableArea mpa;
        String printSpecPath;
        File filePrintSpec;
        format = new HashPrintRequestAttributeSet();
        String settings = jEdit.getSettingsDirectory();
        if (settings != null && (filePrintSpec = new File(printSpecPath = MiscUtilities.constructPath(settings, "printspec"))).exists()) {
            ObjectInputStream obIn = null;
            try {
                FileInputStream fileIn = new FileInputStream(filePrintSpec);
                obIn = new ObjectInputStream(fileIn);
                format = (HashPrintRequestAttributeSet)obIn.readObject();
            }
            catch (Exception e) {
                Log.log(9, BufferPrinter1_7.class, e);
            }
            finally {
                try {
                    if (obIn != null) {
                        obIn.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if ((mpa = (MediaPrintableArea)format.get(MediaPrintableArea.class)) == null) {
            mpa = new MediaPrintableArea(0.5f, 0.5f, 10.0f, 7.5f, 25400);
            format.add(mpa);
        }
        format.remove(Reverse.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePrintSpec() {
        String settings = jEdit.getSettingsDirectory();
        if (settings == null) {
            return;
        }
        String printSpecPath = MiscUtilities.constructPath(settings, "printspec");
        File filePrintSpec = new File(printSpecPath);
        ObjectOutputStream objectOut = null;
        try {
            FileOutputStream fileOut = new FileOutputStream(filePrintSpec);
            objectOut = new ObjectOutputStream(fileOut);
            objectOut.writeObject(format);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (objectOut != null) {
                try {
                    objectOut.flush();
                }
                catch (IOException iOException) {}
                try {
                    objectOut.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static class JobListener
    extends PrintJobAdapter {
        private View view;

        public JobListener(View view) {
            this.view = view;
        }

        @Override
        public void printJobCompleted(PrintJobEvent pje) {
            PrintService printService = pje.getPrintJob().getPrintService();
            if (printService instanceof StreamPrintService) {
                StreamPrintService streamService = (StreamPrintService)printService;
                OutputStream outputStream = streamService.getOutputStream();
                try {
                    outputStream.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    outputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.view.getStatus().setMessageAndClear("Printing complete.");
        }

        @Override
        public void printJobFailed(PrintJobEvent pje) {
            JOptionPane.showMessageDialog(this.view, jEdit.getProperty("print-error.message", new String[]{"Print job failed."}), jEdit.getProperty("print-error.title"), 0);
        }

        @Override
        public void printJobRequiresAttention(PrintJobEvent pje) {
            JOptionPane.showMessageDialog(this.view, jEdit.getProperty("print-error.message", new String[]{"Check the printer."}), jEdit.getProperty("print-error.title"), 0);
        }
    }
}

