/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.gui.EditAbbrevDialog;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.StandardUtilities;

public class AbbrevsOptionPane
extends AbstractOptionPane {
    private JComboBox<String> setsComboBox;
    private JCheckBox expandOnInput;
    private JTable abbrevsTable;
    private AbbrevsModel globalAbbrevs;
    private Map<String, AbbrevsModel> modeAbbrevs;
    private JButton add;
    private JButton edit;
    private JButton remove;

    public AbbrevsOptionPane() {
        super("abbrevs");
    }

    @Override
    protected void _init() {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout(6, 6));
        this.expandOnInput = new JCheckBox(jEdit.getProperty("options.abbrevs.expandOnInput"), Abbrevs.getExpandOnInput());
        panel.add((Component)this.expandOnInput, "North");
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 0));
        panel2.setBorder(new EmptyBorder(0, 0, 6, 0));
        panel2.add(Box.createGlue());
        JLabel label = new JLabel(jEdit.getProperty("options.abbrevs.set"));
        label.setBorder(new EmptyBorder(0, 0, 0, 12));
        panel2.add(label);
        Hashtable<String, Hashtable<String, String>> _modeAbbrevs = Abbrevs.getModeAbbrevs();
        this.modeAbbrevs = new HashMap<String, AbbrevsModel>();
        Mode[] modes = jEdit.getModes();
        Arrays.sort(modes, new StandardUtilities.StringCompare(true));
        String[] sets = new String[modes.length + 1];
        sets[0] = "global";
        for (int i = 0; i < modes.length; ++i) {
            String name;
            sets[i + 1] = name = modes[i].getName();
            this.modeAbbrevs.put(name, new AbbrevsModel((Map)_modeAbbrevs.get(name)));
        }
        this.setsComboBox = new JComboBox<String>(sets);
        ActionHandler actionHandler = new ActionHandler();
        this.setsComboBox.addActionListener(actionHandler);
        panel2.add(this.setsComboBox);
        panel2.add(Box.createGlue());
        panel.add((Component)panel2, "South");
        this.add("North", panel);
        this.globalAbbrevs = new AbbrevsModel(Abbrevs.getGlobalAbbrevs());
        this.abbrevsTable = new JTable(this.globalAbbrevs);
        this.abbrevsTable.setRowHeight(GenericGUIUtilities.defaultRowHeight());
        this.abbrevsTable.getColumnModel().getColumn(1).setCellRenderer(new Renderer());
        this.abbrevsTable.setAutoResizeMode(4);
        this.abbrevsTable.getTableHeader().setReorderingAllowed(false);
        this.abbrevsTable.getTableHeader().addMouseListener(new HeaderMouseHandler());
        this.abbrevsTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.abbrevsTable.getSelectionModel().setSelectionMode(0);
        this.abbrevsTable.addMouseListener(new TableMouseHandler());
        Dimension d = this.abbrevsTable.getPreferredSize();
        d.height = Math.min(d.height, 200);
        JScrollPane scroller = new JScrollPane(this.abbrevsTable);
        scroller.setPreferredSize(d);
        this.add("Center", scroller);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(new EmptyBorder(6, 0, 0, 0));
        this.add = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.abbrevs.add.icon")));
        this.add.setToolTipText(jEdit.getProperty("options.abbrevs.add"));
        this.add.addActionListener(actionHandler);
        buttons.add(this.add);
        this.remove = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.abbrevs.remove.icon")));
        this.remove.setToolTipText(jEdit.getProperty("options.abbrevs.remove"));
        this.remove.addActionListener(actionHandler);
        buttons.add(this.remove);
        this.edit = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.abbrevs.edit.icon")));
        this.edit.setToolTipText(jEdit.getProperty("options.abbrevs.edit"));
        this.edit.addActionListener(actionHandler);
        buttons.add(this.edit);
        buttons.add(Box.createGlue());
        this.add("South", buttons);
        this.setsComboBox.setSelectedIndex(jEdit.getIntegerProperty("options.abbrevs.combobox.index", 0));
        this.updateEnabled();
    }

    @Override
    protected void _save() {
        if (this.abbrevsTable.getCellEditor() != null) {
            this.abbrevsTable.getCellEditor().stopCellEditing();
        }
        Abbrevs.setExpandOnInput(this.expandOnInput.isSelected());
        Abbrevs.setGlobalAbbrevs(this.globalAbbrevs.toHashtable());
        Hashtable<String, Hashtable<String, String>> modeHash = new Hashtable<String, Hashtable<String, String>>();
        Set<Map.Entry<String, AbbrevsModel>> entrySet = this.modeAbbrevs.entrySet();
        for (Map.Entry<String, AbbrevsModel> entry : entrySet) {
            modeHash.put(entry.getKey(), entry.getValue().toHashtable());
        }
        Abbrevs.setModeAbbrevs(modeHash);
    }

    private void updateEnabled() {
        int selectedRow = this.abbrevsTable.getSelectedRow();
        this.edit.setEnabled(selectedRow != -1);
        this.remove.setEnabled(selectedRow != -1);
    }

    private void edit() {
        AbbrevsModel abbrevsModel = (AbbrevsModel)this.abbrevsTable.getModel();
        int row = this.abbrevsTable.getSelectedRow();
        String abbrev = (String)abbrevsModel.getValueAt(row, 0);
        String expansion = (String)abbrevsModel.getValueAt(row, 1);
        String oldAbbrev = abbrev;
        EditAbbrevDialog dialog = new EditAbbrevDialog((Dialog)GenericGUIUtilities.getParentDialog(this), abbrev, expansion, abbrevsModel.toHashtable());
        abbrev = dialog.getAbbrev();
        expansion = dialog.getExpansion();
        if (abbrev != null && expansion != null) {
            for (int i = 0; i < abbrevsModel.getRowCount(); ++i) {
                if (!abbrevsModel.getValueAt(i, 0).equals(oldAbbrev)) continue;
                abbrevsModel.remove(i);
                break;
            }
            this.add(abbrevsModel, abbrev, expansion);
        }
    }

    private void add(AbbrevsModel abbrevsModel, String abbrev, String expansion) {
        for (int i = 0; i < abbrevsModel.getRowCount(); ++i) {
            if (!abbrevsModel.getValueAt(i, 0).equals(abbrev)) continue;
            abbrevsModel.remove(i);
            break;
        }
        abbrevsModel.add(abbrev, expansion);
        this.updateEnabled();
    }

    private static class AbbrevsModel
    extends AbstractTableModel {
        List<Abbrev> abbrevs = new Vector<Abbrev>();
        int lastSort;

        AbbrevsModel(Map<String, String> abbrevHash) {
            if (abbrevHash != null) {
                Set<Map.Entry<String, String>> entrySet = abbrevHash.entrySet();
                for (Map.Entry<String, String> entry : entrySet) {
                    this.abbrevs.add(new Abbrev(entry.getKey(), entry.getValue()));
                }
                this.sort(0);
            }
        }

        void sort(int col) {
            this.lastSort = col;
            Collections.sort(this.abbrevs, new AbbrevCompare(col));
            this.fireTableDataChanged();
        }

        void add(String abbrev, String expansion) {
            this.abbrevs.add(new Abbrev(abbrev, expansion));
            this.sort(this.lastSort);
        }

        void remove(int index) {
            this.abbrevs.remove(index);
            this.fireTableStructureChanged();
        }

        public Hashtable<String, String> toHashtable() {
            Hashtable<String, String> hash = new Hashtable<String, String>();
            for (Abbrev abbrev : this.abbrevs) {
                if (abbrev.abbrev.length() <= 0 || abbrev.expand.length() <= 0) continue;
                hash.put(abbrev.abbrev, abbrev.expand);
            }
            return hash;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.abbrevs.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Abbrev abbrev = this.abbrevs.get(row);
            switch (col) {
                case 0: {
                    return abbrev.abbrev;
                }
                case 1: {
                    return abbrev.expand;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (value == null) {
                value = "";
            }
            Abbrev abbrev = this.abbrevs.get(row);
            if (col == 0) {
                abbrev.abbrev = (String)value;
            } else {
                abbrev.expand = (String)value;
            }
            this.fireTableRowsUpdated(row, row);
        }

        @Override
        public String getColumnName(int index) {
            switch (index) {
                case 0: {
                    return jEdit.getProperty("options.abbrevs.abbrev");
                }
                case 1: {
                    return jEdit.getProperty("options.abbrevs.expand");
                }
            }
            return null;
        }

        private static class Abbrev {
            String abbrev;
            String expand;

            Abbrev() {
            }

            Abbrev(String abbrev, String expand) {
                this.abbrev = abbrev;
                this.expand = expand;
            }
        }

        private static class AbbrevCompare
        implements Comparator<Abbrev> {
            private int col;

            AbbrevCompare(int col) {
                this.col = col;
            }

            @Override
            public int compare(Abbrev a1, Abbrev a2) {
                if (this.col == 0) {
                    String abbrev1 = a1.abbrev.toLowerCase();
                    String abbrev2 = a2.abbrev.toLowerCase();
                    return StandardUtilities.compareStrings(abbrev1, abbrev2, true);
                }
                String expand1 = a1.expand.toLowerCase();
                String expand2 = a2.expand.toLowerCase();
                return StandardUtilities.compareStrings(expand1, expand2, true);
            }
        }
    }

    private static class Renderer
    extends DefaultTableCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int col) {
            StringBuilder valueStr = new StringBuilder(value.toString());
            if (valueStr.toString().toLowerCase().startsWith("<html>")) {
                valueStr.insert(32, 0);
            }
            return super.getTableCellRendererComponent(table, valueStr.toString(), isSelected, cellHasFocus, row, col);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AbbrevsModel abbrevsModel = (AbbrevsModel)AbbrevsOptionPane.this.abbrevsTable.getModel();
            Object source = evt.getSource();
            if (source == AbbrevsOptionPane.this.setsComboBox) {
                jEdit.setIntegerProperty("options.abbrevs.combobox.index", AbbrevsOptionPane.this.setsComboBox.getSelectedIndex());
                String selected = (String)AbbrevsOptionPane.this.setsComboBox.getSelectedItem();
                if (selected.equals("global")) {
                    AbbrevsOptionPane.this.abbrevsTable.setModel(AbbrevsOptionPane.this.globalAbbrevs);
                } else {
                    AbbrevsOptionPane.this.abbrevsTable.setModel((TableModel)AbbrevsOptionPane.this.modeAbbrevs.get(selected));
                }
                AbbrevsOptionPane.this.updateEnabled();
            } else if (source == AbbrevsOptionPane.this.add) {
                EditAbbrevDialog dialog = new EditAbbrevDialog((Dialog)GenericGUIUtilities.getParentDialog(AbbrevsOptionPane.this), null, null, abbrevsModel.toHashtable());
                String abbrev = dialog.getAbbrev();
                String expansion = dialog.getExpansion();
                if (abbrev != null && abbrev.length() != 0 && expansion != null && expansion.length() != 0) {
                    AbbrevsOptionPane.this.add(abbrevsModel, abbrev, expansion);
                }
            } else if (source == AbbrevsOptionPane.this.edit) {
                AbbrevsOptionPane.this.edit();
            } else if (source == AbbrevsOptionPane.this.remove) {
                int selectedRow = AbbrevsOptionPane.this.abbrevsTable.getSelectedRow();
                abbrevsModel.remove(selectedRow);
                AbbrevsOptionPane.this.updateEnabled();
            }
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            AbbrevsOptionPane.this.updateEnabled();
        }
    }

    private class TableMouseHandler
    extends MouseAdapter {
        private TableMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                AbbrevsOptionPane.this.edit();
            }
        }
    }

    private class HeaderMouseHandler
    extends MouseAdapter {
        private HeaderMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            switch (AbbrevsOptionPane.this.abbrevsTable.getTableHeader().columnAtPoint(evt.getPoint())) {
                case 0: {
                    ((AbbrevsModel)AbbrevsOptionPane.this.abbrevsTable.getModel()).sort(0);
                    break;
                }
                case 1: {
                    ((AbbrevsModel)AbbrevsOptionPane.this.abbrevsTable.getModel()).sort(1);
                }
            }
        }
    }
}

