/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;

public class WrapWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        WrapWidget wrap = new WrapWidget(view);
        return wrap;
    }

    private static class WrapWidget
    implements Widget {
        private final JLabel wrap = new ToolTipLabel();
        private final View view;

        public WrapWidget(final View view) {
            this.wrap.setHorizontalAlignment(0);
            this.view = view;
            this.wrap.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    view.getBuffer().toggleWordWrap(view);
                }
            });
        }

        @Override
        public JComponent getComponent() {
            return this.wrap;
        }

        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            String wrap = buffer.getStringProperty("wrap");
            if (this.largeBufferDeactivateWrap() && "soft".equals(wrap)) {
                wrap = "none";
            }
            this.wrap.setToolTipText(jEdit.getProperty("view.status.wrap-tooltip", new String[]{jEdit.getProperty("wrap." + wrap)}));
            if ("none".equals(wrap)) {
                this.wrap.setEnabled(false);
                this.wrap.setText("n");
            } else {
                this.wrap.setEnabled(true);
                if ("hard".equals(wrap)) {
                    this.wrap.setText("H");
                } else if ("soft".equals(wrap)) {
                    this.wrap.setText("S");
                }
            }
        }

        @Override
        public void propertiesChanged() {
            Font font = new JLabel().getFont();
            FontMetrics fm = this.wrap.getFontMetrics(font);
            Dimension dim = new Dimension(Math.max(Math.max(fm.charWidth('N'), fm.charWidth('H')), fm.charWidth('S')) + 1, fm.getHeight());
            this.wrap.setPreferredSize(dim);
            this.wrap.setMaximumSize(dim);
        }

        private boolean largeBufferDeactivateWrap() {
            Buffer buffer = this.view.getBuffer();
            String largeFileMode = buffer.getStringProperty("largefilemode");
            return "limited".equals(largeFileMode) || "nohighlight".equals(largeFileMode);
        }
    }
}

