/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.ColorWellButton;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.SyntaxUtilities;

public class StyleEditor
extends EnhancedDialog
implements ActionListener {
    private JCheckBox italics;
    private JCheckBox bold;
    private JCheckBox fgColorCheckBox;
    private ColorWellButton fgColor;
    private JCheckBox bgColorCheckBox;
    private ColorWellButton bgColor;
    private JButton ok;
    private JButton cancel;
    private boolean okClicked;

    public static void invokeForCaret(JEditTextArea textArea) {
        JEditBuffer buffer = textArea.getBuffer();
        int lineNum = textArea.getCaretLine();
        int start = buffer.getLineStartOffset(lineNum);
        int position = textArea.getCaretPosition();
        DefaultTokenHandler tokenHandler = new DefaultTokenHandler();
        buffer.markTokens(lineNum, tokenHandler);
        Token token = tokenHandler.getTokens();
        while (token.id != 127) {
            int next = start + token.length;
            if (start <= position && next > position) break;
            start = next;
            token = token.next;
        }
        if (token.id == 127 || token.id % 19 == 0) {
            JOptionPane.showMessageDialog(textArea.getView(), jEdit.getProperty("syntax-style-no-token.message"), jEdit.getProperty("syntax-style-no-token.title"), -1);
            return;
        }
        String typeName = Token.tokenToString(token.id);
        String property = "view.style." + typeName.toLowerCase();
        Font font = new JLabel().getFont();
        SyntaxStyle currentStyle = SyntaxUtilities.parseStyle(jEdit.getProperty(property), font.getFamily(), font.getSize(), true);
        SyntaxStyle style = new StyleEditor(textArea.getView(), currentStyle, typeName).getStyle();
        if (style != null) {
            jEdit.setProperty(property, GUIUtilities.getStyleString(style));
            jEdit.propertiesChanged();
        }
    }

    public StyleEditor(JDialog parent, SyntaxStyle style, String styleName) {
        super(parent, jEdit.getProperty("style-editor.title"), true);
        this.initialize(parent, style, styleName);
    }

    public StyleEditor(JFrame parent, SyntaxStyle style, String styleName) {
        super(parent, jEdit.getProperty("style-editor.title"), true);
        this.initialize(parent, style, styleName);
    }

    private void initialize(Component comp, SyntaxStyle style, String styleName) {
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        JPanel panel = new JPanel(new GridLayout(5, 2, 12, 12));
        panel.add(new JLabel(jEdit.getProperty("style-editor.tokenType")));
        panel.add(new JLabel(styleName));
        this.italics = new JCheckBox(jEdit.getProperty("style-editor.italics"));
        this.italics.setSelected(style.getFont().isItalic());
        panel.add(this.italics);
        panel.add(new JLabel());
        this.bold = new JCheckBox(jEdit.getProperty("style-editor.bold"));
        this.bold.setSelected(style.getFont().isBold());
        panel.add(this.bold);
        panel.add(new JLabel());
        Color fg = style.getForegroundColor();
        if (fg == null) {
            fg = jEdit.getActiveView().getForeground();
        }
        this.fgColorCheckBox = new JCheckBox(jEdit.getProperty("style-editor.fgColor"));
        this.fgColorCheckBox.setSelected(fg != null);
        this.fgColorCheckBox.addActionListener(this);
        panel.add(this.fgColorCheckBox);
        this.fgColor = new ColorWellButton(fg);
        this.fgColor.setEnabled(fg != null);
        panel.add(this.fgColor);
        Color bg = style.getBackgroundColor();
        if (bg == null) {
            bg = jEdit.getActiveView().getBackground();
        }
        this.bgColorCheckBox = new JCheckBox(jEdit.getProperty("style-editor.bgColor"));
        this.bgColorCheckBox.setSelected(bg != null);
        this.bgColorCheckBox.addActionListener(this);
        panel.add(this.bgColorCheckBox);
        this.bgColor = new ColorWellButton(bg);
        this.bgColor.setEnabled(bg != null);
        panel.add(this.bgColor);
        content.add("Center", panel);
        Box box = new Box(0);
        box.setBorder(BorderFactory.createEmptyBorder(17, 0, 0, 0));
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.getRootPane().setDefaultButton(this.ok);
        this.ok.addActionListener(this);
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(this);
        GenericGUIUtilities.makeSameSize(this.ok, this.cancel);
        box.add(Box.createGlue());
        box.add(this.ok);
        box.add(Box.createHorizontalStrut(6));
        box.add(this.cancel);
        content.add("South", box);
        this.pack();
        this.setLocationRelativeTo(comp);
        this.setResizable(false);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.ok) {
            this.ok();
        } else if (source == this.cancel) {
            this.cancel();
        } else if (source == this.fgColorCheckBox) {
            this.fgColor.setEnabled(this.fgColorCheckBox.isSelected());
        } else if (source == this.bgColorCheckBox) {
            this.bgColor.setEnabled(this.bgColorCheckBox.isSelected());
        }
    }

    @Override
    public void ok() {
        this.okClicked = true;
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    public SyntaxStyle getStyle() {
        if (!this.okClicked) {
            return null;
        }
        Color foreground = this.fgColorCheckBox.isSelected() ? this.fgColor.getSelectedColor() : null;
        Color background = this.bgColorCheckBox.isSelected() ? this.bgColor.getSelectedColor() : null;
        Font font = new JLabel().getFont();
        return new SyntaxStyle(foreground, background, new Font(font.getFamily(), (this.italics.isSelected() ? 2 : 0) | (this.bold.isSelected() ? 1 : 0), font.getSize()));
    }
}

