/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.datatransfer.JEditDataFlavor;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.GenericGUIUtilities;

public class PasteSpecialDialog
extends EnhancedDialog {
    private static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, JEditDataFlavor.jEditRichTextDataFlavor, JEditDataFlavor.html};
    private final TextArea textArea;
    private JList<DataFlavor> flavorList;

    public PasteSpecialDialog(View view, TextArea textArea) {
        super(view, jEdit.getProperty("paste-special.title"), true);
        this.textArea = textArea;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        Registers.Register register = Registers.getRegister('$');
        Transferable transferable = register.getTransferable();
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        List<DataFlavor> flavorList = Arrays.asList(flavors);
        ArrayList<DataFlavor> supportedFlavors = new ArrayList<DataFlavor>(PasteSpecialDialog.flavors.length);
        for (DataFlavor flavor : PasteSpecialDialog.flavors) {
            if (!flavorList.contains(flavor)) continue;
            supportedFlavors.add(flavor);
        }
        this.flavorList = new JList<DataFlavor>(supportedFlavors.toArray(new DataFlavor[supportedFlavors.size()]));
        this.flavorList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value.equals(DataFlavor.stringFlavor)) {
                    this.setText("Plain text");
                } else if (value.equals(JEditDataFlavor.jEditRichTextDataFlavor)) {
                    this.setText("jEdit rich text");
                } else if (value.equals(JEditDataFlavor.html)) {
                    this.setText("html");
                }
                return this;
            }
        });
        this.getContentPane().add(new JScrollPane(this.flavorList));
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(new EmptyBorder(17, 0, 0, 0));
        buttons.add(Box.createGlue());
        JButton ok = new JButton(jEdit.getProperty("common.ok"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasteSpecialDialog.this.ok();
            }
        });
        this.getRootPane().setDefaultButton(ok);
        buttons.add(ok);
        buttons.add(Box.createHorizontalStrut(6));
        JButton cancel = new JButton(jEdit.getProperty("common.cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasteSpecialDialog.this.cancel();
            }
        });
        buttons.add(cancel);
        GenericGUIUtilities.makeSameSize(ok, cancel);
        content.add("South", buttons);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    @Override
    public void ok() {
        DataFlavor flavor = this.flavorList.getSelectedValue();
        if (flavor == null) {
            flavor = DataFlavor.stringFlavor;
        }
        Registers.paste(this.textArea, '$', flavor);
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }
}

