/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.event.InputEvent;
import java.util.Hashtable;
import javax.swing.UIManager;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.ShortcutPrefixActiveEvent;

public class DefaultInputHandler
extends InputHandler {
    public DefaultInputHandler(View view, Hashtable bindings) {
        super(view);
        if (bindings == null) {
            throw new NullPointerException();
        }
        this.bindings = this.currentBindings = bindings;
    }

    public DefaultInputHandler(View view) {
        this(view, new Hashtable());
    }

    public DefaultInputHandler(View view, DefaultInputHandler copy) {
        this(view, copy.bindings);
    }

    @Override
    public boolean isPrefixActive() {
        return this.bindings != this.currentBindings || super.isPrefixActive();
    }

    @Override
    public void setCurrentBindings(Hashtable bindings) {
        this.view.getStatus().setMessage((String)bindings.get(PREFIX_STR));
        this.currentBindings = bindings;
    }

    @Override
    public boolean handleKey(KeyEventTranslator.Key keyStroke, boolean dryRun) {
        Object o;
        char input = '\u0000';
        if (keyStroke.modifiers == null || keyStroke.modifiers.equals("S")) {
            switch (keyStroke.key) {
                case 9: 
                case 10: {
                    input = (char)keyStroke.key;
                    break;
                }
                default: {
                    input = keyStroke.input;
                }
            }
        }
        if (this.readNextChar != null) {
            if (input != '\u0000') {
                if (!dryRun) {
                    this.setCurrentBindings(this.bindings);
                    this.invokeReadNextChar(input);
                    this.repeatCount = 1;
                }
                return true;
            }
            if (!dryRun) {
                this.readNextChar = null;
                this.view.getStatus().setMessage(null);
            }
        }
        if ((o = this.currentBindings.get(keyStroke)) == null) {
            if (!dryRun) {
                if (this.currentBindings != this.bindings) {
                    UIManager.getLookAndFeel().provideErrorFeedback(null);
                    this.repeatCount = 1;
                    this.setCurrentBindings(this.bindings);
                } else if (input != '\u0000' && !keyStroke.isFromGlobalContext()) {
                    this.userInput(input);
                }
                this.sendShortcutPrefixOff();
            }
        } else {
            if (o instanceof Hashtable) {
                if (!dryRun) {
                    this.setCurrentBindings((Hashtable)o);
                    ShortcutPrefixActiveEvent.firePrefixStateChange(this.currentBindings, true);
                    this.shortcutOn = true;
                }
                return true;
            }
            if (o instanceof String) {
                if (!dryRun) {
                    this.setCurrentBindings(this.bindings);
                    this.sendShortcutPrefixOff();
                    this.invokeAction((String)o);
                }
                return true;
            }
            if (o instanceof EditAction) {
                if (!dryRun) {
                    this.setCurrentBindings(this.bindings);
                    this.sendShortcutPrefixOff();
                    this.invokeAction((EditAction)o);
                }
                return true;
            }
        }
        if (!dryRun) {
            this.sendShortcutPrefixOff();
        }
        return false;
    }

    public static char getSymbolicModifierName(int mod) {
        return KeyEventTranslator.getSymbolicModifierName(mod);
    }

    public static String getModifierString(InputEvent evt) {
        return KeyEventTranslator.getModifierString(evt);
    }
}

