/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.swing.UIManager;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.buffer.BufferListener;
import org.gjt.sp.jedit.buffer.ContentManager;
import org.gjt.sp.jedit.buffer.DummyFoldHandler;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.LineManager;
import org.gjt.sp.jedit.buffer.PositionManager;
import org.gjt.sp.jedit.buffer.UndoManager;
import org.gjt.sp.jedit.indent.IndentAction;
import org.gjt.sp.jedit.indent.IndentRule;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.DummyTokenHandler;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.textarea.ColumnBlock;
import org.gjt.sp.jedit.textarea.ColumnBlockLine;
import org.gjt.sp.jedit.textarea.Node;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.IntegerArray;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class JEditBuffer {
    public static final String LINESEP = "lineSeparator";
    public static final String ENCODING = "encoding";
    public static final int NORMAL_PRIORITY = 0;
    public static final int HIGH_PRIORITY = 1;
    protected Mode mode;
    protected boolean contextInsensitive;
    protected UndoManager undoMgr;
    protected TokenMarker tokenMarker;
    private final List<Listener> bufferListeners = new Vector<Listener>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ContentManager contentMgr = new ContentManager();
    private final LineManager lineMgr = new LineManager();
    private final PositionManager positionMgr = new PositionManager(this);
    @Nonnull
    private FoldHandler foldHandler;
    private final IntegerArray integerArray;
    private boolean undoInProgress;
    private boolean dirty;
    private boolean readOnly;
    private boolean readOnlyOverride;
    private boolean editable = true;
    private boolean transaction;
    private boolean loading;
    private boolean io;
    private final Map<Object, PropValue> properties;
    private final Object propertyLock;
    public boolean elasticTabstopsOn = false;
    private ColumnBlock columnBlock;
    public final Object columnBlockLock;

    public JEditBuffer(Map props) {
        this.undoMgr = new UndoManager(this);
        this.integerArray = new IntegerArray();
        this.propertyLock = new Object();
        this.properties = new HashMap<Object, PropValue>();
        this.columnBlockLock = new Object();
        Set set = props.entrySet();
        for (Map.Entry entry : set) {
            this.properties.put(entry.getKey(), new PropValue(entry.getValue(), false));
        }
        if (this.getProperty(ENCODING) == null) {
            this.properties.put(ENCODING, new PropValue(System.getProperty("file.encoding"), false));
        }
        if (this.getProperty(LINESEP) == null) {
            this.properties.put(LINESEP, new PropValue(System.getProperty("line.separator"), false));
        }
        this.setFoldHandler(new DummyFoldHandler());
    }

    public JEditBuffer() {
        this.undoMgr = new UndoManager(this);
        this.integerArray = new IntegerArray();
        this.propertyLock = new Object();
        this.properties = new HashMap<Object, PropValue>();
        this.columnBlockLock = new Object();
        this.properties.put("wrap", new PropValue("none", false));
        this.properties.put("folding", new PropValue("none", false));
        this.tokenMarker = new TokenMarker();
        this.tokenMarker.addRuleSet(new ParserRuleSet("text", "MAIN"));
        this.setTokenMarker(this.tokenMarker);
        this.loadText(null, null);
        if (this.getProperty(ENCODING) == null) {
            this.properties.put(ENCODING, new PropValue(System.getProperty("file.encoding"), false));
        }
        if (this.getProperty(LINESEP) == null) {
            this.properties.put(LINESEP, new PropValue(System.getProperty("line.separator"), false));
        }
        this.setFoldHandler(new DummyFoldHandler());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public boolean isPerformingIO() {
        return this.isLoading() || this.io;
    }

    public void setPerformingIO(boolean io) {
        this.io = io;
    }

    public boolean isEditable() {
        return !this.isPerformingIO() && this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isReadOnly() {
        return this.readOnly || this.readOnlyOverride;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnlyOverride = readOnly;
    }

    public void setDirty(boolean d) {
        boolean editable = this.isEditable();
        if (d) {
            if (editable) {
                this.dirty = true;
            }
        } else {
            this.dirty = false;
            if (!this.isUndoInProgress()) {
                this.undoMgr.resetClearDirty();
            }
        }
    }

    public void readLock() {
        this.lock.readLock().lock();
    }

    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    public void writeLock() {
        this.lock.writeLock().lock();
    }

    public void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    public int getLength() {
        return this.contentMgr.getLength();
    }

    public int getLineCount() {
        return this.lineMgr.getLineCount();
    }

    public int getLineOfOffset(int offset) {
        try {
            this.readLock();
            if (offset < 0 || offset > this.getLength()) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            int n = this.lineMgr.getLineOfOffset(offset);
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    public int getLineStartOffset(int line) {
        try {
            this.readLock();
            if (line < 0 || line >= this.lineMgr.getLineCount()) {
                throw new ArrayIndexOutOfBoundsException(line);
            }
            if (line == 0) {
                int n = 0;
                return n;
            }
            int n = this.lineMgr.getLineEndOffset(line - 1);
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    public int getLineEndOffset(int line) {
        try {
            this.readLock();
            if (line < 0 || line >= this.lineMgr.getLineCount()) {
                throw new ArrayIndexOutOfBoundsException(line);
            }
            int n = this.lineMgr.getLineEndOffset(line);
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    public int getLineLength(int line) {
        try {
            this.readLock();
            int n = this.getLineEndOffset(line) - this.getLineStartOffset(line) - 1;
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    public int getPriorNonEmptyLine(int lineIndex) {
        if (!this.mode.getIgnoreWhitespace()) {
            return lineIndex - 1;
        }
        int returnValue = -1;
        for (int i = lineIndex - 1; i >= 0; --i) {
            Segment seg = new Segment();
            this.getLineText(i, seg);
            if (seg.count != 0) {
                returnValue = i;
            }
            for (int j = 0; j < seg.count; ++j) {
                char ch = seg.array[seg.offset + j];
                if (Character.isWhitespace(ch)) continue;
                return i;
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLineText(int line) {
        if (line < 0 || line >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(line);
        }
        try {
            this.readLock();
            int start = line == 0 ? 0 : this.lineMgr.getLineEndOffset(line - 1);
            int end = this.lineMgr.getLineEndOffset(line);
            String string = this.getText(start, end - start - 1);
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    public void getLineText(int line, Segment segment) {
        this.getLineText(line, 0, segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLineText(int line, int relativeStartOffset, Segment segment) {
        if (line < 0 || line >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(line);
        }
        try {
            this.readLock();
            int start = line == 0 ? 0 : this.lineMgr.getLineEndOffset(line - 1);
            int end = this.lineMgr.getLineEndOffset(line);
            if (start + relativeStartOffset > end) {
                throw new IllegalArgumentException("This index is outside the line length (start+relativeOffset):" + start + " + " + relativeStartOffset + " > endffset:" + end);
            }
            this.getText(start + relativeStartOffset, end - start - relativeStartOffset - 1, segment);
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence getLineSegment(int line) {
        if (line < 0 || line >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(line);
        }
        try {
            this.readLock();
            int start = line == 0 ? 0 : this.lineMgr.getLineEndOffset(line - 1);
            int end = this.lineMgr.getLineEndOffset(line);
            CharSequence charSequence = this.getSegment(start, end - start - 1);
            return charSequence;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(int start, int length) {
        try {
            this.readLock();
            if (start < 0 || length < 0 || start + length > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(start + ":" + length);
            }
            String string = this.contentMgr.getText(start, length);
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    public String getText() {
        try {
            this.readLock();
            String string = this.contentMgr.getText(0, this.getLength());
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getText(int start, int length, Segment seg) {
        try {
            this.readLock();
            if (start < 0 || length < 0 || start + length > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(start + ":" + length);
            }
            this.contentMgr.getText(start, length, seg);
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence getSegment(int start, int length) {
        try {
            this.readLock();
            if (start < 0 || length < 0 || start + length > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(start + ":" + length);
            }
            CharSequence charSequence = this.contentMgr.getSegment(start, length);
            return charSequence;
        }
        finally {
            this.readUnlock();
        }
    }

    public void insert(int offset, String str) {
        this.insert(offset, (CharSequence)str);
    }

    public void insert(int offset, Segment seg) {
        this.insert(offset, (CharSequence)seg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int offset, CharSequence seq) {
        if (seq == null) {
            return;
        }
        int len = seq.length();
        if (len == 0) {
            return;
        }
        try {
            this.writeLock();
            if (offset < 0 || offset > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            this.contentMgr.insert(offset, seq);
            this.integerArray.clear();
            for (int i = 0; i < len; ++i) {
                if (seq.charAt(i) != '\n') continue;
                this.integerArray.add(i + 1);
            }
            if (!this.undoInProgress) {
                this.undoMgr.contentInserted(offset, len, seq.toString(), !this.dirty);
            }
            this.contentInserted(offset, len, this.integerArray);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int offset, int length) {
        if (length == 0) {
            return;
        }
        try {
            this.transaction = true;
            this.writeLock();
            if (offset < 0 || length < 0 || offset + length > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(offset + ":" + length);
            }
            int startLine = this.lineMgr.getLineOfOffset(offset);
            int endLine = this.lineMgr.getLineOfOffset(offset + length);
            int numLines = endLine - startLine;
            if (!this.undoInProgress && !this.loading) {
                this.undoMgr.contentRemoved(offset, length, this.getText(offset, length), !this.dirty);
            }
            this.firePreContentRemoved(startLine, offset, numLines, length);
            this.contentMgr.remove(offset, length);
            this.lineMgr.contentRemoved(startLine, offset, numLines, length);
            this.positionMgr.contentRemoved(offset, length);
            this.setDirty(true);
            this.fireContentRemoved(startLine, offset, numLines, length);
            if (!this.undoInProgress && !this.insideCompoundEdit()) {
                this.fireTransactionComplete();
            }
        }
        finally {
            this.transaction = false;
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrailingWhiteSpace(int[] lines) {
        try {
            this.beginCompoundEdit();
            for (int line : lines) {
                int lineEnd;
                int pos;
                Segment seg = new Segment();
                this.getLineText(line, seg);
                if (seg.count == 0) continue;
                int lineStart = seg.offset;
                for (pos = lineEnd = seg.offset + seg.count - 1; pos >= lineStart && Character.isWhitespace(seg.array[pos]); --pos) {
                }
                int tail = lineEnd - pos;
                if (tail == 0) continue;
                this.remove(this.getLineEndOffset(line) - 1 - tail, tail);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shiftIndentLeft(int[] lines) {
        int tabSize = this.getTabSize();
        int indentSize = this.getIndentSize();
        boolean noTabs = this.getBooleanProperty("noTabs");
        try {
            this.beginCompoundEdit();
            for (int l : lines) {
                int lineStart = this.getLineStartOffset(l);
                CharSequence line = this.getLineSegment(l);
                int whiteSpace = StandardUtilities.getLeadingWhiteSpace(line);
                if (whiteSpace == 0) continue;
                int whiteSpaceWidth = Math.max(0, StandardUtilities.getLeadingWhiteSpaceWidth(line, tabSize) - indentSize);
                this.insert(lineStart + whiteSpace, StandardUtilities.createWhiteSpace(whiteSpaceWidth, noTabs ? 0 : tabSize));
                this.remove(lineStart, whiteSpace);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shiftIndentRight(int[] lines) {
        try {
            this.beginCompoundEdit();
            int tabSize = this.getTabSize();
            int indentSize = this.getIndentSize();
            boolean noTabs = this.getBooleanProperty("noTabs");
            for (int l : lines) {
                int lineStart = this.getLineStartOffset(l);
                CharSequence line = this.getLineSegment(l);
                int whiteSpace = StandardUtilities.getLeadingWhiteSpace(line);
                int whiteSpaceWidth = StandardUtilities.getLeadingWhiteSpaceWidth(line, tabSize) + indentSize;
                this.insert(lineStart + whiteSpace, StandardUtilities.createWhiteSpace(whiteSpaceWidth, noTabs ? 0 : tabSize));
                this.remove(lineStart, whiteSpace);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indentLines(int start, int end) {
        try {
            this.beginCompoundEdit();
            for (int i = start; i <= end; ++i) {
                this.indentLine(i, true);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indentLines(int[] lines) {
        try {
            this.beginCompoundEdit();
            for (int line : lines) {
                this.indentLine(line, true);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleIndentLine(int lineIndex) {
        int[] whitespaceChars = new int[1];
        int prevLineIndex = this.getPriorNonEmptyLine(lineIndex);
        if (prevLineIndex == -1) {
            return;
        }
        String indentString = StandardUtilities.getIndentString(this.getLineText(prevLineIndex));
        try {
            this.beginCompoundEdit();
            int start = this.getLineStartOffset(lineIndex);
            this.remove(start, whitespaceChars[0]);
            this.insert(start, indentString);
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indentLine(int lineIndex, boolean canDecreaseIndent) {
        int prevLineIndex;
        int[] whitespaceChars = new int[1];
        int currentIndent = this.getCurrentIndentForLine(lineIndex, whitespaceChars);
        int prevLineIndent = (prevLineIndex = this.getPriorNonEmptyLine(lineIndex)) == -1 ? 0 : StandardUtilities.getLeadingWhiteSpaceWidth(this.getLineSegment(prevLineIndex), this.getTabSize());
        int idealIndent = this.getIdealIndentForLine(lineIndex, prevLineIndex, prevLineIndent);
        if (idealIndent == -1 || idealIndent == currentIndent || !canDecreaseIndent && idealIndent < currentIndent) {
            return false;
        }
        try {
            String prevIndentString;
            this.beginCompoundEdit();
            int start = this.getLineStartOffset(lineIndex);
            this.remove(start, whitespaceChars[0]);
            String string = prevIndentString = prevLineIndex >= 0 ? StandardUtilities.getIndentString(this.getLineText(prevLineIndex)) : null;
            String indentString = prevIndentString == null ? StandardUtilities.createWhiteSpace(idealIndent, this.getBooleanProperty("noTabs") ? 0 : this.getTabSize()) : (idealIndent == prevLineIndent ? prevIndentString : (idealIndent < prevLineIndent ? StandardUtilities.truncateWhiteSpace(idealIndent, this.getTabSize(), prevIndentString) : prevIndentString + StandardUtilities.createWhiteSpace(idealIndent - prevLineIndent, this.getBooleanProperty("noTabs") ? 0 : this.getTabSize(), prevLineIndent)));
            this.insert(start, indentString);
        }
        finally {
            this.endCompoundEdit();
        }
        return true;
    }

    public int getCurrentIndentForLine(int lineIndex, int[] whitespaceChars) {
        Segment seg = new Segment();
        this.getLineText(lineIndex, seg);
        int tabSize = this.getTabSize();
        int currentIndent = 0;
        block4: for (int i = 0; i < seg.count; ++i) {
            char c = seg.array[seg.offset + i];
            switch (c) {
                case ' ': {
                    ++currentIndent;
                    if (whitespaceChars == null) continue block4;
                    whitespaceChars[0] = whitespaceChars[0] + 1;
                    continue block4;
                }
                case '\t': {
                    currentIndent += tabSize - currentIndent % tabSize;
                    if (whitespaceChars == null) continue block4;
                    whitespaceChars[0] = whitespaceChars[0] + 1;
                    continue block4;
                }
            }
        }
        return currentIndent;
    }

    public int getIdealIndentForLine(int lineIndex) {
        int prevLineIndex = this.getPriorNonEmptyLine(lineIndex);
        int oldIndent = prevLineIndex == -1 ? 0 : StandardUtilities.getLeadingWhiteSpaceWidth(this.getLineSegment(prevLineIndex), this.getTabSize());
        return this.getIdealIndentForLine(lineIndex, prevLineIndex, oldIndent);
    }

    private int getIdealIndentForLine(int lineIndex, int prevLineIndex, int oldIndent) {
        int prevPrevLineIndex = prevLineIndex < 0 ? -1 : this.getPriorNonEmptyLine(prevLineIndex);
        int newIndent = oldIndent;
        List<IndentRule> indentRules = this.getIndentRules(lineIndex);
        LinkedList<IndentAction> actions = new LinkedList<IndentAction>();
        for (IndentRule rule : indentRules) {
            rule.apply(this, lineIndex, prevLineIndex, prevPrevLineIndex, actions);
        }
        for (IndentAction action : actions) {
            newIndent = action.calculateIndent(this, lineIndex, oldIndent, newIndent);
            if (action.keepChecking()) continue;
            break;
        }
        if (newIndent < 0) {
            newIndent = 0;
        }
        return newIndent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVirtualWidth(int line, int column) {
        try {
            this.readLock();
            int start = this.getLineStartOffset(line);
            Segment seg = new Segment();
            this.getText(start, column, seg);
            int n = StandardUtilities.getVirtualWidth(seg, this.getTabSize());
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOffsetOfVirtualColumn(int line, int column, int[] totalVirtualWidth) {
        try {
            this.readLock();
            Segment seg = new Segment();
            this.getLineText(line, seg);
            int n = StandardUtilities.getOffsetOfVirtualColumn(seg, this.getTabSize(), column, totalVirtualWidth);
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAtColumn(int line, int col, String str) {
        try {
            this.writeLock();
            int[] total = new int[1];
            int offset = this.getOffsetOfVirtualColumn(line, col, total);
            if (offset == -1) {
                offset = this.getLineEndOffset(line) - 1;
                str = StandardUtilities.createWhiteSpace(col - total[0], 0) + str;
            } else {
                offset += this.getLineStartOffset(line);
            }
            this.insert(offset, str);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertIndented(int offset, String text) {
        try {
            this.beginCompoundEdit();
            int firstLine = this.getLineOfOffset(offset);
            CharSequence lineText = this.getLineSegment(firstLine);
            int leadingIndent = StandardUtilities.getLeadingWhiteSpaceWidth(lineText, this.getTabSize());
            String whiteSpace = StandardUtilities.createWhiteSpace(leadingIndent, this.getBooleanProperty("noTabs") ? 0 : this.getTabSize());
            this.insert(offset, text);
            int lastLine = this.getLineOfOffset(offset + text.length());
            for (int i = firstLine + 1; i <= lastLine; ++i) {
                this.insert(this.getLineStartOffset(i), whiteSpace);
            }
            int n = whiteSpace.length();
            return n;
        }
        finally {
            this.endCompoundEdit();
        }
    }

    public boolean isElectricKey(char ch, int line) {
        TokenMarker.LineContext ctx = this.getLineContext(line);
        Mode mode = ModeProvider.instance.getMode(ctx.rules.getModeName());
        if (mode == null) {
            return false;
        }
        return mode.isElectricKey(ch);
    }

    public TokenMarker.LineContext getLineContext(int line) {
        return this.lineMgr.getLineContext(line);
    }

    public void markTokens(int lineIndex, TokenHandler tokenHandler) {
        Segment seg = new Segment();
        if (lineIndex < 0 || lineIndex >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(lineIndex);
        }
        int firstInvalidLineContext = this.lineMgr.getFirstInvalidLineContext();
        int start = this.contextInsensitive || firstInvalidLineContext == -1 ? lineIndex : Math.min(firstInvalidLineContext, lineIndex);
        if (Debug.TOKEN_MARKER_DEBUG) {
            Log.log(1, this, "tokenize from " + start + " to " + lineIndex);
        }
        TokenMarker.LineContext oldContext = null;
        TokenMarker.LineContext context = null;
        for (int i = start; i <= lineIndex; ++i) {
            this.getLineText(i, seg);
            oldContext = this.getLineContext(i);
            TokenMarker.LineContext prevContext = i == 0 || this.contextInsensitive ? null : this.getLineContext(i - 1);
            TokenHandler _tokenHandler = i == lineIndex ? tokenHandler : DummyTokenHandler.INSTANCE;
            context = this.markTokens(seg, prevContext, _tokenHandler);
            this.lineMgr.setLineContext(i, context);
        }
        int lineCount = this.lineMgr.getLineCount();
        if (lineCount - 1 == lineIndex) {
            this.lineMgr.setFirstInvalidLineContext(-1);
        } else if (oldContext != context) {
            this.lineMgr.setFirstInvalidLineContext(lineIndex + 1);
        } else if (firstInvalidLineContext != -1) {
            this.lineMgr.setFirstInvalidLineContext(Math.max(firstInvalidLineContext, lineIndex + 1));
        }
    }

    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    public void setTokenMarker(TokenMarker tokenMarker) {
        TokenMarker oldTokenMarker = this.tokenMarker;
        this.tokenMarker = tokenMarker;
        if (oldTokenMarker != null && tokenMarker != oldTokenMarker) {
            this.lineMgr.setFirstInvalidLineContext(0);
        }
    }

    public Position createPosition(int offset) {
        try {
            this.readLock();
            if (offset < 0 || offset > this.contentMgr.getLength()) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            Position position = this.positionMgr.createPosition(offset);
            return position;
        }
        finally {
            this.readUnlock();
        }
    }

    public void propertiesChanged() {
        String folding = this.getStringProperty("folding");
        FoldHandler handler = FoldHandler.getFoldHandler(folding);
        if (handler != null) {
            this.setFoldHandler(handler);
        } else {
            this.setFoldHandler(new DummyFoldHandler());
        }
    }

    public int getTabSize() {
        int tabSize = this.getIntegerProperty("tabSize", 8);
        if (tabSize <= 0) {
            return 8;
        }
        return tabSize;
    }

    public int getIndentSize() {
        int indentSize = this.getIntegerProperty("indentSize", 8);
        if (indentSize <= 0) {
            return 8;
        }
        return indentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(Object name) {
        Object object = this.propertyLock;
        synchronized (object) {
            PropValue o = this.properties.get(name);
            if (o != null) {
                return o.value;
            }
            if (!(name instanceof String)) {
                return null;
            }
            Object retVal = this.getDefaultProperty((String)name);
            if (retVal == null) {
                return null;
            }
            this.properties.put(name, new PropValue(retVal, true));
            return retVal;
        }
    }

    public Object getDefaultProperty(String key) {
        return null;
    }

    public void setProperty(String name, Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            PropValue test = this.properties.get(name);
            if (test == null) {
                this.properties.put(name, new PropValue(value, false));
            } else if (!test.value.equals(value)) {
                test.value = value;
                test.defaultValue = false;
            }
        }
    }

    public void setDefaultProperty(String name, Object value) {
        this.properties.put(name, new PropValue(value, true));
    }

    public void unsetProperty(String name) {
        this.properties.remove(name);
    }

    public void resetCachedProperties() {
        Iterator<PropValue> iter = this.properties.values().iterator();
        while (iter.hasNext()) {
            PropValue value = iter.next();
            if (!value.defaultValue) continue;
            iter.remove();
        }
    }

    public String getStringProperty(String name) {
        Object obj = this.getProperty(name);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public void setStringProperty(String name, String value) {
        this.setProperty(name, value);
    }

    public boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    public boolean getBooleanProperty(String name, boolean def) {
        Object obj = this.getProperty(name);
        return StandardUtilities.getBoolean(obj, def);
    }

    public void setBooleanProperty(String name, boolean value) {
        this.setProperty(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getIntegerProperty(String name, int defaultValue) {
        boolean defaultValueFlag;
        Object obj;
        PropValue value = this.properties.get(name);
        if (value != null) {
            obj = value.value;
            defaultValueFlag = value.defaultValue;
        } else {
            obj = this.getProperty(name);
            defaultValueFlag = true;
        }
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        try {
            int returnValue = Integer.parseInt(obj.toString().trim());
            this.properties.put(name, new PropValue(returnValue, defaultValueFlag));
            return returnValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void setIntegerProperty(String name, int value) {
        this.setProperty(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern getPatternProperty(String name, int flags) {
        Object object = this.propertyLock;
        synchronized (object) {
            boolean defaultValueFlag;
            Object obj;
            PropValue value = this.properties.get(name);
            if (value != null) {
                obj = value.value;
                defaultValueFlag = value.defaultValue;
            } else {
                obj = this.getProperty(name);
                defaultValueFlag = true;
            }
            if (obj == null) {
                return null;
            }
            if (obj instanceof Pattern) {
                return (Pattern)obj;
            }
            Pattern re = Pattern.compile(obj.toString(), flags);
            this.properties.put(name, new PropValue(re, defaultValueFlag));
            return re;
        }
    }

    public ParserRuleSet getRuleSetAtOffset(int offset) {
        int line;
        if ((offset -= this.getLineStartOffset(line = this.getLineOfOffset(offset))) != 0) {
            --offset;
        }
        DefaultTokenHandler tokens = new DefaultTokenHandler();
        this.markTokens(line, tokens);
        Token token = TextUtilities.getTokenAtOffset(tokens.getTokens(), offset);
        return token.rules;
    }

    public KeywordMap getKeywordMapAtOffset(int offset) {
        return this.getRuleSetAtOffset(offset).getKeywords();
    }

    public String getContextSensitiveProperty(int offset, String name) {
        ParserRuleSet rules = this.getRuleSetAtOffset(offset);
        Object value = null;
        Hashtable<String, String> rulesetProps = rules.getProperties();
        if (rulesetProps != null) {
            value = rulesetProps.get(name);
        }
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.setMode(ModeProvider.instance.getMode(mode));
    }

    public void setMode(Mode mode) {
        this.setMode(mode, false);
    }

    public void setMode(Mode mode, boolean forceContextInsensitive) {
        if (mode == null) {
            throw new NullPointerException("Mode must be non-null");
        }
        this.mode = mode;
        this.contextInsensitive = forceContextInsensitive || mode.getBooleanProperty("contextInsensitive");
        this.setTokenMarker(mode.getTokenMarker());
        this.resetCachedProperties();
        this.propertiesChanged();
    }

    public boolean isFoldStart(int line) {
        return line != this.getLineCount() - 1 && this.getFoldLevel(line) < this.getFoldLevel(line + 1);
    }

    public boolean isFoldEnd(int line) {
        int foldLevel = this.getFoldLevel(line);
        int nextLineFoldLevel = line == this.getLineCount() - 1 ? 0 : this.getFoldLevel(line + 1);
        return foldLevel > nextLineFoldLevel;
    }

    public void invalidateCachedFoldLevels() {
        this.lineMgr.setFirstInvalidFoldLevel(0);
        this.fireFoldLevelChanged(0, this.getLineCount());
    }

    public int getFoldLevel(int line) {
        if (line < 0 || line >= this.lineMgr.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(line);
        }
        if (this.foldHandler instanceof DummyFoldHandler) {
            return 0;
        }
        int firstInvalidFoldLevel = this.lineMgr.getFirstInvalidFoldLevel();
        if (firstInvalidFoldLevel == -1 || line < firstInvalidFoldLevel) {
            return this.lineMgr.getFoldLevel(line);
        }
        if (Debug.FOLD_DEBUG) {
            Log.log(1, this, "Invalid fold levels from " + firstInvalidFoldLevel + " to " + line);
        }
        int newFoldLevel = 0;
        boolean changed = false;
        int firstUpdatedFoldLevel = firstInvalidFoldLevel;
        for (int i = firstInvalidFoldLevel; i <= line; ++i) {
            Segment seg = new Segment();
            newFoldLevel = this.foldHandler.getFoldLevel(this, i, seg);
            if (Debug.FOLD_DEBUG) {
                Log.log(1, this, i + " fold level changed");
            }
            changed = true;
            List<Integer> precedingFoldLevels = this.foldHandler.getPrecedingFoldLevels(this, i, seg, newFoldLevel);
            if (precedingFoldLevels != null) {
                int j = i;
                for (Integer foldLevel : precedingFoldLevels) {
                    this.lineMgr.setFoldLevel(--j, foldLevel);
                }
                if (j < firstUpdatedFoldLevel) {
                    firstUpdatedFoldLevel = j;
                }
            }
            this.lineMgr.setFoldLevel(i, newFoldLevel);
        }
        if (line == this.lineMgr.getLineCount() - 1) {
            this.lineMgr.setFirstInvalidFoldLevel(-1);
        } else {
            this.lineMgr.setFirstInvalidFoldLevel(line + 1);
        }
        if (changed) {
            if (Debug.FOLD_DEBUG) {
                Log.log(1, this, "fold level changed: " + firstUpdatedFoldLevel + ',' + line);
            }
            this.fireFoldLevelChanged(firstUpdatedFoldLevel, line);
        }
        return newFoldLevel;
    }

    public int[] getFoldAtLine(int line) {
        int end;
        int foldLevel;
        int start;
        if (this.isFoldStart(line)) {
            start = line;
            foldLevel = this.getFoldLevel(line);
            ++line;
            while (this.getFoldLevel(line) > foldLevel && ++line != this.getLineCount()) {
            }
            end = line - 1;
        } else {
            foldLevel = this.getFoldLevel(line);
            for (start = line; this.getFoldLevel(start) >= foldLevel && start != 0; --start) {
            }
            end = line;
            while (this.getFoldLevel(end) >= foldLevel && ++end != this.getLineCount()) {
            }
            --end;
        }
        while (this.getLineLength(end) == 0 && end > start) {
            --end;
        }
        return new int[]{start, end};
    }

    @Nonnull
    public FoldHandler getFoldHandler() {
        return this.foldHandler;
    }

    public void setFoldHandler(@Nonnull FoldHandler foldHandler) {
        FoldHandler oldFoldHandler = this.foldHandler;
        if (foldHandler.equals(oldFoldHandler)) {
            return;
        }
        this.foldHandler = foldHandler;
        this.lineMgr.setFirstInvalidFoldLevel(0);
        this.fireFoldHandlerChanged();
    }

    public void undo(TextArea textArea) {
        if (this.undoMgr == null) {
            return;
        }
        if (!this.isEditable()) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        try {
            this.writeLock();
            this.undoInProgress = true;
            this.fireBeginUndo();
            Selection[] s = this.undoMgr.undo();
            if (s == null || s.length == 0) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
            } else {
                textArea.setCaretPosition(s[s.length - 1].getEnd());
                textArea.setSelection(s);
            }
            this.fireEndUndo();
            this.fireTransactionComplete();
        }
        finally {
            this.undoInProgress = false;
            this.writeUnlock();
        }
    }

    public void redo(TextArea textArea) {
        if (this.undoMgr == null) {
            return;
        }
        if (!this.isEditable()) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        try {
            this.writeLock();
            this.undoInProgress = true;
            this.fireBeginRedo();
            Selection[] s = this.undoMgr.redo();
            if (s == null || s.length == 0) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
            } else {
                textArea.setCaretPosition(s[s.length - 1].getEnd());
                textArea.setSelection(s);
            }
            this.fireEndRedo();
            this.fireTransactionComplete();
        }
        finally {
            this.undoInProgress = false;
            this.writeUnlock();
        }
    }

    public boolean isTransactionInProgress() {
        return this.transaction || this.undoInProgress || this.insideCompoundEdit() || this.loading;
    }

    public void beginCompoundEdit() {
        try {
            this.writeLock();
            this.undoMgr.beginCompoundEdit();
        }
        finally {
            this.writeUnlock();
        }
    }

    public void endCompoundEdit() {
        try {
            this.writeLock();
            this.undoMgr.endCompoundEdit();
            if (!this.insideCompoundEdit()) {
                this.fireTransactionComplete();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public boolean insideCompoundEdit() {
        return this.undoMgr.insideCompoundEdit();
    }

    public boolean isUndoInProgress() {
        return this.undoInProgress;
    }

    public Object getUndoId() {
        return this.undoMgr.getUndoId();
    }

    public void addBufferListener(BufferListener listener, int priority) {
        Listener l = new Listener(listener, priority);
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            Listener _l = this.bufferListeners.get(i);
            if (_l.priority >= priority) continue;
            this.bufferListeners.add(i, l);
            return;
        }
        this.bufferListeners.add(l);
    }

    public void addBufferListener(BufferListener listener) {
        this.addBufferListener(listener, 0);
    }

    public void removeBufferListener(BufferListener listener) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            if (this.bufferListeners.get((int)i).listener != listener) continue;
            this.bufferListeners.remove(i);
            return;
        }
    }

    public BufferListener[] getBufferListeners() {
        BufferListener[] returnValue = new BufferListener[this.bufferListeners.size()];
        for (int i = 0; i < returnValue.length; ++i) {
            returnValue[i] = this.bufferListeners.get((int)i).listener;
        }
        return returnValue;
    }

    public void setUndoLimit(int limit) {
        if (this.undoMgr != null) {
            this.undoMgr.setLimit(limit);
        }
    }

    public boolean canUndo() {
        if (this.undoMgr == null) {
            return false;
        }
        return this.undoMgr.canUndo();
    }

    public boolean canRedo() {
        if (this.undoMgr == null) {
            return false;
        }
        return this.undoMgr.canRedo();
    }

    public boolean isContextInsensitive() {
        return this.contextInsensitive;
    }

    public void setContextInsensitive(boolean contextInsensitive) {
        this.contextInsensitive = contextInsensitive;
    }

    protected void fireFoldLevelChanged(int start, int end) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            BufferListener listener = this.getListener(i);
            try {
                listener.foldLevelChanged(this, start, end);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer event to " + listener + " :");
                Log.log(9, this, t);
            }
        }
    }

    protected void fireContentInserted(int startLine, int offset, int numLines, int length) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            BufferListener listener = this.getListener(i);
            try {
                listener.contentInserted(this, startLine, offset, numLines, length);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer event to " + listener + " :");
                Log.log(9, this, t);
            }
        }
    }

    protected void fireContentRemoved(int startLine, int offset, int numLines, int length) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            BufferListener listener = this.getListener(i);
            try {
                listener.contentRemoved(this, startLine, offset, numLines, length);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer event to " + listener + " :");
                Log.log(9, this, t);
            }
        }
    }

    protected void firePreContentInserted(int startLine, int offset, int numLines, int length) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            BufferListener listener = this.getListener(i);
            try {
                listener.preContentInserted(this, startLine, offset, numLines, length);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer event to " + listener + " :");
                Log.log(9, this, t);
            }
        }
    }

    protected void firePreContentRemoved(int startLine, int offset, int numLines, int length) {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            BufferListener listener = this.getListener(i);
            try {
                listener.preContentRemoved(this, startLine, offset, numLines, length);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer event to " + listener + " :");
                Log.log(9, this, t);
            }
        }
    }

    protected void fireBeginUndo() {
    }

    protected void fireEndUndo() {
    }

    protected void fireBeginRedo() {
    }

    protected void fireEndRedo() {
    }

    protected void fireTransactionComplete() {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            BufferListener listener = this.getListener(i);
            try {
                listener.transactionComplete(this);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer event to " + listener + " :");
                Log.log(9, this, t);
            }
        }
    }

    protected void fireFoldHandlerChanged() {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            BufferListener listener = this.getListener(i);
            try {
                listener.foldHandlerChanged(this);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer event to " + listener + " :");
                Log.log(9, this, t);
            }
        }
    }

    protected void fireBufferLoaded() {
        for (int i = 0; i < this.bufferListeners.size(); ++i) {
            BufferListener listener = this.getListener(i);
            try {
                listener.bufferLoaded(this);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer event to " + listener + " :");
                Log.log(9, this, t);
            }
        }
    }

    protected boolean isFileReadOnly() {
        return this.readOnly;
    }

    protected void setFileReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadText(Segment seg, IntegerArray endOffsets) {
        if (seg == null) {
            seg = new Segment(new char[1024], 0, 0);
        }
        if (endOffsets == null) {
            endOffsets = new IntegerArray();
            endOffsets.add(1);
        }
        try {
            this.writeLock();
            int length = this.getLength();
            this.firePreContentRemoved(0, 0, this.getLineCount() - 1, length);
            this.contentMgr.remove(0, length);
            this.lineMgr.contentRemoved(0, 0, this.getLineCount() - 1, length);
            this.positionMgr.contentRemoved(0, length);
            this.fireContentRemoved(0, 0, this.getLineCount() - 1, length);
            this.firePreContentInserted(0, 0, endOffsets.getSize() - 1, seg.count - 1);
            this.contentMgr._setContent(seg.array, seg.count);
            this.lineMgr._contentInserted(endOffsets);
            this.positionMgr.contentInserted(0, seg.count);
            this.fireContentInserted(0, 0, endOffsets.getSize() - 1, seg.count - 1);
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void invalidateFoldLevels() {
        this.lineMgr.setFirstInvalidFoldLevel(0);
    }

    protected void parseBufferLocalProperties() {
        int maxRead = 10000;
        int lineCount = this.getLineCount();
        int lastLine = Math.min(9, lineCount - 1);
        int max = Math.min(maxRead, this.getLineEndOffset(lastLine) - 1);
        this.parseBufferLocalProperties(this.getSegment(0, max));
        int firstLine = Math.max(lastLine + 1, lineCount - 10);
        if (firstLine < lineCount) {
            int firstLineStartOffset = this.getLineStartOffset(firstLine);
            int length = this.getLineEndOffset(lineCount - 1) - (firstLineStartOffset + 1);
            if (length > maxRead) {
                firstLineStartOffset += length - maxRead;
                length = maxRead;
            }
            this.parseBufferLocalProperties(this.getSegment(firstLineStartOffset, length));
        }
    }

    protected TokenMarker.LineContext markTokens(Segment seg, TokenMarker.LineContext prevContext, TokenHandler _tokenHandler) {
        TokenMarker.LineContext context = this.tokenMarker.markTokens(prevContext, _tokenHandler, seg);
        return context;
    }

    private BufferListener getListener(int index) {
        return this.bufferListeners.get((int)index).listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void contentInserted(int offset, int length, IntegerArray endOffsets) {
        try {
            this.transaction = true;
            int startLine = this.lineMgr.getLineOfOffset(offset);
            int numLines = endOffsets.getSize();
            if (!this.loading) {
                this.firePreContentInserted(startLine, offset, numLines, length);
            }
            this.lineMgr.contentInserted(startLine, offset, numLines, length, endOffsets);
            this.positionMgr.contentInserted(offset, length);
            this.setDirty(true);
            if (!this.loading) {
                this.fireContentInserted(startLine, offset, numLines, length);
                if (!this.undoInProgress && !this.insideCompoundEdit()) {
                    this.fireTransactionComplete();
                }
            }
        }
        finally {
            this.transaction = false;
        }
    }

    private void parseBufferLocalProperties(CharSequence prop) {
        StringBuilder buf = new StringBuilder();
        String name = null;
        boolean escape = false;
        int length = prop.length();
        block8: for (int i = 0; i < length; ++i) {
            char c = prop.charAt(i);
            switch (c) {
                case ':': {
                    if (escape) {
                        escape = false;
                        buf.append(':');
                        continue block8;
                    }
                    if (name != null) {
                        if (!name.equals(ENCODING)) {
                            this.properties.put(name, new PropValue(buf.toString(), false));
                        }
                        name = null;
                    }
                    buf.setLength(0);
                    continue block8;
                }
                case '=': {
                    if (escape) {
                        escape = false;
                        buf.append('=');
                        continue block8;
                    }
                    name = buf.toString();
                    buf.setLength(0);
                    continue block8;
                }
                case '\\': {
                    if (escape) {
                        buf.append('\\');
                    }
                    escape = !escape;
                    continue block8;
                }
                case 'n': {
                    if (escape) {
                        buf.append('\n');
                        escape = false;
                        continue block8;
                    }
                }
                case 'r': {
                    if (escape) {
                        buf.append('\r');
                        escape = false;
                        continue block8;
                    }
                }
                case 't': {
                    if (escape) {
                        buf.append('\t');
                        escape = false;
                        continue block8;
                    }
                }
                default: {
                    buf.append(c);
                    escape = false;
                }
            }
        }
    }

    private List<IndentRule> getIndentRules(int line) {
        String modeName = null;
        TokenMarker.LineContext ctx = this.getLineContext(line);
        if (ctx != null && ctx.rules != null) {
            modeName = ctx.rules.getModeName();
        }
        if (modeName == null) {
            modeName = this.tokenMarker.getMainRuleSet().getModeName();
        }
        return ModeProvider.instance.getMode(modeName).getIndentRules();
    }

    public void updateColumnBlocks(int startLine, int endLine, int startColumn, Node parent) {
        if (parent != null && startLine >= 0 && endLine >= 0 && startLine <= endLine) {
            int currentLine = startLine;
            int colBlockWidth = 0;
            Vector<ColumnBlockLine> columnBlockLines = new Vector<ColumnBlockLine>();
            ColumnBlock parentColumnBlock = (ColumnBlock)parent;
            int ik = startLine - parentColumnBlock.getStartLine();
            while (currentLine <= endLine) {
                Segment seg = new Segment();
                int actualStart = startColumn;
                if (!parentColumnBlock.getLines().isEmpty()) {
                    ColumnBlockLine line = parentColumnBlock.getLines().elementAt(ik);
                    if (currentLine != line.getLine()) {
                        throw new IllegalArgumentException();
                    }
                    actualStart = line.getColumnEndIndex() + 1;
                }
                this.getLineText(currentLine, actualStart, seg);
                int tabPos = this.getTabStopPosition(seg);
                if (tabPos >= 0) {
                    columnBlockLines.add(new ColumnBlockLine(currentLine, actualStart, actualStart + tabPos));
                    if (tabPos > colBlockWidth) {
                        colBlockWidth = tabPos;
                    }
                }
                if (tabPos < 0 && !columnBlockLines.isEmpty() || !columnBlockLines.isEmpty() && currentLine == endLine) {
                    ColumnBlock block = new ColumnBlock(this, ((ColumnBlockLine)columnBlockLines.elementAt(0)).getLine(), startColumn + colBlockWidth, ((ColumnBlockLine)columnBlockLines.elementAt(columnBlockLines.size() - 1)).getLine(), startColumn + colBlockWidth);
                    block.setLines(columnBlockLines);
                    block.setParent(parent);
                    block.setWidth(colBlockWidth);
                    block.setTabSizeDirtyStatus(true, false);
                    parent.addChild(block);
                    colBlockWidth = 0;
                    columnBlockLines = new Vector();
                    this.updateColumnBlocks(block.getStartLine(), block.getEndLine(), startColumn + block.getColumnWidth() + 1, block);
                }
                ++currentLine;
                ++ik;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public int getTabStopPosition(Segment seg) {
        for (int i = 0; i < seg.count; ++i) {
            if (seg.array[i + seg.offset] != '\t') continue;
            return i;
        }
        return -5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indentUsingElasticTabstops() {
        Object object = this.columnBlockLock;
        synchronized (object) {
            this.columnBlock = new ColumnBlock(this, 0, this.getLineCount() - 1);
            this.updateColumnBlocks(0, this.lineMgr.getLineCount() - 1, 0, this.columnBlock);
        }
    }

    public ColumnBlock getColumnBlock() {
        return this.columnBlock;
    }

    protected static class PropValue {
        Object value;
        boolean defaultValue;

        PropValue(Object value, boolean defaultValue) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.value = value;
            this.defaultValue = defaultValue;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    static class Listener {
        BufferListener listener;
        int priority;

        Listener(BufferListener listener, int priority) {
            this.listener = listener;
            this.priority = priority;
        }
    }
}

