/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.File$;
import isabelle.UTF8$;
import isabelle.package$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Paths;
import java.util.zip.GZIPInputStream;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class Url$ {
    public static Url$ MODULE$;

    static {
        new Url$();
    }

    public String escape(String name) {
        return new StringOps(Predef$.MODULE$.augmentString(name)).iterator().map((Function1 & Serializable & scala.Serializable)c -> Url$.$anonfun$escape$1(BoxesRunTime.unboxToChar((Object)c))).mkString();
    }

    public URL apply(String name) {
        URL uRL;
        try {
            uRL = new URL(name);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = (URL)package$.MODULE$.error().apply((Object)new StringBuilder(14).append("Malformed URL ").append(package$.MODULE$.quote().apply((Object)name)).toString());
        }
        return uRL;
    }

    public boolean is_wellformed(String name) {
        boolean bl;
        try {
            this.apply(name);
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<String> option = package$.MODULE$.ERROR().unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    public boolean is_readable(String name) {
        boolean bl;
        try {
            this.apply(name).openStream().close();
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<String> option = package$.MODULE$.ERROR().unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    public String decode(String s) {
        return URLDecoder.decode(s, UTF8$.MODULE$.charset_name());
    }

    public String encode(String s) {
        return URLEncoder.encode(s, UTF8$.MODULE$.charset_name());
    }

    private String read(URL url, boolean gzip) {
        return (String)package$.MODULE$.using(url.openStream(), (Function1 & Serializable & scala.Serializable)stream -> File$.MODULE$.read_stream(gzip ? new GZIPInputStream((InputStream)stream) : stream));
    }

    public String read(URL url) {
        return this.read(url, false);
    }

    public String read_gzip(URL url) {
        return this.read(url, true);
    }

    public String read(String name) {
        return this.read(this.apply(name), false);
    }

    public String read_gzip(String name) {
        return this.read(this.apply(name), true);
    }

    public String print_file(File file) {
        return File$.MODULE$.absolute(file).toPath().toUri().toString();
    }

    public String print_file_name(String name) {
        return this.print_file(new File(name));
    }

    public File parse_file(String uri) {
        return Paths.get(new URI(uri)).toFile();
    }

    public boolean is_wellformed_file(String uri) {
        boolean bl;
        try {
            this.parse_file(uri);
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl2 = throwable2 instanceof URISyntaxException ? true : (throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof FileSystemNotFoundException);
            if (!bl2) {
                throw throwable;
            }
            boolean bl3 = false;
            bl = bl3;
        }
        return bl;
    }

    public File absolute_file(String uri) {
        return File$.MODULE$.absolute(this.parse_file(uri));
    }

    public String absolute_file_name(String uri) {
        return this.absolute_file(uri).getPath();
    }

    public File canonical_file(String uri) {
        return File$.MODULE$.canonical(this.parse_file(uri));
    }

    public String canonical_file_name(String uri) {
        return this.canonical_file(uri).getPath();
    }

    public static final /* synthetic */ String $anonfun$escape$1(char c) {
        return c == '\'' ? "%27" : new String(new char[]{c});
    }

    private Url$() {
        MODULE$ = this;
    }
}

