/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Mercurial;
import isabelle.Mercurial$;
import isabelle.No_Progress$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.Sessions$;
import isabelle.Token$;
import isabelle.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class Mkroot$ {
    public static Mkroot$ MODULE$;
    private final Isabelle_Tool isabelle_tool;

    static {
        new Mkroot$();
    }

    public String root_name(String name) {
        return Token$.MODULE$.quote_name(Sessions$.MODULE$.root_syntax().keywords(), name);
    }

    public String latex_name(String name) {
        return new StringOps(Predef$.MODULE$.augmentString(name)).iterator().withFilter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)Mkroot$.$anonfun$latex_name$1(BoxesRunTime.unboxToChar((Object)c)))).map((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToCharacter((char)Mkroot$.$anonfun$latex_name$2(BoxesRunTime.unboxToChar((Object)c)))).mkString();
    }

    public void mkroot(String session_name, Path session_dir, String session_parent, boolean init_repos, String title, String author, Progress progress) {
        Isabelle_System$.MODULE$.mkdirs(session_dir);
        String name = (String)((Option)package$.MODULE$.proper_string().apply((Object)session_name)).getOrElse((Function0 & Serializable & scala.Serializable)() -> session_dir.absolute_file().getName());
        String parent = (String)((Option)package$.MODULE$.proper_string().apply((Object)session_parent)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Isabelle_System$.MODULE$.getenv("ISABELLE_LOGIC", Isabelle_System$.MODULE$.getenv$default$2()));
        Path root_path = session_dir.$plus(Path$.MODULE$.explode("ROOT"));
        Object object = root_path.file().exists() ? package$.MODULE$.error().apply((Object)new StringBuilder(26).append("Cannot overwrite existing ").append(root_path).toString()) : BoxedUnit.UNIT;
        Path document_path = session_dir.$plus(Path$.MODULE$.explode("document"));
        Object object2 = document_path.file().exists() ? package$.MODULE$.error().apply((Object)new StringBuilder(26).append("Cannot overwrite existing ").append(document_path).toString()) : BoxedUnit.UNIT;
        Path root_tex = session_dir.$plus(Path$.MODULE$.explode("document/root.tex"));
        progress.echo(new StringBuilder(23).append("\nPreparing session ").append(package$.MODULE$.quote().apply((Object)name)).append(" in ").append(session_dir).toString());
        progress.echo(new StringBuilder(11).append("  creating ").append(root_path).toString());
        File$.MODULE$.write(root_path, (CharSequence)new StringBuilder(168).append("session ").append(this.root_name(name)).append(" = ").append(this.root_name(parent)).append(" +\n  options [document = pdf, document_output = \"output\"]\n(*theories [document = false]\n    A\n    B\n  theories\n    C\n    D*)\n  document_files\n    \"root.tex\"\n").toString());
        progress.echo(new StringBuilder(11).append("  creating ").append(root_tex).toString());
        Isabelle_System$.MODULE$.mkdirs(root_tex.dir());
        File$.MODULE$.write(root_tex, (CharSequence)new StringBuilder(1225).append("\\documentclass[11pt,a4paper]{article}\n\\usepackage{isabelle,isabellesym}\n\n% further packages required for unusual symbols (see also\n% isabellesym.sty), use only when needed\n\n%\\usepackage{amssymb}\n  %for \\<leadsto>, \\<box>, \\<diamond>, \\<sqsupset>, \\<mho>, \\<Join>,\n  %\\<lhd>, \\<lesssim>, \\<greatersim>, \\<lessapprox>, \\<greaterapprox>,\n  %\\<triangleq>, \\<yen>, \\<lozenge>\n\n%\\usepackage{eurosym}\n  %for \\<euro>\n\n%\\usepackage[only,bigsqcap]{stmaryrd}\n  %for \\<Sqinter>\n\n%\\usepackage{eufrak}\n  %for \\<AA> ... \\<ZZ>, \\<aa> ... \\<zz> (also included in amssymb)\n\n%\\usepackage{textcomp}\n  %for \\<onequarter>, \\<onehalf>, \\<threequarters>, \\<degree>, \\<cent>,\n  %\\<currency>\n\n% this should be the last package used\n\\usepackage{pdfsetup}\n\n% urls in roman style, theory text in math-similar italics\n\\urlstyle{rm}\n\\isabellestyle{it}\n\n% for uniform font size\n%\\renewcommand{\\isastyle}{\\isastyleminor}\n\n\n\\begin{document}\n\n\\title{").append(((Option)package$.MODULE$.proper_string().apply((Object)title)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.latex_name(name))).append("}\n\\author{").append(((Option)package$.MODULE$.proper_string().apply((Object)author)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.latex_name(System.getProperty("user.name")))).append("}\n\\maketitle\n\n\\tableofcontents\n\n% sane default for proof documents\n\\parindent 0pt\\parskip 0.5ex\n\n% generated text of all theories\n\\input{session}\n\n% optional bibliography\n%\\bibliographystyle{abbrv}\n%\\bibliography{root}\n\n\\end{document}\n\n%%% Local Variables:\n%%% mode: latex\n%%% TeX-master: t\n%%% End:\n").toString());
        if (init_repos) {
            progress.echo(new StringBuilder(37).append("  \nInitializing Mercurial repository ").append(session_dir).toString());
            Mercurial.Repository hg = Mercurial$.MODULE$.init_repository(session_dir, Mercurial$.MODULE$.init_repository$default$2());
            Path hg_ignore = session_dir.$plus(Path$.MODULE$.explode(".hgignore"));
            File$.MODULE$.write(hg_ignore, (CharSequence)"syntax: glob\n\n*~\n*.marks\n*.orig\n*.rej\n.DS_Store\n.swp\n\nsyntax: regexp\n\n^output/\n");
            hg.add((List<Path>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{root_path, root_tex, hg_ignore})));
        }
        String print_dir = session_dir.implode();
        String string = Bash$.MODULE$.string(print_dir);
        String string2 = print_dir;
        progress.echo(new StringBuilder(80).append("\nNow use the following command line to build the session:\n\n  isabelle build -D ").append(!(string != null ? !string.equals(string2) : string2 != null) ? print_dir : package$.MODULE$.quote().apply((Object)print_dir)).append("\n").toString());
    }

    public String mkroot$default$1() {
        return "";
    }

    public Path mkroot$default$2() {
        return Path$.MODULE$.current();
    }

    public String mkroot$default$3() {
        return "";
    }

    public boolean mkroot$default$4() {
        return false;
    }

    public String mkroot$default$5() {
        return "";
    }

    public String mkroot$default$6() {
        return "";
    }

    public Progress mkroot$default$7() {
        return No_Progress$.MODULE$;
    }

    public Isabelle_Tool isabelle_tool() {
        return this.isabelle_tool;
    }

    public static final /* synthetic */ boolean $anonfun$latex_name$1(char c) {
        return c != '\\';
    }

    public static final /* synthetic */ char $anonfun$latex_name$2(char c) {
        return c == '_' ? (char)'-' : (char)c;
    }

    public static final /* synthetic */ void $anonfun$isabelle_tool$1(List args) {
        Path path;
        ObjectRef author = ObjectRef.create((Object)"");
        BooleanRef init_repos = BooleanRef.create((boolean)false);
        ObjectRef title = ObjectRef.create((Object)"");
        ObjectRef session_name = ObjectRef.create((Object)"");
        Getopts getopts = Getopts$.MODULE$.apply("\nUsage: isabelle mkroot [OPTIONS] [DIRECTORY]\n\n  Options are:\n    -A LATEX     provide author in LaTeX notation (default: user name)\n    -I           init Mercurial repository and add generated files\n    -T LATEX     provide title in LaTeX notation (default: session name)\n    -n NAME      alternative session name (default: directory base name)\n\n  Prepare session root directory (default: current directory).\n", (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"A:"), (Function1 & Serializable & scala.Serializable)arg -> {
            author.elem = arg;
            return BoxedUnit.UNIT;
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"I"), (Function1 & Serializable & scala.Serializable)arg -> {
            init_repos.elem = true;
            return BoxedUnit.UNIT;
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"T:"), (Function1 & Serializable & scala.Serializable)arg -> {
            title.elem = arg;
            return BoxedUnit.UNIT;
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n:"), (Function1 & Serializable & scala.Serializable)arg -> {
            session_name.elem = arg;
            return BoxedUnit.UNIT;
        })}));
        List<String> more_args = getopts.apply((List<String>)args);
        List<String> list = more_args;
        if (Nil$.MODULE$.equals(list)) {
            path = Path$.MODULE$.current();
        } else {
            Some some = List$.MODULE$.unapplySeq(list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0) {
                String dir = (String)((LinearSeqOptimized)some.get()).apply(0);
                path = Path$.MODULE$.explode(dir);
            } else {
                throw getopts.usage();
            }
        }
        Path session_dir = path;
        String x$1 = (String)session_name.elem;
        Path x$2 = session_dir;
        boolean x$3 = init_repos.elem;
        String x$4 = (String)author.elem;
        String x$5 = (String)title.elem;
        Console_Progress x$6 = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2());
        String x$7 = MODULE$.mkroot$default$3();
        MODULE$.mkroot(x$1, x$2, x$7, x$3, x$5, x$4, x$6);
    }

    private Mkroot$() {
        MODULE$ = this;
        this.isabelle_tool = new Isabelle_Tool("mkroot", "prepare session root directory", (Function1<List<String>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)args -> {
            Mkroot$.$anonfun$isabelle_tool$1(args);
            return BoxedUnit.UNIT;
        }, Isabelle_Tool$.MODULE$.apply$default$4());
    }
}

