/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.AFP$;
import isabelle.Bash$;
import isabelle.Build_History$;
import isabelle.Build_Log$;
import isabelle.Build_Log$Data$;
import isabelle.Build_Log$Identify$;
import isabelle.Build_Log$Prop$;
import isabelle.Build_Log$Settings$;
import isabelle.Build_Status;
import isabelle.Bytes;
import isabelle.Bytes$;
import isabelle.Command_Line$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date;
import isabelle.Date$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Graph;
import isabelle.Isabelle_Cronjob;
import isabelle.Isabelle_Cronjob$Log_Service$;
import isabelle.Isabelle_Cronjob$Logger_Task$;
import isabelle.Isabelle_Cronjob$Remote_Build$;
import isabelle.Isabelle_Devel$;
import isabelle.Isabelle_System$;
import isabelle.Jenkins$;
import isabelle.Library$;
import isabelle.Mercurial;
import isabelle.Mercurial$;
import isabelle.No_Progress$;
import isabelle.Options$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Progress;
import isabelle.SQL;
import isabelle.SQL$;
import isabelle.SSH;
import isabelle.package$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class Isabelle_Cronjob$ {
    public static Isabelle_Cronjob$ MODULE$;
    private final String backup;
    private final Path main_dir;
    private final Path main_state_file;
    private final Path current_log;
    private final Path cumulative_log;
    private final String isabelle_repos_source;
    private final Path isabelle_repos;
    private final Path afp_repos;
    private final List<Path> build_log_dirs;
    private final Isabelle_Cronjob.Logger_Task init;
    private final Isabelle_Cronjob.Logger_Task exit;
    private final Isabelle_Cronjob.Logger_Task build_release;
    private final Isabelle_Cronjob.Logger_Task build_history_base;
    private final List<Isabelle_Cronjob.Remote_Build> remote_builds_old;
    private final List<List<Isabelle_Cronjob.Remote_Build>> remote_builds1;
    private final List<List<Isabelle_Cronjob.Remote_Build>> remote_builds2;
    private final List<Build_Status.Profile> build_status_profiles;

    static {
        new Isabelle_Cronjob$();
    }

    public String backup() {
        return this.backup;
    }

    public Path main_dir() {
        return this.main_dir;
    }

    public Path main_state_file() {
        return this.main_state_file;
    }

    public Path current_log() {
        return this.current_log;
    }

    public Path cumulative_log() {
        return this.cumulative_log;
    }

    public String isabelle_repos_source() {
        return this.isabelle_repos_source;
    }

    public Path isabelle_repos() {
        return this.isabelle_repos;
    }

    public Path afp_repos() {
        return this.afp_repos;
    }

    public List<Path> build_log_dirs() {
        return this.build_log_dirs;
    }

    public String get_rev() {
        Mercurial.Repository qual$1 = Mercurial$.MODULE$.repository(this.isabelle_repos(), Mercurial$.MODULE$.repository$default$2());
        String x$29 = qual$1.id$default$1();
        return qual$1.id(x$29);
    }

    public String get_afp_rev() {
        Mercurial.Repository qual$2 = Mercurial$.MODULE$.repository(this.afp_repos(), Mercurial$.MODULE$.repository$default$2());
        String x$30 = qual$2.id$default$1();
        return qual$2.id(x$30);
    }

    public Isabelle_Cronjob.Logger_Task init() {
        return this.init;
    }

    public Isabelle_Cronjob.Logger_Task exit() {
        return this.exit;
    }

    public Isabelle_Cronjob.Logger_Task build_release() {
        return this.build_release;
    }

    public Isabelle_Cronjob.Logger_Task build_history_base() {
        return this.build_history_base;
    }

    public List<Isabelle_Cronjob.Item> recent_items(SQL.Database db, int days, String rev, Option<String> afp_rev, String sql) {
        boolean afp = afp_rev.isDefined();
        String select = Build_Log$Data$.MODULE$.select_recent_versions(days, rev, afp_rev, new StringBuilder(6).append("WHERE ").append(sql).toString());
        return (List)db.using_statement(select, (Function1 & Serializable & scala.Serializable)stmt -> stmt.execute_query().iterator((Function1 & Serializable & scala.Serializable)res -> {
            boolean known = res.bool(Build_Log$Data$.MODULE$.known());
            String isabelle_version = res.string(Build_Log$Prop$.MODULE$.isabelle_version());
            None$ afp_version = afp ? (Option)package$.MODULE$.proper_string().apply((Object)res.string(Build_Log$Prop$.MODULE$.afp_version())) : None$.MODULE$;
            Date pull_date = res.date(Build_Log$Data$.MODULE$.pull_date(afp));
            return new Isabelle_Cronjob.Item(known, isabelle_version, (Option<String>)afp_version, pull_date);
        }).toList());
    }

    public List<List<Isabelle_Cronjob.Item>> unknown_runs(List<Isabelle_Cronjob.Item> items) {
        Nil$ nil$;
        Tuple2 tuple2 = Library$.MODULE$.take_prefix((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.unknown()), items.dropWhile((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.known())));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List run = (List)tuple2._1();
        List rest = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)run, (Object)rest);
        Tuple2 tuple23 = tuple22;
        List run2 = (List)tuple23._1();
        List rest2 = (List)tuple23._2();
        if (run2.nonEmpty()) {
            List list = run2;
            nil$ = this.unknown_runs((List<Isabelle_Cronjob.Item>)rest2).$colon$colon((Object)list);
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public List<Isabelle_Cronjob.Remote_Build> remote_builds_old() {
        return this.remote_builds_old;
    }

    public List<List<Isabelle_Cronjob.Remote_Build>> remote_builds1() {
        return this.remote_builds1;
    }

    public List<List<Isabelle_Cronjob.Remote_Build>> remote_builds2() {
        return this.remote_builds2;
    }

    public Isabelle_Cronjob.Logger_Task remote_build_history(String rev, Option<String> afp_rev, int i, Isabelle_Cronjob.Remote_Build r) {
        String task_name = new StringBuilder(14).append("build_history-").append(r.host()).toString();
        return new Isabelle_Cronjob.Logger_Task(task_name, (Function1<Isabelle_Cronjob.Logger, BoxedUnit>)(Function1 & Serializable & scala.Serializable)logger -> {
            package$.MODULE$.using(r.ssh_session(logger.ssh_context()), (Function1 & Serializable & scala.Serializable)ssh -> {
                Isabelle_Cronjob$.$anonfun$remote_build_history$2(rev$2, afp_rev$2, i$1, r$1, task_name$1, logger, ssh);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public List<Build_Status.Profile> build_status_profiles() {
        return this.build_status_profiles;
    }

    public void cronjob(Progress progress, Set<String> exclude_task) {
        Some some;
        String string;
        Some still_running;
        Some some2;
        try {
            some2 = new Some((Object)File$.MODULE$.read(this.main_state_file()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<String> option = package$.MODULE$.ERROR().unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some2 = none$;
        }
        Some some3 = still_running = some2;
        boolean bl = None$.MODULE$.equals(some3) ? true : some3 instanceof Some && "".equals(string = (String)(some = some3).value());
        if (bl) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (some3 instanceof Some) {
            Some some4 = some3;
            String running = (String)some4.value();
            BoxedUnit boxedUnit = (BoxedUnit)package$.MODULE$.error().apply((Object)new StringBuilder(46).append("Isabelle cronjob appears to be still running: ").append(running).toString());
        } else {
            throw new MatchError((Object)some3);
        }
        Isabelle_Cronjob.Log_Service log_service = Isabelle_Cronjob$Log_Service$.MODULE$.apply(Options$.MODULE$.init(Options$.MODULE$.init$default$1(), Options$.MODULE$.init$default$2()), progress);
        Mercurial.Repository hg = Mercurial$.MODULE$.repository(this.isabelle_repos(), Mercurial$.MODULE$.repository$default$2());
        Graph<String, BoxedUnit> hg_graph = hg.graph();
        Date main_start_date = Date$.MODULE$.now(Date$.MODULE$.now$default$1());
        File$.MODULE$.write(this.main_state_file(), (CharSequence)new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)main_start_date), " ")).append(log_service.hostname()).toString());
        Isabelle_Cronjob$.run$1(main_start_date, new Isabelle_Cronjob.Logger_Task("isabelle_cronjob", (Function1<Isabelle_Cronjob.Logger, BoxedUnit>)(Function1 & Serializable & scala.Serializable)logger -> {
            Isabelle_Cronjob$.$anonfun$cronjob$9(this, exclude_task, log_service, hg, hg_graph, logger);
            return BoxedUnit.UNIT;
        }), log_service);
        log_service.shutdown();
        this.main_state_file().file().delete();
    }

    public void main(String[] args) {
        throw Command_Line$.MODULE$.tool0((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Progress progress;
            BooleanRef force = BooleanRef.create((boolean)false);
            BooleanRef verbose = BooleanRef.create((boolean)false);
            ObjectRef exclude_task = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            Getopts getopts = Getopts$.MODULE$.apply("\nUsage: Admin/cronjob/main [OPTIONS]\n\n  Options are:\n    -f           apply force to do anything\n    -v           verbose\n    -x NAME      exclude tasks with this name\n", (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f"), (Function1 & Serializable & scala.Serializable)x$27 -> {
                force.elem = true;
                return BoxedUnit.UNIT;
            }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Function1 & Serializable & scala.Serializable)x$28 -> {
                verbose.elem = true;
                return BoxedUnit.UNIT;
            }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x:"), (Function1 & Serializable & scala.Serializable)arg -> {
                exclude_task.elem = (Set)((Set)exclude_task.elem).$plus((Object)arg);
                return BoxedUnit.UNIT;
            })}));
            List<String> more_args = getopts.apply(args);
            if (more_args.nonEmpty()) {
                throw getopts.usage();
            }
            Progress progress2 = progress = verbose.elem ? new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2()) : No_Progress$.MODULE$;
            if (force.elem) {
                MODULE$.cronjob(progress, (Set<String>)((Set)exclude_task.elem));
            } else {
                package$.MODULE$.error().apply((Object)"Need to apply force to do anything");
            }
        });
    }

    public static final /* synthetic */ void $anonfun$init$1(Isabelle_Cronjob.Logger logger) {
        block0: {
            Isabelle_Devel$.MODULE$.make_index();
            Mercurial$.MODULE$.setup_repository(MODULE$.isabelle_repos_source(), MODULE$.isabelle_repos(), Mercurial$.MODULE$.setup_repository$default$3());
            Mercurial$.MODULE$.setup_repository(AFP$.MODULE$.repos_source(), MODULE$.afp_repos(), Mercurial$.MODULE$.setup_repository$default$3());
            File$.MODULE$.write(logger.log_dir().$plus(Build_Log$.MODULE$.log_filename("isabelle_identify", logger.start_date(), Build_Log$.MODULE$.log_filename$default$3())), (CharSequence)Build_Log$Identify$.MODULE$.content(logger.start_date(), (Option<String>)new Some((Object)MODULE$.get_rev()), (Option<String>)new Some((Object)MODULE$.get_afp_rev())));
            Isabelle_System$.MODULE$.bash(new StringBuilder(67).append("rsync -a --include=\"*/\" --include=\"plain_identify*\" --exclude=\"*\" ").append(Bash$.MODULE$.string(new StringBuilder(4).append(MODULE$.backup()).append("/log").toString())).append(" ").append(File$.MODULE$.bash_path(MODULE$.main_dir())).toString(), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9()).check();
            if (Isabelle_Devel$.MODULE$.cronjob_log().is_file()) break block0;
            Files.createSymbolicLink(Isabelle_Devel$.MODULE$.cronjob_log().file().toPath(), MODULE$.current_log().file().toPath(), new FileAttribute[0]);
        }
    }

    public static final /* synthetic */ void $anonfun$exit$1(Isabelle_Cronjob.Logger logger) {
        Isabelle_System$.MODULE$.bash(new StringBuilder(10).append("rsync -a ").append(File$.MODULE$.bash_path(MODULE$.main_dir().$plus(Path$.MODULE$.explode("log")))).append(" ").append(Bash$.MODULE$.string(MODULE$.backup())).toString(), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9()).check();
    }

    public static final /* synthetic */ void $anonfun$build_release$1(Isabelle_Cronjob.Logger logger) {
        String x$31 = MODULE$.get_rev();
        String x$32 = MODULE$.get_afp_rev();
        String x$33 = "macbroy30";
        int x$34 = Isabelle_Devel$.MODULE$.release_snapshot$default$3();
        Isabelle_Devel$.MODULE$.release_snapshot(x$31, x$32, x$34, x$33);
    }

    public static final /* synthetic */ boolean $anonfun$build_history_base$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$build_history_base$4(Isabelle_Cronjob.Logger logger$2, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String log_name = (String)tuple2._1();
        Bytes bytes = (Bytes)tuple2._2();
        Bytes$.MODULE$.write(logger$2.log_dir().$plus(Path$.MODULE$.explode(log_name)), bytes);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$build_history_base$2(Isabelle_Cronjob.Logger logger$2, SSH.Session ssh) {
        SSH.Session x$42 = ssh;
        Path x$43 = MODULE$.isabelle_repos();
        Path x$44 = MODULE$.isabelle_repos().ext("build_history_base");
        String x$45 = "cronjob_build_history";
        boolean x$46 = true;
        String x$47 = "build_history_base";
        String x$48 = "-f";
        String x$49 = "HOL";
        String x$50 = Build_History$.MODULE$.remote_build_history$default$4();
        String x$51 = Build_History$.MODULE$.remote_build_history$default$5();
        Progress x$52 = Build_History$.MODULE$.remote_build_history$default$8();
        Option<String> x$53 = Build_History$.MODULE$.remote_build_history$default$10();
        List<Tuple2<String, Bytes>> results = Build_History$.MODULE$.remote_build_history(x$42, x$43, x$44, x$50, x$51, x$45, x$46, x$52, x$47, x$53, x$48, x$49);
        results.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Isabelle_Cronjob$.$anonfun$build_history_base$3(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Isabelle_Cronjob$.$anonfun$build_history_base$4(logger$2, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$build_history_base$1(Isabelle_Cronjob.Logger logger) {
        SSH.Context qual$3 = logger.ssh_context();
        String x$35 = "lxbroy10";
        String x$36 = qual$3.open_session$default$2();
        int x$37 = qual$3.open_session$default$3();
        String x$38 = qual$3.open_session$default$4();
        String x$39 = qual$3.open_session$default$5();
        int x$40 = qual$3.open_session$default$6();
        boolean x$41 = qual$3.open_session$default$7();
        package$.MODULE$.using(qual$3.open_session(x$35, x$36, x$37, x$38, x$39, x$40, x$41), (Function1 & Serializable & scala.Serializable)ssh -> {
            Isabelle_Cronjob$.$anonfun$build_history_base$2(logger, ssh);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$remote_builds1$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$remote_build_history$3(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$remote_build_history$4(Isabelle_Cronjob.Logger logger$3, Tuple2 x$13) {
        Tuple2 tuple2 = x$13;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String log_name = (String)tuple2._1();
        Bytes bytes = (Bytes)tuple2._2();
        logger$3.log(Date$.MODULE$.now(Date$.MODULE$.now$default$1()), log_name);
        Bytes$.MODULE$.write(logger$3.log_dir().$plus(Path$.MODULE$.explode(log_name)), bytes);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$remote_build_history$2(String rev$2, Option afp_rev$2, int i$1, Isabelle_Cronjob.Remote_Build r$1, String task_name$1, Isabelle_Cronjob.Logger logger$3, SSH.Session ssh) {
        SSH.Session x$434 = ssh;
        Path x$435 = MODULE$.isabelle_repos();
        Path x$436 = MODULE$.isabelle_repos().ext(r$1.host());
        String x$437 = "cronjob_build_history";
        boolean x$438 = r$1.self_update();
        String x$439 = rev$2;
        Option x$440 = afp_rev$2;
        String x$441 = new StringBuilder(8).append(" -N ").append(Bash$.MODULE$.string(task_name$1)).append((Object)(i$1 < 0 ? "" : new StringBuilder(1).append("_").append(((Object)BoxesRunTime.boxToInteger((int)(i$1 + 1))).toString()).toString())).append(" -f ").append(r$1.options()).toString();
        String x$442 = new StringBuilder(17).append("-o timeout=10800 ").append(r$1.args()).toString();
        String x$443 = Build_History$.MODULE$.remote_build_history$default$4();
        String x$444 = Build_History$.MODULE$.remote_build_history$default$5();
        Progress x$445 = Build_History$.MODULE$.remote_build_history$default$8();
        List<Tuple2<String, Bytes>> results = Build_History$.MODULE$.remote_build_history(x$434, x$435, x$436, x$443, x$444, x$437, x$438, x$445, x$439, (Option<String>)x$440, x$441, x$442);
        results.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)Isabelle_Cronjob$.$anonfun$remote_build_history$3(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            Isabelle_Cronjob$.$anonfun$remote_build_history$4(logger$3, x$13);
            return BoxedUnit.UNIT;
        });
    }

    private static final void run$1(Date start_date, Isabelle_Cronjob.Logger_Task task, Isabelle_Cronjob.Log_Service log_service$1) {
        log_service$1.run_task(start_date, task);
    }

    private static final void run_now$1(Isabelle_Cronjob.Logger_Task task, Isabelle_Cronjob.Log_Service log_service$1) {
        Isabelle_Cronjob$.run$1(Date$.MODULE$.now(Date$.MODULE$.now$default$1()), task, log_service$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$cronjob$2(Set exclude_task$1, Isabelle_Cronjob.Logger_Task task) {
        if (!exclude_task$1.apply((Object)task.name())) return true;
        String string = task.name();
        String string2 = "";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$cronjob$1(Set exclude_task$1, Isabelle_Cronjob.Log_Service log_service$1, List tasks$1, Isabelle_Cronjob.Logger x$17) {
        tasks$1.iterator().withFilter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)Isabelle_Cronjob$.$anonfun$cronjob$2(exclude_task$1, task))).foreach((Function1 & Serializable & scala.Serializable)task -> {
            Isabelle_Cronjob$.run_now$1(task, log_service$1);
            return BoxedUnit.UNIT;
        });
    }

    private static final Isabelle_Cronjob.Logger_Task SEQ$1(List tasks, Set exclude_task$1, Isabelle_Cronjob.Log_Service log_service$1) {
        Function1 & Serializable & scala.Serializable x$450 = (Function1 & Serializable & scala.Serializable)x$17 -> {
            Isabelle_Cronjob$.$anonfun$cronjob$1(exclude_task$1, log_service$1, tasks, x$17);
            return BoxedUnit.UNIT;
        };
        String x$451 = Isabelle_Cronjob$Logger_Task$.MODULE$.apply$default$1();
        return new Isabelle_Cronjob.Logger_Task(x$451, (Function1<Isabelle_Cronjob.Logger, BoxedUnit>)x$450);
    }

    private final void join$1(List running) {
        block4: {
            Tuple2 tuple2;
            while (true) {
                if ((tuple2 = running.partition((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.is_finished()))) != null) {
                    List list = (List)tuple2._1();
                    List list2 = (List)tuple2._2();
                    if (Nil$.MODULE$.equals(list) && Nil$.MODULE$.equals(list2)) break block4;
                }
                if (tuple2 != null) {
                    List list = (List)tuple2._1();
                    List list3 = (List)tuple2._2();
                    if (Nil$.MODULE$.equals(list) && list3 instanceof .colon.colon) {
                        Thread.sleep(500L);
                        continue;
                    }
                }
                if (tuple2 == null) break;
                List list = (List)tuple2._1();
                List remaining = (List)tuple2._2();
                if (!(list instanceof .colon.colon)) break;
                running = remaining;
            }
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$cronjob$6(Set exclude_task$1, Isabelle_Cronjob.Logger_Task task) {
        return !exclude_task$1.apply((Object)task.name());
    }

    public static final /* synthetic */ void $anonfun$cronjob$4(Isabelle_Cronjob$ $this, Set exclude_task$1, Isabelle_Cronjob.Log_Service log_service$1, List tasks$2, Isabelle_Cronjob.Logger x$18) {
        Date start_date = Date$.MODULE$.now(Date$.MODULE$.now$default$1());
        List running = (List)tasks$2.withFilter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)Isabelle_Cronjob$.$anonfun$cronjob$6(exclude_task$1, task))).map((Function1 & Serializable & scala.Serializable)task -> log_service$1.fork_task(start_date, (Isabelle_Cronjob.Logger_Task)task), List$.MODULE$.canBuildFrom());
        $this.join$1(running);
    }

    private final Isabelle_Cronjob.Logger_Task PAR$1(List tasks, Set exclude_task$1, Isabelle_Cronjob.Log_Service log_service$1) {
        Function1 & Serializable & scala.Serializable x$452 = (Function1 & Serializable & scala.Serializable)x$18 -> {
            Isabelle_Cronjob$.$anonfun$cronjob$4(this, exclude_task$1, log_service$1, tasks, x$18);
            return BoxedUnit.UNIT;
        };
        String x$453 = Isabelle_Cronjob$Logger_Task$.MODULE$.apply$default$1();
        return new Isabelle_Cronjob.Logger_Task(x$453, (Function1<Isabelle_Cronjob.Logger, BoxedUnit>)x$452);
    }

    private static final Function1 history_base_filter$1(Isabelle_Cronjob.Remote_Build r, Mercurial.Repository hg$1, Graph hg_graph$1) {
        String base_rev = hg$1.id(r.history_base());
        Set nodes = hg_graph$1.all_succs(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{base_rev}))).toSet();
        return (Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)nodes.apply((Object)item.isabelle_version()));
    }

    public static final /* synthetic */ boolean $anonfun$cronjob$15(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$cronjob$17(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2 = check$ifrefutable$5;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$cronjob$9(Isabelle_Cronjob$ $this, Set exclude_task$1, Isabelle_Cronjob.Log_Service log_service$1, Mercurial.Repository hg$1, Graph hg_graph$1, Isabelle_Cronjob.Logger logger) {
        Isabelle_Cronjob.Logger_Task[] logger_TaskArray = new Isabelle_Cronjob.Logger_Task[4];
        logger_TaskArray[0] = MODULE$.init();
        logger_TaskArray[1] = MODULE$.build_history_base();
        Isabelle_Cronjob.Logger_Task logger_Task = MODULE$.build_release();
        logger_TaskArray[2] = $this.PAR$1(((List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{MODULE$.remote_builds1(), MODULE$.remote_builds2()})).map((Function1 & Serializable & scala.Serializable)remote_builds -> Isabelle_Cronjob$.SEQ$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Isabelle_Cronjob.Logger_Task[]{$this.PAR$1((List)((List)remote_builds.map((Function1 & Serializable & scala.Serializable)x$20 -> (List)x$20.filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)x$21.active())), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)seq -> Isabelle_Cronjob$.SEQ$1((List)((TraversableLike)(seq.length() <= 1 ? seq.map((Function1 & Serializable & scala.Serializable)x$22 -> new Tuple2(x$22, (Object)BoxesRunTime.boxToInteger((int)-1)), List$.MODULE$.canBuildFrom()) : seq.zipWithIndex(List$.MODULE$.canBuildFrom()))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)Isabelle_Cronjob$.$anonfun$cronjob$15(check$ifrefutable$4))).flatMap((Function1 & Serializable & scala.Serializable)x$24 -> {
            Tuple2 tuple2 = x$24;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Isabelle_Cronjob.Remote_Build r = (Isabelle_Cronjob.Remote_Build)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Iterable iterable = Option$.MODULE$.option2Iterable(r.pick(logger.options(), hg$1.id(hg$1.id$default$1()), (Function1<Isabelle_Cronjob.Item, Object>)Isabelle_Cronjob$.history_base_filter$1(r, hg$1, hg_graph$1)).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)Isabelle_Cronjob$.$anonfun$cronjob$17(check$ifrefutable$5))).map((Function1 & Serializable & scala.Serializable)x$23 -> {
                Tuple2 tuple2 = x$23;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String rev = (String)tuple2._1();
                Option afp_rev = (Option)tuple2._2();
                Isabelle_Cronjob.Logger_Task logger_Task = MODULE$.remote_build_history(rev, (Option<String>)afp_rev, i, r);
                return logger_Task;
            }));
            return iterable;
        }, List$.MODULE$.canBuildFrom()), exclude_task$1, log_service$1), List$.MODULE$.canBuildFrom()), exclude_task$1, log_service$1), new Isabelle_Cronjob.Logger_Task("jenkins_logs", (Function1<Isabelle_Cronjob.Logger, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$25 -> {
            Jenkins$.MODULE$.download_logs(logger.options(), Jenkins$.MODULE$.build_log_jobs(), Isabelle_Cronjob$.MODULE$.main_dir(), Jenkins$.MODULE$.download_logs$default$4());
            return BoxedUnit.UNIT;
        }), new Isabelle_Cronjob.Logger_Task("build_log_database", (Function1<Isabelle_Cronjob.Logger, BoxedUnit>)(Function1 & Serializable & scala.Serializable)logger -> {
            Isabelle_Devel$.MODULE$.build_log_database(logger.options(), Isabelle_Cronjob$.MODULE$.build_log_dirs());
            return BoxedUnit.UNIT;
        }), new Isabelle_Cronjob.Logger_Task("build_status", (Function1<Isabelle_Cronjob.Logger, BoxedUnit>)(Function1 & Serializable & scala.Serializable)logger -> {
            Isabelle_Devel$.MODULE$.build_status(logger.options());
            return BoxedUnit.UNIT;
        })})), exclude_task$1, log_service$1), List$.MODULE$.canBuildFrom())).$colon$colon((Object)logger_Task), exclude_task$1, log_service$1);
        logger_TaskArray[3] = MODULE$.exit();
        Isabelle_Cronjob$.run_now$1(Isabelle_Cronjob$.SEQ$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])logger_TaskArray)), exclude_task$1, log_service$1), log_service$1);
    }

    private Isabelle_Cronjob$() {
        MODULE$ = this;
        this.backup = "lxbroy10:cronjob";
        this.main_dir = Path$.MODULE$.explode("~/cronjob");
        this.main_state_file = this.main_dir().$plus(Path$.MODULE$.explode("run/main.state"));
        this.current_log = this.main_dir().$plus(Path$.MODULE$.explode("run/main.log"));
        this.cumulative_log = this.main_dir().$plus(Path$.MODULE$.explode("log/main.log"));
        this.isabelle_repos_source = "https://isabelle.sketis.net/repos/isabelle";
        this.isabelle_repos = this.main_dir().$plus(Path$.MODULE$.explode("isabelle"));
        this.afp_repos = this.main_dir().$plus(Path$.MODULE$.explode("AFP"));
        this.build_log_dirs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{Path$.MODULE$.explode("~/log"), Path$.MODULE$.explode("~/afp/log"), Path$.MODULE$.explode("~/cronjob/log")}));
        this.init = new Isabelle_Cronjob.Logger_Task("init", (Function1<Isabelle_Cronjob.Logger, BoxedUnit>)(Function1 & Serializable & scala.Serializable)logger -> {
            Isabelle_Cronjob$.$anonfun$init$1(logger);
            return BoxedUnit.UNIT;
        });
        this.exit = new Isabelle_Cronjob.Logger_Task("exit", (Function1<Isabelle_Cronjob.Logger, BoxedUnit>)(Function1 & Serializable & scala.Serializable)logger -> {
            Isabelle_Cronjob$.$anonfun$exit$1(logger);
            return BoxedUnit.UNIT;
        });
        this.build_release = new Isabelle_Cronjob.Logger_Task("build_release", (Function1<Isabelle_Cronjob.Logger, BoxedUnit>)(Function1 & Serializable & scala.Serializable)logger -> {
            Isabelle_Cronjob$.$anonfun$build_release$1(logger);
            return BoxedUnit.UNIT;
        });
        this.build_history_base = new Isabelle_Cronjob.Logger_Task("build_history_base", (Function1<Isabelle_Cronjob.Logger, BoxedUnit>)(Function1 & Serializable & scala.Serializable)logger -> {
            Isabelle_Cronjob$.$anonfun$build_history_base$1(logger);
            return BoxedUnit.UNIT;
        });
        Isabelle_Cronjob.Remote_Build[] remote_BuildArray = new Isabelle_Cronjob.Remote_Build[7];
        String x$54 = "AFP";
        String x$55 = "lxbroy7";
        String x$56 = "-N -X slow";
        boolean x$57 = true;
        String x$58 = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Build_Log$Prop$.MODULE$.build_tags()), " = ")).append(SQL$.MODULE$.string("AFP")).toString();
        String x$59 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$60 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        String x$61 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
        boolean x$62 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
        String x$63 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
        String x$64 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
        int x$65 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        boolean x$66 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$10();
        boolean x$67 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$11();
        int x$68 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$12();
        String x$69 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$13();
        String x$70 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$14();
        boolean x$71 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
        List<String> x$72 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        boolean x$73 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray[0] = new Isabelle_Cronjob.Remote_Build(x$54, x$55, x$59, x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$69, x$70, x$56, x$57, x$71, x$72, x$58, x$73);
        String x$74 = "Poly/ML 5.7 Linux";
        String x$75 = "lxbroy8";
        String x$76 = "37074e22e8be";
        String x$77 = "-m32 -B -M1x2,2 -t polyml-5.7 -i 'init_component /home/isabelle/contrib/polyml-5.7'";
        String x$78 = "-N -g timing";
        String x$79 = new StringBuilder(9).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Build_Log$Prop$.MODULE$.build_tags()), " = ")).append(SQL$.MODULE$.string("polyml-5.7")).append(" AND ").append(Build_Log$Settings$.MODULE$.ML_OPTIONS()).append(" <> ").append(SQL$.MODULE$.string("-H 500")).toString();
        String x$80 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$81 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        String x$82 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
        boolean x$83 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
        String x$84 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
        String x$85 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
        int x$86 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        boolean x$87 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$10();
        boolean x$88 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$11();
        int x$89 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$12();
        boolean x$90 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$16();
        boolean x$91 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
        List<String> x$92 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        boolean x$93 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray[1] = new Isabelle_Cronjob.Remote_Build(x$74, x$75, x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$76, x$77, x$78, x$90, x$91, x$92, x$79, x$93);
        String x$94 = "Poly/ML 5.7.1 Linux";
        String x$95 = "lxbroy8";
        String x$96 = "a9d5b59c3e12";
        String x$97 = "-m32 -B -M1x2,2 -t polyml-5.7.1-pre2 -i 'init_component /home/isabelle/contrib/polyml-test-905dae2ebfda'";
        String x$98 = "-N -g timing";
        String x$99 = new StringBuilder(7).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Build_Log$Prop$.MODULE$.build_tags()), " = ")).append(SQL$.MODULE$.string("polyml-5.7.1-pre1")).append(" OR ").append(Build_Log$Prop$.MODULE$.build_tags()).append(" = ").append(SQL$.MODULE$.string("polyml-5.7.1-pre2")).toString();
        String x$100 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$101 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        String x$102 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
        boolean x$103 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
        String x$104 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
        String x$105 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
        int x$106 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        boolean x$107 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$10();
        boolean x$108 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$11();
        int x$109 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$12();
        boolean x$110 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$16();
        boolean x$111 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
        List<String> x$112 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        boolean x$113 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray[2] = new Isabelle_Cronjob.Remote_Build(x$94, x$95, x$100, x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108, x$109, x$96, x$97, x$98, x$110, x$111, x$112, x$99, x$113);
        String x$114 = "Poly/ML 5.7 Mac OS X";
        String x$115 = "macbroy2";
        String x$116 = "37074e22e8be";
        String x$117 = "-m32 -B -M1x4,4 -t polyml-5.7 -i 'init_component /home/isabelle/contrib/polyml-5.7'";
        String x$118 = "-a";
        String x$119 = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Build_Log$Prop$.MODULE$.build_tags()), " = ")).append(SQL$.MODULE$.string("polyml-5.7")).toString();
        String x$120 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$121 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        String x$122 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
        boolean x$123 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
        String x$124 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
        String x$125 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
        int x$126 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        boolean x$127 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$10();
        boolean x$128 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$11();
        int x$129 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$12();
        boolean x$130 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$16();
        boolean x$131 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
        List<String> x$132 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        boolean x$133 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray[3] = new Isabelle_Cronjob.Remote_Build(x$114, x$115, x$120, x$121, x$122, x$123, x$124, x$125, x$126, x$127, x$128, x$129, x$116, x$117, x$118, x$130, x$131, x$132, x$119, x$133);
        String x$134 = "Poly/ML 5.7.1 Mac OS X";
        String x$135 = "macbroy2";
        String x$136 = "a9d5b59c3e12";
        String x$137 = "-m32 -B -M1x4,4 -t polyml-5.7.1-pre2 -i 'init_component /home/isabelle/contrib/polyml-test-905dae2ebfda'";
        String x$138 = "-a";
        String x$139 = new StringBuilder(7).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Build_Log$Prop$.MODULE$.build_tags()), " = ")).append(SQL$.MODULE$.string("polyml-5.7.1-pre1")).append(" OR ").append(Build_Log$Prop$.MODULE$.build_tags()).append(" = ").append(SQL$.MODULE$.string("polyml-5.7.1-pre2")).toString();
        String x$140 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$141 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        String x$142 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
        boolean x$143 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
        String x$144 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
        String x$145 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
        int x$146 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        boolean x$147 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$10();
        boolean x$148 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$11();
        int x$149 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$12();
        boolean x$150 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$16();
        boolean x$151 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
        List<String> x$152 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        boolean x$153 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray[4] = new Isabelle_Cronjob.Remote_Build(x$134, x$135, x$140, x$141, x$142, x$143, x$144, x$145, x$146, x$147, x$148, x$149, x$136, x$137, x$138, x$150, x$151, x$152, x$139, x$153);
        String x$154 = "Poly/ML test";
        String x$155 = "lxbroy8";
        String x$156 = "-m32 -B -M1x2,2 -t polyml-test -i 'init_component /home/isabelle/contrib/polyml-5.7-20170217'";
        String x$157 = "-N -g timing";
        String x$158 = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Build_Log$Prop$.MODULE$.build_tags()), " = ")).append(SQL$.MODULE$.string("polyml-test")).toString();
        String x$159 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$160 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        String x$161 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
        boolean x$162 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
        String x$163 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
        String x$164 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
        int x$165 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        boolean x$166 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$10();
        boolean x$167 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$11();
        int x$168 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$12();
        String x$169 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$13();
        boolean x$170 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$16();
        boolean x$171 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
        List<String> x$172 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        boolean x$173 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray[5] = new Isabelle_Cronjob.Remote_Build(x$154, x$155, x$159, x$160, x$161, x$162, x$163, x$164, x$165, x$166, x$167, x$168, x$169, x$156, x$157, x$170, x$171, x$172, x$158, x$173);
        String x$174 = "Mac OS X 10.8 Mountain Lion";
        String x$175 = "macbroy30";
        String x$176 = "-m32 -M2";
        String x$177 = "-a";
        String x$178 = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Build_Log$Prop$.MODULE$.build_start()), " < date '2017-03-03'");
        String x$179 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$180 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        String x$181 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
        boolean x$182 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
        String x$183 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
        String x$184 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
        int x$185 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        boolean x$186 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$10();
        boolean x$187 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$11();
        int x$188 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$12();
        String x$189 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$13();
        boolean x$190 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$16();
        boolean x$191 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
        List<String> x$192 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        boolean x$193 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray[6] = new Isabelle_Cronjob.Remote_Build(x$174, x$175, x$179, x$180, x$181, x$182, x$183, x$184, x$185, x$186, x$187, x$188, x$189, x$176, x$177, x$190, x$191, x$192, x$178, x$193);
        this.remote_builds_old = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])remote_BuildArray));
        List[] listArray = new List[7];
        Isabelle_Cronjob.Remote_Build[] remote_BuildArray2 = new Isabelle_Cronjob.Remote_Build[1];
        String x$194 = "Linux A";
        String x$195 = "lxbroy9";
        String x$196 = "-m32 -B -M1x2,2";
        String x$197 = "-N -g timing";
        String x$198 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$199 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        String x$200 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
        boolean x$201 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
        String x$202 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
        String x$203 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
        int x$204 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        boolean x$205 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$10();
        boolean x$206 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$11();
        int x$207 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$12();
        String x$208 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$13();
        boolean x$209 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$16();
        boolean x$210 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
        List<String> x$211 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        String x$212 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$19();
        boolean x$213 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray2[0] = new Isabelle_Cronjob.Remote_Build(x$194, x$195, x$198, x$199, x$200, x$201, x$202, x$203, x$204, x$205, x$206, x$207, x$208, x$196, x$197, x$209, x$210, x$211, x$212, x$213);
        listArray[0] = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])remote_BuildArray2));
        Isabelle_Cronjob.Remote_Build[] remote_BuildArray3 = new Isabelle_Cronjob.Remote_Build[1];
        String x$214 = "Linux B";
        String x$215 = "lxbroy10";
        boolean x$216 = true;
        int x$217 = 90;
        String x$218 = "-m32 -B -M1x4,2,4,6";
        String x$219 = "-N -g timing";
        String x$220 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$221 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        String x$222 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
        boolean x$223 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
        String x$224 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
        String x$225 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
        int x$226 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        boolean x$227 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$10();
        String x$228 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$13();
        boolean x$229 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$16();
        boolean x$230 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
        List<String> x$231 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        String x$232 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$19();
        boolean x$233 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray3[0] = new Isabelle_Cronjob.Remote_Build(x$214, x$215, x$220, x$221, x$222, x$223, x$224, x$225, x$226, x$227, x$216, x$217, x$228, x$218, x$219, x$229, x$230, x$231, x$232, x$233);
        listArray[1] = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])remote_BuildArray3));
        Isabelle_Cronjob.Remote_Build[] remote_BuildArray4 = new Isabelle_Cronjob.Remote_Build[1];
        String x$234 = "Linux Benchmarks";
        String x$235 = "lxbroy5";
        boolean x$236 = true;
        int x$237 = 90;
        String x$238 = "-m32 -B -M1x2,2 -t Benchmarks -e ISABELLE_GHC=ghc -e ISABELLE_MLTON=mlton -e ISABELLE_OCAML=ocaml -e ISABELLE_OCAMLC=ocamlc -e ISABELLE_SMLNJ=sml -e ISABELLE_SWIPL=swipl";
        String x$239 = "-N -a -d '~~/src/Benchmarks'";
        String x$240 = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Build_Log$Prop$.MODULE$.build_tags()), " = ")).append(SQL$.MODULE$.string("Benchmarks")).toString();
        String x$241 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$242 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        String x$243 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
        boolean x$244 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
        String x$245 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
        String x$246 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
        int x$247 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        boolean x$248 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$10();
        String x$249 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$13();
        boolean x$250 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$16();
        boolean x$251 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
        List<String> x$252 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        boolean x$253 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray4[0] = new Isabelle_Cronjob.Remote_Build(x$234, x$235, x$241, x$242, x$243, x$244, x$245, x$246, x$247, x$248, x$236, x$237, x$249, x$238, x$239, x$250, x$251, x$252, x$240, x$253);
        listArray[2] = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])remote_BuildArray4));
        Isabelle_Cronjob.Remote_Build[] remote_BuildArray5 = new Isabelle_Cronjob.Remote_Build[3];
        String x$254 = "Mac OS X";
        String x$255 = "macbroy2";
        String x$256 = "-m32 -M8 -e ISABELLE_GHC=ghc -e ISABELLE_MLTON=mlton -e ISABELLE_OCAML=ocaml -e ISABELLE_OCAMLC=ocamlc -e ISABELLE_SMLNJ=/mnt/nfsbroy/home/smlnj/bin/sml";
        String x$257 = "-a";
        String x$258 = Build_Log$Prop$.MODULE$.build_tags().undefined();
        String x$259 = "2c0f24e927dd";
        String x$260 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$261 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        String x$262 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
        boolean x$263 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
        String x$264 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
        String x$265 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
        int x$266 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        boolean x$267 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$10();
        boolean x$268 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$11();
        int x$269 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$12();
        boolean x$270 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$16();
        boolean x$271 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
        List<String> x$272 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        boolean x$273 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray5[0] = new Isabelle_Cronjob.Remote_Build(x$254, x$255, x$260, x$261, x$262, x$263, x$264, x$265, x$266, x$267, x$268, x$269, x$259, x$256, x$257, x$270, x$271, x$272, x$258, x$273);
        String x$274 = "Mac OS X, quick_and_dirty";
        String x$275 = "macbroy2";
        String x$276 = "-m32 -M8 -t quick_and_dirty";
        String x$277 = "-a -o quick_and_dirty";
        String x$278 = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Build_Log$Prop$.MODULE$.build_tags()), " = ")).append(SQL$.MODULE$.string("quick_and_dirty")).toString();
        String x$279 = "2c0f24e927dd";
        String x$280 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$281 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        String x$282 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
        boolean x$283 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
        String x$284 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
        String x$285 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
        int x$286 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        boolean x$287 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$10();
        boolean x$288 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$11();
        int x$289 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$12();
        boolean x$290 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$16();
        boolean x$291 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
        List<String> x$292 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        boolean x$293 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray5[1] = new Isabelle_Cronjob.Remote_Build(x$274, x$275, x$280, x$281, x$282, x$283, x$284, x$285, x$286, x$287, x$288, x$289, x$279, x$276, x$277, x$290, x$291, x$292, x$278, x$293);
        String x$294 = "Mac OS X, skip_proofs";
        String x$295 = "macbroy2";
        String x$296 = "-m32 -M8 -t skip_proofs";
        String x$297 = "-a -o skip_proofs";
        String x$298 = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Build_Log$Prop$.MODULE$.build_tags()), " = ")).append(SQL$.MODULE$.string("skip_proofs")).toString();
        String x$299 = "2c0f24e927dd";
        String x$300 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$301 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        String x$302 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
        boolean x$303 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
        String x$304 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
        String x$305 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
        int x$306 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        boolean x$307 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$10();
        boolean x$308 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$11();
        int x$309 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$12();
        boolean x$310 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$16();
        boolean x$311 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
        List<String> x$312 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        boolean x$313 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray5[2] = new Isabelle_Cronjob.Remote_Build(x$294, x$295, x$300, x$301, x$302, x$303, x$304, x$305, x$306, x$307, x$308, x$309, x$299, x$296, x$297, x$310, x$311, x$312, x$298, x$313);
        listArray[3] = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])remote_BuildArray5));
        Isabelle_Cronjob.Remote_Build[] remote_BuildArray6 = new Isabelle_Cronjob.Remote_Build[1];
        String x$314 = "Mac OS X 10.12 Sierra";
        String x$315 = "macbroy30";
        String x$316 = "-m32 -M2";
        String x$317 = "-a";
        String x$318 = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Build_Log$Prop$.MODULE$.build_start()), " > date '2017-03-03'");
        String x$319 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$320 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        String x$321 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
        boolean x$322 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
        String x$323 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
        String x$324 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
        int x$325 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        boolean x$326 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$10();
        boolean x$327 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$11();
        int x$328 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$12();
        String x$329 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$13();
        boolean x$330 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$16();
        boolean x$331 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
        List<String> x$332 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        boolean x$333 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray6[0] = new Isabelle_Cronjob.Remote_Build(x$314, x$315, x$319, x$320, x$321, x$322, x$323, x$324, x$325, x$326, x$327, x$328, x$329, x$316, x$317, x$330, x$331, x$332, x$318, x$333);
        listArray[4] = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])remote_BuildArray6));
        Isabelle_Cronjob.Remote_Build[] remote_BuildArray7 = new Isabelle_Cronjob.Remote_Build[1];
        String x$334 = "Mac OS X 10.10 Yosemite";
        String x$335 = "macbroy31";
        String x$336 = "-m32 -M2";
        String x$337 = "-a";
        String x$338 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$339 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        String x$340 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
        boolean x$341 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
        String x$342 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
        String x$343 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
        int x$344 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        boolean x$345 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$10();
        boolean x$346 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$11();
        int x$347 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$12();
        String x$348 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$13();
        boolean x$349 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$16();
        boolean x$350 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
        List<String> x$351 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        String x$352 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$19();
        boolean x$353 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray7[0] = new Isabelle_Cronjob.Remote_Build(x$334, x$335, x$338, x$339, x$340, x$341, x$342, x$343, x$344, x$345, x$346, x$347, x$348, x$336, x$337, x$349, x$350, x$351, x$352, x$353);
        listArray[5] = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])remote_BuildArray7));
        Isabelle_Cronjob.Remote_Build[] remote_BuildArray8 = new Isabelle_Cronjob.Remote_Build[2];
        String x$354 = "Windows";
        String x$355 = "vmnipkow9";
        boolean x$356 = true;
        int x$357 = 90;
        boolean x$358 = true;
        String x$359 = "-m32 -M4 -e ISABELLE_OCAML=ocaml -e ISABELLE_OCAMLC=ocamlc -e ISABELLE_GHC=/usr/local/ghc-8.0.2/bin/ghc -e ISABELLE_SMLNJ=/usr/local/smlnj-110.81/bin/sml";
        String x$360 = "-a";
        String x$361 = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Build_Log$Settings$.MODULE$.ML_PLATFORM()), " = ")).append(SQL$.MODULE$.string("x86-windows")).toString();
        String x$362 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$363 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        String x$364 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
        boolean x$365 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
        String x$366 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
        String x$367 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
        int x$368 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        String x$369 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$13();
        boolean x$370 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$16();
        boolean x$371 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
        List<String> x$372 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        boolean x$373 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray8[0] = new Isabelle_Cronjob.Remote_Build(x$354, x$355, x$362, x$363, x$364, x$365, x$366, x$367, x$368, x$358, x$356, x$357, x$369, x$359, x$360, x$370, x$371, x$372, x$361, x$373);
        String x$374 = "Windows";
        String x$375 = "vmnipkow9";
        boolean x$376 = true;
        int x$377 = 90;
        boolean x$378 = true;
        String x$379 = "-m64 -M4 -e ISABELLE_OCAML=ocaml -e ISABELLE_OCAMLC=ocamlc -e ISABELLE_GHC=/usr/local/ghc-8.0.2/bin/ghc -e ISABELLE_SMLNJ=/usr/local/smlnj-110.81/bin/sml";
        String x$380 = "-a";
        String x$381 = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Build_Log$Settings$.MODULE$.ML_PLATFORM()), " = ")).append(SQL$.MODULE$.string("x86_64-windows")).toString();
        String x$382 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$383 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        String x$384 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
        boolean x$385 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
        String x$386 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
        String x$387 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
        int x$388 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        String x$389 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$13();
        boolean x$390 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$16();
        boolean x$391 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
        List<String> x$392 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        boolean x$393 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray8[1] = new Isabelle_Cronjob.Remote_Build(x$374, x$375, x$382, x$383, x$384, x$385, x$386, x$387, x$388, x$378, x$376, x$377, x$389, x$379, x$380, x$390, x$391, x$392, x$381, x$393);
        listArray[6] = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])remote_BuildArray8));
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])listArray));
        this.remote_builds1 = ((List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lxbroy6"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lxbroy8", "lxbroy5"})))})).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Isabelle_Cronjob$.$anonfun$remote_builds1$1(check$ifrefutable$2))).map((Function1 & Serializable & scala.Serializable)x$11 -> {
            Tuple2 tuple2 = x$11;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int n = tuple2._1$mcI$sp();
            List hosts = (List)tuple2._2();
            Isabelle_Cronjob.Remote_Build[] remote_BuildArray = new Isabelle_Cronjob.Remote_Build[1];
            String x$394 = "AFP";
            String x$395 = (String)hosts.head();
            List x$396 = (List)hosts.tail();
            String x$397 = new StringBuilder(152).append("-m32 -M1x2 -t AFP -P").append(n).append(" -e ISABELLE_GHC=ghc").append(" -e ISABELLE_MLTON=mlton").append(" -e ISABELLE_OCAML=ocaml -e ISABELLE_OCAMLC=ocamlc").append(" -e ISABELLE_SMLNJ=/home/smlnj/bin/sml").toString();
            String x$398 = "-N -X slow";
            boolean x$399 = true;
            String x$400 = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Build_Log$Prop$.MODULE$.build_tags()), " = ")).append(SQL$.MODULE$.string("AFP")).toString();
            String x$401 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
            int x$402 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
            String x$403 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$5();
            boolean x$404 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$6();
            String x$405 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$7();
            String x$406 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$8();
            int x$407 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
            boolean x$408 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$10();
            boolean x$409 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$11();
            int x$410 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$12();
            String x$411 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$13();
            boolean x$412 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$17();
            boolean x$413 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
            remote_BuildArray[0] = new Isabelle_Cronjob.Remote_Build(x$394, x$395, x$401, x$402, x$403, x$404, x$405, x$406, x$407, x$408, x$409, x$410, x$411, x$397, x$398, x$399, x$412, (List<String>)x$396, x$400, x$413);
            List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])remote_BuildArray));
            return list;
        }, List$.MODULE$.canBuildFrom())).$colon$colon$colon(list);
        List[] listArray2 = new List[1];
        Isabelle_Cronjob.Remote_Build[] remote_BuildArray9 = new Isabelle_Cronjob.Remote_Build[1];
        String x$414 = "AFP slow";
        String x$415 = "lrzcloud1";
        boolean x$416 = true;
        String x$417 = "lxbroy10";
        String x$418 = "i21isatest";
        String x$419 = "10.155.208.96";
        boolean x$420 = true;
        String x$421 = "-m64 -M6 -U30000 -s10 -t AFP";
        String x$422 = "-g slow";
        boolean x$423 = true;
        boolean x$424 = true;
        String x$425 = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Build_Log$Prop$.MODULE$.build_tags()), " = ")).append(SQL$.MODULE$.string("AFP")).toString();
        String x$426 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$3();
        int x$427 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$4();
        int x$428 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$9();
        boolean x$429 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$11();
        int x$430 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$12();
        String x$431 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$13();
        List<String> x$432 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$18();
        boolean x$433 = Isabelle_Cronjob$Remote_Build$.MODULE$.apply$default$20();
        remote_BuildArray9[0] = new Isabelle_Cronjob.Remote_Build(x$414, x$415, x$426, x$427, x$419, x$420, x$417, x$418, x$428, x$416, x$429, x$430, x$431, x$421, x$422, x$423, x$424, x$432, x$425, x$433);
        listArray2[0] = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])remote_BuildArray9));
        this.remote_builds2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])listArray2));
        List<Isabelle_Cronjob.Remote_Build> list2 = this.remote_builds_old();
        List<List<Isabelle_Cronjob.Remote_Build>> list3 = this.remote_builds1();
        this.build_status_profiles = (List)((List)this.remote_builds2().$colon$colon$colon(list3).$colon$colon(list2).flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.profile(), List$.MODULE$.canBuildFrom());
    }
}

