/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Bytes;
import isabelle.Bytes$;
import isabelle.Isabelle_System$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.UTF8$;
import isabelle.Url$;
import isabelle.Word$;
import isabelle.XZ$;
import isabelle.package$;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZInputStream;
import org.tukaani.xz.XZOutputStream;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class File$ {
    public static File$ MODULE$;
    private final Regex Cygdrive;
    private final Regex Named_Root;

    static {
        new File$();
    }

    public String standard_path(Path path) {
        return path.expand().implode();
    }

    public String standard_path(String platform_path) {
        String string;
        if (Platform$.MODULE$.is_windows()) {
            String string2;
            Regex Platform_Root = new Regex(new java.lang.StringBuilder(18).append("(?i)").append(Pattern.quote(Isabelle_System$.MODULE$.cygwin_root())).append("(?:\\\\+|\\z)(.*)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            Regex Drive = new Regex("([a-zA-Z]):\\\\*(.*)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            String string3 = platform_path.replace('/', '\\');
            Option option = Platform_Root.unapplySeq((CharSequence)string3);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String rest = (String)((LinearSeqOptimized)option.get()).apply(0);
                string2 = new java.lang.StringBuilder(1).append("/").append(rest.replace('\\', '/')).toString();
            } else {
                Option option2 = Drive.unapplySeq((CharSequence)string3);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                    String letter = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    String rest = (String)((LinearSeqOptimized)option2.get()).apply(1);
                    String string4 = rest;
                    String string5 = "";
                    string2 = new java.lang.StringBuilder(10).append("/cygdrive/").append(Word$.MODULE$.lowercase(letter)).append((Object)(!(string4 != null ? !string4.equals(string5) : string5 != null) ? "" : new java.lang.StringBuilder(1).append("/").append(rest.replace('\\', '/')).toString())).toString();
                } else {
                    string2 = string3.replace('\\', '/');
                }
            }
            string = string2;
        } else {
            string = platform_path;
        }
        return string;
    }

    public String standard_path(File file) {
        return this.standard_path(file.getPath());
    }

    public String standard_url(String name) {
        String string;
        block3: {
            try {
                URL url = new URL(name);
                String string2 = url.getProtocol();
                String string3 = "file";
                if (!(string2 != null ? !string2.equals(string3) : string3 != null) && Url$.MODULE$.is_wellformed_file(name)) {
                    string = this.standard_path(Url$.MODULE$.parse_file(name));
                    break block3;
                }
                string = name;
            }
            catch (MalformedURLException malformedURLException) {
                string = this.standard_path(name);
            }
        }
        return string;
    }

    private Regex Cygdrive() {
        return this.Cygdrive;
    }

    private Regex Named_Root() {
        return this.Named_Root;
    }

    public String platform_path(String standard_path) {
        String string;
        if (Platform$.MODULE$.is_windows()) {
            String string2;
            StringBuilder result_path = new StringBuilder();
            String string3 = standard_path;
            Option option = this.Cygdrive().unapplySeq((CharSequence)string3);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                String drive = (String)((LinearSeqOptimized)option.get()).apply(0);
                String rest = (String)((LinearSeqOptimized)option.get()).apply(1);
                result_path.$plus$plus$eq(new java.lang.StringBuilder(1).append(Word$.MODULE$.uppercase(drive)).append(":").append(File.separator).toString());
                string2 = rest;
            } else {
                Option option2 = this.Named_Root().unapplySeq((CharSequence)string3);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                    String root = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    String rest = (String)((LinearSeqOptimized)option2.get()).apply(1);
                    result_path.$plus$plus$eq(File.separator);
                    result_path.$plus$plus$eq(File.separator);
                    result_path.$plus$plus$eq(root);
                    string2 = rest;
                } else if (string3.startsWith("/")) {
                    result_path.$plus$plus$eq(Isabelle_System$.MODULE$.cygwin_root());
                    string2 = string3;
                } else {
                    string2 = string3;
                }
            }
            String rest = string2;
            ((TraversableLike)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)'/'), (Object)rest)).withFilter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)File$.$anonfun$platform_path$1(p))).foreach((Function1 & Serializable & scala.Serializable)p -> {
                int len = result_path.length();
                Object object = len > 0 && result_path.apply(len - 1) != File.separatorChar ? result_path.$plus$eq(File.separatorChar) : BoxedUnit.UNIT;
                return result_path.$plus$plus$eq(p);
            });
            string = result_path.toString();
        } else {
            string = standard_path;
        }
        return string;
    }

    public String platform_path(Path path) {
        return this.platform_path(this.standard_path(path));
    }

    public File platform_file(Path path) {
        return new File(this.platform_path(path));
    }

    public File absolute(File file) {
        return file.toPath().toAbsolutePath().normalize().toFile();
    }

    public String absolute_name(File file) {
        return this.absolute(file).getPath();
    }

    public File canonical(File file) {
        return file.getCanonicalFile();
    }

    public String canonical_name(File file) {
        return this.canonical(file).getPath();
    }

    public Path path(File file) {
        return Path$.MODULE$.explode(this.standard_path(file));
    }

    public Path pwd() {
        return this.path(Path$.MODULE$.current().absolute_file());
    }

    public Option<Path> relative_path(Path base, Path other) {
        java.nio.file.Path base_path = base.file().toPath();
        java.nio.file.Path other_path = other.file().toPath();
        return other_path.startsWith(base_path) ? new Some((Object)this.path(base_path.relativize(other_path).toFile())) : None$.MODULE$;
    }

    public Option<Path> rebase_path(Path base, Path other) {
        return this.relative_path(base, other).map((Function1 & Serializable & scala.Serializable)x$1 -> base.$plus((Path)x$1));
    }

    public String bash_path(Path path) {
        return Bash$.MODULE$.string(this.standard_path(path));
    }

    public String bash_path(File file) {
        return Bash$.MODULE$.string(this.standard_path(file));
    }

    public Path check_dir(Path path) {
        return path.is_dir() ? path : (Path)package$.MODULE$.error().apply((Object)new java.lang.StringBuilder(19).append("No such directory: ").append(path).toString());
    }

    public Path check_file(Path path) {
        return path.is_file() ? path : (Path)package$.MODULE$.error().apply((Object)new java.lang.StringBuilder(14).append("No such file: ").append(path).toString());
    }

    public List<String> read_dir(Path dir) {
        Object object = !dir.is_dir() ? package$.MODULE$.error().apply((Object)new java.lang.StringBuilder(15).append("Bad directory: ").append(dir.toString()).toString()) : BoxedUnit.UNIT;
        File[] files = dir.file().listFiles();
        return files == null ? Nil$.MODULE$ : (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).toList().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName(), List$.MODULE$.canBuildFrom());
    }

    public List<File> find_files(File start, Function1<File, Object> pred, boolean include_dirs) {
        Object object;
        ListBuffer result = new ListBuffer();
        if (start.isFile()) {
            File$.isabelle$File$$check$1(start, pred, result);
            object = BoxedUnit.UNIT;
        } else {
            object = start.isDirectory() ? Files.walkFileTree(start.toPath(), (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(pred, include_dirs, result){
                private final Function1 pred$1;
                private final boolean include_dirs$1;
                private final ListBuffer result$1;

                public FileVisitResult preVisitDirectory(java.nio.file.Path path, BasicFileAttributes attrs) {
                    block0: {
                        if (!this.include_dirs$1) break block0;
                        File$.isabelle$File$$check$1(path.toFile(), this.pred$1, this.result$1);
                    }
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFile(java.nio.file.Path path, BasicFileAttributes attrs) {
                    File$.isabelle$File$$check$1(path.toFile(), this.pred$1, this.result$1);
                    return FileVisitResult.CONTINUE;
                }
                {
                    this.pred$1 = pred$1;
                    this.include_dirs$1 = include_dirs$1;
                    this.result$1 = result$1;
                }
            }) : BoxedUnit.UNIT;
        }
        return result.toList();
    }

    public Function1<File, Object> find_files$default$2() {
        return (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)File$.$anonfun$find_files$default$2$1(x$3));
    }

    public boolean find_files$default$3() {
        return false;
    }

    public String read(File file) {
        return Bytes$.MODULE$.read(file).text();
    }

    public String read(Path path) {
        return this.read(path.file());
    }

    public String read_stream(BufferedReader reader) {
        StringBuilder output = new StringBuilder(100);
        int c = -1;
        while ((c = reader.read()) != -1) {
            output.$plus$eq((char)c);
        }
        reader.close();
        return output.toString();
    }

    public String read_stream(InputStream stream) {
        return this.read_stream(new BufferedReader(new InputStreamReader(stream, UTF8$.MODULE$.charset())));
    }

    public String read_gzip(File file) {
        return this.read_stream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file))));
    }

    public String read_gzip(Path path) {
        return this.read_gzip(path.file());
    }

    public String read_xz(File file) {
        return this.read_stream((InputStream)new XZInputStream((InputStream)new BufferedInputStream(new FileInputStream(file))));
    }

    public String read_xz(Path path) {
        return this.read_xz(path.file());
    }

    public List<String> read_lines(BufferedReader reader, Function1<String, BoxedUnit> progress) {
        ListBuffer result = new ListBuffer();
        String line = null;
        while ((line = File$.liftedTree1$1(reader)) != null) {
            progress.apply((Object)line);
            result.$plus$eq((Object)line);
        }
        reader.close();
        return result.toList();
    }

    public void write_file(File file, CharSequence text, Function1<OutputStream, OutputStream> make_stream) {
        OutputStream stream = (OutputStream)make_stream.apply((Object)new FileOutputStream(file));
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, UTF8$.MODULE$.charset()));){
            writer.append(text);
        }
    }

    public void write(File file, CharSequence text) {
        this.write_file(file, text, (Function1<OutputStream, OutputStream>)(Function1 & Serializable & scala.Serializable)s -> s);
    }

    public void write(Path path, CharSequence text) {
        this.write(path.file(), text);
    }

    public void write_gzip(File file, CharSequence text) {
        this.write_file(file, text, (Function1<OutputStream, OutputStream>)(Function1 & Serializable & scala.Serializable)s -> new GZIPOutputStream(new BufferedOutputStream((OutputStream)s)));
    }

    public void write_gzip(Path path, CharSequence text) {
        this.write_gzip(path.file(), text);
    }

    public void write_xz(File file, CharSequence text, LZMA2Options options) {
        this.write_file(file, text, (Function1<OutputStream, OutputStream>)(Function1 & Serializable & scala.Serializable)s -> new XZOutputStream((OutputStream)new BufferedOutputStream((OutputStream)s), (FilterOptions)options));
    }

    public void write_xz(File file, CharSequence text) {
        this.write_xz(file, text, XZ$.MODULE$.options(XZ$.MODULE$.options$default$1()));
    }

    public void write_xz(Path path, CharSequence text, LZMA2Options options) {
        this.write_xz(path.file(), text, options);
    }

    public void write_xz(Path path, CharSequence text) {
        this.write_xz(path, text, XZ$.MODULE$.options(XZ$.MODULE$.options$default$1()));
    }

    public void write_backup(Path path, CharSequence text) {
        if (path.is_file()) {
            this.move(path, path.backup());
        }
        this.write(path, text);
    }

    public void write_backup2(Path path, CharSequence text) {
        if (path.is_file()) {
            this.move(path, path.backup2());
        }
        this.write(path, text);
    }

    public void append(File file, CharSequence text) {
        Files.write(file.toPath(), UTF8$.MODULE$.bytes(((Object)text).toString()), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
    }

    public void append(Path path, CharSequence text) {
        this.append(path.file(), text);
    }

    public boolean eq(File file1, File file2) {
        boolean bl;
        try {
            bl = Files.isSameFile(file1.toPath(), file2.toPath());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<String> option = package$.MODULE$.ERROR().unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    public boolean eq(Path path1, Path path2) {
        return this.eq(path1.file(), path2.file());
    }

    public boolean eq_content(File file1, File file2) {
        boolean bl;
        if (this.eq(file1, file2)) {
            bl = true;
        } else if (file1.length() != file2.length()) {
            bl = false;
        } else {
            Bytes bytes = Bytes$.MODULE$.read(file1);
            Bytes bytes2 = Bytes$.MODULE$.read(file2);
            bl = !(bytes != null ? !((Object)bytes).equals(bytes2) : bytes2 != null);
        }
        return bl;
    }

    public boolean eq_content(Path path1, Path path2) {
        return this.eq_content(path1.file(), path2.file());
    }

    public void copy(File src, File dst) {
        block0: {
            File target;
            File file = target = dst.isDirectory() ? new File(dst, src.getName()) : dst;
            if (this.eq(src, target)) break block0;
            Files.copy(src.toPath(), target.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void copy(Path path1, Path path2) {
        this.copy(path1.file(), path2.file());
    }

    public void move(File src, File dst) {
        block0: {
            File target;
            File file = target = dst.isDirectory() ? new File(dst, src.getName()) : dst;
            if (this.eq(src, target)) break block0;
            Files.move(src.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void move(Path path1, Path path2) {
        this.move(path1.file(), path2.file());
    }

    public static final /* synthetic */ boolean $anonfun$platform_path$1(String p) {
        String string = p;
        String string2 = "";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final void isabelle$File$$check$1(File file, Function1 pred$1, ListBuffer result$1) {
        block0: {
            if (!BoxesRunTime.unboxToBoolean((Object)pred$1.apply((Object)file))) break block0;
            result$1.$plus$eq((Object)file);
        }
    }

    public static final /* synthetic */ boolean $anonfun$find_files$default$2$1(File x$3) {
        return true;
    }

    private static final String liftedTree1$1(BufferedReader reader$1) {
        String string;
        try {
            string = reader$1.readLine();
        }
        catch (IOException iOException) {
            string = null;
        }
        return string;
    }

    private File$() {
        MODULE$ = this;
        this.Cygdrive = new Regex("/cygdrive/([a-zA-Z])($|/.*)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.Named_Root = new Regex("//+([^/]*)(.*)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }
}

