/*
 * Decompiled with CFR 0.152.
 */
package ise.plugin.nav;

import ise.plugin.nav.NavHistoryPopup;
import ise.plugin.nav.NavPosition;
import ise.plugin.nav.NavStack;
import ise.plugin.nav.NavigatorPlugin;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.ThreadUtilities;

public class Navigator
implements ActionListener {
    public static final String BACK = "back";
    public static final String FORWARD = "forward";
    public static final String CAN_GO_BACK = "canGoBack";
    public static final String CANNOT_GO_BACK = "cannotGoBack";
    public static final String CAN_GO_FORWARD = "canGoForward";
    public static final String CANNOT_GO_FORWARD = "cannotGoForward";
    private NavStack<NavPosition> backHistory;
    private NavPosition current = null;
    private NavStack<NavPosition> forwardHistory;
    private NavStack<NavPosition> userStack;
    private int maxStackSize = jEdit.getIntegerProperty((String)"navigator.maxStackSize", (int)512);
    private DefaultButtonModel backButtonModel;
    private DefaultButtonModel forwardButtonModel;
    private View view;
    private EditPane _editPane;
    private boolean ignoreUpdates;
    private Set<ChangeListener> changeListeners = null;

    public Navigator(View view) {
        this.view = view;
        this.init();
    }

    public Navigator(EditPane editPane) {
        this._editPane = editPane;
        this.view = editPane.getView();
        this.init();
    }

    private void init() {
        this.ignoreUpdates = false;
        this.backButtonModel = new DefaultButtonModel();
        this.backButtonModel.setActionCommand(BACK);
        this.backButtonModel.addActionListener(this);
        this.forwardButtonModel = new DefaultButtonModel();
        this.forwardButtonModel.setActionCommand(FORWARD);
        this.forwardButtonModel.addActionListener(this);
        this.backHistory = new NavStack(this.maxStackSize);
        this.forwardHistory = new NavStack(this.maxStackSize);
        this.userStack = new NavStack(this.maxStackSize);
        this.clearHistory();
        this.current = this.currentPosition();
    }

    public View getView() {
        return this.view;
    }

    public EditPane getEditPane() {
        return this._editPane;
    }

    public void setEditPane(EditPane editPane) {
        this._editPane = editPane;
    }

    public ButtonModel getBackModel() {
        return this.backButtonModel;
    }

    public ButtonModel getForwardModel() {
        return this.forwardButtonModel;
    }

    private NavPosition currentPosition() {
        EditPane editPane = this.getEditPane();
        JEditTextArea textarea = null;
        if (editPane != null) {
            textarea = editPane.getTextArea();
        } else {
            editPane = this.view.getEditPane();
            if (editPane != null) {
                textarea = editPane.getTextArea();
            }
        }
        if (textarea == null) {
            return null;
        }
        Buffer buffer = editPane.getBuffer();
        if (buffer == null || buffer.getLength() == 0 && buffer.getName().startsWith("Untitled") || !buffer.isLoaded()) {
            return null;
        }
        buffer.readLock();
        int caretPosition = textarea.getCaretPosition();
        String linetext = textarea.getLineText(textarea.getCaretLine());
        buffer.readUnlock();
        return new NavPosition(editPane, buffer, caretPosition, linetext);
    }

    public void addToHistory() {
        if (this.ignoreUpdates) {
            return;
        }
        NavPosition np = this.currentPosition();
        this.addToHistory(np);
    }

    private void addToHistory(NavPosition position) {
        if (position == null) {
            return;
        }
        if (position.equals(this.current)) {
            return;
        }
        if (this.current == null) {
            this.current = position;
            this.notifyChangeListeners();
            return;
        }
        this.backHistory.push(this.current);
        this.current = position;
        this.forwardHistory.clear();
        this.setButtonState();
        this.notifyChangeListeners();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals(BACK)) {
            this.goBack();
        } else if (ae.getActionCommand().equals(FORWARD)) {
            this.goForward();
        } else if (ae.getActionCommand().equals(CAN_GO_BACK)) {
            this.backButtonModel.setEnabled(true);
        } else if (ae.getActionCommand().equals(CANNOT_GO_BACK)) {
            this.backButtonModel.setEnabled(false);
        } else if (ae.getActionCommand().equals(CAN_GO_FORWARD)) {
            this.forwardButtonModel.setEnabled(true);
        } else if (ae.getActionCommand().equals(CANNOT_GO_FORWARD)) {
            this.forwardButtonModel.setEnabled(false);
        }
    }

    public void remove(NavPosition position) {
        this.view.getStatus().setMessage(jEdit.getProperty((String)"navigator.removingPosition", (String)"Navigator: removing invalid position") + ": " + position.plainText());
        this.backHistory.remove(position);
        this.forwardHistory.remove(position);
        if (this.current.equals(position)) {
            this.current = this.currentPosition();
        }
        this.notifyChangeListeners();
    }

    public void removeAll(String bufferPath) {
        NavPosition pos;
        int i;
        if (bufferPath == null) {
            return;
        }
        for (i = this.backHistory.getSize() - 1; i >= 0; --i) {
            pos = this.backHistory.getElementAt(i);
            if (!bufferPath.equals(pos.path)) continue;
            this.backHistory.removeElementAt(i);
        }
        for (i = this.forwardHistory.getSize() - 1; i >= 0; --i) {
            pos = this.forwardHistory.getElementAt(i);
            if (!bufferPath.equals(pos.path)) continue;
            this.forwardHistory.removeElementAt(i);
        }
        if (this.current == null || bufferPath.equals(this.current.path)) {
            this.current = this.currentPosition();
        }
        this.notifyChangeListeners();
    }

    public void setMaxHistorySize(int size) {
        if (size > 0) {
            this.backHistory.setMaxSize(size);
            this.forwardHistory.setMaxSize(size);
            this.maxStackSize = size;
        }
    }

    public int getMaxHistorySize() {
        return this.maxStackSize;
    }

    public void clearHistory() {
        this.backHistory.clear();
        this.userStack.clear();
        this.current = this.currentPosition();
        this.forwardHistory.clear();
        this.setButtonState();
        this.notifyChangeListeners();
    }

    private void setButtonState() {
        this.backButtonModel.setEnabled(this.backHistory.size() > 0);
        this.forwardButtonModel.setEnabled(this.forwardHistory.size() > 0);
    }

    private EditPane findEditPane(NavPosition position) {
        if (NavigatorPlugin.getScope() == 2) {
            if (this.getEditPane() == null) {
                this.setEditPane(this.view.getEditPane());
            }
            return this.getEditPane();
        }
        for (EditPane editPane : this.view.getEditPanes()) {
            if (editPane.hashCode() != position.editPane) continue;
            return editPane;
        }
        for (EditPane editPane : this.view.getEditPanes()) {
            Buffer[] buffers;
            for (Buffer buffer : buffers = editPane.getBufferSet().getAllBuffers()) {
                if (!position.path.equals(buffer.getPath())) continue;
                position.editPane = editPane.hashCode();
                return editPane;
            }
        }
        EditPane editPane = this.view.getEditPane();
        position.editPane = editPane.hashCode();
        return editPane;
    }

    private boolean validatePosition(NavPosition position) {
        if (position == null) {
            return false;
        }
        this.ignoreUpdates = true;
        EditPane editPaneForPosition = this.findEditPane(position);
        Buffer[] buffers = editPaneForPosition.getBufferSet().getAllBuffers();
        Buffer buffer = null;
        String path = position.path;
        for (Buffer b : buffers) {
            if (!path.equals(b.getPath())) continue;
            buffer = b;
            break;
        }
        if (buffer == null) {
            if (position.name != null && position.name.startsWith("Untitled")) {
                this.remove(position);
                this.ignoreUpdates = false;
                return false;
            }
            buffer = jEdit.openFile((View)this.view, (String)position.path);
            if (buffer == null) {
                this.remove(position);
                this.ignoreUpdates = false;
                return false;
            }
        }
        if (position.lineno >= buffer.getLineCount()) {
            this.remove(position);
            this.ignoreUpdates = false;
            return false;
        }
        return true;
    }

    public boolean setPosition(NavPosition position) {
        if (position == null) {
            return false;
        }
        if (!this.validatePosition(position)) {
            return false;
        }
        this.ignoreUpdates = true;
        final EditPane editPaneForPosition = this.findEditPane(position);
        Buffer[] buffers = editPaneForPosition.getBufferSet().getAllBuffers();
        Buffer buffer = null;
        String path = position.path;
        for (Buffer b : buffers) {
            if (!path.equals(b.getPath())) continue;
            buffer = b;
            break;
        }
        editPaneForPosition.setBuffer(buffer);
        int caret = position.caret;
        if (caret > buffer.getLength()) {
            caret = buffer.getLength();
        }
        if (caret < 0) {
            caret = 0;
        }
        try {
            final int caretFinal = caret;
            ThreadUtilities.runInDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    editPaneForPosition.getTextArea().setCaretPosition(caretFinal, true);
                    editPaneForPosition.getTextArea().requestFocus();
                }
            });
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        this.ignoreUpdates = false;
        return true;
    }

    public NavHistoryPopup backList() {
        if (this.backHistory.size() == 0) {
            JOptionPane.showMessageDialog((Component)this.view, "No backward items", "Info", 1);
            return null;
        }
        return new NavHistoryPopup(this.view, this, (Vector)this.backHistory.clone());
    }

    public NavHistoryPopup forwardList() {
        if (this.forwardHistory.size() == 0) {
            JOptionPane.showMessageDialog((Component)this.view, "No forward items", "Info", 1);
            return null;
        }
        return new NavHistoryPopup(this.view, this, (Vector)this.forwardHistory.clone());
    }

    public NavStack<NavPosition> getBackListModel() {
        return (NavStack)this.backHistory.clone();
    }

    public NavPosition getCurrentPosition() {
        return this.current == null ? null : new NavPosition(this.current);
    }

    public NavStack<NavPosition> getForwardListModel() {
        return (NavStack)this.forwardHistory.clone();
    }

    public NavStack<NavPosition> getCombinedListModel() {
        NavStack<NavPosition> stack = new NavStack<NavPosition>(this.backHistory.size() + this.forwardHistory.size() + (this.current == null ? 0 : 1));
        if (this.backHistory != null && this.backHistory.size() > 0) {
            stack.addAll(this.backHistory);
        }
        if (this.current != null) {
            stack.add(this.current);
        }
        if (this.forwardHistory != null && this.forwardHistory.size() > 0) {
            stack.addAll(this.forwardHistory);
        }
        return stack;
    }

    public void combinedList() {
        NavStack<NavPosition> stack = this.getCombinedListModel();
        if (stack.size() > 0) {
            new NavHistoryPopup(this.view, this, stack, this.current);
        } else {
            JOptionPane.showMessageDialog((Component)this.view, "No history items", "Info", 1);
        }
    }

    public void goBack() {
        if (this.backHistory == null || this.backHistory.size() == 0) {
            return;
        }
        if (this.current == null) {
            return;
        }
        NavPosition start = new NavPosition(this.current);
        NavPosition now = this.currentPosition();
        if (!this.current.equals(now)) {
            NavPosition item = this.forwardHistory.push(now);
            if (item == null) {
                this.forwardHistory.push(this.current);
                this.current = this.backHistory.pop();
            }
        } else {
            this.forwardHistory.push(this.current);
            this.current = this.backHistory.pop();
        }
        this.setPosition(this.current);
        this.setButtonState();
        this.notifyChangeListeners();
        this.setFileJump(start);
    }

    public void goBackFile() {
        this.singleFileJump(this.backHistory);
    }

    public void goForward() {
        NavPosition possible;
        if (this.forwardHistory.size() == 0) {
            return;
        }
        NavPosition start = new NavPosition(this.current);
        if (this.current != null) {
            this.backHistory.push(this.current);
        }
        if (this.setPosition(possible = (NavPosition)this.forwardHistory.peek())) {
            this.current = this.forwardHistory.pop();
            this.setButtonState();
            this.notifyChangeListeners();
        }
        this.setFileJump(start);
    }

    public void goForwardFile() {
        this.singleFileJump(this.forwardHistory);
    }

    public void singleFileJump(NavStack<NavPosition> history) {
        if (history == null || history.size() == 0) {
            return;
        }
        if (this.current == null) {
            return;
        }
        NavStack<NavPosition> oppositeHistory = null;
        if (history.equals(this.forwardHistory)) {
            oppositeHistory = this.backHistory;
        } else if (history.equals(this.backHistory)) {
            oppositeHistory = this.forwardHistory;
        } else {
            return;
        }
        NavPosition start = new NavPosition(this.current);
        while (this.current != null && this.current.path == start.path && history.size() != 0) {
            oppositeHistory.push(this.current);
            this.current = history.pop();
        }
        if (this.current.path == start.path) {
            while (this.current != null && !this.current.equals(start)) {
                history.push(this.current);
                this.current = oppositeHistory.pop();
            }
            return;
        }
        NavPosition nextStart = new NavPosition(this.current);
        while (this.current != null && this.current.path.equals(nextStart.path) && !this.current.fileJump.booleanValue() && history.size() != 0) {
            oppositeHistory.push(this.current);
            this.current = history.pop();
        }
        NavPosition end = new NavPosition(this.current);
        while (this.current != null && !this.current.equals(start)) {
            history.push(this.current);
            this.current = oppositeHistory.pop();
        }
        start = this.current;
        if (end != null && end.fileJump.booleanValue()) {
            this.jump(end);
        } else {
            this.jump(nextStart);
        }
    }

    public void jump(NavPosition position) {
        if (position == null) {
            return;
        }
        this.ignoreUpdates = true;
        NavPosition start = new NavPosition(this.current);
        if (this.backHistory.contains(position)) {
            this.forwardHistory.push(this.current);
            while (true) {
                this.current = this.backHistory.pop();
                if (!this.current.equals(position)) {
                    this.forwardHistory.push(this.current);
                    continue;
                }
                break;
            }
        } else if (this.forwardHistory.contains(position)) {
            this.backHistory.push(this.current);
            while (true) {
                this.current = this.forwardHistory.pop();
                if (!this.current.equals(position)) {
                    this.backHistory.push(this.current);
                    continue;
                }
                break;
            }
        } else {
            this.backHistory.push(this.current);
            this.current = position;
        }
        if (this.setPosition(this.current)) {
            this.setButtonState();
            this.notifyChangeListeners();
        }
        this.ignoreUpdates = false;
        this.setFileJump(start);
    }

    private void setFileJump(NavPosition pos) {
        if (this.current != null && pos != null && !pos.path.equals(this.current.path)) {
            for (NavPosition np : this.backHistory) {
                if (pos.path.equals(np.path)) {
                    np.fileJump = false;
                }
                if (!pos.equals(np)) continue;
                np.fileJump = true;
            }
            for (NavPosition np : this.forwardHistory) {
                if (pos.path.equals(np.path)) {
                    np.fileJump = false;
                }
                if (!pos.equals(np)) continue;
                np.fileJump = true;
            }
        }
    }

    public void pushPosition() {
        NavPosition now = this.currentPosition();
        this.addToHistory(now);
        this.userStack.push(now);
    }

    public void popPosition() {
        if (this.userStack.isEmpty()) {
            return;
        }
        this.addToHistory(this.currentPosition());
        this.setPosition(this.userStack.pop());
    }

    public void swapCaretAndTop() {
        if (this.userStack.isEmpty()) {
            return;
        }
        NavPosition old = this.currentPosition();
        NavPosition current = this.userStack.pop();
        this.userStack.push(old);
        this.addToHistory(old);
        this.setPosition(current);
    }

    public void gotoTopPosition() {
        if (this.userStack.isEmpty()) {
            return;
        }
        NavPosition top = (NavPosition)this.userStack.lastElement();
        this.addToHistory(this.currentPosition());
        this.setPosition(top);
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new HashSet<ChangeListener>();
        }
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(listener);
        }
    }

    private void notifyChangeListeners() {
        if (this.changeListeners == null) {
            return;
        }
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(event);
        }
    }

    public void addListDataListener(ListDataListener listener) {
        this.backHistory.addListDataListener(listener);
        this.forwardHistory.addListDataListener(listener);
    }

    public void contentInserted(Buffer buffer, int startLine, int offset, int numLines, int length) {
        NavPosition pos;
        int i;
        if (buffer == null) {
            return;
        }
        String bufferPath = buffer.getPath();
        if (bufferPath == null) {
            return;
        }
        if (numLines == 0 || length == 0) {
            return;
        }
        for (i = this.backHistory.size() - 1; i >= 0; --i) {
            pos = this.backHistory.getElementAt(i);
            if (!bufferPath.equals(pos.path) || pos.caret <= offset) continue;
            pos.lineno += numLines;
            pos.caret += length;
        }
        for (i = this.forwardHistory.size() - 1; i >= 0; --i) {
            pos = this.forwardHistory.getElementAt(i);
            if (!bufferPath.equals(pos.path) || pos.caret <= offset) continue;
            pos.lineno += numLines;
            pos.caret += length;
        }
        if (this.current != null && bufferPath.equals(this.current.path) && this.current.caret > offset) {
            this.current.lineno += numLines;
            this.current.caret += length;
        }
        this.notifyChangeListeners();
    }

    public void contentRemoved(Buffer buffer, int startLine, int offset, int numLines, int length) {
        NavPosition pos;
        int i;
        if (buffer == null) {
            return;
        }
        String bufferPath = buffer.getPath();
        if (bufferPath == null) {
            return;
        }
        int endOffset = offset + length;
        for (i = this.backHistory.size() - 1; i >= 0; --i) {
            pos = this.backHistory.getElementAt(i);
            if (!bufferPath.equals(pos.path)) continue;
            if (pos.caret >= offset && pos.caret < endOffset) {
                this.backHistory.removeElementAt(i);
                continue;
            }
            if (pos.caret < endOffset) continue;
            pos.lineno -= numLines;
            pos.caret -= length;
        }
        for (i = this.forwardHistory.size() - 1; i >= 0; --i) {
            pos = this.forwardHistory.getElementAt(i);
            if (!bufferPath.equals(pos.path)) continue;
            if (pos.caret >= offset && pos.caret < endOffset) {
                this.forwardHistory.removeElementAt(i);
                continue;
            }
            if (pos.caret < endOffset) continue;
            pos.lineno -= numLines;
            pos.caret -= length;
        }
        if (this.current != null && bufferPath.equals(this.current.path)) {
            if (this.current.caret >= offset && this.current.caret < endOffset) {
                this.current = this.currentPosition();
            } else if (this.current.caret >= endOffset) {
                this.current.lineno -= numLines;
                this.current.caret -= length;
            }
        }
        this.notifyChangeListeners();
    }
}

