/*
 * Decompiled with CFR 0.152.
 */
package common.gui.blame;

import common.gui.blame.BasicBlamePaneUI;
import common.gui.blame.BlameModel;
import common.gui.blame.BlamePaneUI;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferChanging;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class BlamePane
extends JComponent
implements CaretListener,
EBComponent {
    private static final String uiClassID = "BlamePaneUI";
    private Set<ChangeListener> changeListeners = new HashSet<ChangeListener>();
    private BlameModel model = null;

    public BlamePane() {
        this(null);
    }

    public BlamePane(BlameModel model) {
        this.model = model;
        this.updateUI();
        EditBus.addToBus((EBComponent)this);
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((BlamePaneUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicBlamePaneUI());
        }
    }

    public BlamePaneUI getUI() {
        return (BlamePaneUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void caretUpdate(CaretEvent e) {
        if (e.getSource() instanceof JEditTextArea) {
            this.fireStateChanged();
        }
    }

    public void addChangeListener(ChangeListener cl) {
        if (cl != null) {
            this.changeListeners.add(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (cl != null) {
            this.changeListeners.remove(cl);
        }
    }

    public void fireStateChanged() {
        if (this.changeListeners.size() > 0) {
            ChangeEvent event = new ChangeEvent(this);
            for (ChangeListener cl : this.changeListeners) {
                cl.stateChanged(event);
            }
        }
    }

    public void setModel(BlameModel model) {
        this.model = model;
        this.updateUI();
    }

    public BlameModel getModel() {
        return this.model;
    }

    public void install(Buffer buffer) {
        BlameModel model = this.getModel();
        if (model == null) {
            return;
        }
        JEditTextArea textArea = model.getTextArea();
        if (textArea == null) {
            return;
        }
        Object old_blame = buffer.getProperty((Object)"_old_blame_");
        if (old_blame != null) {
            textArea.removeLeftOfScrollBar((Component)((JComponent)old_blame));
            Object old_closer = buffer.getProperty((Object)"_old_closer_");
            textArea.remove((Component)((JComponent)old_closer));
        }
        textArea.addLeftOfScrollBar((Component)this);
        JPanel closer = this.getCloser(textArea.getView());
        textArea.addTopRightComponent((Component)closer);
        textArea.addCaretListener((CaretListener)this);
        buffer.setProperty("_old_blame_", (Object)this);
        buffer.setProperty("_old_closer_", (Object)closer);
        textArea.getView().invalidate();
        textArea.getView().validate();
    }

    public JPanel getCloser(final View view) {
        final JPanel panel = new JPanel(new FlowLayout(2, 16, 0));
        JButton button = new JButton(jEdit.getProperty((String)"common.gui.Close_blame", (String)"Close blame"), GUIUtilities.loadIcon((String)"10x10/actions/close.png"));
        button.setBorder(null);
        panel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Runnable runner = new Runnable(){

                    public void run() {
                        BlamePane.this.getUI().uninstallUI(BlamePane.this);
                        JEditTextArea textarea = view.getEditPane().getTextArea();
                        textarea.removeCaretListener((CaretListener)BlamePane.this);
                        textarea.removeTopComponent((Component)panel);
                        textarea.removeLeftOfScrollBar((Component)BlamePane.this);
                        textarea.getBuffer().unsetProperty("_old_blame_");
                        textarea.getBuffer().unsetProperty("_old_closer_");
                        view.invalidate();
                        view.validate();
                    }
                };
                SwingUtilities.invokeLater(runner);
            }
        });
        return panel;
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof EditPaneUpdate) {
            EditPaneUpdate epu = (EditPaneUpdate)msg;
            if (EditPaneUpdate.BUFFER_CHANGING.equals(epu.getWhat())) {
                Object old_closer;
                JEditTextArea textArea = epu.getEditPane().getTextArea();
                JEditBuffer buffer = textArea.getBuffer();
                if (buffer == null || epu instanceof BufferChanging && buffer.equals(((BufferChanging)epu).getBuffer())) {
                    return;
                }
                Object old_blame = buffer.getProperty((Object)"_old_blame_");
                if (old_blame != null) {
                    textArea.removeLeftOfScrollBar((Component)((JComponent)old_blame));
                }
                if ((old_closer = buffer.getProperty((Object)"_old_closer_")) != null) {
                    textArea.removeTopComponent((Component)((JComponent)old_closer));
                }
                epu.getEditPane().getView().invalidate();
                epu.getEditPane().getView().validate();
            } else if (EditPaneUpdate.BUFFER_CHANGED.equals(epu.getWhat())) {
                JEditTextArea textArea = epu.getEditPane().getTextArea();
                JEditBuffer buffer = textArea.getBuffer();
                Object old_blame = buffer.getProperty((Object)"_old_blame_");
                Object old_closer = buffer.getProperty((Object)"_old_closer_");
                if (old_blame != null && old_closer != null) {
                    textArea.addLeftOfScrollBar((Component)((JComponent)old_blame));
                    textArea.addTopComponent((Component)((JComponent)old_closer));
                    epu.getEditPane().getView().invalidate();
                    epu.getEditPane().getView().validate();
                }
            }
        }
    }
}

