/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.tray;

import java.awt.Frame;
import java.awt.Image;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.gjt.sp.util.GenericGUIUtilities;

public class JTrayIcon
extends TrayIcon {
    private JDialog parent;
    private JPopupMenu menu;
    private MouseListener mouseListener;
    private PopupMenuListener popupMenuListener;

    public JTrayIcon(Image image, String tooltip) {
        super(image, tooltip, null);
    }

    public JPopupMenu getMenu() {
        return this.menu;
    }

    public void setMenu(JPopupMenu menu) {
        if (menu == null) {
            if (this.mouseListener != null) {
                this.removeMouseListener(this.mouseListener);
                this.mouseListener = null;
            }
            if (this.popupMenuListener != null) {
                this.menu.removePopupMenuListener(this.popupMenuListener);
                this.popupMenuListener = null;
            }
            this.parent = null;
        } else {
            this.parent = new JDialog((Frame)null);
            this.parent.setUndecorated(true);
            this.parent.setAlwaysOnTop(true);
            if (this.mouseListener == null) {
                this.mouseListener = new MyMouseListener();
                this.addMouseListener(this.mouseListener);
            }
            this.popupMenuListener = new MyPopupMenuListener();
            menu.addPopupMenuListener(this.popupMenuListener);
        }
        this.menu = menu;
    }

    private class MyPopupMenuListener
    implements PopupMenuListener {
        private MyPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            JTrayIcon.this.parent.setVisible(false);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            JTrayIcon.this.parent.setVisible(false);
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (GenericGUIUtilities.isPopupTrigger(e)) {
                JTrayIcon.this.parent.setLocation(e.getX(), e.getY() - ((JTrayIcon)JTrayIcon.this).menu.getPreferredSize().height);
                JTrayIcon.this.parent.setVisible(true);
                JTrayIcon.this.menu.show(JTrayIcon.this.parent, 0, 0);
            }
        }
    }
}

