/*
 * Decompiled with CFR 0.152.
 */
package isabelle.vscode;

import isabelle.JSON$;
import isabelle.JSON$Format$;
import isabelle.Library$;
import isabelle.Logger;
import isabelle.Output$;
import isabelle.Progress;
import isabelle.UTF8$;
import isabelle.Value$Int$;
import isabelle.package$;
import isabelle.vscode.Channel$;
import isabelle.vscode.Channel$Error_Logger$;
import isabelle.vscode.Protocol$DisplayMessage$;
import isabelle.vscode.Protocol$Message$;
import isabelle.vscode.Protocol$MessageType$;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u0001\u001d\u0011qa\u00115b]:,GN\u0003\u0002\u0004\t\u00051ao]2pI\u0016T\u0011!B\u0001\tSN\f'-\u001a7mK\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\"Aq\u0002\u0001B\u0001B\u0003%\u0001#\u0001\u0002j]B\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\u0003S>T\u0011!F\u0001\u0005U\u00064\u0018-\u0003\u0002\u0018%\tY\u0011J\u001c9viN#(/Z1n\u0011!I\u0002A!A!\u0002\u0013Q\u0012aA8viB\u0011\u0011cG\u0005\u00039I\u0011AbT;uaV$8\u000b\u001e:fC6D\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\u0004Y><\u0007C\u0001\u0011\"\u001b\u0005!\u0011B\u0001\u0012\u0005\u0005\u0019aunZ4fe\"AA\u0005\u0001B\u0001B\u0003%Q%A\u0004wKJ\u0014wn]3\u0011\u0005%1\u0013BA\u0014\u000b\u0005\u001d\u0011un\u001c7fC:DQ!\u000b\u0001\u0005\u0002)\na\u0001P5oSRtD#B\u0016.]=\u0002\u0004C\u0001\u0017\u0001\u001b\u0005\u0011\u0001\"B\b)\u0001\u0004\u0001\u0002\"B\r)\u0001\u0004Q\u0002b\u0002\u0010)!\u0003\u0005\ra\b\u0005\bI!\u0002\n\u00111\u0001&\u0011\u001d\u0011\u0004A1A\u0005\nM\nabQ8oi\u0016tGo\u0018'f]\u001e$\b.F\u00015!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\tI$\"\u0001\u0003vi&d\u0017BA\u001e7\u0005\u0015\u0011VmZ3y\u0011\u0019i\u0004\u0001)A\u0005i\u0005y1i\u001c8uK:$x\fT3oORD\u0007\u0005C\u0003@\u0001\u0011%\u0001)A\u0005sK\u0006$w\f\\5oKR\t\u0011\t\u0005\u0002C\u0013:\u00111i\u0012\t\u0003\t*i\u0011!\u0012\u0006\u0003\r\u001a\ta\u0001\u0010:p_Rt\u0014B\u0001%\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011!j\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!S\u0001\"B'\u0001\t\u0013q\u0015a\u0003:fC\u0012|\u0006.Z1eKJ$\u0012a\u0014\t\u0004!V\u000beBA)T\u001d\t!%+C\u0001\f\u0013\t!&\"A\u0004qC\u000e\\\u0017mZ3\n\u0005Y;&\u0001\u0002'jgRT!\u0001\u0016\u0006\t\u000be\u0003A\u0011\u0002.\u0002\u0019I,\u0017\rZ0d_:$XM\u001c;\u0015\u0005\u0005[\u0006\"\u0002/Y\u0001\u0004i\u0016!\u00018\u0011\u0005%q\u0016BA0\u000b\u0005\rIe\u000e\u001e\u0005\u0006C\u0002!\tAY\u0001\u0005e\u0016\fG\rF\u0001d!\rIAMZ\u0005\u0003K*\u0011aa\u00149uS>t\u0007CA4k\u001d\t\u0001\u0003.\u0003\u0002j\t\u0005!!jU(O\u0013\tYGNA\u0001U\u0015\tIG\u0001C\u0003o\u0001\u0011\u0005q.A\u0003xe&$X\r\u0006\u0002qgB\u0011\u0011\"]\u0005\u0003e*\u0011A!\u00168ji\")A/\u001ca\u0001M\u0006!!n]8o\u0011\u00151\b\u0001\"\u0001x\u0003=!\u0017n\u001d9mCf|V.Z:tC\u001e,G\u0003\u00029yurDQ!_;A\u0002u\u000bA\"\\3tg\u0006<Wm\u0018;za\u0016DQa_;A\u0002\u0005\u000b1!\\:h\u0011\u001diX\u000f%AA\u0002\u0015\nAa\u001d5po\"1q\u0010\u0001C\u0001\u0003\u0003\tQ\"\u001a:s_J|V.Z:tC\u001e,Gc\u00019\u0002\u0004!)1P a\u0001\u0003\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0011aB<be:Lgn\u001a\u000b\u0004a\u0006-\u0001BB>\u0002\u0006\u0001\u0007\u0011\tC\u0004\u0002\u0010\u0001!\t!!\u0005\u0002\u000f]\u0014\u0018\u000e^3m]R\u0019\u0001/a\u0005\t\rm\fi\u00011\u0001B\u0011\u001d\t9\u0002\u0001C\u0001\u00033\t\u0011\u0003\\8h?\u0016\u0014(o\u001c:`[\u0016\u001c8/Y4f)\r\u0001\u00181\u0004\u0005\u0007w\u0006U\u0001\u0019A!\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"\u0005YAn\\4`o\u0006\u0014h.\u001b8h)\r\u0001\u00181\u0005\u0005\u0007w\u0006u\u0001\u0019A!\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*\u0005YAn\\4`oJLG/\u001a7o)\r\u0001\u00181\u0006\u0005\u0007w\u0006\u0015\u0002\u0019A!\b\u000f\u0005=\u0002\u0001#\u0001\u00022\u0005aQI\u001d:pe~cunZ4feB!\u00111GA\u001b\u001b\u0005\u0001aaBA\u001c\u0001!\u0005\u0011\u0011\b\u0002\r\u000bJ\u0014xN]0M_\u001e<WM]\n\u0005\u0003kAq\u0004C\u0004*\u0003k!\t!!\u0010\u0015\u0005\u0005E\u0002\u0002CA!\u0003k!\t!a\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007A\f)\u0005\u0003\u0005|\u0003\u007f!\t\u0019AA$!\u0011I\u0011\u0011J!\n\u0007\u0005-#B\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\ty\u0005\u0001C\u0001\u0003#\nQ\"\\1lK~\u0003(o\\4sKN\u001cH\u0003BA*\u00033\u00022\u0001IA+\u0013\r\t9\u0006\u0002\u0002\t!J|wM]3tg\"AA%!\u0014\u0011\u0002\u0003\u0007Q\u0005C\u0005\u0002^\u0001\t\n\u0011\"\u0001\u0002`\u0005IB-[:qY\u0006Lx,\\3tg\u0006<W\r\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tGK\u0002&\u0003GZ#!!\u001a\u0011\t\u0005\u001d\u0014\u0011O\u0007\u0003\u0003SRA!a\u001b\u0002n\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003_R\u0011AC1o]>$\u0018\r^5p]&!\u00111OA5\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003o\u0002\u0011\u0013!C\u0001\u0003?\nq#\\1lK~\u0003(o\\4sKN\u001cH\u0005Z3gCVdG\u000fJ\u0019\b\u0013\u0005m$!!A\t\u0002\u0005u\u0014aB\"iC:tW\r\u001c\t\u0004Y\u0005}d\u0001C\u0001\u0003\u0003\u0003E\t!!!\u0014\u0007\u0005}\u0004\u0002C\u0004*\u0003\u007f\"\t!!\"\u0015\u0005\u0005u\u0004BCAE\u0003\u007f\n\n\u0011\"\u0001\u0002\f\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!!$+\u0007}\t\u0019\u0007\u0003\u0006\u0002\u0012\u0006}\u0014\u0013!C\u0001\u0003?\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004")
public class Channel {
    private volatile Channel$Error_Logger$ Error_Logger$module;
    private final InputStream in;
    private final OutputStream out;
    private final Logger log;
    private final boolean verbose;
    private final Regex Content_Length;

    public static boolean $lessinit$greater$default$4() {
        return Channel$.MODULE$.$lessinit$greater$default$4();
    }

    public static Logger $lessinit$greater$default$3() {
        return Channel$.MODULE$.$lessinit$greater$default$3();
    }

    public Channel$Error_Logger$ Error_Logger() {
        if (this.Error_Logger$module == null) {
            this.Error_Logger$lzycompute$1();
        }
        return this.Error_Logger$module;
    }

    private Regex Content_Length() {
        return this.Content_Length;
    }

    private String read_line() {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(100);
        int c = 0;
        while ((c = this.in.read()) != -1 && c != 10) {
            buffer.write(c);
        }
        return Library$.MODULE$.trim_line(buffer.toString(UTF8$.MODULE$.charset_name()));
    }

    private List<String> read_header() {
        ListBuffer header = new ListBuffer();
        String line = "";
        while (true) {
            String string = line = this.read_line();
            String string2 = "";
            if (!(string == null ? string2 != null : !string.equals(string2))) break;
            header.$plus$eq((Object)line);
        }
        return header.toList();
    }

    private String read_content(int n) {
        byte[] buffer = new byte[n];
        int i = 0;
        int m = 0;
        do {
            if ((m = this.in.read(buffer, i, n - i)) == -1) continue;
            i += m;
        } while (m != -1 && n > i);
        return i == n ? new String(buffer, UTF8$.MODULE$.charset()) : (String)package$.MODULE$.error().apply((Object)("Bad message content (unexpected EOF after " + i + " of " + n + " bytes)"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Object> read() {
        List<String> list = this.read_header();
        if (Nil$.MODULE$.equals(list)) {
            return None$.MODULE$;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String string = (String)colon2.head();
            Option option = this.Content_Length().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                Option option2;
                int n;
                String s = (String)((LinearSeqOptimized)option.get()).apply(0);
                String string2 = s;
                Option<Object> option3 = Value$Int$.MODULE$.unapply(string2);
                if (!option3.isEmpty() && (n = BoxesRunTime.unboxToInt((Object)option3.get())) >= 0) {
                    String msg = this.read_content(n);
                    Object json = JSON$.MODULE$.parse(msg);
                    Protocol$Message$.MODULE$.log("IN: " + n, json, this.log, this.verbose);
                    option2 = new Some(json);
                    return option2;
                } else {
                    option2 = (Option)package$.MODULE$.error().apply((Object)("Bad Content-Length: " + s));
                }
                return option2;
            }
        }
        String string = "Malformed header:";
        return (Option)package$.MODULE$.error().apply(package$.MODULE$.cat_lines().apply((Object)list.$colon$colon((Object)string)));
    }

    public void write(Object json) {
        String msg = JSON$Format$.MODULE$.apply(json);
        byte[] content = UTF8$.MODULE$.bytes(msg);
        int n = content.length;
        byte[] header = UTF8$.MODULE$.bytes("Content-Length: " + n + "\r\n\r\n");
        Protocol$Message$.MODULE$.log("OUT: " + n, json, this.log, this.verbose);
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            this.out.write(header);
            this.out.write(content);
            this.out.flush();
        }
    }

    public void display_message(int message_type, String msg, boolean show) {
        this.write(Protocol$DisplayMessage$.MODULE$.apply(message_type, Output$.MODULE$.clean_yxml(msg), show));
    }

    public boolean display_message$default$3() {
        return true;
    }

    public void error_message(String msg) {
        this.display_message(Protocol$MessageType$.MODULE$.Error(), msg, true);
    }

    public void warning(String msg) {
        this.display_message(Protocol$MessageType$.MODULE$.Warning(), msg, true);
    }

    public void writeln(String msg) {
        this.display_message(Protocol$MessageType$.MODULE$.Info(), msg, true);
    }

    public void log_error_message(String msg) {
        this.display_message(Protocol$MessageType$.MODULE$.Error(), msg, false);
    }

    public void log_warning(String msg) {
        this.display_message(Protocol$MessageType$.MODULE$.Warning(), msg, false);
    }

    public void log_writeln(String msg) {
        this.display_message(Protocol$MessageType$.MODULE$.Info(), msg, false);
    }

    public Progress make_progress(boolean verbose) {
        return new Progress(this, verbose){
            private final /* synthetic */ Channel $outer;
            private final boolean verbose$1;

            public void echo(String msg) {
                this.$outer.log_writeln(msg);
            }

            public void echo_warning(String msg) {
                this.$outer.log_warning(msg);
            }

            public void echo_error_message(String msg) {
                this.$outer.log_error_message(msg);
            }

            public void theory(String session, String theory) {
                block0: {
                    if (!this.verbose$1) break block0;
                    this.echo(session + ": theory " + theory);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.verbose$1 = verbose$1;
            }
        };
    }

    public boolean make_progress$default$1() {
        return false;
    }

    private final void Error_Logger$lzycompute$1() {
        Channel channel = this;
        synchronized (channel) {
            if (this.Error_Logger$module == null) {
                this.Error_Logger$module = new Channel$Error_Logger$(this);
            }
        }
    }

    public Channel(InputStream in, OutputStream out, Logger log, boolean verbose) {
        this.in = in;
        this.out = out;
        this.log = log;
        this.verbose = verbose;
        this.Content_Length = new StringOps(Predef$.MODULE$.augmentString("^\\s*Content-Length:\\s*(\\d+)\\s*$")).r();
    }
}

