/*
 * Decompiled with CFR 0.152.
 */
package code2html.impl.latex;

import code2html.generic.GenericDocument;
import code2html.generic.GenericGutter;
import code2html.generic.Style;
import code2html.impl.latex.LatexStyle;
import java.io.IOException;
import java.io.Writer;
import org.gjt.sp.jedit.syntax.SyntaxStyle;

public class LatexDocument
extends GenericDocument {
    public LatexDocument(String viewBgColor, String viewFgColor, SyntaxStyle[] syntaxStyles, Style style, GenericGutter gutter, String title, String lineSeparator) {
        super(viewBgColor, viewFgColor, syntaxStyles, style, gutter, title, lineSeparator);
    }

    public void openBeforeStyle(Writer out) throws IOException {
        out.write("\\documentclass{article}      " + this.lineSeparator);
        out.write("\\usepackage{color}           " + this.lineSeparator);
        out.write("\\usepackage{alltt}           " + this.lineSeparator);
        out.write("\\usepackage[latin1]{inputenc}" + this.lineSeparator);
        out.write("\\usepackage{hyperref}" + this.lineSeparator);
        out.write("\\title{" + this.title + "}" + this.lineSeparator);
    }

    public void openAfterStyle(Writer out) throws IOException {
        out.write("\\begin{document}" + this.lineSeparator);
        out.write("\\pagecolor{bgcolor}" + this.lineSeparator);
    }

    public void beforeContent(Writer out) throws IOException {
        out.write("\\noindent" + this.lineSeparator);
        out.write("\\ttfamily" + this.lineSeparator);
        out.write("\\syntax" + LatexStyle.getCleanStyle(0) + "{}");
    }

    public void afterContent(Writer out) throws IOException {
        out.write("\\mbox{}" + this.lineSeparator);
        out.write("\\normalfont" + this.lineSeparator);
    }

    public void close(Writer out) throws IOException {
        out.write("\\end{document}" + this.lineSeparator);
    }

    public void openStyle(Writer out) throws IOException {
        super.openStyle(out);
        out.write("\\definecolor{bgcolor}{rgb}{");
        out.write((double)this.bgColor.getRed() / 255.0 + ",");
        out.write((double)this.bgColor.getGreen() / 255.0 + ",");
        out.write((double)this.bgColor.getBlue() / 255.0 + "}" + this.lineSeparator);
        out.write("\\newsavebox{\\opencurlybracket}%" + this.lineSeparator);
        out.write("\\newsavebox{\\closecurlybracket}%" + this.lineSeparator);
        out.write("\\newsavebox{\\lessthan}%" + this.lineSeparator);
        out.write("\\newsavebox{\\greaterthan}%" + this.lineSeparator);
        out.write("\\newsavebox{\\dollarbox}%" + this.lineSeparator);
        out.write("\\newsavebox{\\underscorebox}%" + this.lineSeparator);
        out.write("\\newsavebox{\\andbox}%" + this.lineSeparator);
        out.write("\\newsavebox{\\hashbox}%" + this.lineSeparator);
        out.write("\\newsavebox{\\backslashbox}%" + this.lineSeparator);
        out.write("\\newsavebox{\\atbox}%" + this.lineSeparator);
        out.write("\\newsavebox{\\percentbox}%" + this.lineSeparator);
        out.write("\\newsavebox{\\hatbox}%" + this.lineSeparator);
        out.write("\\setbox\\opencurlybracket=\\hbox{\\verb.{.}%" + this.lineSeparator);
        out.write("\\setbox\\closecurlybracket=\\hbox{\\verb.}.}%" + this.lineSeparator);
        out.write("\\setbox\\lessthan=\\hbox{\\verb.<.}%" + this.lineSeparator);
        out.write("\\setbox\\dollarbox=\\hbox{\\verb.$.}%" + this.lineSeparator);
        out.write("\\setbox\\underscorebox=\\hbox{\\verb._.}%" + this.lineSeparator);
        out.write("\\setbox\\andbox=\\hbox{\\verb.&.}%" + this.lineSeparator);
        out.write("\\setbox\\hashbox=\\hbox{\\verb.#.}%" + this.lineSeparator);
        out.write("\\setbox\\atbox=\\hbox{\\verb.@.}%" + this.lineSeparator);
        out.write("\\setbox\\backslashbox=\\hbox{\\verb.\\.}%" + this.lineSeparator);
        out.write("\\setbox\\greaterthan=\\hbox{\\verb.>.}%" + this.lineSeparator);
        out.write("\\setbox\\percentbox=\\hbox{\\verb.\\%.}%" + this.lineSeparator);
        out.write("\\setbox\\hatbox=\\hbox{\\verb.^.}%" + this.lineSeparator);
        out.write("\\def\\urltilda{\\kern -.15em\\lower .7ex\\hbox{\\~{}}\\kern .04em}" + this.lineSeparator);
    }
}

