/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.font.FontRenderContext;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.List;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class DisplayTokenHandler
extends DefaultTokenHandler {
    private static final int MAX_CHUNK_LEN = 100;
    private SyntaxStyle[] styles;
    private FontRenderContext fontRenderContext;
    private TabExpander expander;
    private List<Chunk> out;
    private float wrapMargin;
    private int physicalLineOffset;

    public void init(SyntaxStyle[] styles, FontRenderContext fontRenderContext, TabExpander expander, List<Chunk> out, float wrapMargin, int physicalLineOffset) {
        super.init();
        this.styles = styles;
        this.fontRenderContext = fontRenderContext;
        this.expander = expander;
        this.out = out;
        this.wrapMargin = wrapMargin;
        this.physicalLineOffset = physicalLineOffset;
    }

    public List<Chunk> getChunkList() {
        return this.out;
    }

    @Override
    public void handleToken(Segment seg, byte id, int offset, int length, TokenMarker.LineContext context) {
        int splitLength;
        if (id == 127) {
            this.makeScreenLine(seg);
            return;
        }
        if (length <= 100) {
            Chunk chunk = this.createChunk(id, offset, length, context);
            this.addToken(chunk, context);
            return;
        }
        BreakIterator charBreaker = BreakIterator.getCharacterInstance();
        charBreaker.setText(seg);
        int tokenBeinIndex = seg.offset + offset;
        int tokenEndIndex = tokenBeinIndex + length;
        int splitOffset = 0;
        do {
            int beginIndex = tokenBeinIndex + splitOffset;
            int charBreakIndex = charBreaker.preceding(beginIndex + 100 + 1);
            assert (charBreakIndex != -1);
            if (charBreakIndex <= beginIndex) {
                charBreakIndex = charBreaker.following(beginIndex + 100);
                assert (charBreakIndex != -1);
                if (charBreakIndex >= tokenEndIndex) break;
            }
            splitLength = charBreakIndex - beginIndex;
            Chunk chunk = this.createChunk(id, offset + splitOffset, splitLength, context);
            this.addToken(chunk, context);
        } while ((splitOffset += splitLength) + 100 < length);
        Chunk chunk = this.createChunk(id, offset + splitOffset, length - splitOffset, context);
        this.addToken(chunk, context);
    }

    private Chunk createChunk(byte id, int offset, int length, TokenMarker.LineContext context) {
        return new Chunk(id, offset, length, this.getParserRuleSet(context), this.styles, context.rules.getDefault());
    }

    private void initChunk(Chunk chunk, float x, Segment lineText) {
        chunk.init(lineText, this.expander, x, this.fontRenderContext, this.physicalLineOffset);
    }

    private float initChunks(Chunk lineHead, Segment lineText) {
        float x = 0.0f;
        Chunk chunk = lineHead;
        while (chunk != null) {
            this.initChunk(chunk, x, lineText);
            x += chunk.width;
            chunk = (Chunk)chunk.next;
        }
        return x;
    }

    private void mergeAdjucentChunks(Chunk lineHead, Segment lineText) {
        Chunk chunk = lineHead;
        while (chunk.next != null) {
            Chunk next = (Chunk)chunk.next;
            if (DisplayTokenHandler.canMerge(chunk, next, lineText)) {
                chunk.length += next.length;
                chunk.next = next.next;
                continue;
            }
            chunk = next;
        }
    }

    private static boolean canMerge(Chunk c1, Chunk c2, Segment lineText) {
        return c1.style == c2.style && c1.isAccessible() && !c1.isTab(lineText) && c2.isAccessible() && !c2.isTab(lineText) && c1.length + c2.length <= 100;
    }

    private Chunk makeWrappedLine(Chunk lineHead, float virtualIndentWidth, Segment lineText) {
        if (virtualIndentWidth > 0.0f) {
            Chunk virtualIndent = new Chunk(virtualIndentWidth, lineHead.offset, lineHead.rules);
            this.initChunk(virtualIndent, 0.0f, lineText);
            virtualIndent.next = lineHead;
            return virtualIndent;
        }
        return lineHead;
    }

    private boolean recalculateTabWidthInWrapMargin(Chunk lineHead, Segment lineText) {
        float x = 0.0f;
        Chunk chunk = lineHead;
        while (chunk != null) {
            if (chunk.isTab(lineText)) {
                this.initChunk(chunk, x, lineText);
            }
            if ((x += chunk.width) > this.wrapMargin) {
                return false;
            }
            chunk = (Chunk)chunk.next;
        }
        return true;
    }

    private static int endOffsetOfWhitespaces(Segment lineText, int origin) {
        int offset;
        for (offset = origin; offset < lineText.count && Character.isWhitespace(lineText.array[lineText.offset + offset]); ++offset) {
        }
        return offset;
    }

    private void makeScreenLineInWrapMargin(Chunk lineHead, Segment lineText) {
        int endOfWhitespace = DisplayTokenHandler.endOffsetOfWhitespaces(lineText, 0);
        float virtualIndentWidth = Chunk.offsetToX(lineHead, endOfWhitespace);
        LineBreaker lineBreaker = new LineBreaker(lineText, endOfWhitespace);
        if (lineBreaker.currentBreak() == -1) {
            this.out.add(lineHead);
            return;
        }
        do {
            int offsetInMargin = Chunk.xToOffset(lineHead, this.wrapMargin, false);
            assert (offsetInMargin != -1);
            lineBreaker.skipToNearest(DisplayTokenHandler.endOffsetOfWhitespaces(lineText, offsetInMargin));
            int lineBreak = lineBreaker.currentBreak();
            if (lineBreak == -1) {
                this.out.add(lineHead);
                return;
            }
            lineBreaker.advance();
            Chunk linePreEnd = null;
            Chunk lineEnd = lineHead;
            float endX = 0.0f;
            while (lineEnd.offset + lineEnd.length < lineBreak) {
                endX += lineEnd.width;
                linePreEnd = lineEnd;
                lineEnd = (Chunk)lineEnd.next;
            }
            if (lineEnd.offset + lineEnd.length == lineBreak) {
                Token nextHead = lineEnd.next;
                lineEnd.next = null;
                this.out.add(lineHead);
                if (nextHead == null) {
                    return;
                }
                lineHead = (Chunk)nextHead;
                continue;
            }
            Chunk shortened = lineEnd.snippetBeforeLineOffset(lineBreak);
            this.initChunk(shortened, endX, lineText);
            if (linePreEnd != null) {
                linePreEnd.next = shortened;
            } else {
                lineHead = shortened;
            }
            this.out.add(lineHead);
            Chunk remaining = lineEnd.snippetAfter(shortened.length);
            float remainingRoom = this.wrapMargin - virtualIndentWidth;
            float processedWidth = shortened.width;
            while (lineEnd.width - processedWidth > remainingRoom && lineBreaker.currentBreak() != -1 && lineBreaker.currentBreak() < remaining.offset + remaining.length) {
                int offsetInRoom = lineEnd.xToOffset(processedWidth + remainingRoom, false);
                assert (offsetInRoom != -1);
                lineBreaker.skipToNearest(DisplayTokenHandler.endOffsetOfWhitespaces(lineText, offsetInRoom));
                int moreBreak = lineBreaker.currentBreak();
                assert (moreBreak != -1);
                if (moreBreak >= remaining.offset + remaining.length) break;
                lineBreaker.advance();
                Chunk moreShortened = remaining.snippetBeforeLineOffset(moreBreak);
                this.initChunk(moreShortened, virtualIndentWidth, lineText);
                this.out.add(this.makeWrappedLine(moreShortened, virtualIndentWidth, lineText));
                remaining = remaining.snippetAfter(moreShortened.length);
                processedWidth += moreShortened.width;
            }
            this.initChunk(remaining, virtualIndentWidth, lineText);
            remaining.next = lineEnd.next;
            lineHead = remaining;
        } while (!this.recalculateTabWidthInWrapMargin(lineHead = this.makeWrappedLine(lineHead, virtualIndentWidth, lineText), lineText));
        this.out.add(lineHead);
    }

    private void makeScreenLine(Segment lineText) {
        if (this.firstToken == null) {
            assert (this.out.isEmpty());
        } else {
            Chunk lineHead = (Chunk)this.firstToken;
            this.mergeAdjucentChunks(lineHead, lineText);
            float endX = this.initChunks(lineHead, lineText);
            if (this.wrapMargin > 0.0f && endX > this.wrapMargin) {
                this.makeScreenLineInWrapMargin(lineHead, lineText);
            } else {
                this.out.add(lineHead);
            }
        }
    }

    private static class LineBreakIterator
    extends BreakIterator {
        private final BreakIterator base;

        public LineBreakIterator() {
            this.base = BreakIterator.getLineInstance();
        }

        private LineBreakIterator(LineBreakIterator other) {
            this.base = (BreakIterator)other.base.clone();
        }

        @Override
        public Object clone() {
            return new LineBreakIterator(this);
        }

        @Override
        public int current() {
            int baseBreak = this.base.current();
            if (this.isAcceptableBreak(baseBreak)) {
                return baseBreak;
            }
            return this.base.next() == -1 ? this.last() : this.first();
        }

        @Override
        public int first() {
            return this.baseOrNext(this.base.first());
        }

        @Override
        public int following(int offset) {
            return this.baseOrNext(this.base.following(offset));
        }

        @Override
        public CharacterIterator getText() {
            return this.base.getText();
        }

        @Override
        public int last() {
            return this.baseOrPrevious(this.base.last());
        }

        @Override
        public int next() {
            return this.baseOrNext(this.base.next());
        }

        @Override
        public int next(int n) {
            while (n > 1) {
                if (this.next() == -1) {
                    return -1;
                }
                --n;
            }
            return this.next();
        }

        @Override
        public int previous() {
            return this.baseOrPrevious(this.base.previous());
        }

        @Override
        public void setText(CharacterIterator newText) {
            this.base.setText(newText);
            this.baseOrNext(this.base.first());
        }

        private int baseOrNext(int baseBreak) {
            while (!this.isAcceptableBreak(baseBreak)) {
                baseBreak = this.base.next();
            }
            return baseBreak;
        }

        private int baseOrPrevious(int baseBreak) {
            while (!this.isAcceptableBreak(baseBreak)) {
                baseBreak = this.base.previous();
            }
            return baseBreak;
        }

        private boolean isAcceptableBreak(int baseBreak) {
            if (baseBreak == -1) {
                return true;
            }
            CharacterIterator text = this.getText();
            if (baseBreak <= text.getBeginIndex() || baseBreak > text.getEndIndex()) {
                return true;
            }
            int originalIndex = text.getIndex();
            char next = text.setIndex(baseBreak);
            char prev = text.previous();
            text.setIndex(originalIndex);
            return !Character.isWhitespace(next) && (Character.isWhitespace(prev) || prev > '\u007f' || next > '\u007f') && (prev != '\u2019' || !Character.isLowerCase(next) && !Character.isUpperCase(next)) && !LineBreakIterator.isUnacceptableBreakInsideQuote(baseBreak, text, prev, next);
        }

        private static char charAt(CharacterIterator text, int index) {
            int originalIndex = text.getIndex();
            char c = text.setIndex(index);
            text.setIndex(originalIndex);
            return c;
        }

        private static boolean isUnacceptableBreakInsideQuote(int baseBreak, CharacterIterator text, char prev, char next) {
            if ("\u201d\u2019\u00bb\u203a".indexOf(prev) >= 0 && !Character.isWhitespace(next)) {
                int beginIndex = text.getBeginIndex();
                for (int beforeQuote = baseBreak - 2; beforeQuote >= beginIndex; --beforeQuote) {
                    char c = LineBreakIterator.charAt(text, beforeQuote);
                    if (Character.isWhitespace(c)) {
                        return true;
                    }
                    if (!Character.isLetterOrDigit(c)) continue;
                    return false;
                }
                return true;
            }
            if (!Character.isWhitespace(prev) && "\u201c\u201e\u2018\u201a\u00ab\u2039".indexOf(next) >= 0) {
                int endIndex = text.getEndIndex();
                for (int afterQuote = baseBreak + 1; afterQuote < endIndex; ++afterQuote) {
                    char c = LineBreakIterator.charAt(text, afterQuote);
                    if (Character.isWhitespace(c)) {
                        return true;
                    }
                    if (!Character.isLetterOrDigit(c)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static class LineBreaker {
        public static final int DONE = -1;
        private final BreakIterator iterator = new LineBreakIterator();
        private final int offsetOrigin;
        private int current;
        private int next;

        public LineBreaker(Segment lineText, int startOffset) {
            this.iterator.setText(lineText);
            this.offsetOrigin = lineText.offset;
            this.current = startOffset < lineText.count ? this.iterator.following(this.offsetOrigin + startOffset) : -1;
            this.next = this.current != -1 ? this.iterator.next() : -1;
        }

        public int currentBreak() {
            return this.outerOffset(this.current);
        }

        public void advance() {
            this.current = this.next;
            this.next = this.iterator.next();
        }

        public void skipToNearest(int offset) {
            while (this.next != -1 && this.next - this.offsetOrigin <= offset) {
                this.advance();
            }
        }

        private int outerOffset(int iteratorOffset) {
            return iteratorOffset != -1 ? iteratorOffset - this.offsetOrigin : -1;
        }
    }
}

