/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.bufferset.BufferSetManager;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;

public class BufferSetWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        BufferSetWidget bufferSetWidget = new BufferSetWidget();
        return bufferSetWidget;
    }

    private static class BufferSetWidget
    implements Widget,
    EBComponent {
        private final JLabel bufferSetLabel = new ToolTipLabel(){

            @Override
            public void addNotify() {
                super.addNotify();
                this.update();
                EditBus.addToBus(this);
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                EditBus.removeFromBus(this);
            }
        };
        private BufferSet.Scope currentScope;

        BufferSetWidget() {
            this.update();
            this.bufferSetLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (evt.getClickCount() == 2) {
                        BufferSetManager bufferSetManager = jEdit.getBufferSetManager();
                        BufferSet.Scope scope = bufferSetManager.getScope();
                        switch (scope) {
                            case global: {
                                scope = BufferSet.Scope.view;
                                break;
                            }
                            case view: {
                                scope = BufferSet.Scope.editpane;
                                break;
                            }
                            case editpane: {
                                scope = BufferSet.Scope.global;
                            }
                        }
                        bufferSetManager.setScope(scope);
                    }
                }
            });
        }

        @Override
        public JComponent getComponent() {
            return this.bufferSetLabel;
        }

        @Override
        public void update() {
            BufferSet.Scope scope = jEdit.getBufferSetManager().getScope();
            if (this.currentScope == null || !this.currentScope.equals((Object)scope)) {
                this.bufferSetLabel.setText(scope.toString().substring(0, 1).toUpperCase());
                this.bufferSetLabel.setToolTipText(jEdit.getProperty("view.status.bufferset-tooltip", new Object[]{scope}));
                this.currentScope = scope;
            }
        }

        @Override
        public void propertiesChanged() {
            Font font = new JLabel().getFont();
            FontMetrics fm = this.bufferSetLabel.getFontMetrics(font);
            Dimension dim = new Dimension(Math.max(fm.charWidth('E'), Math.max(fm.charWidth('V'), fm.charWidth('G'))), fm.getHeight());
            this.bufferSetLabel.setPreferredSize(dim);
            this.bufferSetLabel.setMaximumSize(dim);
        }

        @Override
        public void handleMessage(EBMessage message) {
            PropertiesChanged propertiesChanged;
            if (message instanceof PropertiesChanged && (propertiesChanged = (PropertiesChanged)message).getSource() instanceof BufferSetManager) {
                this.update();
            }
        }
    }
}

