/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskListener;
import org.gjt.sp.util.TaskManager;

public class StatusBar
extends JPanel {
    private String currentBar;
    private final TaskHandler taskHandler;
    private final View view;
    private final JPanel panel;
    private final Box box;
    private final ToolTipLabel caretStatus;
    private Component messageComp;
    private final JLabel message;
    private final Widget modeWidget;
    private final Widget foldWidget;
    private final Widget encodingWidget;
    private final Widget wrapWidget;
    private final Widget indentWidget;
    private final Widget multiSelectWidget;
    private final Widget rectSelectWidget;
    private final Widget overwriteWidget;
    private final Widget lineSepWidget;
    StringBuilder buf = new StringBuilder();
    private Timer tempTimer;
    private boolean currentMessageIsIO;
    private final Segment seg = new Segment();
    private boolean showCaretStatus;
    static final String caretTestStr = "9999,999-999 (99999999/99999999)";

    public StatusBar(View view) {
        super(new BorderLayout());
        this.setName("StatusBar");
        this.setBorder(new CompoundBorder(new EmptyBorder(4, 0, 0, OperatingSystem.isMacOS() ? 18 : 0), UIManager.getBorder("TextField.border")));
        this.view = view;
        this.panel = new JPanel(new BorderLayout());
        this.box = new Box(0);
        this.panel.add("East", this.box);
        this.add("Center", this.panel);
        MouseHandler mouseHandler = new MouseHandler();
        this.caretStatus = new ToolTipLabel();
        this.caretStatus.setName("caretStatus");
        this.caretStatus.setToolTipText(jEdit.getProperty("view.status.caret-tooltip"));
        this.caretStatus.addMouseListener(mouseHandler);
        this.message = new JLabel(" ");
        this.setMessageComponent(this.message);
        this.modeWidget = this._getWidget("mode");
        this.foldWidget = this._getWidget("fold");
        this.encodingWidget = this._getWidget("encoding");
        this.wrapWidget = this._getWidget("wrap");
        this.indentWidget = this._getWidget("indent");
        this.multiSelectWidget = this._getWidget("multiSelect");
        this.rectSelectWidget = this._getWidget("rectSelect");
        this.overwriteWidget = this._getWidget("overwrite");
        this.lineSepWidget = this._getWidget("lineSep");
        this.taskHandler = new TaskHandler();
    }

    public void propertiesChanged() {
        Color fg = jEdit.getColorProperty("view.status.foreground");
        Color bg = jEdit.getColorProperty("view.status.background");
        this.showCaretStatus = jEdit.getBooleanProperty("view.status.show-caret-status");
        this.panel.setBackground(bg);
        this.panel.setForeground(fg);
        this.caretStatus.setBackground(bg);
        this.caretStatus.setForeground(fg);
        this.message.setBackground(bg);
        this.message.setForeground(fg);
        Font font = new JLabel().getFont();
        FontMetrics fm = this.getFontMetrics(font);
        if (this.showCaretStatus) {
            this.panel.add("West", this.caretStatus);
            this.caretStatus.setFont(font);
            Dimension dim = new Dimension(fm.stringWidth(caretTestStr), fm.getHeight());
            this.caretStatus.setPreferredSize(dim);
            this.updateCaretStatus();
        } else {
            this.panel.remove(this.caretStatus);
        }
        String statusBar = jEdit.getProperty("view.status");
        if (!Objects.equals(this.currentBar, statusBar)) {
            this.box.removeAll();
            StringTokenizer tokenizer = new StringTokenizer(statusBar);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (Character.isLetter(token.charAt(0))) {
                    Widget widget = this.getWidget(token);
                    if (widget == null) {
                        JLabel label = new JLabel(token);
                        label.setBackground(bg);
                        label.setForeground(fg);
                        this.box.add(label);
                        continue;
                    }
                    JComponent c = widget.getComponent();
                    ((Component)c).setBackground(bg);
                    ((Component)c).setForeground(fg);
                    this.box.add(c);
                    widget.update();
                    widget.propertiesChanged();
                    continue;
                }
                JLabel label = new JLabel(token);
                label.setBackground(bg);
                label.setForeground(fg);
                this.box.add(label);
            }
            this.currentBar = statusBar;
        }
        this.updateBufferStatus();
        this.updateMiscStatus();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        TaskManager.instance.addTaskListener(this.taskHandler);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        TaskManager.instance.removeTaskListener(this.taskHandler);
    }

    public String getMessage() {
        return this.message.getText();
    }

    public void setMessageAndClear(String message) {
        this.setMessage(message);
        this.tempTimer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (StatusBar.this.isShowing()) {
                    StatusBar.this.setMessage(null);
                }
            }
        });
        this.tempTimer.setInitialDelay(10000);
        this.tempTimer.setRepeats(false);
        this.tempTimer.start();
    }

    public void setMessage(String message) {
        if (this.tempTimer != null) {
            this.tempTimer.stop();
            this.tempTimer = null;
        }
        this.setMessageComponent(this.message);
        if (message == null) {
            if (this.view.getMacroRecorder() != null) {
                this.message.setText(jEdit.getProperty("view.status.recording"));
            } else {
                this.message.setText(" ");
            }
        } else {
            this.message.setText(message);
        }
    }

    public void setMessageComponent(Component comp) {
        this.currentMessageIsIO = false;
        if (comp == null || this.messageComp == comp) {
            return;
        }
        this.messageComp = comp;
        this.panel.add("Center", this.messageComp);
    }

    public void updateCaretStatus() {
        if (this.showCaretStatus) {
            Buffer buffer = this.view.getBuffer();
            if (!buffer.isLoaded() || buffer != this.view.getTextArea().getBuffer()) {
                this.caretStatus.setText(" ");
                return;
            }
            JEditTextArea textArea = this.view.getTextArea();
            int caretPosition = textArea.getCaretPosition();
            int currLine = textArea.getCaretLine();
            if (currLine >= buffer.getLineCount()) {
                return;
            }
            int start = textArea.getLineStartOffset(currLine);
            int dot = caretPosition - start;
            if (dot < 0) {
                return;
            }
            int bufferLength = buffer.getLength();
            buffer.getText(start, dot, this.seg);
            int virtualPosition = StandardUtilities.getVirtualWidth(this.seg, buffer.getTabSize());
            this.seg.array = null;
            this.seg.count = 0;
            if (jEdit.getBooleanProperty("view.status.show-caret-linenumber", true)) {
                this.buf.append(currLine + 1);
                this.buf.append(',');
            }
            if (jEdit.getBooleanProperty("view.status.show-caret-dot", true)) {
                this.buf.append(dot + 1);
            }
            if (jEdit.getBooleanProperty("view.status.show-caret-virtual", true) && virtualPosition != dot) {
                this.buf.append('-');
                this.buf.append(virtualPosition + 1);
            }
            if (this.buf.length() > 0) {
                this.buf.append(' ');
            }
            if (jEdit.getBooleanProperty("view.status.show-caret-offset", true) && jEdit.getBooleanProperty("view.status.show-caret-bufferlength", true)) {
                this.buf.append('(');
                this.buf.append(caretPosition);
                this.buf.append('/');
                this.buf.append(bufferLength);
                this.buf.append(')');
            } else if (jEdit.getBooleanProperty("view.status.show-caret-offset", true)) {
                this.buf.append('(');
                this.buf.append(caretPosition);
                this.buf.append(')');
            } else if (jEdit.getBooleanProperty("view.status.show-caret-bufferlength", true)) {
                this.buf.append('(');
                this.buf.append(bufferLength);
                this.buf.append(')');
            }
            this.caretStatus.setText(this.buf.toString());
            this.buf.setLength(0);
        }
    }

    public void updateBufferStatus() {
        this.wrapWidget.update();
        this.indentWidget.update();
        this.lineSepWidget.update();
        this.modeWidget.update();
        this.foldWidget.update();
        this.encodingWidget.update();
    }

    public void updateMiscStatus() {
        this.multiSelectWidget.update();
        this.rectSelectWidget.update();
        this.overwriteWidget.update();
    }

    private Widget getWidget(String name) {
        if ("mode".equals(name)) {
            return this.modeWidget;
        }
        if ("fold".equals(name)) {
            return this.foldWidget;
        }
        if ("encoding".equals(name)) {
            return this.encodingWidget;
        }
        if ("wrap".equals(name)) {
            return this.wrapWidget;
        }
        if ("indent".equals(name)) {
            return this.indentWidget;
        }
        if ("multiSelect".equals(name)) {
            return this.multiSelectWidget;
        }
        if ("rectSelect".equals(name)) {
            return this.rectSelectWidget;
        }
        if ("overwrite".equals(name)) {
            return this.overwriteWidget;
        }
        if ("lineSep".equals(name)) {
            return this.lineSepWidget;
        }
        return this._getWidget(name);
    }

    private Widget _getWidget(String name) {
        StatusWidgetFactory widgetFactory = (StatusWidgetFactory)ServiceManager.getService("org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory", name);
        if (widgetFactory == null) {
            return null;
        }
        return widgetFactory.getWidget(this.view);
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            Object source = evt.getSource();
            if (source == StatusBar.this.caretStatus && evt.getClickCount() == 2) {
                StatusBar.this.view.getTextArea().showGoToLineDialog();
            }
        }
    }

    private class TaskHandler
    implements TaskListener {
        private final Runnable statusLineIo = new Runnable(){

            @Override
            public void run() {
                if (!StatusBar.this.currentMessageIsIO && StatusBar.this.message != null && !"".equals(StatusBar.this.message.getText().trim())) {
                    return;
                }
                int requestCount = TaskManager.instance.countIoTasks();
                if (requestCount == 0) {
                    StatusBar.this.setMessageAndClear(jEdit.getProperty("view.status.io.done"));
                    StatusBar.this.currentMessageIsIO = true;
                } else if (requestCount == 1) {
                    StatusBar.this.setMessage(jEdit.getProperty("view.status.io-1"));
                    StatusBar.this.currentMessageIsIO = true;
                } else {
                    Object[] args = new Object[]{requestCount};
                    StatusBar.this.setMessage(jEdit.getProperty("view.status.io", args));
                    StatusBar.this.currentMessageIsIO = true;
                }
            }
        };

        private TaskHandler() {
        }

        @Override
        public void waiting(Task task) {
            SwingUtilities.invokeLater(this.statusLineIo);
        }

        @Override
        public void running(Task task) {
        }

        @Override
        public void done(Task task) {
            SwingUtilities.invokeLater(this.statusLineIo);
        }

        @Override
        public void statusUpdated(Task task) {
        }

        @Override
        public void maximumUpdated(Task task) {
        }

        @Override
        public void valueUpdated(Task task) {
        }
    }
}

