/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorListPlugin;
import errorlist.ErrorSource;
import errorlist.ErrorSourceUpdate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.EnhancedTreeCellRenderer;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;
import org.jedit.core.FileOpenerService;

public class ErrorList
extends JPanel
implements DefaultFocusComponent {
    public static final ImageIcon ERROR_ICON = new ImageIcon(ErrorList.class.getResource("error.png"));
    public static final ImageIcon WARNING_ICON = new ImageIcon(ErrorList.class.getResource("warning.png"));
    public static final Integer[] allTypes = new Integer[]{0, 1};
    private View view;
    private JLabel status;
    private DefaultMutableTreeNode errorRoot;
    private DefaultTreeModel errorModel;
    private JTree errorTree;
    private HashSet<ErrorSource.Error> errors;
    private Vector<Integer> filteredTypes;
    private Map<Integer, JToggleButton> toggleButtons;
    private PopupMenu popupMenu;

    public ErrorList(View view) {
        this.view = view;
        this.setLayout(new BorderLayout());
        this.errors = new HashSet();
        this.filteredTypes = new Vector();
        this.initFilteredTypes();
        Box toolBar = new Box(0);
        this.status = new JLabel();
        toolBar.add(this.status);
        toolBar.add(Box.createHorizontalStrut(30));
        this.toggleButtons = new HashMap<Integer, JToggleButton>();
        JToggleButton toggleBtn = new JToggleButton(ERROR_ICON, true);
        toggleBtn.setSelected(!this.filteredTypes.contains(0));
        toggleBtn.setToolTipText(jEdit.getProperty((String)"error-list-toggle-errors.label"));
        toggleBtn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-toggle-errors"));
        toolBar.add(toggleBtn);
        this.toggleButtons.put(0, toggleBtn);
        toolBar.add(Box.createHorizontalStrut(3));
        toggleBtn = new JToggleButton(WARNING_ICON, true);
        toggleBtn.setSelected(!this.filteredTypes.contains(1));
        toggleBtn.setToolTipText(jEdit.getProperty((String)"error-list-toggle-warnings.label"));
        toggleBtn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-toggle-warnings"));
        toolBar.add(toggleBtn);
        this.toggleButtons.put(1, toggleBtn);
        toolBar.add(Box.createGlue());
        RolloverButton btn = new RolloverButton(GUIUtilities.loadIcon((String)"PreviousFile.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-previous-error-file.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-previous-error-file"));
        toolBar.add((Component)btn);
        btn = new RolloverButton(GUIUtilities.loadIcon((String)"NextFile.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-next-error-file.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-next-error-file"));
        toolBar.add((Component)btn);
        btn = new RolloverButton(GUIUtilities.loadIcon((String)"ArrowL.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-previous-error.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-previous-error"));
        toolBar.add((Component)btn);
        btn = new RolloverButton(GUIUtilities.loadIcon((String)"ArrowR.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-next-error.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-next-error"));
        toolBar.add((Component)btn);
        btn = new RolloverButton(GUIUtilities.loadIcon((String)"Plus.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-expand-all.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-expand-all"));
        toolBar.add((Component)btn);
        btn = new RolloverButton(GUIUtilities.loadIcon((String)"Minus.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-collapse-all.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-collapse-all"));
        toolBar.add((Component)btn);
        toolBar.add(Box.createHorizontalStrut(6));
        btn = new RolloverButton(GUIUtilities.loadIcon((String)"Clear.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-clear.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-clear"));
        toolBar.add((Component)btn);
        toolBar.add(Box.createHorizontalStrut(6));
        this.add("North", toolBar);
        this.errorRoot = new DefaultMutableTreeNode(new Root(), true);
        this.errorModel = new DefaultTreeModel(this.errorRoot, true);
        this.errorTree = new JTree(this.errorModel);
        if (!OperatingSystem.isMacOSLF()) {
            this.errorTree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.errorTree.addMouseListener(new MouseHandler());
        this.errorTree.addKeyListener(new KeyHandler());
        this.errorTree.setCellRenderer((TreeCellRenderer)((Object)new ErrorCellRenderer()));
        this.errorTree.setRootVisible(false);
        this.errorTree.setShowsRootHandles(true);
        ErrorSource[] sources = ErrorSource.getErrorSources();
        for (int i = 0; i < sources.length; ++i) {
            ErrorSource source = sources[i];
            if (sources[i].getView() != null && view != sources[i].getView()) continue;
            this.addErrorSource(source, source.getAllErrors());
        }
        Object[] expandPath = new TreeNode[]{this.errorRoot, null};
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            expandPath[1] = this.errorRoot.getChildAt(i);
            this.errorTree.expandPath(new TreePath(expandPath));
        }
        JScrollPane scroller = new JScrollPane(this.errorTree);
        scroller.setPreferredSize(new Dimension(640, 200));
        this.add("Center", scroller);
        this.updateStatus();
        this.popupMenu = new PopupMenu(new ActionHandler(this));
        this.load();
    }

    public void load() {
        EditBus.addToBus((Object)this);
    }

    public void unload() {
        EditBus.removeFromBus((Object)this);
    }

    public void focusOnDefaultComponent() {
        if (jEdit.getBooleanProperty((String)"error-list.autoRefocusTextArea")) {
            this.view.getTextArea().requestFocus();
        } else {
            this.errorTree.requestFocus();
        }
    }

    public void focus() {
        this.errorTree.requestFocus();
    }

    public void expandAll() {
        this.expandAll(new TreePath(new TreeNode[]{this.errorRoot}));
    }

    public void expandAll(TreePath parent) {
        this.errorTree.expandPath(parent);
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        Enumeration<? extends TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            TreeNode n = e.nextElement();
            TreePath path = parent.pathByAddingChild(n);
            this.expandAll(path);
        }
    }

    public void collapseAll() {
        Object[] collapsePath = new TreeNode[]{this.errorRoot, null};
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            collapsePath[1] = this.errorRoot.getChildAt(i);
            this.errorTree.collapsePath(new TreePath(collapsePath));
        }
    }

    private void initFilteredTypes() {
        for (Integer type : allTypes) {
            if (!jEdit.getBooleanProperty((String)("error-list-filtered-types." + type), (boolean)false)) continue;
            this.filteredTypes.add(type);
        }
    }

    @EditBus.EBHandler
    public void handleViewUpdate(ViewUpdate vu) {
        if (vu.getWhat() == ViewUpdate.CLOSED && vu.getView() == this.view) {
            this.unload();
        }
    }

    public void nextErrorFile() {
        DefaultMutableTreeNode next;
        if (this.errorRoot.getChildCount() == 0) {
            this.getToolkit().beep();
            return;
        }
        TreePath selected = this.errorTree.getSelectionPath();
        if (selected == null) {
            next = (DefaultMutableTreeNode)this.errorRoot.getChildAt(0);
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected.getLastPathComponent();
            if (node.getUserObject() instanceof Extra) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof ErrorSource.Error) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof String) {
                int index = this.errorRoot.getIndex(node);
                if (index == this.errorRoot.getChildCount() - 1) {
                    this.getToolkit().beep();
                    return;
                }
                next = (DefaultMutableTreeNode)this.errorRoot.getChildAt(index + 1);
            } else {
                return;
            }
        }
        TreePath path = new TreePath(new TreeNode[]{this.errorRoot, next});
        this.errorTree.setSelectionPath(path);
        this.errorTree.scrollPathToVisible(path);
        this._openFile((String)next.getUserObject());
    }

    public void prevErrorFile() {
        DefaultMutableTreeNode prev;
        if (this.errorRoot.getChildCount() == 0) {
            this.getToolkit().beep();
            return;
        }
        TreePath selected = this.errorTree.getSelectionPath();
        if (selected == null) {
            prev = (DefaultMutableTreeNode)this.errorRoot.getChildAt(this.errorRoot.getChildCount() - 1);
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected.getLastPathComponent();
            if (node.getUserObject() instanceof Extra) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof ErrorSource.Error) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof String) {
                int index = this.errorRoot.getIndex(node);
                if (index == 0) {
                    this.getToolkit().beep();
                    return;
                }
                prev = (DefaultMutableTreeNode)this.errorRoot.getChildAt(index - 1);
            } else {
                return;
            }
        }
        TreePath path = new TreePath(new TreeNode[]{this.errorRoot, prev});
        this.errorTree.setSelectionPath(path);
        this.errorTree.scrollPathToVisible(path);
        this._openFile((String)prev.getUserObject());
    }

    public void nextError() {
        DefaultMutableTreeNode next;
        DefaultMutableTreeNode parent;
        if (this.errorRoot.getChildCount() == 0) {
            this.getToolkit().beep();
            return;
        }
        TreePath selected = this.errorTree.getSelectionPath();
        if (selected == null) {
            parent = (DefaultMutableTreeNode)this.errorRoot.getChildAt(0);
            next = (DefaultMutableTreeNode)parent.getChildAt(0);
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected.getLastPathComponent();
            if (node.getUserObject() instanceof Extra) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof String) {
                parent = node;
                next = (DefaultMutableTreeNode)node.getChildAt(0);
            } else if (node.getUserObject() instanceof ErrorSource.Error) {
                parent = (DefaultMutableTreeNode)node.getParent();
                int index = parent.getIndex(node);
                if (index == parent.getChildCount() - 1) {
                    index = this.errorRoot.getIndex(parent);
                    if (index == this.errorRoot.getChildCount() - 1) {
                        this.getToolkit().beep();
                        return;
                    }
                    parent = (DefaultMutableTreeNode)this.errorRoot.getChildAt(index + 1);
                    next = (DefaultMutableTreeNode)parent.getChildAt(0);
                } else {
                    next = (DefaultMutableTreeNode)parent.getChildAt(index + 1);
                }
            } else {
                return;
            }
        }
        TreePath path = new TreePath(new TreeNode[]{this.errorRoot, parent, next});
        this.selectPath(path);
        this.openError((ErrorSource.Error)next.getUserObject());
    }

    public void previousError() {
        DefaultMutableTreeNode prev;
        DefaultMutableTreeNode parent;
        if (this.errorRoot.getChildCount() == 0) {
            this.getToolkit().beep();
            return;
        }
        TreePath selected = this.errorTree.getSelectionPath();
        if (selected == null) {
            parent = (DefaultMutableTreeNode)this.errorRoot.getChildAt(this.errorRoot.getChildCount() - 1);
            prev = (DefaultMutableTreeNode)parent.getChildAt(parent.getChildCount() - 1);
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected.getLastPathComponent();
            if (node.getUserObject() instanceof Extra) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof String) {
                int index = this.errorRoot.getIndex(node);
                if (index == 0) {
                    this.getToolkit().beep();
                    return;
                }
                parent = (DefaultMutableTreeNode)this.errorRoot.getChildAt(index - 1);
                prev = (DefaultMutableTreeNode)parent.getChildAt(parent.getChildCount() - 1);
            } else if (node.getUserObject() instanceof ErrorSource.Error) {
                parent = (DefaultMutableTreeNode)node.getParent();
                int index = parent.getIndex(node);
                if (index == 0) {
                    index = this.errorRoot.getIndex(parent);
                    if (index == 0) {
                        this.getToolkit().beep();
                        return;
                    }
                    parent = (DefaultMutableTreeNode)this.errorRoot.getChildAt(index - 1);
                    prev = (DefaultMutableTreeNode)parent.getChildAt(parent.getChildCount() - 1);
                } else {
                    prev = (DefaultMutableTreeNode)parent.getChildAt(index - 1);
                }
            } else {
                return;
            }
        }
        TreePath path = new TreePath(new TreeNode[]{this.errorRoot, parent, prev});
        this.selectPath(path);
        this.openError((ErrorSource.Error)prev.getUserObject());
    }

    public void toggleErrors() {
        this.toggleType(0);
    }

    public void toggleWarnings() {
        this.toggleType(1);
    }

    @EditBus.EBHandler
    public void handleErrorSourceMessage(ErrorSourceUpdate message) {
        Object what = message.getWhat();
        ErrorSource es = message.getErrorSource();
        View v = es.getView();
        if (v != null && v != this.view) {
            return;
        }
        if (what == ErrorSourceUpdate.ERROR_SOURCE_ADDED) {
            this.addErrorSource(message.getErrorSource(), message.getErrors());
            this.updateStatus();
        }
        if (what == ErrorSourceUpdate.ERROR_ADDED) {
            this.addError(message.getError(), false);
            this.updateStatus();
        } else if (what == ErrorSourceUpdate.ERROR_REMOVED) {
            this.removeError(message.getError());
            this.updateStatus();
        } else if (what == ErrorSourceUpdate.ERRORS_CLEARED || what == ErrorSourceUpdate.ERROR_SOURCE_REMOVED) {
            this.removeErrorSource(message.getErrorSource());
            this.updateStatus();
        }
    }

    private void addErrorSource(ErrorSource source, ErrorSource.Error[] errors) {
        if (errors == null || errors.length == 0) {
            return;
        }
        for (int j = 0; j < errors.length; ++j) {
            this.addError(errors[j], true);
        }
        this.errorModel.reload(this.errorRoot);
        Object[] expandPath = new TreeNode[]{this.errorRoot, null};
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            expandPath[1] = this.errorRoot.getChildAt(i);
            this.errorTree.expandPath(new TreePath(expandPath));
        }
    }

    private void updateList() {
        this.errorRoot.removeAllChildren();
        this.errorModel.reload(this.errorRoot);
        for (ErrorSource.Error error : this.errors) {
            if (this.isFiltered(error)) continue;
            this.addErrorToTree(error, false);
        }
        this.updateStatus();
    }

    private void toggleType(int errType) {
        Integer type = errType;
        boolean filtered = this.filteredTypes.contains(type);
        JToggleButton toggleBtn = this.toggleButtons.get(type);
        toggleBtn.setSelected(filtered);
        if (filtered) {
            this.filteredTypes.remove(type);
        } else {
            this.filteredTypes.add(type);
        }
        jEdit.setBooleanProperty((String)("error-list-filtered-types." + type), (boolean)this.filteredTypes.contains(type));
        this.updateList();
    }

    private void updateStatus() {
        int warningCount = 0;
        int errorCount = 0;
        for (ErrorSource.Error error : this.errors) {
            if (error.getErrorType() == 0) {
                ++errorCount;
                continue;
            }
            ++warningCount;
        }
        int shownWarningCount = 0;
        int shownErrorCount = 0;
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.errorRoot.getChildAt(i);
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode errorNode = (DefaultMutableTreeNode)node.getChildAt(j);
                ErrorSource.Error error = (ErrorSource.Error)errorNode.getUserObject();
                if (error.getErrorType() == 0) {
                    ++shownErrorCount;
                    continue;
                }
                ++shownWarningCount;
            }
        }
        StringBuffer errorStr = new StringBuffer(String.valueOf(shownErrorCount));
        if (shownErrorCount != errorCount) {
            errorStr.append("(" + String.valueOf(errorCount) + ")");
        }
        StringBuffer warningStr = new StringBuffer(String.valueOf(shownWarningCount));
        if (shownWarningCount != warningCount) {
            warningStr.append("(" + String.valueOf(warningCount) + ")");
        }
        Object[] args = new StringBuffer[]{errorStr, warningStr};
        this.status.setText(jEdit.getProperty((String)ErrorList.getStatusProperty(errorCount, warningCount), (Object[])args));
    }

    private void removeErrorSource(ErrorSource source) {
        DockableWindowManager dwm;
        Iterator<ErrorSource.Error> it = this.errors.iterator();
        while (it.hasNext()) {
            ErrorSource.Error error = it.next();
            if (error.getErrorSource() != source) continue;
            it.remove();
        }
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.errorRoot.getChildAt(i);
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode errorNode = (DefaultMutableTreeNode)node.getChildAt(j);
                if (((ErrorSource.Error)errorNode.getUserObject()).getErrorSource() != source) continue;
                node.remove(errorNode);
                if (node.getChildCount() == 0) {
                    this.errorRoot.remove(node);
                    --i;
                }
                --j;
            }
        }
        this.errorModel.reload(this.errorRoot);
        Object[] expandPath = new TreeNode[]{this.errorRoot, null};
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            expandPath[1] = this.errorRoot.getChildAt(i);
            this.errorTree.expandPath(new TreePath(expandPath));
        }
        if (this.errorRoot.getChildCount() == 0 && jEdit.getBooleanProperty((String)"error-list.autoCloseOnNoErrors") && (dwm = this.view.getDockableWindowManager()).isDockableWindowDocked("error-list") && dwm.isDockableWindowVisible("error-list")) {
            dwm.toggleDockableWindow("error-list");
        }
    }

    private boolean isFiltered(ErrorSource.Error error) {
        String path;
        boolean match;
        if (this.filteredTypes.contains(error.getErrorType())) {
            return true;
        }
        Pattern filter = ErrorListPlugin.getFilenameFilter();
        return filter != null && (match = filter.matcher(path = error.getFilePath()).matches()) != ErrorListPlugin.isInclusionFilter();
    }

    private void addError(ErrorSource.Error error, boolean init) {
        int c = this.errors.size();
        this.errors.add(error);
        if (this.errors.size() > c && !this.isFiltered(error)) {
            this.addErrorToTree(error, init);
        }
    }

    private void addErrorToTree(ErrorSource.Error error, boolean init) {
        Log.log((int)1, ErrorList.class, (Object)("Adding Error Line#" + (error.getLineNumber() + 1) + " Start#" + (error.getStartOffset() + 1) + " Error Message:" + error.getErrorMessage()));
        String[] extras = error.getExtraMessages();
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(error, extras.length > 0);
        for (int j = 0; j < extras.length; ++j) {
            newNode.add(new DefaultMutableTreeNode(new Extra(extras[j]), false));
        }
        String path = error.getFilePath();
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.errorRoot.getChildAt(i);
            String nodePath = (String)node.getUserObject();
            if (!nodePath.equals(path)) continue;
            node.add(newNode);
            if (!init) {
                this.errorModel.reload(node);
                this.errorTree.expandPath(new TreePath(new TreeNode[]{this.errorRoot, node, newNode}));
            }
            return;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(path, true);
        node.add(newNode);
        this.errorRoot.add(node);
        this.errorModel.reload(this.errorRoot);
        if (!init) {
            Object[] expandPath = new TreeNode[]{this.errorRoot, null};
            for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
                expandPath[1] = this.errorRoot.getChildAt(i);
                this.errorTree.expandPath(new TreePath(expandPath));
            }
        }
    }

    private void removeError(ErrorSource.Error error) {
        this.errors.remove(error);
        this.removeErrorFromTree(error);
    }

    private void removeErrorFromTree(ErrorSource.Error error) {
        DockableWindowManager dwm;
        block0: for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.errorRoot.getChildAt(i);
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode errorNode = (DefaultMutableTreeNode)node.getChildAt(j);
                if (errorNode.getUserObject() != error) continue;
                node.remove(errorNode);
                if (node.getChildCount() != 0) continue block0;
                this.errorRoot.remove(node);
                continue block0;
            }
        }
        this.errorModel.reload(this.errorRoot);
        if (this.errorRoot.getChildCount() == 0 && jEdit.getBooleanProperty((String)"error-list.autoCloseOnNoErrors") && (dwm = this.view.getDockableWindowManager()).isDockableWindowDocked("error-list") && dwm.isDockableWindowVisible("error-list")) {
            dwm.toggleDockableWindow("error-list");
        }
    }

    private void _openFile(String vfsPath) {
        try {
            VFS vfs = VFSManager.getVFSForPath((String)vfsPath);
            VFSFile file = vfs._getFile(null, vfsPath, null);
            if (file == null || file.getLength() == 0L) {
                FileOpenerService.open((String)MiscUtilities.getFileName((String)vfsPath), (View)this.view);
            } else {
                jEdit.openFile((View)this.view, (String)vfsPath);
            }
        }
        catch (IOException ioe) {
            Log.log((int)9, (Object)this, (Object)ioe);
        }
    }

    private void openError(final ErrorSource.Error error) {
        Buffer buffer;
        this._openFile(error.getFilePath());
        Buffer buffer2 = buffer = error.getBuffer() != null ? error.getBuffer() : this.view.getEditPane().getBuffer();
        if (buffer.isNewFile() || !buffer.getName().equals(error.getFileName())) {
            return;
        }
        ThreadUtilities.runInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ErrorList.this.view.goToBuffer(buffer);
                int start = error.getStartOffset();
                int end = error.getEndOffset();
                int lineNo = error.getLineNumber();
                if (lineNo >= 0 && lineNo < buffer.getLineCount()) {
                    start += buffer.getLineStartOffset(lineNo);
                    end = end == 0 ? buffer.getLineEndOffset(lineNo) - 1 : (end += buffer.getLineStartOffset(lineNo));
                }
                ErrorList.this.view.getTextArea().setSelection((Selection)new Selection.Range(start, end));
                ErrorList.this.view.getTextArea().moveCaretPosition(end);
            }
        });
    }

    private void selectPath(TreePath path) {
        this.errorTree.setSelectionPath(path);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node.getChildCount() > 0) {
            this.errorTree.expandPath(path);
            this.errorTree.scrollPathToVisible(path.pathByAddingChild(node.getChildAt(node.getChildCount() - 1)));
        } else {
            this.errorTree.scrollPathToVisible(path);
        }
    }

    private void openNode(DefaultMutableTreeNode node) {
        Object object = node.getUserObject();
        if (!(object instanceof Root)) {
            if (object instanceof String) {
                this._openFile((String)object);
            } else if (object instanceof Extra) {
                this.openNode((DefaultMutableTreeNode)node.getParent());
            } else if (object instanceof ErrorSource.Error) {
                this.openError((ErrorSource.Error)object);
            }
        }
    }

    private void openSelectedNode() {
        TreePath selected = this.errorTree.getSelectionPath();
        if (selected != null) {
            this.openNode((DefaultMutableTreeNode)selected.getLastPathComponent());
        }
    }

    private void setClipboardContents(String errorMessage) {
        StringSelection stringSelection = new StringSelection(errorMessage);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    public void copySelectedNodeToClipboard() {
        TreePath[] allSelected = this.errorTree.getSelectionPaths();
        StringBuilder fullError = new StringBuilder();
        String lastPath = "";
        HashSet<String> selectedFiles = new HashSet<String>();
        if (allSelected != null) {
            for (TreePath selected : allSelected) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected.getLastPathComponent();
                Object object = node.getUserObject();
                if (object instanceof ErrorSource.Error) {
                    ErrorSource.Error error = (ErrorSource.Error)object;
                    if (selectedFiles.contains(error.getFilePath())) continue;
                    if (!lastPath.equals(error.getFilePath())) {
                        if (!"".equals(lastPath)) {
                            fullError.append("\n");
                        }
                        fullError.append(error.getFilePath());
                        fullError.append("\n");
                        lastPath = error.getFilePath();
                    }
                    fullError.append(ErrorList.formatErrorDisplay(error));
                    fullError.append("\n");
                    continue;
                }
                if (!(object instanceof String)) continue;
                fullError.append((String)object);
                fullError.append("\n");
                selectedFiles.add((String)object);
                for (int i = 0; i < node.getChildCount(); ++i) {
                    DefaultMutableTreeNode errorNode = (DefaultMutableTreeNode)node.getChildAt(i);
                    ErrorSource.Error error = (ErrorSource.Error)errorNode.getUserObject();
                    fullError.append(ErrorList.formatErrorDisplay(error));
                    fullError.append("\n");
                }
            }
            this.setClipboardContents(fullError.toString());
        }
    }

    public void copyAllNodesToClipboard() {
        StringBuilder allErrors = new StringBuilder();
        String lastPath = "";
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.errorRoot.getChildAt(i);
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode errorNode = (DefaultMutableTreeNode)node.getChildAt(j);
                ErrorSource.Error error = (ErrorSource.Error)errorNode.getUserObject();
                if (!lastPath.equals(error.getFilePath())) {
                    if (!"".equals(lastPath)) {
                        allErrors.append("\n");
                    }
                    allErrors.append(error.getFilePath());
                    allErrors.append("\n");
                    lastPath = error.getFilePath();
                }
                allErrors.append(ErrorList.formatErrorDisplay(error));
                allErrors.append("\n");
            }
        }
        this.setClipboardContents(allErrors.toString());
    }

    protected static String getStatusProperty(int errorCount, int warningCount) {
        String statusProp = "error-list.status.";
        statusProp = statusProp + (errorCount == 1 ? "one" : "many");
        statusProp = statusProp + "-error-";
        statusProp = statusProp + (warningCount == 1 ? "one" : "many");
        statusProp = statusProp + "-warning";
        return statusProp;
    }

    protected static String formatErrorDisplay(ErrorSource.Error error) {
        Log.log((int)1, ErrorList.class, (Object)("Formatted Error Line#" + (error.getLineNumber() + 1) + " Error Message: " + error.getErrorMessage()));
        StringBuilder errorFormat = new StringBuilder();
        errorFormat.append(error.getLineNumber() + 1);
        errorFormat.append(":");
        errorFormat.append(error.getErrorMessage() == null ? "" : error.getErrorMessage().replace('\t', ' '));
        return errorFormat.toString();
    }

    class PopupMenu
    extends JPopupMenu {
        JMenuItem selectOne = new JMenuItem(jEdit.getProperty((String)"hypersearch-results.copy-to-clipboard"));
        JMenuItem selectAll;
        JMenuItem expandAll;
        JMenuItem collapseAll;

        public PopupMenu(ActionListener listener) {
            this.selectOne.addActionListener(listener);
            this.selectAll = new JMenuItem(jEdit.getProperty((String)"error-list.copy-all-to-clipboard"));
            this.selectAll.addActionListener(listener);
            this.expandAll = new JMenuItem(jEdit.getProperty((String)"error-list.expand-all"));
            this.expandAll.addActionListener(listener);
            this.collapseAll = new JMenuItem(jEdit.getProperty((String)"error-list.collapse-all"));
            this.collapseAll.addActionListener(listener);
            this.add(this.selectOne);
            this.add(this.selectAll);
            this.addSeparator();
            this.add(this.expandAll);
            this.add(this.collapseAll);
        }

        public void enableSelectOne(boolean enabled) {
            this.selectOne.setEnabled(enabled);
        }
    }

    class ActionHandler
    implements ActionListener {
        public ErrorList errorList;

        public ActionHandler(ErrorList errorList2) {
            this.errorList = errorList2;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JMenuItem item = (JMenuItem)evt.getSource();
            if (jEdit.getProperty((String)"hypersearch-results.copy-to-clipboard").equals(item.getText())) {
                ErrorList.this.copySelectedNodeToClipboard();
            } else if (jEdit.getProperty((String)"error-list.copy-all-to-clipboard").equals(item.getText())) {
                ErrorList.this.copyAllNodesToClipboard();
            } else if (jEdit.getProperty((String)"error-list.expand-all").equals(item.getText())) {
                ErrorList.this.expandAll();
            } else if (jEdit.getProperty((String)"error-list.collapse-all").equals(item.getText())) {
                ErrorList.this.collapseAll();
            } else {
                JOptionPane.showMessageDialog(null, "Invalid Menu option.");
            }
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            switch (evt.getKeyCode()) {
                case 32: {
                    ErrorList.this.openSelectedNode();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ErrorList.this.errorTree.requestFocus();
                        }
                    });
                    evt.consume();
                    break;
                }
                case 10: {
                    ErrorList.this.openSelectedNode();
                    evt.consume();
                    break;
                }
                case 127: {
                    ErrorList.this.getToolkit().beep();
                    evt.consume();
                    break;
                }
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (SwingUtilities.isRightMouseButton(evt)) {
                ErrorList.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                ErrorList.this.popupMenu.enableSelectOne(!ErrorList.this.errorTree.isSelectionEmpty());
            } else {
                TreePath path = ErrorList.this.errorTree.getPathForLocation(evt.getX(), evt.getY());
                if (path == null) {
                    return;
                }
                ErrorList.this.errorTree.setSelectionPath(path);
                ErrorList.this.openNode((DefaultMutableTreeNode)path.getLastPathComponent());
            }
        }
    }

    static class ErrorCellRenderer
    extends EnhancedTreeCellRenderer {
        private static Font plainFont = UIManager.getFont("Tree.font");
        private static Font boldFont;

        ErrorCellRenderer() {
        }

        protected TreeCellRenderer newInstance() {
            return new ErrorCellRenderer();
        }

        protected void configureTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object nodeValue = node.getUserObject();
            if (nodeValue == null) {
                this.setIcon(null);
                this.setText(null);
            } else if (nodeValue instanceof String) {
                this.setFont(boldFont);
                int errorCount = 0;
                int warningCount = 0;
                for (int i = 0; i < node.getChildCount(); ++i) {
                    DefaultMutableTreeNode errorNode = (DefaultMutableTreeNode)node.getChildAt(i);
                    ErrorSource.Error error = (ErrorSource.Error)errorNode.getUserObject();
                    if (error.getErrorType() == 0) {
                        ++errorCount;
                        continue;
                    }
                    ++warningCount;
                }
                this.setText(nodeValue + " (" + jEdit.getProperty((String)ErrorList.getStatusProperty(errorCount, warningCount), (Object[])new Object[]{new Integer(errorCount), new Integer(warningCount)}) + ")");
                this.setIcon(null);
            } else if (nodeValue instanceof ErrorSource.Error) {
                this.setFont(plainFont);
                ErrorSource.Error error = (ErrorSource.Error)nodeValue;
                this.setText(ErrorList.formatErrorDisplay(error));
                this.setIcon(error.getErrorType() == 1 ? WARNING_ICON : ERROR_ICON);
            } else if (nodeValue instanceof Extra) {
                this.setFont(plainFont);
                this.setText(nodeValue.toString());
                this.setIcon(null);
            } else if (nodeValue instanceof Root) {
                this.setText(null);
                this.setIcon(null);
            }
        }

        static {
            if (plainFont == null) {
                plainFont = jEdit.getFontProperty((String)"metal.secondary.font");
            }
            boldFont = plainFont.deriveFont(1);
        }
    }

    static class Extra {
        String message;

        Extra(String message) {
            this.message = message;
        }

        public String toString() {
            return this.message;
        }
    }

    static class Root {
        Root() {
        }
    }
}

