/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.migration;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gjt.sp.jedit.jEdit;
import org.jedit.core.MigrationService;
import org.jedit.keymap.Keymap;
import org.jedit.keymap.KeymapManager;

public class KeymapMigration
implements MigrationService {
    @Override
    public void migrate() {
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory == null) {
            return;
        }
        File keymapFolder = new File(settingsDirectory, "keymaps");
        if (keymapFolder.exists()) {
            return;
        }
        KeymapManager keymapManager = jEdit.getKeymapManager();
        keymapManager.copyKeymap("jEdit", "imported");
        Keymap imported = keymapManager.getKeymap("imported");
        Properties properties = jEdit.getProperties();
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            String key = entry.getKey().toString();
            if (!key.endsWith(".shortcut") && !key.endsWith(".shortcut2")) continue;
            imported.setShortcut(key, entry.getValue().toString());
            jEdit.resetProperty(key);
        }
        imported.save();
        jEdit.setProperty("keymap.current", "imported");
        keymapManager.reload();
    }
}

