/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.ColorWellButton;
import org.gjt.sp.jedit.gui.FontSelector;
import org.gjt.sp.jedit.gui.FontSelectorDialog;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.IntegerInputVerifier;
import org.gjt.sp.jedit.textarea.AntiAlias;

public class TextAreaOptionPane
extends AbstractOptionPane {
    private FontSelector font;
    private JCheckBox fontSubst;
    private FontList fontSubstList;
    private JCheckBox fontSubstSystemFonts;
    private ColorWellButton foregroundColor;
    private ColorWellButton backgroundColor;
    private JCheckBox blinkCaret;
    private JCheckBox blockCaret;
    private JCheckBox thickCaret;
    private ColorWellButton caretColor;
    private ColorWellButton selectionColor;
    private JCheckBox selectionFg;
    private ColorWellButton selectionFgColor;
    private ColorWellButton multipleSelectionColor;
    private JCheckBox lineHighlight;
    private ColorWellButton lineHighlightColor;
    private JCheckBox structureHighlight;
    private ColorWellButton structureHighlightColor;
    private JCheckBox eolMarkers;
    private ColorWellButton eolMarkerColor;
    private JCheckBox wrapGuide;
    private ColorWellButton wrapGuideColor;
    private JCheckBox electricBorders;
    private JComboBox antiAlias;
    private JCheckBox fracFontMetrics;
    private JCheckBox stripTrailingEOL;
    private JCheckBox completeFromAllBuffers;
    private JCheckBox insertCompletionWithDigit;
    private JTextField lineSpacing;

    public TextAreaOptionPane() {
        super("textarea");
    }

    @Override
    public void _init() {
        this.font = new FontSelector(jEdit.getFontProperty("view.font"));
        this.addComponent(jEdit.getProperty("options.textarea.font"), (Component)this.font);
        this.fontSubst = new JCheckBox(jEdit.getProperty("options.textarea.fontSubst"));
        this.fontSubst.setToolTipText(jEdit.getProperty("options.textarea.fontSubst.tooltip"));
        this.fontSubst.setSelected(jEdit.getBooleanProperty("view.enableFontSubst"));
        this.fontSubst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextAreaOptionPane.this.fontSubstList.setVisible(TextAreaOptionPane.this.fontSubst.isSelected());
                TextAreaOptionPane.this.fontSubstSystemFonts.setVisible(TextAreaOptionPane.this.fontSubst.isSelected());
            }
        });
        this.addComponent(this.fontSubst);
        this.fontSubstList = new FontList();
        this.fontSubstList.setVisible(this.fontSubst.isSelected());
        this.addComponent((Component)this.fontSubstList, 2);
        this.fontSubstSystemFonts = new JCheckBox(jEdit.getProperty("options.textarea.fontSubstSystemFonts"));
        this.fontSubstSystemFonts.setSelected(jEdit.getBooleanProperty("view.enableFontSubstSystemFonts"));
        this.fontSubstSystemFonts.setVisible(this.fontSubst.isSelected());
        this.fontSubstSystemFonts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!TextAreaOptionPane.this.fontSubstSystemFonts.isSelected() && TextAreaOptionPane.this.fontSubstList.listSize() == 0) {
                    JOptionPane.showMessageDialog(TextAreaOptionPane.this.fontSubstSystemFonts.getParent(), jEdit.getProperty("options.textarea.fontSubstWarning"), jEdit.getProperty("options.textarea.fontSubstWarning.label"), 2);
                }
            }
        });
        this.addComponent((Component)this.fontSubstSystemFonts, 2);
        this.antiAlias = new JComboBox<String>(AntiAlias.comboChoices);
        this.antiAlias.setToolTipText(jEdit.getProperty("options.textarea.antiAlias.tooltip"));
        AntiAlias antiAliasValue = new AntiAlias(jEdit.getProperty("view.antiAlias"));
        this.font.setAntiAliasEnabled(antiAliasValue.val() > 0);
        this.antiAlias.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int idx = TextAreaOptionPane.this.antiAlias.getSelectedIndex();
                TextAreaOptionPane.this.font.setAntiAliasEnabled(idx > 0);
                TextAreaOptionPane.this.font.repaint();
            }
        });
        this.antiAlias.setSelectedIndex(antiAliasValue.val());
        this.addComponent(jEdit.getProperty("options.textarea.antiAlias"), (Component)this.antiAlias);
        this.fracFontMetrics = new JCheckBox(jEdit.getProperty("options.textarea.fracFontMetrics"));
        this.fracFontMetrics.setToolTipText(jEdit.getProperty("options.textarea.fracFontMetrics.tooltip"));
        this.fracFontMetrics.setSelected(jEdit.getBooleanProperty("view.fracFontMetrics"));
        this.addComponent(this.fracFontMetrics);
        IntegerInputVerifier integerInputVerifier = new IntegerInputVerifier();
        JPanel lineSpacingPanel = new JPanel();
        this.lineSpacing = new JTextField(String.valueOf(jEdit.getIntegerProperty("options.textarea.lineSpacing", 0)));
        this.lineSpacing.setColumns(4);
        this.lineSpacing.setHorizontalAlignment(4);
        this.lineSpacing.setInputVerifier(integerInputVerifier);
        lineSpacingPanel.add(new JLabel(jEdit.getProperty("options.textarea.lineSpacing.label")));
        lineSpacingPanel.add(this.lineSpacing);
        this.addComponent(lineSpacingPanel);
        this.addSeparator();
        this.foregroundColor = new ColorWellButton(jEdit.getColorProperty("view.fgColor"));
        this.addComponent(jEdit.getProperty("options.textarea.foreground"), (Component)this.foregroundColor, 3);
        this.backgroundColor = new ColorWellButton(jEdit.getColorProperty("view.bgColor"));
        this.addComponent(jEdit.getProperty("options.textarea.background"), (Component)this.backgroundColor, 3);
        this.blinkCaret = new JCheckBox(jEdit.getProperty("options.textarea.blinkCaret"));
        this.blinkCaret.setSelected(jEdit.getBooleanProperty("view.caretBlink"));
        this.blockCaret = new JCheckBox(jEdit.getProperty("options.textarea.blockCaret"));
        this.blockCaret.setSelected(jEdit.getBooleanProperty("view.blockCaret"));
        this.thickCaret = new JCheckBox(jEdit.getProperty("options.textarea.thickCaret"));
        this.thickCaret.setSelected(jEdit.getBooleanProperty("view.thickCaret"));
        Box caretSettings = new Box(0);
        caretSettings.add(new JLabel(jEdit.getProperty("options.textarea.caret")));
        caretSettings.add(Box.createHorizontalStrut(6));
        caretSettings.add(this.blinkCaret);
        caretSettings.add(this.blockCaret);
        caretSettings.add(this.thickCaret);
        this.caretColor = new ColorWellButton(jEdit.getColorProperty("view.caretColor"));
        this.addComponent(caretSettings, (Component)this.caretColor, 3);
        this.selectionColor = new ColorWellButton(jEdit.getColorProperty("view.selectionColor"));
        this.addComponent(jEdit.getProperty("options.textarea.selection"), (Component)this.selectionColor, 3);
        this.multipleSelectionColor = new ColorWellButton(jEdit.getColorProperty("view.multipleSelectionColor"));
        this.addComponent(jEdit.getProperty("options.textarea.multipleSelection"), (Component)this.multipleSelectionColor, 3);
        this.selectionFg = new JCheckBox(jEdit.getProperty("options.textarea.selectionFg"));
        this.selectionFg.setName("selectionFg");
        this.selectionFg.setSelected(jEdit.getBooleanProperty("view.selectionFg"));
        this.selectionFgColor = new ColorWellButton(jEdit.getColorProperty("view.selectionFgColor"));
        this.addComponent(this.selectionFg, (Component)this.selectionFgColor, 3);
        this.lineHighlight = new JCheckBox(jEdit.getProperty("options.textarea.lineHighlight"));
        this.lineHighlight.setSelected(jEdit.getBooleanProperty("view.lineHighlight"));
        this.lineHighlightColor = new ColorWellButton(jEdit.getColorProperty("view.lineHighlightColor"));
        this.addComponent(this.lineHighlight, (Component)this.lineHighlightColor, 3);
        this.structureHighlight = new JCheckBox(jEdit.getProperty("options.textarea.structureHighlight"));
        this.structureHighlight.setSelected(jEdit.getBooleanProperty("view.structureHighlight"));
        this.structureHighlightColor = new ColorWellButton(jEdit.getColorProperty("view.structureHighlightColor"));
        this.addComponent(this.structureHighlight, (Component)this.structureHighlightColor, 3);
        this.eolMarkers = new JCheckBox(jEdit.getProperty("options.textarea.eolMarkers"));
        this.eolMarkers.setSelected(jEdit.getBooleanProperty("view.eolMarkers"));
        this.eolMarkerColor = new ColorWellButton(jEdit.getColorProperty("view.eolMarkerColor"));
        this.addComponent(this.eolMarkers, (Component)this.eolMarkerColor, 3);
        this.wrapGuide = new JCheckBox(jEdit.getProperty("options.textarea.wrapGuide"));
        this.wrapGuide.setSelected(jEdit.getBooleanProperty("view.wrapGuide"));
        this.wrapGuideColor = new ColorWellButton(jEdit.getColorProperty("view.wrapGuideColor"));
        this.addComponent(this.wrapGuide, (Component)this.wrapGuideColor, 3);
        this.addSeparator();
        this.electricBorders = new JCheckBox(jEdit.getProperty("options.textarea.electricBorders"));
        this.electricBorders.setSelected(!"0".equals(jEdit.getProperty("view.electricBorders")));
        this.addComponent(this.electricBorders);
        this.stripTrailingEOL = new JCheckBox(jEdit.getProperty("options.textarea.stripTrailingEOL"));
        this.stripTrailingEOL.setSelected(jEdit.getBooleanProperty("stripTrailingEOL"));
        this.addComponent(this.stripTrailingEOL);
        this.completeFromAllBuffers = new JCheckBox(jEdit.getProperty("options.textarea.completeFromAllBuffers"));
        this.completeFromAllBuffers.setSelected(jEdit.getBooleanProperty("completeFromAllBuffers"));
        this.addComponent(this.completeFromAllBuffers);
        this.insertCompletionWithDigit = new JCheckBox(jEdit.getProperty("options.textarea.insertCompletionWithDigit"));
        this.insertCompletionWithDigit.setSelected(jEdit.getBooleanProperty("insertCompletionWithDigit"));
        this.addComponent(this.insertCompletionWithDigit);
    }

    @Override
    public void _save() {
        jEdit.setFontProperty("view.font", this.font.getFont());
        jEdit.setBooleanProperty("view.enableFontSubst", this.fontSubst.isSelected());
        this.fontSubstList.save();
        jEdit.setBooleanProperty("view.enableFontSubstSystemFonts", this.fontSubstSystemFonts.isSelected());
        jEdit.setColorProperty("view.fgColor", this.foregroundColor.getSelectedColor());
        jEdit.setColorProperty("view.bgColor", this.backgroundColor.getSelectedColor());
        jEdit.setBooleanProperty("view.caretBlink", this.blinkCaret.isSelected());
        jEdit.setBooleanProperty("view.blockCaret", this.blockCaret.isSelected());
        jEdit.setBooleanProperty("view.thickCaret", this.thickCaret.isSelected());
        jEdit.setColorProperty("view.caretColor", this.caretColor.getSelectedColor());
        jEdit.setColorProperty("view.selectionColor", this.selectionColor.getSelectedColor());
        jEdit.setColorProperty("view.multipleSelectionColor", this.multipleSelectionColor.getSelectedColor());
        jEdit.setBooleanProperty("view.selectionFg", this.selectionFg.isSelected());
        jEdit.setColorProperty("view.selectionFgColor", this.selectionFgColor.getSelectedColor());
        jEdit.setBooleanProperty("view.lineHighlight", this.lineHighlight.isSelected());
        jEdit.setColorProperty("view.lineHighlightColor", this.lineHighlightColor.getSelectedColor());
        jEdit.setBooleanProperty("view.structureHighlight", this.structureHighlight.isSelected());
        jEdit.setColorProperty("view.structureHighlightColor", this.structureHighlightColor.getSelectedColor());
        jEdit.setBooleanProperty("view.eolMarkers", this.eolMarkers.isSelected());
        jEdit.setColorProperty("view.eolMarkerColor", this.eolMarkerColor.getSelectedColor());
        jEdit.setBooleanProperty("view.wrapGuide", this.wrapGuide.isSelected());
        jEdit.setColorProperty("view.wrapGuideColor", this.wrapGuideColor.getSelectedColor());
        jEdit.setIntegerProperty("view.electricBorders", this.electricBorders.isSelected() ? 3 : 0);
        AntiAlias nv = new AntiAlias(jEdit.getProperty("view.antiAlias"));
        nv.set(this.antiAlias.getSelectedIndex());
        jEdit.setProperty("view.antiAlias", nv.toString());
        jEdit.setBooleanProperty("view.fracFontMetrics", this.fracFontMetrics.isSelected());
        jEdit.setBooleanProperty("stripTrailingEOL", this.stripTrailingEOL.isSelected());
        jEdit.setBooleanProperty("completeFromAllBuffers", this.completeFromAllBuffers.isSelected());
        jEdit.setBooleanProperty("insertCompletionWithDigit", this.insertCompletionWithDigit.isSelected());
        jEdit.setIntegerProperty("options.textarea.lineSpacing", Integer.valueOf(this.lineSpacing.getText()));
    }

    private static class FontList
    extends JPanel
    implements ActionListener {
        private DefaultListModel fontsModel;
        private JList fonts;
        private JButton add;
        private JButton remove;
        private JButton up;
        private JButton down;

        public FontList() {
            Font f;
            int i = 0;
            this.setLayout(new BorderLayout());
            JLabel l = new JLabel(jEdit.getProperty("options.textarea.fontSubstList"));
            this.fontsModel = new DefaultListModel();
            this.fonts = new JList(this.fontsModel);
            this.fonts.setCellRenderer(new FontItemRenderer());
            while ((f = jEdit.getFontProperty("view.fontSubstList." + i)) != null) {
                this.fontsModel.addElement(f);
                ++i;
            }
            Box buttons = new Box(1);
            this.add = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.context.add.icon")));
            this.add.setToolTipText(jEdit.getProperty("common.add"));
            this.add.addActionListener(this);
            buttons.add(this.add);
            buttons.add(Box.createVerticalStrut(2));
            this.remove = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.context.remove.icon")));
            this.remove.setToolTipText(jEdit.getProperty("common.remove"));
            this.remove.addActionListener(this);
            buttons.add(this.remove);
            buttons.add(Box.createVerticalStrut(2));
            this.up = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.context.moveUp.icon")));
            this.up.setToolTipText(jEdit.getProperty("common.moveUp"));
            this.up.addActionListener(this);
            buttons.add(this.up);
            buttons.add(Box.createVerticalStrut(2));
            this.down = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.context.moveDown.icon")));
            this.down.setToolTipText(jEdit.getProperty("common.moveDown"));
            this.down.addActionListener(this);
            buttons.add(this.down);
            buttons.add(Box.createGlue());
            this.add("North", l);
            this.add("Center", new JScrollPane(this.fonts));
            this.add("East", buttons);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int idx;
            if (ae.getSource() == this.add) {
                JDialog parent = GUIUtilities.getParentDialog(this);
                Font selected = new FontSelectorDialog((Dialog)parent, null).getSelectedFont();
                if (selected != null) {
                    selected = selected.deriveFont(0, 12.0f);
                    this.fontsModel.addElement(selected);
                    this.fonts.setSelectedIndex(this.fontsModel.size() - 1);
                }
            } else if (ae.getSource() == this.remove) {
                int idx2 = this.fonts.getSelectedIndex();
                if (idx2 != -1) {
                    this.fontsModel.removeElementAt(idx2);
                }
            } else if (ae.getSource() == this.up) {
                int idx3 = this.fonts.getSelectedIndex();
                if (idx3 > 0) {
                    Object o = this.fontsModel.getElementAt(idx3);
                    this.fontsModel.removeElementAt(idx3);
                    this.fontsModel.add(idx3 - 1, o);
                    this.fonts.setSelectedIndex(idx3 - 1);
                }
            } else if (ae.getSource() == this.down && (idx = this.fonts.getSelectedIndex()) != -1 && idx < this.fontsModel.size() - 1) {
                Object o = this.fontsModel.getElementAt(idx);
                this.fontsModel.removeElementAt(idx);
                this.fontsModel.add(idx + 1, o);
                this.fonts.setSelectedIndex(idx + 1);
            }
        }

        public void save() {
            Font f;
            int i = 0;
            while ((f = jEdit.getFontProperty("view.fontSubstList." + i)) != null) {
                jEdit.unsetProperty("view.fontSubstList." + i);
                ++i;
            }
            for (i = 0; i < this.fontsModel.size(); ++i) {
                f = (Font)this.fontsModel.getElementAt(i);
                jEdit.setFontProperty("view.fontSubstList." + i, f);
            }
        }

        public int listSize() {
            return this.fontsModel.size();
        }

        private static class FontItemRenderer
        extends DefaultListCellRenderer {
            private FontItemRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Font f = (Font)value;
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(f.getFamily());
                return this;
            }
        }
    }
}

