/*
 * Decompiled with CFR 0.152.
 */
package code2html.impl.latex;

import code2html.generic.GenericGutter;

public class LatexGutter
extends GenericGutter {
    protected static final String gutterBorder = "{|}\\ ";
    protected String spacer;
    private static final String SPACESTRING = "{\\ }";

    public LatexGutter(String bgColor, String fgColor, String highlightColor, int highlightInterval) {
        this(4, bgColor, fgColor, highlightColor, highlightInterval);
    }

    public LatexGutter(int gutterSize, String bgColor, String fgColor, String highlightColor, int highlightInterval) {
        super(gutterSize, bgColor, fgColor, highlightColor, highlightInterval);
    }

    public String format(int lineNumber) {
        StringBuffer buf = new StringBuffer();
        String s = Integer.toString(lineNumber);
        buf.append("\\" + this.gutterStyle(lineNumber) + "{");
        for (int i = this.gutterSize - s.length(); i >= 0; --i) {
            buf.append("\\ ");
        }
        buf.append(s);
        buf.append(gutterBorder + "}");
        return buf.toString();
    }

    public String formatEmpty(int lineNumber) {
        return "\\" + this.gutterStyle(lineNumber) + "{" + this.spacer + gutterBorder + "}";
    }

    public String style() {
        StringBuffer buf = new StringBuffer();
        buf.append("\\newcommand{\\gutter}[1]{\\textcolor[rgb]{0,0,0}{{|}#1}}\n");
        buf.append("\\newcommand{\\gutterH}[1]{\\textcolor[rgb]{1,0,0}{{|}#1}}\n");
        return buf.toString();
    }

    public void setGutterSize(int gutterSize) {
        this.gutterSize = gutterSize;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < gutterSize; ++i) {
            buf.append("\\ ");
        }
        this.spacer = buf.toString();
    }

    public String getSpaceString() {
        return SPACESTRING;
    }
}

