/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Bytes$;
import isabelle.Isabelle_System$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.UTF8$;
import isabelle.Word$;
import isabelle.XZ$;
import isabelle.package$;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZInputStream;
import org.tukaani.xz.XZOutputStream;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class File$ {
    public static final File$ MODULE$;
    private final Regex Cygdrive;
    private final Regex Named_Root;

    static {
        new File$();
    }

    public String standard_path(Path path2) {
        return path2.expand().implode();
    }

    public String standard_path(String platform_path2) {
        String string2;
        if (Platform$.MODULE$.is_windows()) {
            String string3;
            Regex Platform_Root = new Regex(new StringBuilder().append((Object)"(?i)").append((Object)Pattern.quote(Isabelle_System$.MODULE$.cygwin_root())).append((Object)"(?:\\\\+|\\z)(.*)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            Regex Drive = new Regex("([a-zA-Z]):\\\\*(.*)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            String string4 = platform_path2.replace('/', '\\');
            Option option2 = Platform_Root.unapplySeq((CharSequence)string4);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                String rest = (String)((LinearSeqOptimized)option2.get()).apply(0);
                string3 = new StringBuilder().append((Object)"/").append((Object)rest.replace('\\', '/')).toString();
            } else {
                Option option3 = Drive.unapplySeq((CharSequence)string4);
                if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
                    String letter = (String)((LinearSeqOptimized)option3.get()).apply(0);
                    String rest = (String)((LinearSeqOptimized)option3.get()).apply(1);
                    String string5 = rest;
                    String string6 = "";
                    string3 = new StringBuilder().append((Object)"/cygdrive/").append((Object)Word$.MODULE$.lowercase(letter)).append((Object)(!(string5 != null ? !string5.equals(string6) : string6 != null) ? "" : new StringBuilder().append((Object)"/").append((Object)rest.replace('\\', '/')).toString())).toString();
                } else {
                    string3 = string4.replace('\\', '/');
                }
            }
            string2 = string3;
        } else {
            string2 = platform_path2;
        }
        return string2;
    }

    public String standard_path(File file) {
        return this.standard_path(file.getPath());
    }

    public Path path(File file) {
        return Path$.MODULE$.explode(this.standard_path(file));
    }

    public String standard_url(String name2) {
        String string2;
        try {
            URL url = new URL(name2);
            String string3 = url.getProtocol();
            String string4 = "file";
            string2 = !(string3 != null ? !string3.equals(string4) : string4 != null) ? this.standard_path(URLDecoder.decode(url.getPath(), UTF8$.MODULE$.charset_name())) : name2;
        }
        catch (MalformedURLException malformedURLException) {
            string2 = this.standard_path(name2);
        }
        return string2;
    }

    private Regex Cygdrive() {
        return this.Cygdrive;
    }

    private Regex Named_Root() {
        return this.Named_Root;
    }

    public String platform_path(String standard_path) {
        String string2;
        if (Platform$.MODULE$.is_windows()) {
            String string3;
            StringBuilder result_path = new StringBuilder();
            String string4 = standard_path;
            Option option2 = this.Cygdrive().unapplySeq((CharSequence)string4);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                String drive = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String rest = (String)((LinearSeqOptimized)option2.get()).apply(1);
                result_path.$plus$plus$eq(new StringBuilder().append((Object)Word$.MODULE$.uppercase(drive)).append((Object)":").append((Object)File.separator).toString());
                string3 = rest;
            } else {
                Option option3 = this.Named_Root().unapplySeq((CharSequence)string4);
                if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
                    String root = (String)((LinearSeqOptimized)option3.get()).apply(0);
                    String rest = (String)((LinearSeqOptimized)option3.get()).apply(1);
                    result_path.$plus$plus$eq(File.separator);
                    result_path.$plus$plus$eq(File.separator);
                    result_path.$plus$plus$eq(root);
                    string3 = rest;
                } else if (string4.startsWith("/")) {
                    result_path.$plus$plus$eq(Isabelle_System$.MODULE$.cygwin_root());
                    string3 = string4;
                } else {
                    string3 = string4;
                }
            }
            String rest = string3;
            ((TraversableLike)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)'/'), (Object)rest)).withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String p) {
                    String string2 = p;
                    String string3 = "";
                    return string2 != null ? !string2.equals(string3) : string3 != null;
                }
            }).foreach((Function1)new Serializable(result_path){
                public static final long serialVersionUID = 0L;
                private final StringBuilder result_path$1;

                public final StringBuilder apply(String p) {
                    int len = this.result_path$1.length();
                    Object object = len > 0 && this.result_path$1.apply(len - 1) != File.separatorChar ? this.result_path$1.$plus$eq(File.separatorChar) : BoxedUnit.UNIT;
                    return this.result_path$1.$plus$plus$eq(p);
                }
                {
                    this.result_path$1 = result_path$1;
                }
            });
            string2 = result_path.toString();
        } else {
            string2 = standard_path;
        }
        return string2;
    }

    public String platform_path(Path path2) {
        return this.platform_path(this.standard_path(path2));
    }

    public File platform_file(Path path2) {
        return new File(this.platform_path(path2));
    }

    public String platform_url(Path raw_path) {
        Path path2 = raw_path.expand();
        Predef$.MODULE$.require(path2.is_absolute());
        String s = this.platform_path(path2).replaceAll(" ", "%20");
        return Platform$.MODULE$.is_windows() ? (s.startsWith("\\\\") ? new StringBuilder().append((Object)"file:").append((Object)s.replace('\\', '/')).toString() : new StringBuilder().append((Object)"file:///").append((Object)s.replace('\\', '/')).toString()) : new StringBuilder().append((Object)"file://").append((Object)s).toString();
    }

    public String bash_path(Path path2) {
        return Bash$.MODULE$.string(this.standard_path(path2));
    }

    public String bash_path(File file) {
        return Bash$.MODULE$.string(this.standard_path(file));
    }

    public Path check_dir(Path path2) {
        return path2.is_dir() ? path2 : (Path)package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"No such directory: ").append((Object)path2).toString());
    }

    public Path check_file(Path path2) {
        return path2.is_file() ? path2 : (Path)package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"No such file: ").append((Object)path2).toString());
    }

    public List<String> read_dir(Path dir) {
        Object object = dir.is_dir() ? BoxedUnit.UNIT : package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"Bad directory: ").append((Object)dir.toString()).toString());
        File[] files = dir.file().listFiles();
        return files == null ? Nil$.MODULE$ : (List)Predef$.MODULE$.refArrayOps((Object[])files).toList().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$1) {
                return x$1.getName();
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public List<File> find_files(File start, Function1<File, Object> pred) {
        ListBuffer result2 = new ListBuffer();
        Object object = start.isFile() && BoxesRunTime.unboxToBoolean((Object)pred.apply((Object)start)) ? result2.$plus$eq((Object)start) : (start.isDirectory() ? Files.walkFileTree(start.toPath(), (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(pred, result2){
            private final Function1 pred$1;
            private final ListBuffer result$1;

            public FileVisitResult visitFile(java.nio.file.Path path2, BasicFileAttributes attrs) {
                File file = path2.toFile();
                Object object = BoxesRunTime.unboxToBoolean((Object)this.pred$1.apply((Object)file)) ? this.result$1.$plus$eq((Object)file) : BoxedUnit.UNIT;
                return FileVisitResult.CONTINUE;
            }
            {
                this.pred$1 = pred$1;
                this.result$1 = result$1;
            }
        }) : BoxedUnit.UNIT);
        return result2.toList();
    }

    public Function1<File, Object> find_files$default$2() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$2) {
                return true;
            }
        };
    }

    public String read(File file) {
        return Bytes$.MODULE$.read(file).toString();
    }

    public String read(Path path2) {
        return this.read(path2.file());
    }

    public String read_stream(BufferedReader reader) {
        StringBuilder output2 = new StringBuilder(100);
        int c = -1;
        while ((c = reader.read()) != -1) {
            output2.$plus$eq((char)c);
        }
        reader.close();
        return output2.toString();
    }

    public String read_stream(InputStream stream) {
        return this.read_stream(new BufferedReader(new InputStreamReader(stream, UTF8$.MODULE$.charset())));
    }

    public String read_gzip(File file) {
        return this.read_stream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file))));
    }

    public String read_gzip(Path path2) {
        return this.read_gzip(path2.file());
    }

    public String read_xz(File file) {
        return this.read_stream((InputStream)new XZInputStream((InputStream)new BufferedInputStream(new FileInputStream(file))));
    }

    public String read_xz(Path path2) {
        return this.read_xz(path2.file());
    }

    public List<String> read_lines(BufferedReader reader, Function1<String, BoxedUnit> progress) {
        ListBuffer result2 = new ListBuffer();
        String line = null;
        while ((line = this.liftedTree1$1(reader)) != null) {
            progress.apply((Object)line);
            result2.$plus$eq((Object)line);
        }
        reader.close();
        return result2.toList();
    }

    /*
     * WARNING - void declaration
     */
    public void write_file(File file, CharSequence text2, Function1<OutputStream, OutputStream> make_stream) {
        OutputStream stream = (OutputStream)make_stream.apply((Object)new FileOutputStream(file));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, UTF8$.MODULE$.charset()));
        try {
            writer.append(text2);
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.close();
            throw throwable;
        }
        writer.close();
    }

    public void write(File file, CharSequence text2) {
        this.write_file(file, text2, (Function1<OutputStream, OutputStream>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OutputStream apply(OutputStream s) {
                return s;
            }
        });
    }

    public void write(Path path2, CharSequence text2) {
        this.write(path2.file(), text2);
    }

    public void write_gzip(File file, CharSequence text2) {
        this.write_file(file, text2, (Function1<OutputStream, OutputStream>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final GZIPOutputStream apply(OutputStream s) {
                return new GZIPOutputStream(new BufferedOutputStream(s));
            }
        });
    }

    public void write_gzip(Path path2, CharSequence text2) {
        this.write_gzip(path2.file(), text2);
    }

    public void write_xz(File file, CharSequence text2, LZMA2Options options) {
        this.write_file(file, text2, (Function1<OutputStream, OutputStream>)new Serializable(options){
            public static final long serialVersionUID = 0L;
            private final LZMA2Options options$1;

            public final XZOutputStream apply(OutputStream s) {
                return new XZOutputStream((OutputStream)new BufferedOutputStream(s), (FilterOptions)this.options$1);
            }
            {
                this.options$1 = options$1;
            }
        });
    }

    public void write_xz(File file, CharSequence text2) {
        this.write_xz(file, text2, XZ$.MODULE$.options(XZ$.MODULE$.options$default$1()));
    }

    public void write_xz(Path path2, CharSequence text2, LZMA2Options options) {
        this.write_xz(path2.file(), text2, options);
    }

    public void write_xz(Path path2, CharSequence text2) {
        this.write_xz(path2, text2, XZ$.MODULE$.options(XZ$.MODULE$.options$default$1()));
    }

    public void write_backup(Path path2, CharSequence text2) {
        if (path2.is_file()) {
            this.move(path2, path2.backup());
        }
        this.write(path2, text2);
    }

    public void write_backup2(Path path2, CharSequence text2) {
        if (path2.is_file()) {
            this.move(path2, path2.backup2());
        }
        this.write(path2, text2);
    }

    public void append(File file, CharSequence text2) {
        Files.write(file.toPath(), UTF8$.MODULE$.bytes(((Object)text2).toString()), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
    }

    public void append(Path path2, CharSequence text2) {
        this.append(path2.file(), text2);
    }

    public boolean eq(File file1, File file2) {
        boolean bl;
        try {
            bl = Files.isSameFile(file1.toPath(), file2.toPath());
        }
        catch (Throwable throwable) {
            boolean bl2;
            Throwable throwable2 = throwable;
            Option<String> option2 = package$.MODULE$.ERROR().unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            bl = bl2 = false;
        }
        return bl;
    }

    public boolean eq(Path path1, Path path2) {
        return this.eq(path1.file(), path2.file());
    }

    public void copy(File src, File dst) {
        File target;
        File file = target = dst.isDirectory() ? new File(dst, src.getName()) : dst;
        if (!this.eq(src, target)) {
            Files.copy(src.toPath(), target.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void copy(Path path1, Path path2) {
        this.copy(path1.file(), path2.file());
    }

    public void move(File src, File dst) {
        File target;
        File file = target = dst.isDirectory() ? new File(dst, src.getName()) : dst;
        if (!this.eq(src, target)) {
            Files.move(src.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void move(Path path1, Path path2) {
        this.move(path1.file(), path2.file());
    }

    private final String liftedTree1$1(BufferedReader reader$1) {
        String string2;
        try {
            string2 = reader$1.readLine();
        }
        catch (IOException iOException) {
            string2 = null;
        }
        return string2;
    }

    private File$() {
        MODULE$ = this;
        this.Cygdrive = new Regex("/cygdrive/([a-zA-Z])($|/.*)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.Named_Root = new Regex("//+([^/]*)(.*)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }
}

