/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.ManagePanel;

class PluginDetailPanel
extends JPanel {
    private final JEditorPane pluginDetail;
    private final JLabel title;
    private ManagePanel.Entry entry;

    PluginDetailPanel() {
        this.setLayout(new BorderLayout());
        this.pluginDetail = new JEditorPane();
        this.pluginDetail.setEditable(false);
        this.pluginDetail.setContentType("text/html");
        this.pluginDetail.setBackground(jEdit.getColorProperty("view.bgColor"));
        this.pluginDetail.setForeground(jEdit.getColorProperty("view.fgColor"));
        this.pluginDetail.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.title = new JLabel();
        this.add((Component)this.title, "North");
        JScrollPane scroll = new JScrollPane(this.pluginDetail);
        scroll.setHorizontalScrollBarPolicy(31);
        this.add(scroll);
    }

    void setPlugin(ManagePanel.Entry entry) {
        if (entry != this.entry) {
            if (entry.status.equals("loaded")) {
                if (entry.name == null) {
                    this.title.setText("<html><b>" + entry.jar + "</b></html>");
                } else {
                    this.title.setText("<html><b>" + entry.name + "</b></html>");
                }
                StringBuilder builder = new StringBuilder();
                if (entry.version != null) {
                    builder.append("<b>").append(jEdit.getProperty("install-plugins.info.version", "Version")).append("</b>: ").append(entry.version).append("<br>");
                }
                if (entry.author != null) {
                    builder.append("<b>").append(jEdit.getProperty("install-plugins.info.author", "Author")).append("</b>: ").append(entry.author).append("<br>");
                }
                if (entry.description != null) {
                    builder.append("<br>").append(entry.description);
                }
                builder.append(this.getDepends(entry));
                this.pluginDetail.setText(builder.toString());
            } else {
                this.title.setText("<html><b>" + entry.jar + "</b></html>");
                PluginJAR pluginJar = new PluginJAR(new File(entry.jar));
                pluginJar.init();
                entry.plugin = pluginJar.getPlugin();
                String clazz = pluginJar.getPlugin().getClassName();
                StringBuilder sb = new StringBuilder(256);
                sb.append("<b>").append(jEdit.getProperty("install-plugin.info.version", "Version")).append("</b>: ").append(jEdit.getProperty("plugin." + clazz + ".version", ""));
                sb.append("<br><b>").append(jEdit.getProperty("install-plugin.info.author", "Author")).append("</b>: ").append(jEdit.getProperty("plugin." + clazz + ".author", ""));
                sb.append("<br>").append(jEdit.getProperty("plugin." + clazz + ".description", ""));
                sb.append(this.getDepends(entry));
                this.pluginDetail.setText(sb.toString());
                pluginJar.uninit(false);
            }
            this.entry = entry;
        }
    }

    private String getDepends(ManagePanel.Entry entry) {
        StringBuilder builder = new StringBuilder();
        Set<String> dependencies = entry.getDependencies();
        if (dependencies != null && !dependencies.isEmpty()) {
            builder.append("<br><br><b>").append(jEdit.getProperty("install-plugins.info.depends", "Depends on")).append("</b>:");
            ArrayList<String> depends = new ArrayList<String>(dependencies);
            Collections.sort(depends);
            int i = 0;
            for (String dep : depends) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(" ").append(dep);
                ++i;
            }
        }
        return builder.toString();
    }
}

