/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.gui.ColorWellButton;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.FilteredListModel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

public class LogViewer
extends JPanel
implements DefaultFocusComponent {
    private final ColorizerCellRenderer cellRenderer;
    private ListHandler listHandler;
    private final FilteredListModel<ListModel> listModel;
    private final JList list;
    private final JButton copy;
    private final JCheckBox tail;
    private final JTextField filter;
    private boolean tailIsOn;
    private static boolean showDebug = jEdit.getBooleanProperty("log-viewer.message.debug", true);
    private static boolean showMessage = jEdit.getBooleanProperty("log-viewer.message.message", true);
    private static boolean showNotice = jEdit.getBooleanProperty("log-viewer.message.notice", true);
    private static boolean showWarning = jEdit.getBooleanProperty("log-viewer.message.warning", true);
    private static boolean showError = jEdit.getBooleanProperty("log-viewer.message.error", true);

    public LogViewer() {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        JPanel caption = new JPanel();
        caption.setLayout(new BoxLayout(caption, 0));
        caption.setBorder(new EmptyBorder(6, 0, 6, 0));
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory != null) {
            Object[] args = new String[]{MiscUtilities.constructPath(settingsDirectory, "activity.log")};
            JLabel label = new JLabel(jEdit.getProperty("log-viewer.caption", args));
            caption.add(label);
        }
        caption.add(Box.createHorizontalGlue());
        this.tailIsOn = jEdit.getBooleanProperty("log-viewer.tail", false);
        this.tail = new JCheckBox(jEdit.getProperty("log-viewer.tail.label"), this.tailIsOn);
        this.tail.addActionListener(new ActionHandler());
        this.filter = new JTextField();
        this.filter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                LogViewer.this.setFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LogViewer.this.setFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LogViewer.this.setFilter();
            }
        });
        caption.add(this.filter);
        caption.add(this.tail);
        caption.add(Box.createHorizontalStrut(12));
        this.copy = new JButton(jEdit.getProperty("log-viewer.copy"));
        this.copy.addActionListener(new ActionHandler());
        caption.add(this.copy);
        caption.add(Box.createHorizontalStrut(6));
        JButton settings = new JButton(jEdit.getProperty("log-viewer.settings.label"));
        settings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                new LogSettings();
            }
        });
        caption.add(settings);
        ListModel model = Log.getLogListModel();
        this.listModel = new MyFilteredListModel(model);
        model.removeListDataListener(this.listModel);
        this.list = new LogList(this.listModel);
        this.listModel.setList(this.list);
        this.cellRenderer = new ColorizerCellRenderer();
        this.list.setCellRenderer(this.cellRenderer);
        this.setFilter();
        this.add("North", caption);
        JScrollPane scroller = new JScrollPane(this.list);
        Dimension dim = scroller.getPreferredSize();
        dim.width = Math.min(600, dim.width);
        scroller.setPreferredSize(dim);
        this.add("Center", scroller);
        this.propertiesChanged();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.scrollLaterIfRequired();
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged msg) {
        this.propertiesChanged();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.cellRenderer.updateColors();
        ListModel model = Log.getLogListModel();
        model.addListDataListener(this.listModel);
        this.listHandler = new ListHandler();
        model.addListDataListener(this.listHandler);
        if (this.tailIsOn) {
            this.scrollToTail();
        }
        EditBus.addToBus(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ListModel model = Log.getLogListModel();
        model.removeListDataListener(this.listModel);
        model.removeListDataListener(this.listHandler);
        this.listHandler = null;
        EditBus.removeFromBus(this);
    }

    @Override
    public void focusOnDefaultComponent() {
        this.list.requestFocus();
    }

    private void setFilter() {
        String toFilter = this.filter.getText();
        this.listModel.setFilter(toFilter.length() == 0 ? " " : toFilter);
        this.scrollLaterIfRequired();
    }

    private void propertiesChanged() {
        this.cellRenderer.updateColors();
        this.list.setFont(jEdit.getFontProperty("view.font"));
        this.list.setFixedCellHeight(this.list.getFontMetrics(this.list.getFont()).getHeight());
    }

    private void scrollToTail() {
        int index = this.list.getModel().getSize();
        if (index != 0) {
            this.list.ensureIndexIsVisible(index - 1);
        }
    }

    private void scrollLaterIfRequired() {
        if (this.tailIsOn) {
            ThreadUtilities.runInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    LogViewer.this.scrollToTail();
                }
            });
        }
    }

    private class LogSettings
    extends JDialog {
        private JSpinner maxLines;
        private JCheckBox debug;
        private JCheckBox message;
        private JCheckBox notice;
        private JCheckBox warning;
        private JCheckBox error;
        private ColorWellButton debugColor;
        private ColorWellButton messageColor;
        private ColorWellButton noticeColor;
        private ColorWellButton warningColor;
        private ColorWellButton errorColor;
        private JCheckBox beep;

        LogSettings() {
            super((Frame)jEdit.getActiveView(), jEdit.getProperty("log-viewer.dialog.title"));
            AbstractOptionPane pane = new AbstractOptionPane(jEdit.getProperty("log-viewer.settings.label")){

                @Override
                protected void _init() {
                    this.setBorder(BorderFactory.createEmptyBorder(11, 11, 12, 12));
                    LogSettings.this.maxLines = new JSpinner(new SpinnerNumberModel(jEdit.getIntegerProperty("log-viewer.maxlines", 500), 500, Integer.MAX_VALUE, 1));
                    this.addComponent(jEdit.getProperty("log-viewer.maxlines.label", "Max lines"), (Component)LogSettings.this.maxLines, 0);
                    this.addComponent(Box.createVerticalStrut(11));
                    LogSettings.this.debug = new JCheckBox(jEdit.getProperty("log-viewer.message.debug.label", "Debug"), jEdit.getBooleanProperty("log-viewer.message.debug", true));
                    LogSettings.this.message = new JCheckBox(jEdit.getProperty("log-viewer.message.message.label", "Message"), jEdit.getBooleanProperty("log-viewer.message.message", true));
                    LogSettings.this.notice = new JCheckBox(jEdit.getProperty("log-viewer.message.notice.label", "Notice"), jEdit.getBooleanProperty("log-viewer.message.notice", true));
                    LogSettings.this.warning = new JCheckBox(jEdit.getProperty("log-viewer.message.warning.label", "Warning"), jEdit.getBooleanProperty("log-viewer.message.warning", true));
                    LogSettings.this.error = new JCheckBox(jEdit.getProperty("log-viewer.message.error.label", "Error"), jEdit.getBooleanProperty("log-viewer.message.error", true));
                    this.addComponent(new JLabel(jEdit.getProperty("log-viewer.message.label", "Message Display:")));
                    this.addComponent(LogSettings.this.debug, (Component)(LogSettings.this.debugColor = new ColorWellButton(jEdit.getColorProperty("log-viewer.message.debug.color", Color.BLUE))), 0);
                    this.addComponent(LogSettings.this.message, (Component)(LogSettings.this.messageColor = new ColorWellButton(jEdit.getColorProperty("log-viewer.message.message.color", Color.GREEN))), 0);
                    this.addComponent(LogSettings.this.notice, (Component)(LogSettings.this.noticeColor = new ColorWellButton(jEdit.getColorProperty("log-viewer.message.notice.color", Color.GREEN))), 0);
                    this.addComponent(LogSettings.this.warning, (Component)(LogSettings.this.warningColor = new ColorWellButton(jEdit.getColorProperty("log-viewer.message.warning.color", Color.ORANGE))), 0);
                    this.addComponent(LogSettings.this.error, (Component)(LogSettings.this.errorColor = new ColorWellButton(jEdit.getColorProperty("log-viewer.message.error.color", Color.RED))), 0);
                    this.addComponent(Box.createVerticalStrut(11));
                    LogSettings.this.beep = new JCheckBox(jEdit.getProperty("debug.beepOnOutput.label"), jEdit.getBooleanProperty("debug.beepOnOutput", false));
                    this.addComponent(LogSettings.this.beep);
                    this.addComponent(Box.createVerticalStrut(11));
                    JPanel buttonPanel = new JPanel(new FlowLayout(1));
                    JButton okButton = new JButton(jEdit.getProperty("common.ok"));
                    okButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            this.save();
                            LogSettings.this.setVisible(false);
                            LogSettings.this.dispose();
                        }
                    });
                    JButton cancelButton = new JButton(jEdit.getProperty("common.cancel"));
                    cancelButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            LogSettings.this.setVisible(false);
                            LogSettings.this.dispose();
                        }
                    });
                    buttonPanel.add(okButton);
                    buttonPanel.add(cancelButton);
                    this.addComponent((Component)buttonPanel, 2);
                }

                @Override
                protected void _save() {
                    jEdit.setIntegerProperty("log-viewer.maxlines", ((SpinnerNumberModel)LogSettings.this.maxLines.getModel()).getNumber().intValue());
                    showDebug = LogSettings.this.debug.isSelected();
                    jEdit.setBooleanProperty("log-viewer.message.debug", showDebug);
                    showMessage = LogSettings.this.message.isSelected();
                    jEdit.setBooleanProperty("log-viewer.message.message", showMessage);
                    showNotice = LogSettings.this.notice.isSelected();
                    jEdit.setBooleanProperty("log-viewer.message.notice", showNotice);
                    showWarning = LogSettings.this.warning.isSelected();
                    jEdit.setBooleanProperty("log-viewer.message.warning", showWarning);
                    showError = LogSettings.this.error.isSelected();
                    jEdit.setBooleanProperty("log-viewer.message.error", showError);
                    jEdit.setColorProperty("log-viewer.message.debug.color", LogSettings.this.debugColor.getSelectedColor());
                    jEdit.setColorProperty("log-viewer.message.message.color", LogSettings.this.messageColor.getSelectedColor());
                    jEdit.setColorProperty("log-viewer.message.notice.color", LogSettings.this.noticeColor.getSelectedColor());
                    jEdit.setColorProperty("log-viewer.message.warning.color", LogSettings.this.warningColor.getSelectedColor());
                    jEdit.setColorProperty("log-viewer.message.error.color", LogSettings.this.errorColor.getSelectedColor());
                    jEdit.setBooleanProperty("debug.beepOnOutput", LogSettings.this.beep.isSelected());
                    LogViewer.this.setFilter();
                    Log.setBeepOnOutput(LogSettings.this.beep.isSelected());
                }
            };
            this.setContentPane(pane);
            pane.init();
            this.pack();
            this.setLocationRelativeTo(LogViewer.this);
            this.setVisible(true);
        }
    }

    private static class MyFilteredListModel
    extends FilteredListModel<ListModel> {
        MyFilteredListModel(ListModel model) {
            super(model);
        }

        @Override
        public String prepareFilter(String filter) {
            return filter.toLowerCase();
        }

        @Override
        public boolean passFilter(int row, @Nullable String filter) {
            if (filter == null || filter.isEmpty()) {
                return true;
            }
            String text = this.delegated.getElementAt(row).toString().toLowerCase();
            if (!showDebug && text.contains("[debug]")) {
                return false;
            }
            if (!showMessage && text.contains("[message]")) {
                return false;
            }
            if (!showNotice && text.contains("[notice]")) {
                return false;
            }
            if (!showWarning && text.contains("[warning]")) {
                return false;
            }
            if (!showError && text.contains("[error]")) {
                return false;
            }
            return text.contains(filter);
        }
    }

    private static class ColorizerCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static Color debugColor;
        private static Color messageColor;
        private static Color noticeColor;
        private static Color warningColor;
        private static Color errorColor;

        private ColorizerCellRenderer() {
            this.updateColors();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                Color color = list.getForeground();
                if (s.contains("[debug]")) {
                    color = debugColor;
                } else if (s.contains("[message]")) {
                    color = messageColor;
                } else if (s.contains("[notice]")) {
                    color = noticeColor;
                } else if (s.contains("[warning]")) {
                    color = warningColor;
                } else if (s.contains("[error]")) {
                    color = errorColor;
                }
                this.setForeground(color);
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }

        public void updateColors() {
            debugColor = jEdit.getColorProperty("log-viewer.message.debug.color", Color.BLUE);
            messageColor = jEdit.getColorProperty("log-viewer.message.message.color", Color.BLACK);
            noticeColor = jEdit.getColorProperty("log-viewer.message.notice.color", Color.GREEN);
            warningColor = jEdit.getColorProperty("log-viewer.message.warning.color", Color.ORANGE);
            errorColor = jEdit.getColorProperty("log-viewer.message.error.color", Color.RED);
        }
    }

    private class LogList
    extends JList {
        private int startIndex;

        LogList(ListModel model) {
            super(model);
            this.setVisibleRowCount(24);
            this.getSelectionModel().setSelectionMode(1);
            this.setAutoscrolls(true);
        }

        @Override
        public void processMouseEvent(MouseEvent evt) {
            if (evt.getID() == 501) {
                this.startIndex = LogViewer.this.list.locationToIndex(evt.getPoint());
            }
            super.processMouseEvent(evt);
        }

        @Override
        public void processMouseMotionEvent(MouseEvent evt) {
            if (evt.getID() == 506) {
                int row = LogViewer.this.list.locationToIndex(evt.getPoint());
                if (row != -1) {
                    if (this.startIndex == -1) {
                        LogViewer.this.list.setSelectionInterval(row, row);
                        this.startIndex = row;
                    } else {
                        LogViewer.this.list.setSelectionInterval(this.startIndex, row);
                    }
                    LogViewer.this.list.ensureIndexIsVisible(row);
                    evt.consume();
                }
            } else {
                super.processMouseMotionEvent(evt);
            }
        }
    }

    private class ListHandler
    implements ListDataListener {
        private ListHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            LogViewer.this.scrollLaterIfRequired();
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == LogViewer.this.tail) {
                LogViewer.this.tailIsOn = !LogViewer.this.tailIsOn;
                jEdit.setBooleanProperty("log-viewer.tail", LogViewer.this.tailIsOn);
                if (LogViewer.this.tailIsOn) {
                    LogViewer.this.scrollToTail();
                }
            } else if (src == LogViewer.this.copy) {
                StringBuilder buf = new StringBuilder();
                Object[] selected = LogViewer.this.list.getSelectedValues();
                if (selected != null && selected.length != 0) {
                    for (Object sel : selected) {
                        buf.append(sel);
                        buf.append('\n');
                    }
                } else {
                    ListModel model = LogViewer.this.list.getModel();
                    for (int i = 0; i < model.getSize(); ++i) {
                        buf.append(model.getElementAt(i));
                        buf.append('\n');
                    }
                }
                Registers.setRegister('$', buf.toString());
            }
        }
    }
}

