/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.TaskManager;

public class CloseDialog
extends EnhancedDialog {
    private final View view;
    private final JList bufferList;
    private final DefaultListModel bufferModel;
    private final JButton selectAll;
    private final JButton save;
    private final JButton discard;
    private final JButton cancel;
    private boolean ok;
    boolean selectAllFlag;

    public CloseDialog(View view) {
        this(view, Arrays.asList(jEdit.getBuffers()));
    }

    public CloseDialog(View view, Collection<Buffer> buffers) {
        super(view, jEdit.getProperty("close.title"), true);
        this.view = view;
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        Box iconBox = new Box(1);
        iconBox.add(new JLabel(UIManager.getIcon("OptionPane.warningIcon")));
        iconBox.add(Box.createGlue());
        content.add("West", iconBox);
        JPanel centerPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(jEdit.getProperty("close.caption"));
        label.setBorder(new EmptyBorder(0, 0, 6, 0));
        centerPanel.add("North", label);
        this.bufferModel = new DefaultListModel();
        this.bufferList = new JList(this.bufferModel);
        this.bufferList.setVisibleRowCount(10);
        this.bufferList.addListSelectionListener(new ListHandler());
        for (Buffer buffer : buffers) {
            if (!buffer.isDirty()) continue;
            this.bufferModel.addElement(buffer.getPath());
        }
        centerPanel.add("Center", new JScrollPane(this.bufferList));
        content.add("Center", centerPanel);
        ActionHandler actionListener = new ActionHandler();
        Box buttons = new Box(0);
        buttons.add(Box.createGlue());
        this.selectAll = new JButton(jEdit.getProperty("close.selectAll"));
        buttons.add(this.selectAll);
        this.selectAll.setMnemonic(jEdit.getProperty("close.selectAll.mnemonic").charAt(0));
        this.selectAll.addActionListener(actionListener);
        buttons.add(Box.createHorizontalStrut(6));
        this.save = new JButton(jEdit.getProperty("close.save"));
        buttons.add(this.save);
        this.save.setMnemonic(jEdit.getProperty("close.save.mnemonic").charAt(0));
        this.save.addActionListener(actionListener);
        buttons.add(Box.createHorizontalStrut(6));
        this.discard = new JButton(jEdit.getProperty("close.discard"));
        buttons.add(this.discard);
        this.discard.setMnemonic(jEdit.getProperty("close.discard.mnemonic").charAt(0));
        this.discard.addActionListener(actionListener);
        buttons.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        buttons.add(this.cancel);
        this.cancel.addActionListener(actionListener);
        buttons.add(Box.createGlue());
        this.bufferList.setSelectedIndex(0);
        content.add("South", buttons);
        content.getRootPane().setDefaultButton(this.cancel);
        GUIUtilities.requestFocus(this, this.bufferList);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    public boolean isOK() {
        return this.ok;
    }

    @Override
    public void ok() {
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    private void updateButtons() {
        int index = this.bufferList.getSelectedIndex();
        this.save.getModel().setEnabled(index != -1);
        this.discard.getModel().setEnabled(index != -1);
    }

    private class ListHandler
    implements ListSelectionListener {
        private ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (CloseDialog.this.selectAllFlag) {
                return;
            }
            int index = CloseDialog.this.bufferList.getSelectedIndex();
            if (index != -1) {
                String path = (String)CloseDialog.this.bufferModel.getElementAt(index);
                Buffer buffer = jEdit.getBuffer(path);
                if (buffer == null) {
                    Log.log(1, this, "Buffer " + path + " is already closed");
                    CloseDialog.this.bufferModel.removeElementAt(index);
                } else {
                    CloseDialog.this.view.showBuffer(buffer);
                }
            }
            CloseDialog.this.updateButtons();
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == CloseDialog.this.selectAll) {
                try {
                    CloseDialog.this.selectAllFlag = true;
                    CloseDialog.this.bufferList.setSelectionInterval(0, CloseDialog.this.bufferModel.getSize() - 1);
                }
                finally {
                    CloseDialog.this.selectAllFlag = false;
                }
                CloseDialog.this.bufferList.requestFocus();
            } else if (source == CloseDialog.this.save) {
                Object[] paths;
                for (Object path1 : paths = CloseDialog.this.bufferList.getSelectedValues()) {
                    String path = (String)path1;
                    Buffer buffer = jEdit.getBuffer(path);
                    if (!buffer.save(CloseDialog.this.view, null, true, true)) {
                        return;
                    }
                    TaskManager.instance.waitForIoTasks();
                    if (buffer.getBooleanProperty("BufferIORequest__error")) {
                        return;
                    }
                    jEdit._closeBuffer(CloseDialog.this.view, buffer);
                    CloseDialog.this.bufferModel.removeElement(path);
                }
                if (CloseDialog.this.bufferModel.getSize() == 0) {
                    CloseDialog.this.ok = true;
                    CloseDialog.this.dispose();
                } else {
                    CloseDialog.this.bufferList.setSelectedIndex(0);
                    CloseDialog.this.bufferList.requestFocus();
                }
            } else if (source == CloseDialog.this.discard) {
                Object[] paths;
                for (Object path1 : paths = CloseDialog.this.bufferList.getSelectedValues()) {
                    String path = (String)path1;
                    Buffer buffer = jEdit.getBuffer(path);
                    jEdit._closeBuffer(CloseDialog.this.view, buffer);
                    CloseDialog.this.bufferModel.removeElement(path);
                }
                if (CloseDialog.this.bufferModel.getSize() == 0) {
                    CloseDialog.this.ok = true;
                    CloseDialog.this.dispose();
                } else {
                    CloseDialog.this.bufferList.setSelectedIndex(0);
                    CloseDialog.this.bufferList.requestFocus();
                }
            } else if (source == CloseDialog.this.cancel) {
                CloseDialog.this.cancel();
            }
        }
    }
}

