/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.AnsiEscapeParser;
import console.CommandOutputParser;
import console.Console;
import console.ConsolePane;
import console.Output;
import console.SimpleOutputStreamTask;
import errorlist.DefaultErrorSource;
import java.awt.Color;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import jcfunc.Description;
import org.gjt.sp.jedit.View;
import org.gjt.sp.util.Log;

public class ParsingOutputStreamTask
extends SimpleOutputStreamTask {
    private CommandOutputParser errorParser = null;
    private AnsiEscapeParser ansiParser = null;
    private final int DEFAULT = -1;
    private final int WARNING = 1;
    private final int ERROR = 0;
    private int shiftUCW;
    private Pattern eolPattern;
    private SimpleAttributeSet commonAttrs;
    private SimpleAttributeSet defaultAttrs;
    private SimpleAttributeSet warningAttrs;
    private SimpleAttributeSet errorAttrs;
    private final int CACHE_SIZE_LIMIT = 100;
    private SimpleAttributeSet cache_lastAttrs;
    private int cache_strCount;
    private int buffer_start;

    private void init(Color defaultColor, Color backgroundColor) {
        this.shiftUCW = 0;
        this.eolPattern = Pattern.compile("\n");
        this.commonAttrs = new SimpleAttributeSet();
        StyleConstants.setBackground(this.commonAttrs, backgroundColor);
        StyleConstants.setForeground(this.commonAttrs, defaultColor);
        this.defaultAttrs = this.setDefaultAttrs(null);
        this.buffer_start = 0;
        this.cache_strCount = 0;
    }

    private void handleString(String str, boolean isUnterminated) {
        int errorStatus;
        ArrayList<Description> seqs = null;
        SimpleAttributeSet currentAttrs = null;
        if (this.ansiParser != null && this.ansiParser.touch(AnsiEscapeParser.Behaviour.PARSE, str)) {
            seqs = this.ansiParser.parse(str, true);
            str = this.ansiParser.removeAll(str);
        }
        int n = errorStatus = this.errorParser != null ? this.errorParser.processLine(str) : -1;
        if (isUnterminated) {
            this.shiftUCW += str.length();
        } else {
            currentAttrs = this.updateCurrentAttrs(errorStatus);
            if (this.shiftUCW > 0) {
                this.output.setAttrs(this.shiftUCW, currentAttrs);
                this.shiftUCW = 0;
            }
        }
        try {
            if (seqs == null) {
                this.push(currentAttrs, str);
            } else {
                boolean firstFlushed = false;
                block5: for (Description descr : seqs) {
                    if (!firstFlushed) {
                        if (descr.bPosition > 0) {
                            this.flushSubstring(str, currentAttrs, 0, descr.bPosition);
                        }
                        firstFlushed = true;
                    }
                    switch (descr.function) {
                        case SGR: {
                            this.defaultAttrs = this.setDefaultAttrs(this.ansiParser.processSGRparameters(descr.parameters, this.defaultAttrs));
                            currentAttrs = this.updateCurrentAttrs(errorStatus);
                            this.flushSubstring(str, currentAttrs, descr.bPosition, descr.ePosition);
                            continue block5;
                        }
                    }
                    this.flushSubstring(str, currentAttrs, descr.bPosition, descr.ePosition);
                }
            }
        }
        catch (Exception err) {
            Log.log((int)9, (Object)this, (Object)"Can't print data:", (Throwable)err);
        }
    }

    private void flushSubstring(String str, SimpleAttributeSet localAttrs, int bpos, int epos) {
        if (epos - bpos > 0) {
            this.push(localAttrs, str.substring(bpos, epos));
        }
    }

    private SimpleAttributeSet setDefaultAttrs(SimpleAttributeSet newAttrs) {
        return newAttrs == null ? this.commonAttrs : newAttrs;
    }

    private SimpleAttributeSet setNondefaultAttrs(SimpleAttributeSet nondefAttrs, Color color) {
        if (nondefAttrs == null) {
            nondefAttrs = new SimpleAttributeSet(this.commonAttrs);
            StyleConstants.setForeground(nondefAttrs, color);
        }
        return nondefAttrs;
    }

    private SimpleAttributeSet updateCurrentAttrs(int errorStatus) {
        switch (errorStatus) {
            case -1: {
                return this.defaultAttrs;
            }
            case 1: {
                this.warningAttrs = this.setNondefaultAttrs(this.warningAttrs, this.errorParser.getColor());
                return this.warningAttrs;
            }
            case 0: {
                this.errorAttrs = this.setNondefaultAttrs(this.errorAttrs, this.errorParser.getColor());
                return this.errorAttrs;
            }
        }
        return this.defaultAttrs;
    }

    public void push(SimpleAttributeSet currentAttrs, String str) {
        if (currentAttrs != this.cache_lastAttrs) {
            this.pop(true);
            this.cache_lastAttrs = currentAttrs;
        } else {
            this.pop(false);
        }
        this.buffer_start = this.lineBuffer.append(str).length();
    }

    public boolean pop(boolean forced) {
        if (this.buffer_start > 0 && (forced || this.cache_strCount >= 100)) {
            this.output.writeAttrs(this.cache_lastAttrs, this.lineBuffer.substring(0, this.buffer_start));
            if (this.buffer_start < this.lineBuffer.length()) {
                this.lineBuffer.delete(0, this.buffer_start);
            } else {
                this.lineBuffer.setLength(0);
            }
            this.buffer_start = 0;
            this.cache_strCount = 0;
            return true;
        }
        return false;
    }

    public String trim_cache() {
        String result = this.lineBuffer.substring(this.buffer_start);
        this.lineBuffer.setLength(this.buffer_start);
        return result;
    }

    public ParsingOutputStreamTask(InputStream in, Output output, Color defaultColor, Color backgroundColor, View view, DefaultErrorSource des, String currentDirectory) {
        super(in, output, defaultColor);
        this.setErrorParser(view, des, defaultColor, currentDirectory);
        this.setAnsiParser(defaultColor, backgroundColor);
        this.init(defaultColor, backgroundColor);
    }

    public ParsingOutputStreamTask(InputStream in, Output output, Color defaultColor, Console console, String currentDirectory) {
        this(in, output, defaultColor, console.getConsolePane().getBackground(), console.getView(), console.getErrorSource(), currentDirectory);
    }

    public ParsingOutputStreamTask(InputStream in, Output output, Color defaultColor, Color backgroundColor, CommandOutputParser extErrorParser, AnsiEscapeParser extAnsiParser) {
        super(in, output, defaultColor);
        this.setErrorParser(extErrorParser);
        this.setAnsiParser(extAnsiParser);
        this.init(defaultColor, backgroundColor);
    }

    @Override
    protected void actionInsideWaitingLoop(InputStreamReader isr) throws Exception {
        if (this.lineBuffer.length() > 0) {
            if (!isr.ready()) {
                this.handleString(this.trim_cache(), true);
            }
            this.pop(true);
        }
    }

    @Override
    protected void afterWorking() throws Exception {
        this.errorParser.finishErrorParsing();
    }

    @Override
    protected void finalOutputting() {
        if (this.lineBuffer.length() > 0) {
            this.handleString(this.trim_cache(), false);
            this.pop(true);
        }
    }

    @Override
    protected void outputData() throws Exception {
        String line = this.trim_cache();
        if (ConsolePane.eolExchangeRequired()) {
            line = ConsolePane.eolExchanging(line);
        }
        if (this.ansiParser != null && this.ansiParser.touch(AnsiEscapeParser.Behaviour.REMOVE_ALL, line)) {
            line = this.ansiParser.removeAll(line);
        }
        Matcher matcher = this.eolPattern.matcher(line);
        int bPosition = 0;
        while (!this.abortFlag && matcher.find()) {
            this.handleString(line.substring(bPosition, matcher.end()), false);
            bPosition = matcher.end();
            ++this.cache_strCount;
        }
        if (bPosition < line.length()) {
            this.lineBuffer.append(line.substring(bPosition));
        }
    }

    public void setAnsiParser(AnsiEscapeParser extAnsiParser) {
        this.ansiParser = extAnsiParser;
    }

    public void setAnsiParser(Color defaultColor, Color backgroundColor) {
        this.ansiParser = new AnsiEscapeParser(defaultColor, backgroundColor);
    }

    public void setErrorParser(CommandOutputParser extErrorParser) {
        this.errorParser = extErrorParser;
    }

    public void setErrorParser(View view, DefaultErrorSource des, Color defaultColor, String currentDirectory) {
        this.errorParser = new CommandOutputParser(view, des, defaultColor);
        this.errorParser.setDirectory(currentDirectory);
    }
}

