/*
 * Decompiled with CFR 0.152.
 */
package code2html.line;

public class LineTabExpander {
    private char[] spacer;
    private int tabSize;

    public LineTabExpander() {
        this(4);
    }

    public LineTabExpander(int tabSize) {
        if (tabSize > 0) {
            this.tabSize = tabSize;
        }
        this.spacer = new char[this.tabSize];
        for (int i = 0; i < this.tabSize; ++i) {
            this.spacer[i] = 32;
        }
    }

    public String expand(int pos, char[] str, int strOff, int strLen) {
        StringBuffer buf = new StringBuffer();
        int off = strOff;
        int len = 0;
        for (int i = 0; i < strLen; ++i) {
            char c = str[strOff + i];
            if (c != '\t') {
                ++len;
                ++pos;
                continue;
            }
            int rem = this.tabSize - pos % this.tabSize;
            buf.append(str, off, len).append(this.spacer, 0, rem);
            off += len + 1;
            len = 0;
            pos += rem;
        }
        buf.append(str, off, len);
        return buf.toString();
    }

    public String expand(int pos, String s) {
        return this.expand(pos, s.toCharArray(), 0, s.length());
    }
}

