/*
 * Decompiled with CFR 0.152.
 */
package code2html.generic;

import code2html.generic.GenericGutter;
import code2html.generic.Style;
import code2html.line.LinePosition;
import code2html.line.LineTabExpander;
import code2html.line.LineWrapper;
import java.io.IOException;
import java.io.Writer;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;

public abstract class GenericPainter {
    protected Style style;
    protected GenericGutter gutter;
    protected LineTabExpander expander;
    protected LineWrapper wrapper;
    protected SyntaxStyle[] syntaxStyles;
    protected LinePosition position;
    protected boolean showGutter;
    protected int wrap;

    public GenericPainter() {
    }

    public GenericPainter(SyntaxStyle[] syntaxStyles, Style style, GenericGutter gutter, LineTabExpander expander, LineWrapper wrapper) {
        this.syntaxStyles = syntaxStyles;
        this.position = new LinePosition();
        this.style = style;
        this.gutter = gutter;
        this.expander = expander;
        this.wrapper = wrapper;
        this.showGutter = gutter != null;
        this.wrap = wrapper == null ? 0 : wrapper.getWrapSize();
    }

    public SyntaxStyle[] getSyntaxStyles() {
        return this.syntaxStyles;
    }

    public void setPos(int pos) {
        this.position.setPos(pos);
    }

    public void paintPlainLine(Writer out, int lineNumber, Segment line, Token tokens) {
        try {
            if (this.showGutter) {
                out.write(this.gutter.format(lineNumber));
            }
            int pos = this.position.getPos();
            String expandedText = this.expander.expand(pos, line.array, line.offset, line.count);
            this.position.incPos(expandedText.length());
            int[] wraps = null;
            if (this.wrapper != null) {
                wraps = this.wrapper.wrap(pos, expandedText.length());
                if (pos > 0 && pos % this.wrap == 0) {
                    out.write(this.newLine());
                    if (this.showGutter) {
                        out.write(this.gutter.formatEmpty(lineNumber));
                    }
                }
            }
            if (wraps == null) {
                out.write(this.format(expandedText));
            } else {
                for (int i = 0; i < wraps.length - 1; ++i) {
                    if (i >= 1) {
                        out.write("\n");
                        if (this.showGutter) {
                            out.write(this.gutter.formatEmpty(lineNumber));
                        }
                    }
                    out.write(this.format(expandedText.substring(wraps[i], wraps[i + 1])));
                }
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    public void paintSyntaxLine(Writer out, int lineNumber, Segment line, Token tokens) {
        byte id;
        try {
            if (this.showGutter) {
                out.write(this.gutter.format(lineNumber));
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        while ((id = tokens.id) != 127) {
            int length;
            line.count = length = tokens.length;
            try {
                String text;
                int pos = this.position.getPos();
                String expandedText = this.expander.expand(pos, line.array, line.offset, length);
                this.position.incPos(expandedText.length());
                int[] wraps = null;
                if (this.wrapper != null) {
                    wraps = this.wrapper.wrap(pos, expandedText.length());
                    if (pos > 0 && pos % this.wrap == 0) {
                        out.write(this.newLine());
                        if (this.showGutter) {
                            out.write(this.gutter.formatEmpty(lineNumber));
                        }
                    }
                }
                if (wraps == null) {
                    text = this.format(expandedText);
                    if (id == 0) {
                        out.write(text);
                    } else {
                        out.write(this.style.format(id, this.syntaxStyles[id], text));
                    }
                } else {
                    for (int i = 0; i < wraps.length - 1; ++i) {
                        if (i >= 1) {
                            out.write(this.newLine());
                            if (this.showGutter) {
                                out.write(this.gutter.formatEmpty(lineNumber));
                            }
                        }
                        text = this.format(expandedText.substring(wraps[i], wraps[i + 1]));
                        if (id == 0) {
                            out.write(text);
                            continue;
                        }
                        out.write(this.style.format(id, this.syntaxStyles[id], text));
                    }
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            line.offset += length;
            tokens = tokens.next;
        }
    }

    protected abstract String newLine();

    protected abstract String format(String var1);
}

