/*
 * Decompiled with CFR 0.152.
 */
package sidekick.util;

import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.gjt.sp.jedit.Buffer;
import sidekick.util.SideKickAsset;
import sidekick.util.SideKickElement;

public class ElementUtil {
    public static Position createStartPosition(Buffer buffer, SideKickElement element) {
        int line_offset = buffer.getLineStartOffset(Math.max(element.getStartLocation().line - 1, 0));
        int[] totalVirtualWidth = new int[1];
        int column_offset = buffer.getOffsetOfVirtualColumn(Math.max(element.getStartLocation().line - 1, 0), Math.max(element.getStartLocation().column - 1, 0), totalVirtualWidth);
        if (column_offset == -1) {
            column_offset = totalVirtualWidth[0];
        }
        Position p = ElementUtil.createPosition(line_offset, column_offset);
        element.setStartPosition(p);
        return p;
    }

    public static Position createEndPosition(Buffer buffer, SideKickElement element) {
        int line_offset = buffer.getLineStartOffset(Math.max(Math.min(element.getEndLocation().line - 1, buffer.getLineCount() - 1), 0));
        int[] totalVirtualWidth = new int[1];
        int column_offset = -1;
        try {
            column_offset = buffer.getOffsetOfVirtualColumn(Math.max(element.getEndLocation().line - 1, 0), Math.max(element.getEndLocation().column - 1, 0), totalVirtualWidth);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            column_offset = buffer.getLineEndOffset(buffer.getLineCount() - 1);
        }
        if (column_offset == -1) {
            column_offset = totalVirtualWidth[0];
        }
        Position p = ElementUtil.createPosition(line_offset, column_offset);
        element.setEndPosition(p);
        return p;
    }

    public static Position createPosition(int line_offset, int column_offset) {
        final int lo = line_offset;
        final int co = column_offset;
        return new Position(){

            @Override
            public int getOffset() {
                return lo + co;
            }
        };
    }

    public static void convert(Buffer buffer, DefaultMutableTreeNode node) {
        final Buffer _buffer = buffer;
        final DefaultMutableTreeNode _node = node;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ElementUtil._convert(_buffer, _node);
            }
        });
    }

    private static void _convert(Buffer buffer, DefaultMutableTreeNode node) {
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            ElementUtil._convert(buffer, (DefaultMutableTreeNode)children.nextElement());
        }
        if (node.getUserObject() instanceof SideKickElement) {
            SideKickElement userObject = (SideKickElement)node.getUserObject();
            Position start_position = ElementUtil.createStartPosition(buffer, userObject);
            Position end_position = ElementUtil.createEndPosition(buffer, userObject);
            SideKickAsset asset = new SideKickAsset(userObject);
            asset.setStart(start_position);
            asset.setEnd(end_position);
            node.setUserObject(asset);
        }
    }
}

