/*
 * Decompiled with CFR 0.152.
 */
package console;

import errorlist.DefaultErrorSource;
import errorlist.ErrorSource;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StringList;

public class ErrorMatcher
implements Cloneable {
    public String name;
    public String error;
    public String warning;
    public boolean user;
    public String extraPattern;
    public String fileBackref;
    public String lineBackref;
    public String messageBackref;
    public StringList errors = null;
    public Pattern errorRE;
    public Pattern warningRE;
    public Pattern extraRE;
    public String testText;
    private String internalName;
    private boolean isValid;
    private int type = -1;
    private String label;
    private String file;
    private String line;
    private String message;

    public void clear() {
        this.message = null;
        this.line = null;
        this.file = null;
        this.user = false;
        this.errorRE = null;
        this.warningRE = null;
        this.testText = null;
        this.extraRE = null;
        this.type = -1;
        this.internalName = null;
        this.isValid = false;
        this.errors = new StringList();
        this.type = -1;
        this.label = null;
    }

    public String matchLine(String text) {
        try {
            this.label = null;
            Matcher matcher = null;
            if (this.warningRE != null && (matcher = this.warningRE.matcher(text)).matches()) {
                this.label = jEdit.getProperty((String)"options.console.errors.warning");
                this.type = 1;
            }
            if (this.label == null && this.errorRE != null && (matcher = this.errorRE.matcher(text)).find()) {
                this.label = jEdit.getProperty((String)"options.console.errors.match");
                this.type = 0;
            }
            if (this.label != null) {
                matcher.reset(matcher.group());
                this.file = matcher.replaceFirst(this.fileBackref);
                this.line = matcher.replaceFirst(this.lineBackref);
                this.message = matcher.replaceAll(this.messageBackref);
                return this.toLongString();
            }
        }
        catch (RuntimeException e) {
            StringList logmsg = new StringList();
            logmsg.add((Object)this.label);
            logmsg.add((Object)this.internalName());
            logmsg.add((Object)e.getMessage());
            Log.log((int)7, ErrorMatcher.class, (Object)logmsg.join(":"));
        }
        return null;
    }

    public StringList findMatches(String text) {
        this.isValid();
        String[] sl = text.split("\n");
        StringList retval = new StringList();
        int i = -1;
        while (i + 1 < sl.length) {
            String current = sl[++i];
            StringBuffer mlb = new StringBuffer();
            String ml = this.matchLine(current);
            if (ml == null) continue;
            mlb.append(ml);
            if (this.extraRE != null) {
                Matcher m;
                while (i + 1 < sl.length && (m = this.extraRE.matcher(sl[i + 1])).matches()) {
                    try {
                        String extra = m.replaceFirst("$1");
                        mlb.append("\n  " + extra);
                    }
                    catch (Exception e) {
                        mlb.append("\n  " + e.getMessage());
                    }
                    ++i;
                }
            }
            retval.add((Object)mlb.toString());
        }
        return retval;
    }

    public String toLongString() {
        String retval = "[" + this.label + "]" + this.file + ":" + this.line + ":" + this.message;
        return retval;
    }

    public void set(ErrorMatcher other) {
        this.clear();
        this.user = other.user;
        this.name = other.name;
        this.error = other.error;
        this.warning = other.warning;
        this.extraPattern = other.extraPattern;
        this.fileBackref = other.fileBackref;
        this.lineBackref = other.lineBackref;
        this.messageBackref = other.messageBackref;
        this.testText = other.testText;
        this.isValid();
    }

    public Object clone() {
        ErrorMatcher retval = new ErrorMatcher();
        retval.set(this);
        return retval;
    }

    public String internalName() {
        if (this.internalName == null && this.name != null) {
            this.internalName = ErrorMatcher.internalName(this.name);
        }
        return this.internalName;
    }

    public static String internalName(String name) {
        Pattern p = Pattern.compile("\\W");
        if (name == null) {
            return null;
        }
        String retval = null;
        Matcher m = p.matcher(name);
        retval = m.replaceAll("").toLowerCase();
        return retval;
    }

    public boolean isValid() {
        this.errors = new StringList();
        if (this.name == null) {
            this.errors.add((Object)(jEdit.getProperty((String)"console.not-filled-out.title") + ":" + jEdit.getProperty((String)"options.console.errors.name")));
            this.isValid = false;
            return this.isValid;
        }
        this.internalName();
        int compileFlags = 34;
        if (this.error != null && this.error.length() > 0) {
            try {
                this.errorRE = Pattern.compile(this.error, compileFlags);
            }
            catch (PatternSyntaxException pse) {
                this.errors.add((Object)(jEdit.getProperty((String)"options.console.errors.match") + pse.getDescription()));
            }
        }
        if (this.warning != null && this.warning.length() > 0) {
            try {
                this.warningRE = Pattern.compile(this.warning, compileFlags);
            }
            catch (PatternSyntaxException pse) {
                this.errors.add((Object)(jEdit.getProperty((String)"options.console.errors.warning") + pse.getDescription()));
            }
        }
        if (this.extraPattern != null && this.extraPattern.length() != 0) {
            try {
                this.extraRE = Pattern.compile(this.extraPattern, compileFlags);
            }
            catch (PatternSyntaxException pse) {
                this.errors.add((Object)(jEdit.getProperty((String)"options.console.errors.extra") + pse.getMessage()));
            }
        }
        this.isValid = this.errors.size() == 0;
        return this.isValid;
    }

    private ErrorMatcher() {
    }

    public ErrorMatcher(String internalName) {
        this.load(internalName);
    }

    public String getErrors() {
        if (this.errors == null) {
            return "no errors.";
        }
        if (this.errors.size() == 0) {
            return "no errors.";
        }
        return "Error -  " + this.errors.join("\n  - ");
    }

    public DefaultErrorSource.DefaultError match(View view, String text, String directory, ErrorSource errorSource) {
        String t = this.matchLine(text);
        if (t == null) {
            return null;
        }
        String _filename = MiscUtilities.constructPath((String)directory, (String)this.file);
        File f = new File(_filename);
        if (!f.exists()) {
            _filename = this.file;
        }
        try {
            return new DefaultErrorSource.DefaultError(errorSource, this.type, _filename, Math.max(0, Integer.parseInt(this.line) - 1), 0, 0, this.message);
        }
        catch (NumberFormatException nf) {
            return null;
        }
    }

    public String matchExtra(String text) {
        if (this.extraRE == null) {
            return null;
        }
        Matcher matcher = this.extraRE.matcher(text);
        if (matcher.matches()) {
            return matcher.replaceFirst("$1");
        }
        return null;
    }

    public void load(String iname) {
        this.internalName = ErrorMatcher.internalName(iname);
        this.name = jEdit.getProperty((String)("console.error." + this.internalName + ".name"));
        this.error = jEdit.getProperty((String)("console.error." + this.internalName + ".match"));
        this.warning = jEdit.getProperty((String)("console.error." + this.internalName + ".warning"));
        this.extraPattern = jEdit.getProperty((String)("console.error." + this.internalName + ".extra"));
        this.fileBackref = jEdit.getProperty((String)("console.error." + this.internalName + ".filename"));
        this.lineBackref = jEdit.getProperty((String)("console.error." + this.internalName + ".line"));
        this.messageBackref = jEdit.getProperty((String)("console.error." + this.internalName + ".message"));
        this.testText = jEdit.getProperty((String)("console.error." + this.internalName + ".testtext"), (String)"\n\n\n\n\n");
        if (!this.isValid()) {
            Log.log((int)9, ErrorMatcher.class, (Object)("Invalid regexp in matcher " + this.internalName()));
        }
    }

    public void save() {
        jEdit.setProperty((String)("console.error." + this.internalName() + ".testtext"), (String)this.testText);
        jEdit.setProperty((String)("console.error." + this.internalName() + ".name"), (String)this.name);
        jEdit.setProperty((String)("console.error." + this.internalName + ".match"), (String)this.error);
        jEdit.setProperty((String)("console.error." + this.internalName + ".warning"), (String)this.warning);
        jEdit.setProperty((String)("console.error." + this.internalName + ".extra"), (String)this.extraPattern);
        jEdit.setProperty((String)("console.error." + this.internalName + ".filename"), (String)this.fileBackref);
        jEdit.setProperty((String)("console.error." + this.internalName + ".line"), (String)this.lineBackref);
        jEdit.setProperty((String)("console.error." + this.internalName + ".message"), (String)this.messageBackref);
    }

    public String toString() {
        return this.name;
    }
}

