/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.StatusBar;
import org.gjt.sp.jedit.jEdit;
import org.jedit.keymap.Keymap;

public class EnhancedMenuItem
extends JMenuItem {
    static Font acceleratorFont;
    static Color acceleratorForeground;
    static Color acceleratorSelectionForeground;
    private String shortcut;
    private String action;

    public EnhancedMenuItem(String label, String action, ActionContext context) {
        this.action = action;
        this.shortcut = GUIUtilities.getShortcutLabel(action);
        String toolTip = jEdit.getProperty(action + ".tooltip");
        if (toolTip != null) {
            this.setToolTipText(toolTip);
        }
        if (OperatingSystem.hasScreenMenuBar() && this.shortcut != null) {
            if (jEdit.getBooleanProperty("menu.multiShortcut", false)) {
                this.setText(label + " ( " + this.shortcut + " )");
            } else {
                this.setText(label);
                Keymap keymap = jEdit.getKeymapManager().getKeymap();
                String rawShortcut = keymap.getShortcut(action + ".shortcut");
                KeyStroke key = KeyEventTranslator.parseKeyStroke(rawShortcut);
                if (key != null) {
                    this.setAccelerator(key);
                }
            }
            this.shortcut = null;
        } else {
            this.setText(label);
        }
        if (action != null) {
            this.setEnabled(true);
            this.addActionListener(new EditAction.Wrapper(context, action));
            this.addMouseListener(new MouseHandler());
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.shortcut != null) {
            d.width += this.getFontMetrics(acceleratorFont).stringWidth(this.shortcut) + 15;
        }
        return d;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.shortcut != null) {
            g.setFont(acceleratorFont);
            g.setColor(this.getModel().isArmed() ? acceleratorSelectionForeground : acceleratorForeground);
            FontMetrics fm = g.getFontMetrics();
            Insets insets = this.getInsets();
            g.drawString(this.shortcut, this.getWidth() - (fm.stringWidth(this.shortcut) + insets.right + insets.left + 5), this.getFont().getSize() + (insets.top - (OperatingSystem.isMacOSLF() ? 0 : 1)));
        }
    }

    static {
        String shortcutFont = OperatingSystem.isMacOSLF() ? "Lucida Grande" : "Monospaced";
        acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        if (acceleratorFont == null) {
            acceleratorFont = new Font(shortcutFont, 0, 12);
        }
        if ((acceleratorForeground = UIManager.getColor("MenuItem.acceleratorForeground")) == null) {
            acceleratorForeground = Color.black;
        }
        if ((acceleratorSelectionForeground = UIManager.getColor("MenuItem.acceleratorSelectionForeground")) == null) {
            acceleratorSelectionForeground = Color.black;
        }
    }

    class MouseHandler
    extends MouseAdapter {
        boolean msgSet = false;
        private String msg;

        MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.cleanupStatusBar(evt);
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            this.msg = jEdit.getProperty(EnhancedMenuItem.this.action + ".mouse-over");
            if (this.msg != null) {
                GUIUtilities.getView((Component)evt.getSource()).getStatus().setMessage(this.msg);
                this.msgSet = true;
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            this.cleanupStatusBar(evt);
        }

        private void cleanupStatusBar(MouseEvent evt) {
            if (this.msgSet) {
                StatusBar statusBar = GUIUtilities.getView((Component)evt.getSource()).getStatus();
                if (this.msg == statusBar.getMessage()) {
                    statusBar.setMessage(null);
                }
                this.msgSet = false;
                this.msg = null;
            }
        }
    }
}

