/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class PropertyManager {
    private final Properties system = new Properties();
    private final List<Properties> plugins = new LinkedList<Properties>();
    private final Properties site = new Properties();
    private final Properties localization = new Properties();
    private final Properties user = new Properties();

    PropertyManager() {
    }

    Properties getProperties() {
        Properties total = new Properties();
        total.putAll((Map<?, ?>)this.system);
        for (Properties plugin : this.plugins) {
            total.putAll((Map<?, ?>)plugin);
        }
        total.putAll((Map<?, ?>)this.site);
        total.putAll((Map<?, ?>)this.localization);
        total.putAll((Map<?, ?>)this.user);
        return total;
    }

    void loadSystemProps(InputStream in) throws IOException {
        PropertyManager.loadProps(this.system, in);
    }

    void loadSystemProps(Reader in) throws IOException {
        PropertyManager.loadProps(this.system, in);
    }

    void loadSiteProps(InputStream in) throws IOException {
        PropertyManager.loadProps(this.site, in);
    }

    void loadLocalizationProps(Reader in) throws IOException {
        if (in == null) {
            this.localization.clear();
        } else {
            PropertyManager.loadProps(this.localization, in);
        }
    }

    void loadUserProps(InputStream in) throws IOException {
        PropertyManager.loadProps(this.user, in);
    }

    void saveUserProps(OutputStream out) throws IOException {
        this.user.store(out, "jEdit properties");
    }

    Properties loadPluginProps(InputStream in) throws IOException {
        Properties plugin = new Properties();
        PropertyManager.loadProps(plugin, in);
        this.plugins.add(plugin);
        return plugin;
    }

    void addPluginProps(Properties props) {
        this.plugins.add(props);
    }

    void removePluginProps(Properties props) {
        this.plugins.remove(props);
    }

    String getProperty(String name) {
        String value = this.user.getProperty(name);
        if (value != null) {
            return value;
        }
        value = this.localization.getProperty(name);
        if (value != null) {
            return value;
        }
        return this.getDefaultProperty(name);
    }

    void setProperty(String name, String value) {
        String prop = this.getDefaultProperty(name);
        if (value == null) {
            if (prop == null || prop.length() == 0) {
                this.user.remove(name);
            } else {
                this.user.setProperty(name, "");
            }
        } else if (value.equals(prop)) {
            this.user.remove(name);
        } else {
            this.user.setProperty(name, value);
        }
    }

    public void setTemporaryProperty(String name, String value) {
        this.user.remove(name);
        this.system.setProperty(name, value);
    }

    void unsetProperty(String name) {
        if (this.getDefaultProperty(name) != null) {
            this.user.setProperty(name, "");
        } else {
            this.user.remove(name);
        }
    }

    public void resetProperty(String name) {
        this.user.remove(name);
    }

    private String getDefaultProperty(String name) {
        String value = this.site.getProperty(name);
        if (value != null) {
            return value;
        }
        for (Properties plugin : this.plugins) {
            value = plugin.getProperty(name);
            if (value == null) continue;
            return value;
        }
        return this.system.getProperty(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProps(Properties into, InputStream in) throws IOException {
        try {
            into.load(in);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProps(Properties into, Reader in) throws IOException {
        try {
            into.load(in);
        }
        finally {
            in.close();
        }
    }
}

