/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.PerspectiveManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class EditServer
extends Thread {
    private String portFile;
    private ServerSocket socket;
    private int authKey;
    private boolean ok;
    private boolean abort;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EditServer(String portFile) {
        super("jEdit server daemon [" + portFile + "]");
        this.setDaemon(true);
        this.portFile = portFile;
        try {
            if (OperatingSystem.isUnix()) {
                new File(portFile).createNewFile();
                FileVFS.setPermissions(portFile, 384);
            }
            this.socket = new ServerSocket(0, 2, InetAddress.getByName("127.0.0.1"));
            this.authKey = new Random().nextInt(Integer.MAX_VALUE);
            int port = this.socket.getLocalPort();
            FileWriter out = new FileWriter(portFile);
            try {
                out.write("b\n");
                out.write(String.valueOf(port));
                out.write("\n");
                out.write(String.valueOf(this.authKey));
                out.write("\n");
            }
            finally {
                out.close();
            }
            this.ok = true;
            Log.log(1, this, "jEdit server started on port " + this.socket.getLocalPort());
            Log.log(1, this, "Authorization key is " + this.authKey);
        }
        catch (IOException io) {
            Log.log(5, this, io);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.abort) {
            Socket client = null;
            try {
                client = this.socket.accept();
                client.setSoTimeout(1000);
                Log.log(3, this, client + ": connected");
                DataInputStream in = new DataInputStream(client.getInputStream());
                if (this.handleClient(client, in)) continue;
                this.abort = true;
            }
            catch (Exception e) {
                if (!this.abort) {
                    Log.log(9, this, e);
                }
                this.abort = true;
            }
        }
        return;
    }

    public static void handleClient(boolean restore, String parent, String[] args) {
        EditServer.handleClient(restore, false, false, parent, args);
    }

    public static Buffer handleClient(boolean restore, boolean newView, boolean newPlainView, String parent, String[] args) {
        if (jEdit.getFirstView() == null) {
            boolean hasBufferArgs = false;
            for (String arg : args) {
                if (arg == null) continue;
                hasBufferArgs = true;
                break;
            }
            boolean restoreFiles = restore && jEdit.getBooleanProperty("restore") && (!hasBufferArgs || jEdit.getBooleanProperty("restore.cli"));
            View view = PerspectiveManager.loadPerspective(restoreFiles);
            Buffer buffer = jEdit.openFiles(view, parent, args);
            if (view == null) {
                if (buffer == null) {
                    buffer = jEdit.getFirstBuffer();
                }
                jEdit.newView(null, buffer);
            } else if (buffer != null) {
                view.setBuffer(buffer, false);
            }
            return buffer;
        }
        if (newPlainView) {
            Buffer buffer = jEdit.openFiles(null, parent, args);
            if (buffer == null) {
                buffer = jEdit.getFirstBuffer();
            }
            jEdit.newView(null, buffer, true);
            return buffer;
        }
        if (newView) {
            Buffer buffer = jEdit.openFiles(null, parent, args);
            if (buffer == null) {
                buffer = jEdit.getFirstBuffer();
            }
            jEdit.newView(jEdit.getActiveView(), buffer, false);
            return buffer;
        }
        View view = jEdit.getActiveView();
        Buffer buffer = jEdit.openFiles(view, parent, args);
        if (jEdit.getBooleanProperty("server.brokenToFront")) {
            view.setState(1);
        }
        view.setState(0);
        view.requestFocus();
        view.toFront();
        if (!view.isAlwaysOnTop()) {
            view.setAlwaysOnTop(true);
            view.setAlwaysOnTop(false);
        }
        return buffer;
    }

    boolean isOK() {
        return this.ok;
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    void stopServer() {
        this.abort = true;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        new File(this.portFile).delete();
    }

    private boolean handleClient(final Socket client, DataInputStream in) throws Exception {
        int key = in.readInt();
        if (key != this.authKey) {
            Log.log(9, this, client + ": wrong" + " authorization key (got " + key + ", expected " + this.authKey + ")");
            in.close();
            client.close();
            return false;
        }
        client.setSoTimeout(0);
        Log.log(1, this, client + ": authenticated" + " successfully");
        final String script = in.readUTF();
        Log.log(1, this, script);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    NameSpace ns = new NameSpace(BeanShell.getNameSpace(), "EditServer namespace");
                    ns.setVariable("socket", client);
                    BeanShell.eval(null, ns, script);
                }
                catch (UtilEvalError e) {
                    Log.log(9, this, e);
                }
                finally {
                    try {
                        BeanShell.getNameSpace().setVariable("socket", null);
                    }
                    catch (UtilEvalError e) {
                        Log.log(9, this, e);
                    }
                }
            }
        });
        return true;
    }
}

