/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.TextListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.OptionGroup;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.gui.OptionsDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StringModel;

public class OptionGroupPane
extends AbstractOptionPane
implements TreeSelectionListener {
    OptionGroup optionGroup;
    JSplitPane splitter;
    JTree paneTree;
    OptionPane currentPane;
    OptionTreeModel optionTreeModel;
    HashMap<Object, OptionPane> deferredOptionPanes;
    JPanel stage;
    StringModel title = new StringModel();

    public OptionGroupPane(OptionGroup group) {
        super(group.getName());
        this.optionGroup = group;
        this.init();
    }

    void addTextListener(TextListener l) {
        this.title.addTextListener(l);
    }

    public String getTitle() {
        return this.title.toString();
    }

    void setTitle(String newTitle) {
        this.title.setText(newTitle);
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        int i;
        TreePath path = evt.getPath();
        if (path == null) {
            return;
        }
        Object lastPathComponent = path.getLastPathComponent();
        if (!(lastPathComponent instanceof String) && !(lastPathComponent instanceof OptionPane)) {
            return;
        }
        Object[] nodes = path.getPath();
        StringBuffer buf = new StringBuffer();
        OptionPane optionPane = null;
        int lastIdx = nodes.length - 1;
        int n = i = this.paneTree.isRootVisible() ? 0 : 1;
        while (i <= lastIdx) {
            block12: {
                String label;
                block10: {
                    String propName;
                    block13: {
                        Object node;
                        block11: {
                            block9: {
                                node = nodes[i];
                                if (!(node instanceof OptionPane)) break block9;
                                optionPane = (OptionPane)node;
                                label = jEdit.getProperty("options." + optionPane.getName() + ".label");
                                break block10;
                            }
                            if (!(node instanceof OptionGroup)) break block11;
                            label = ((OptionGroup)node).getLabel();
                            break block10;
                        }
                        if (!(node instanceof String)) break block12;
                        label = jEdit.getProperty("options." + node + ".label");
                        optionPane = this.deferredOptionPanes.get((String)node);
                        if (optionPane != null) break block10;
                        propName = "options." + node + ".code";
                        String code = jEdit.getProperty(propName);
                        if (code == null) break block13;
                        optionPane = (OptionPane)BeanShell.eval(jEdit.getActiveView(), BeanShell.getNameSpace(), code);
                        if (optionPane == null) break block12;
                        this.deferredOptionPanes.put(node, optionPane);
                        break block10;
                    }
                    Log.log(9, this, propName + " not defined");
                    break block12;
                }
                if (label != null) {
                    buf.append(label);
                }
                if (i > 0 && i < lastIdx) {
                    buf.append(": ");
                }
            }
            ++i;
        }
        if (optionPane == null) {
            return;
        }
        String ttext = jEdit.getProperty("optional.title-template", new Object[]{this.optionGroup.getName(), buf.toString()});
        this.setTitle(ttext);
        try {
            optionPane.init();
        }
        catch (Throwable t) {
            Log.log(9, this, "Error initializing option pane:");
            Log.log(9, this, t);
        }
        if (this.currentPane != null) {
            this.stage.remove(this.currentPane.getComponent());
        }
        this.currentPane = optionPane;
        this.stage.add("Center", this.currentPane.getComponent());
        this.stage.revalidate();
        this.stage.repaint();
        this.currentPane = optionPane;
    }

    private boolean selectPane(OptionGroup node, String name) {
        return this.selectPane(node, name, new ArrayList<Object>());
    }

    private boolean selectPane(OptionGroup node, String name, ArrayList<Object> path) {
        path.add(node);
        Enumeration<Object> e = node.getMembers();
        while (e.hasMoreElements()) {
            Object pane;
            TreePath treePath;
            Object obj = e.nextElement();
            if (obj instanceof OptionGroup) {
                OptionGroup grp = (OptionGroup)obj;
                if (grp.getName().equals(name)) {
                    path.add(grp);
                    path.add(grp.getMember(0));
                    treePath = new TreePath(path.toArray());
                    if (treePath == null) continue;
                    this.paneTree.scrollPathToVisible(treePath);
                    this.paneTree.setSelectionPath(treePath);
                    return true;
                }
                if (!this.selectPane((OptionGroup)obj, name, path)) continue;
                return true;
            }
            if (obj instanceof OptionPane) {
                pane = (OptionPane)obj;
                if (!pane.getName().equals(name) && name != null) continue;
                path.add(pane);
                treePath = new TreePath(path.toArray());
                this.paneTree.scrollPathToVisible(treePath);
                this.paneTree.setSelectionPath(treePath);
                return true;
            }
            if (!(obj instanceof String) || !((String)(pane = (String)obj)).equals(name) && name != null) continue;
            path.add(pane);
            treePath = new TreePath(path.toArray());
            this.paneTree.scrollPathToVisible(treePath);
            try {
                this.paneTree.setSelectionPath(treePath);
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            return true;
        }
        path.remove(node);
        return false;
    }

    @Override
    protected void _init() {
        this.setLayout(new BorderLayout());
        this.deferredOptionPanes = new HashMap();
        this.optionTreeModel = new OptionTreeModel();
        OptionGroup rootGroup = (OptionGroup)this.optionTreeModel.getRoot();
        Enumeration<Object> members = this.optionGroup.getMembers();
        while (members.hasMoreElements()) {
            Object member = members.nextElement();
            if (member instanceof OptionGroup) {
                rootGroup.addOptionGroup((OptionGroup)member);
                continue;
            }
            if (!(member instanceof String)) continue;
            rootGroup.addOptionPane((String)member);
        }
        this.paneTree = new JTree(this.optionTreeModel);
        this.paneTree.setRootVisible(false);
        this.paneTree.setCellRenderer(new OptionsDialog.PaneNameRenderer());
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.add((Component)content, "Center");
        this.stage = new JPanel(new BorderLayout());
        if (!OperatingSystem.isMacOSLF()) {
            this.paneTree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.paneTree.setShowsRootHandles(true);
        this.paneTree.setRootVisible(false);
        JScrollPane scroller = new JScrollPane(this.paneTree, 22, 30);
        scroller.setMinimumSize(new Dimension(120, 0));
        this.splitter = new JSplitPane(1, scroller, new JScrollPane(this.stage));
        content.add((Component)this.splitter, "Center");
        this.paneTree.getSelectionModel().addTreeSelectionListener(this);
        OptionGroup rootNode = (OptionGroup)this.paneTree.getModel().getRoot();
        String name = this.optionGroup.getName();
        String pane = jEdit.getProperty(name + ".last");
        this.selectPane(rootNode, pane);
        this.paneTree.setVisibleRowCount(1);
        int dividerLocation = jEdit.getIntegerProperty(name + ".splitter", -1);
        if (dividerLocation != -1) {
            this.splitter.setDividerLocation(dividerLocation);
        } else {
            this.splitter.setDividerLocation(this.paneTree.getPreferredSize().width + scroller.getVerticalScrollBar().getPreferredSize().width);
        }
    }

    @Override
    protected void _save() {
        if (this.currentPane != null) {
            jEdit.setProperty(this.getName() + ".last", this.currentPane.getName());
        }
        int dividerPosition = this.splitter.getDividerLocation();
        jEdit.setIntegerProperty(this.optionGroup.getName() + ".splitter", dividerPosition);
        this.save(this.optionGroup);
    }

    private void save(Object obj) {
        if (obj instanceof OptionGroup) {
            OptionGroup grp = (OptionGroup)obj;
            Enumeration<Object> members = grp.getMembers();
            while (members.hasMoreElements()) {
                this.save(members.nextElement());
            }
        } else if (obj instanceof OptionPane) {
            try {
                ((OptionPane)obj).save();
            }
            catch (Throwable t) {
                Log.log(9, this, "Error saving options:");
                Log.log(9, this, t);
            }
        } else if (obj instanceof String) {
            this.save(this.deferredOptionPanes.get(obj));
        }
    }

    public class OptionTreeModel
    implements TreeModel {
        private OptionGroup root = new OptionGroup(null);
        private EventListenerList listenerList = new EventListenerList();

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listenerList.add(TreeModelListener.class, l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listenerList.remove(TreeModelListener.class, l);
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent instanceof OptionGroup) {
                return ((OptionGroup)parent).getMember(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof OptionGroup) {
                return ((OptionGroup)parent).getMemberCount();
            }
            return 0;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof OptionGroup) {
                return ((OptionGroup)parent).getMemberIndex(child);
            }
            return -1;
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public boolean isLeaf(Object node) {
            return !(node instanceof OptionGroup);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        protected void fireNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                if (modelEvent == null) {
                    modelEvent = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesChanged(modelEvent);
            }
        }

        protected void fireNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                if (modelEvent == null) {
                    modelEvent = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesInserted(modelEvent);
            }
        }

        protected void fireNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                if (modelEvent == null) {
                    modelEvent = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(modelEvent);
            }
        }

        protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                if (modelEvent == null) {
                    modelEvent = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeStructureChanged(modelEvent);
            }
        }
    }
}

