/*
 * Decompiled with CFR 0.152.
 */
package jcfunc;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jcfunc.CF;
import jcfunc.Description;
import jcfunc.Sequences;

public class escMatcher {
    private int MATCH_MODE;
    private int COMPILE_FLAG;
    private Pattern basePattern;
    private Pattern commonPattern;
    private Pattern searchPattern;
    private EnumMap<CF, Pattern> workPatterns = new EnumMap(CF.class);
    private String DIVIDER = ";";
    private Pattern replace4spliting = Pattern.compile("[^0-9" + this.DIVIDER + "]");
    private CF notFound;

    private Pattern returnPattern(String str) {
        return Pattern.compile(str, this.COMPILE_FLAG);
    }

    public escMatcher(int mode, int compileFlag) {
        this.MATCH_MODE = mode;
        this.COMPILE_FLAG = compileFlag;
        this.basePattern = this.returnPattern(Sequences.getCFPattern(CF.CSI, this.MATCH_MODE));
        this.commonPattern = this.returnPattern(Sequences.getCommonCFPattern(this.MATCH_MODE, true));
        this.searchPattern = this.returnPattern(".*?" + Sequences.getCFPattern(CF.CSI, this.MATCH_MODE));
        this.notFound = CF.NUL;
    }

    public void setPatterns(CF ... cmds) {
        EnumMap<CF, Sequences.Record> newMap = cmds == null || cmds.length == 0 ? Sequences.generateFullWorkingSet() : Sequences.generateWorkingSet(cmds);
        this.workPatterns.clear();
        boolean is8bit = this.MATCH_MODE == 1;
        for (Map.Entry<CF, Sequences.Record> entry : newMap.entrySet()) {
            String str;
            if (entry.getKey() == CF.CSI || (str = is8bit ? entry.getValue().pattern8 : entry.getValue().pattern7) == null) continue;
            this.workPatterns.put((CF)((Enum)entry.getKey()), Pattern.compile(str));
        }
    }

    public boolean matches(String inputString) {
        return this.searchPattern.matcher(inputString).lookingAt();
    }

    public String remove(String inputString, CF func) {
        if (!this.workPatterns.isEmpty() && this.workPatterns.containsKey((Object)func)) {
            return this.workPatterns.get((Object)func).matcher(inputString).replaceAll("");
        }
        return inputString;
    }

    public String removeAll(String inputString) {
        return this.commonPattern.matcher(inputString).replaceAll("");
    }

    public ArrayList<Description> parse(String inputString) {
        return this.parse(inputString, false);
    }

    public ArrayList<Description> parse(String inputString, boolean ignorSequences) {
        if (this.workPatterns == null || this.workPatterns.isEmpty()) {
            return null;
        }
        ArrayList<Description> returnedList = null;
        TreeMap<Integer, String> internalMap = new TreeMap<Integer, String>();
        Matcher matcher = this.basePattern.matcher(inputString);
        int[] result = new int[]{0, 0, 0};
        int prevBegining = -1;
        while (matcher.find()) {
            int newBegining = matcher.start();
            if (prevBegining != -1) {
                internalMap.put(new Integer(prevBegining), new String(inputString.substring(prevBegining, newBegining)));
            } else {
                result[0] = newBegining;
            }
            prevBegining = newBegining;
        }
        if (prevBegining != -1) {
            internalMap.put(new Integer(prevBegining), new String(inputString.substring(prevBegining)));
        }
        if (internalMap.size() > 0) {
            returnedList = new ArrayList<Description>(internalMap.size());
            for (Map.Entry keyValue : internalMap.entrySet()) {
                int[] params;
                String processingStr = (String)keyValue.getValue();
                CF foundCF = null;
                matcher = null;
                for (Map.Entry<CF, Pattern> pattern : this.workPatterns.entrySet()) {
                    matcher = pattern.getValue().matcher(processingStr);
                    if (!matcher.lookingAt()) continue;
                    foundCF = pattern.getKey();
                    break;
                }
                if (foundCF == null) {
                    foundCF = this.notFound;
                    matcher = null;
                }
                if (matcher != null) {
                    int end = matcher.end();
                    String[] strArr = this.replace4spliting.matcher(this.basePattern.matcher(processingStr.substring(matcher.start(), end)).replaceAll("")).replaceAll(this.DIVIDER).split(this.DIVIDER, 0);
                    params = new int[strArr.length];
                    for (int i = 0; i < strArr.length; ++i) {
                        params[i] = Integer.decode(strArr[i]);
                    }
                } else {
                    params = new int[]{};
                }
                result[2] = result[1] = result[0];
                result[2] = ignorSequences ? result[2] + this.removeAll(processingStr).length() : result[2] + processingStr.length();
                result[0] = result[2];
                returnedList.add(new Description(result[1], result[2], foundCF, params));
            }
        }
        return returnedList;
    }
}

