/*
 * Decompiled with CFR 0.152.
 */
package jcfunc;

import java.util.EnumMap;
import jcfunc.CF;

public class Sequences {
    public static final int MODE_7BIT = 0;
    public static final int MODE_8BIT = 1;
    private static final String Pn = "[0-9:]*";
    private static final String Pn2 = String.format("%s;%s", "[0-9:]*", "[0-9:]*");
    private static final String Pna = String.format("%s(?:;%s)*", "[0-9:]*", "[0-9:]*");

    private static String[] getC0(C0 key) {
        switch (key) {
            case NUL: {
                return new String[]{"\\x00", "\\x00"};
            }
            case SOH: {
                return new String[]{"\\x01", "\\x01"};
            }
            case STX: {
                return new String[]{"\\x02", "\\x02"};
            }
            case ETX: {
                return new String[]{"\\x03", "\\x03"};
            }
            case EOT: {
                return new String[]{"\\x04", "\\x04"};
            }
            case ENQ: {
                return new String[]{"\\x05", "\\x05"};
            }
            case ACK: {
                return new String[]{"\\x06", "\\x06"};
            }
            case BEL: {
                return new String[]{"\\x07", "\\x07"};
            }
            case BS: {
                return new String[]{"\\x08", "\\x08"};
            }
            case HT: {
                return new String[]{"\\x09", "\\x09"};
            }
            case LF: {
                return new String[]{"\\x0A", "\\x0A"};
            }
            case VT: {
                return new String[]{"\\x0B", "\\x0B"};
            }
            case FF: {
                return new String[]{"\\x0C", "\\x0C"};
            }
            case CR: {
                return new String[]{"\\x0D", "\\x0D"};
            }
            case LS1: {
                return new String[]{"\\x0E", "\\x0E"};
            }
            case LS0: {
                return new String[]{"\\x0F", "\\x0F"};
            }
            case DLE: {
                return new String[]{"\\x10", "\\x10"};
            }
            case DC1: {
                return new String[]{"\\x11", "\\x11"};
            }
            case DC2: {
                return new String[]{"\\x12", "\\x12"};
            }
            case DC3: {
                return new String[]{"\\x13", "\\x13"};
            }
            case DC4: {
                return new String[]{"\\x14", "\\x14"};
            }
            case NAK: {
                return new String[]{"\\x15", "\\x15"};
            }
            case SYN: {
                return new String[]{"\\x16", "\\x16"};
            }
            case ETB: {
                return new String[]{"\\x17", "\\x17"};
            }
            case CAN: {
                return new String[]{"\\x18", "\\x18"};
            }
            case EM: {
                return new String[]{"\\x19", "\\x19"};
            }
            case SUB: {
                return new String[]{"\\x1A", "\\x1A"};
            }
            case ESC: {
                return new String[]{"\\x1B", "\\x1B"};
            }
            case IS4: {
                return new String[]{"\\x1C", "\\x1C"};
            }
            case IS3: {
                return new String[]{"\\x1D", "\\x1D"};
            }
            case IS2: {
                return new String[]{"\\x1E", "\\x1E"};
            }
            case IS1: {
                return new String[]{"\\x1F", "\\x1F"};
            }
        }
        return null;
    }

    private static String[] getC1(C1 key, String esc) {
        switch (key) {
            case BPH: {
                return new String[]{esc + "\\x42", "\\x82"};
            }
            case NBH: {
                return new String[]{esc + "\\x43", "\\x83"};
            }
            case NEL: {
                return new String[]{esc + "\\x45", "\\x85"};
            }
            case SSA: {
                return new String[]{esc + "\\x46", "\\x86"};
            }
            case ESA: {
                return new String[]{esc + "\\x47", "\\x87"};
            }
            case HTS: {
                return new String[]{esc + "\\x48", "\\x88"};
            }
            case HTJ: {
                return new String[]{esc + "\\x49", "\\x89"};
            }
            case VTS: {
                return new String[]{esc + "\\x4A", "\\x8A"};
            }
            case PLD: {
                return new String[]{esc + "\\x4B", "\\x8B"};
            }
            case PLU: {
                return new String[]{esc + "\\x4C", "\\x8C"};
            }
            case RI: {
                return new String[]{esc + "\\x4D", "\\x8D"};
            }
            case SS2: {
                return new String[]{esc + "\\x4E", "\\x8E"};
            }
            case SS3: {
                return new String[]{esc + "\\x4F", "\\x8F"};
            }
            case DCS: {
                return new String[]{esc + "\\x50", "\\x90"};
            }
            case PU1: {
                return new String[]{esc + "\\x51", "\\x91"};
            }
            case PU2: {
                return new String[]{esc + "\\x52", "\\x92"};
            }
            case STS: {
                return new String[]{esc + "\\x53", "\\x93"};
            }
            case CCH: {
                return new String[]{esc + "\\x54", "\\x94"};
            }
            case MW: {
                return new String[]{esc + "\\x55", "\\x95"};
            }
            case SPA: {
                return new String[]{esc + "\\x56", "\\x96"};
            }
            case EPA: {
                return new String[]{esc + "\\x57", "\\x97"};
            }
            case SOS: {
                return new String[]{esc + "\\x58", "\\x98"};
            }
            case SCI: {
                return new String[]{esc + "\\x5A", "\\x9A"};
            }
            case CSI: {
                return new String[]{esc + "\\x5B", "\\x9B"};
            }
            case ST: {
                return new String[]{esc + "\\x5C", "\\x9C"};
            }
            case OSC: {
                return new String[]{esc + "\\x5D", "\\x9D"};
            }
            case PM: {
                return new String[]{esc + "\\x5E", "\\x9E"};
            }
            case APC: {
                return new String[]{esc + "\\x5F", "\\x9F"};
            }
        }
        return null;
    }

    private static Record getRecordByCF(CF func) {
        String ESC = Sequences.getC0(C0.ESC)[0];
        String[] CSI = Sequences.getC1(C1.CSI, ESC);
        String str = "";
        switch (func) {
            case ACK: {
                return new Record(Sequences.getC0(C0.ACK));
            }
            case APC: {
                return new Record(Sequences.getC1(C1.APC, ESC));
            }
            case BEL: {
                return new Record(Sequences.getC0(C0.BEL));
            }
            case BPH: {
                return new Record(Sequences.getC1(C1.BPH, ESC));
            }
            case BS: {
                return new Record(Sequences.getC0(C0.BS));
            }
            case CAN: {
                return new Record(Sequences.getC0(C0.CAN));
            }
            case CCH: {
                return new Record(Sequences.getC1(C1.CCH, ESC));
            }
            case CR: {
                return new Record(Sequences.getC0(C0.CR));
            }
            case CSI: {
                return new Record(Sequences.getC1(C1.CSI, ESC));
            }
            case DC1: {
                return new Record(Sequences.getC0(C0.DC1));
            }
            case DC2: {
                return new Record(Sequences.getC0(C0.DC2));
            }
            case DC3: {
                return new Record(Sequences.getC0(C0.DC3));
            }
            case DC4: {
                return new Record(Sequences.getC0(C0.DC4));
            }
            case DCS: {
                return new Record(Sequences.getC1(C1.DCS, ESC));
            }
            case DLE: {
                return new Record(Sequences.getC0(C0.DLE));
            }
            case EM: {
                return new Record(Sequences.getC0(C0.EM));
            }
            case ENQ: {
                return new Record(Sequences.getC0(C0.ENQ));
            }
            case EOT: {
                return new Record(Sequences.getC0(C0.EOT));
            }
            case EPA: {
                return new Record(Sequences.getC1(C1.EPA, ESC));
            }
            case ESA: {
                return new Record(Sequences.getC1(C1.ESA, ESC));
            }
            case ESC: {
                return new Record(Sequences.getC0(C0.ESC));
            }
            case ETB: {
                return new Record(Sequences.getC0(C0.ETB));
            }
            case ETX: {
                return new Record(Sequences.getC0(C0.ETX));
            }
            case FF: {
                return new Record(Sequences.getC0(C0.FF));
            }
            case HT: {
                return new Record(Sequences.getC0(C0.HT));
            }
            case HTJ: {
                return new Record(Sequences.getC1(C1.HTJ, ESC));
            }
            case HTS: {
                return new Record(Sequences.getC1(C1.HTS, ESC));
            }
            case IS1: {
                return new Record(Sequences.getC0(C0.IS1));
            }
            case IS2: {
                return new Record(Sequences.getC0(C0.IS2));
            }
            case IS3: {
                return new Record(Sequences.getC0(C0.IS3));
            }
            case IS4: {
                return new Record(Sequences.getC0(C0.IS4));
            }
            case LF: {
                return new Record(Sequences.getC0(C0.LF));
            }
            case LS0: {
                return new Record(null, Sequences.getC0(C0.LS0)[1]);
            }
            case LS1: {
                return new Record(null, Sequences.getC0(C0.LS0)[1]);
            }
            case MW: {
                return new Record(Sequences.getC1(C1.MW, ESC));
            }
            case NAK: {
                return new Record(Sequences.getC0(C0.NAK));
            }
            case NBH: {
                return new Record(Sequences.getC1(C1.NBH, ESC));
            }
            case NEL: {
                return new Record(Sequences.getC1(C1.NEL, ESC));
            }
            case NUL: {
                return new Record(Sequences.getC0(C0.NUL));
            }
            case OSC: {
                return new Record(Sequences.getC1(C1.OSC, ESC));
            }
            case PLD: {
                return new Record(Sequences.getC1(C1.PLD, ESC));
            }
            case PLU: {
                return new Record(Sequences.getC1(C1.PLU, ESC));
            }
            case PM: {
                return new Record(Sequences.getC1(C1.PM, ESC));
            }
            case PU1: {
                return new Record(Sequences.getC1(C1.PU1, ESC));
            }
            case PU2: {
                return new Record(Sequences.getC1(C1.PU2, ESC));
            }
            case RI: {
                return new Record(Sequences.getC1(C1.RI, ESC));
            }
            case SCI: {
                return new Record(Sequences.getC1(C1.SCI, ESC));
            }
            case SI: {
                return new Record(Sequences.getC0(C0.LS0)[0], null);
            }
            case SO: {
                return new Record(Sequences.getC0(C0.LS1)[0], null);
            }
            case SOH: {
                return new Record(Sequences.getC0(C0.SOH));
            }
            case SOS: {
                return new Record(Sequences.getC1(C1.SOS, ESC));
            }
            case SPA: {
                return new Record(Sequences.getC1(C1.SPA, ESC));
            }
            case SS2: {
                return new Record(Sequences.getC1(C1.SS2, ESC));
            }
            case SS3: {
                return new Record(Sequences.getC1(C1.SS3, ESC));
            }
            case SSA: {
                return new Record(Sequences.getC1(C1.SSA, ESC));
            }
            case ST: {
                return new Record(Sequences.getC1(C1.ST, ESC));
            }
            case STS: {
                return new Record(Sequences.getC1(C1.STS, ESC));
            }
            case STX: {
                return new Record(Sequences.getC0(C0.STX));
            }
            case SUB: {
                return new Record(Sequences.getC0(C0.SUB));
            }
            case SYN: {
                return new Record(Sequences.getC0(C0.SYN));
            }
            case VT: {
                return new Record(Sequences.getC0(C0.VT));
            }
            case VTS: {
                return new Record(Sequences.getC1(C1.VTS, ESC));
            }
            case CBT: {
                str = Pn + (Object)((Object)Sym.Z_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case CHA: {
                str = Pn + (Object)((Object)Sym.G_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case CHT: {
                str = Pn + (Object)((Object)Sym.I_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case CMD: {
                str = ESC + (Object)((Object)Sym.D_DN);
                return new Record(str, str);
            }
            case CNL: {
                str = Pn + (Object)((Object)Sym.E_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case CPL: {
                str = Pn + (Object)((Object)Sym.F_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case CPR: {
                str = Pn2 + (Object)((Object)Sym.R_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case CTC: {
                str = Pna + (Object)((Object)Sym.W_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case CUB: {
                str = Pn + (Object)((Object)Sym.D_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case CUD: {
                str = Pn + (Object)((Object)Sym.B_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case CUF: {
                str = Pn + (Object)((Object)Sym.C_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case CUP: {
                str = Pn2 + (Object)((Object)Sym.H_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case CUU: {
                str = Pn + (Object)((Object)Sym.A_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case CVT: {
                str = Pn + (Object)((Object)Sym.Y_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case DA: {
                str = Pn + (Object)((Object)Sym.C_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case DAQ: {
                str = Pna + (Object)((Object)Sym.O_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case DCH: {
                str = Pn + (Object)((Object)Sym.P_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case DL: {
                str = Pn + (Object)((Object)Sym.M_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case DMI: {
                str = ESC + (Object)((Object)Sym.INAP);
                return new Record(str, str);
            }
            case DSR: {
                str = Pn + (Object)((Object)Sym.N_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case DTA: {
                str = Pn2 + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.T_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case EA: {
                str = Pn + (Object)((Object)Sym.O_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case ECH: {
                str = Pn + (Object)((Object)Sym.X_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case ED: {
                str = Pn + (Object)((Object)Sym.J_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case EF: {
                str = Pn + (Object)((Object)Sym.N_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case EL: {
                str = Pn + (Object)((Object)Sym.K_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case EMI: {
                str = ESC + (Object)((Object)Sym.B_DN);
                return new Record(str, str);
            }
            case FNK: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.W_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case FNT: {
                str = Pn2 + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.D_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case GCC: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.UNLN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case GSM: {
                str = Pn2 + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.B_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case GSS: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.C_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case HPA: {
                str = Pn + (Object)((Object)Sym.INAP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case HPB: {
                str = Pn + (Object)((Object)Sym.J_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case HPR: {
                str = Pn + (Object)((Object)Sym.A_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case HVP: {
                str = Pn2 + (Object)((Object)Sym.F_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case ICH: {
                str = Pn + (Object)((Object)Sym.AT);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case IDCS: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.O_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case IGS: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.M_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case IL: {
                str = Pn + (Object)((Object)Sym.L_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case INT: {
                str = ESC + (Object)((Object)Sym.A_DN);
                return new Record(str, str);
            }
            case JFY: {
                str = Pna + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.F_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case LS1R: {
                str = ESC + (Object)((Object)Sym.TWDL);
                return new Record(str, str);
            }
            case LS2: {
                str = ESC + (Object)((Object)Sym.N_DN);
                return new Record(str, str);
            }
            case LS2R: {
                str = ESC + (Object)((Object)Sym.CBRR);
                return new Record(str, str);
            }
            case LS3: {
                str = ESC + (Object)((Object)Sym.O_DN);
                return new Record(str, str);
            }
            case LS3R: {
                str = ESC + (Object)((Object)Sym.STRK);
                return new Record(str, str);
            }
            case MC: {
                str = Pn + (Object)((Object)Sym.I_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case NP: {
                str = Pn + (Object)((Object)Sym.U_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case PEC: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.Z_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case PFS: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.J_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case PP: {
                str = Pn + (Object)((Object)Sym.V_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case PPA: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.P_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case PPB: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.R_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case PPR: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.Q_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case PTX: {
                str = Pn + (Object)((Object)Sym.BKSL);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case QUAD: {
                str = Pna + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.H_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case REP: {
                str = Pn + (Object)((Object)Sym.B_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case RIS: {
                str = ESC + (Object)((Object)Sym.C_DN);
                return new Record(str, str);
            }
            case RM: {
                str = Pna + (Object)((Object)Sym.L_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SACS: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.BKSL);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SAPV: {
                str = Pna + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.QBRL);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SCO: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.E_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SCP: {
                str = Pn2 + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.K_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SCS: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.G_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SD: {
                str = Pn + (Object)((Object)Sym.T_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SDS: {
                str = Pn + (Object)((Object)Sym.QBRL);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SEE: {
                str = Pn + (Object)((Object)Sym.Q_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SEF: {
                str = Pn2 + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.Y_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SGR: {
                str = Pna + (Object)((Object)Sym.M_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SHS: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.K_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SIMD: {
                str = Pn + (Object)((Object)Sym.CRET);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SL: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.AT);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SLH: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.U_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SLL: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.V_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SLS: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.H_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SM: {
                str = Pna + (Object)((Object)Sym.H_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SPD: {
                str = Pn2 + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.S_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SPH: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.I_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SPI: {
                str = Pn2 + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.G_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SPL: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.J_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SPQR: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.X_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SR: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.A_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SRCS: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.F_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SRS: {
                str = Pn + (Object)((Object)Sym.QBRR);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SSU: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.I_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SSW: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.QBRR);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case STAB: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.CRET);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SU: {
                str = Pn + (Object)((Object)Sym.S_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case SVS: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.L_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case TAC: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.B_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case TALE: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.A_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case TATE: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.INAP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case TBC: {
                str = Pn + (Object)((Object)Sym.G_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case TCC: {
                str = Pn2 + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.C_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case TSR: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.D_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case TSS: {
                str = Pn + (Object)((Object)Sym.SPCE) + (Object)((Object)Sym.E_UP);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case VPA: {
                str = Pn + (Object)((Object)Sym.D_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case VPB: {
                str = Pn + (Object)((Object)Sym.K_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
            case VPR: {
                str = Pn + (Object)((Object)Sym.E_DN);
                return new Record(CSI[0] + str, CSI[1] + str);
            }
        }
        return null;
    }

    public static EnumMap<CF, Record> generateFullWorkingSet() {
        return Sequences.generateWorkingSet(CF.values());
    }

    public static EnumMap<CF, Record> generateWorkingSet(CF ... args) {
        EnumMap<CF, Record> retws = new EnumMap<CF, Record>(CF.ACK.getDeclaringClass());
        for (CF element : args) {
            retws.put(element, Sequences.getRecordByCF(element));
        }
        return retws;
    }

    public static String getCFPattern(CF cmd, int mode) {
        if (mode == 1) {
            return Sequences.getRecordByCF((CF)cmd).pattern8;
        }
        return Sequences.getRecordByCF((CF)cmd).pattern7;
    }

    public static String getCommonCFPattern(int mode, boolean exceptLF_CR) {
        if (exceptLF_CR) {
            return Sequences.getCommonCFPattern(mode, new C0[]{C0.LF, C0.CR}, null, null);
        }
        return Sequences.getCommonCFPattern(mode, null, null, null);
    }

    public static String getCommonCFPattern(int mode, C0[] exclC0Set, C1[] exclC1Set, Sym[] exclSymSet) {
        StringBuilder retStr = new StringBuilder();
        String ESC = "";
        int index = mode == 0 ? 0 : 1;
        retStr.append("(?:");
        retStr.append(mode == 0 ? String.format("(?:%s%s|%s)", Sequences.getC0(C0.ESC)[index], Sequences.getC1(C1.CSI, ESC)[index], Sequences.getC0(C0.ESC)[index]) : String.format("(?:%s|%s)", Sequences.getC1(C1.CSI, ESC)[index], Sequences.getC0(C0.ESC)[index])).append(Pna).append(String.format("%s?[%s-%s%s%s%s", new Object[]{Sym.SPCE, Sym.AT, Sym.O_DN, Sym.STRK, Sym.CBRR, Sym.TWDL}));
        if (exclSymSet != null && exclSymSet.length > 0) {
            retStr.append("&&[^");
            for (Sym sym : exclSymSet) {
                retStr.append((Object)sym);
            }
            retStr.append("]");
        }
        retStr.append("])|");
        retStr.append(String.format("[%s-%s", Sequences.getC0(C0.NUL)[index], Sequences.getC0(C0.IS1)[index]));
        if (exclC0Set != null && exclC0Set.length > 0) {
            retStr.append("&&[^");
            for (Enum enum_ : exclC0Set) {
                retStr.append(Sequences.getC0((C0)enum_)[index]);
            }
            retStr.append("]");
        }
        retStr.append("]|");
        retStr.append(mode == 0 ? String.format("%s[%s-%s", Sequences.getC0(C0.ESC)[index], Sequences.getC1(C1.BPH, ESC)[index], Sequences.getC1(C1.APC, ESC)[index]) : String.format("[%s-%s", Sequences.getC1(C1.BPH, ESC)[index], Sequences.getC1(C1.APC, ESC)[index]));
        if (exclC1Set != null && exclC1Set.length > 0) {
            retStr.append("&&[^");
            for (Enum enum_ : exclC1Set) {
                retStr.append(Sequences.getC1((C1)enum_, ESC)[index]);
            }
            retStr.append("]");
        }
        retStr.append("]");
        return retStr.toString();
    }

    public static class Record
    implements Cloneable {
        public String pattern7;
        public String pattern8;

        public Record(String str7, String str8) {
            this.pattern7 = str7;
            this.pattern8 = str8;
        }

        public Record(String[] strs) {
            this.pattern7 = strs[0];
            this.pattern8 = strs[1];
        }

        public Record clone() {
            return new Record(this.pattern7, this.pattern8);
        }

        public String toString() {
            return String.format("%-35s : %-35s", this.pattern7, this.pattern8);
        }
    }

    public static enum Sym {
        SPCE("\\x20"),
        AT("\\x40"),
        A_UP("\\x41"),
        B_UP("\\x42"),
        C_UP("\\x43"),
        D_UP("\\x44"),
        E_UP("\\x45"),
        F_UP("\\x46"),
        G_UP("\\x47"),
        H_UP("\\x48"),
        I_UP("\\x49"),
        J_UP("\\x4A"),
        K_UP("\\x4B"),
        L_UP("\\x4C"),
        M_UP("\\x4D"),
        N_UP("\\x4E"),
        O_UP("\\x4F"),
        P_UP("\\x50"),
        Q_UP("\\x51"),
        R_UP("\\x52"),
        S_UP("\\x53"),
        T_UP("\\x54"),
        U_UP("\\x55"),
        V_UP("\\x56"),
        W_UP("\\x57"),
        X_UP("\\x58"),
        Y_UP("\\x59"),
        Z_UP("\\x5A"),
        QBRR("\\x5B"),
        BKSL("\\x5C"),
        QBRL("\\x5D"),
        CRET("\\x5E"),
        UNLN("\\x5F"),
        INAP("\\x60"),
        A_DN("\\x61"),
        B_DN("\\x62"),
        C_DN("\\x63"),
        D_DN("\\x64"),
        E_DN("\\x65"),
        F_DN("\\x66"),
        G_DN("\\x67"),
        H_DN("\\x68"),
        I_DN("\\x69"),
        J_DN("\\x6A"),
        K_DN("\\x6B"),
        L_DN("\\x6C"),
        M_DN("\\x6D"),
        N_DN("\\x6E"),
        O_DN("\\x6F"),
        STRK("\\x7C"),
        CBRR("\\x7D"),
        TWDL("\\x7E");

        private String symbol;

        private Sym(String sym) {
            this.symbol = sym;
        }

        public String toString() {
            return this.symbol;
        }
    }

    public static enum C1 {
        BPH,
        NBH,
        NEL,
        SSA,
        ESA,
        HTS,
        HTJ,
        VTS,
        PLD,
        PLU,
        RI,
        SS2,
        SS3,
        DCS,
        PU1,
        PU2,
        STS,
        CCH,
        MW,
        SPA,
        EPA,
        SOS,
        SCI,
        CSI,
        ST,
        OSC,
        PM,
        APC;

    }

    public static enum C0 {
        NUL,
        SOH,
        STX,
        ETX,
        EOT,
        ENQ,
        ACK,
        BEL,
        BS,
        HT,
        LF,
        VT,
        FF,
        CR,
        LS1,
        LS0,
        DLE,
        DC1,
        DC2,
        DC3,
        DC4,
        NAK,
        SYN,
        ETB,
        CAN,
        EM,
        SUB,
        ESC,
        IS4,
        IS3,
        IS2,
        IS1;

    }
}

