/*
 * Decompiled with CFR 0.152.
 */
package console;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import jcfunc.CF;
import jcfunc.Description;
import jcfunc.escMatcher;
import jcfunc.parameters.paramSGR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StringList;

public class AnsiEscapeParser {
    private Behaviour ansi_Behaviour;
    private escMatcher ansi_Matcher;
    private Color defaultFColor;
    private Color defaultBColor;

    public AnsiEscapeParser(int ansi_mode, Behaviour behaviour, CF[] func_arr, Color defFColor, Color defBColor) {
        this.ansi_Matcher = new escMatcher(ansi_mode, 32);
        this.setBehaviour(behaviour);
        this.setFunctions(func_arr);
        this.setDefaultFColor(defFColor);
        this.setDefaultBColor(defBColor);
    }

    public AnsiEscapeParser(Color defFColor, Color defBColor) {
        int i;
        int ansi_mode = jEdit.getIntegerProperty((String)"ansi-escape.mode", (int)0);
        switch (ansi_mode) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                ansi_mode = 0;
            }
        }
        Behaviour behaviour = Behaviour.PARSE;
        int bhvr = jEdit.getIntegerProperty((String)"ansi-escape.behaviour", (int)2);
        switch (bhvr) {
            case 0: {
                behaviour = Behaviour.IGNORE_ALL;
                break;
            }
            case 1: {
                behaviour = Behaviour.REMOVE_ALL;
                break;
            }
            case 2: {
                behaviour = Behaviour.PARSE;
                break;
            }
            default: {
                behaviour = Behaviour.PARSE;
            }
        }
        StringList funcs = StringList.split((String)jEdit.getProperty((String)"ansi-escape.func-list").toLowerCase(), (Object)"\\s+");
        String avaible_funcs = jEdit.getProperty((String)"ansi-escape.func-list-values");
        String str = "";
        for (i = 0; i < funcs.size(); ++i) {
            if (avaible_funcs.contains((CharSequence)funcs.get(i))) continue;
            str = (String)funcs.remove(i);
            str = null;
            --i;
        }
        CF[] func_arr = new CF[funcs.size()];
        for (i = 0; i < funcs.size(); ++i) {
            func_arr[i] = CF.valueOf(CF.class, ((String)funcs.get(i)).toUpperCase());
        }
        this.ansi_Matcher = new escMatcher(ansi_mode, 32);
        this.setBehaviour(behaviour);
        this.setFunctions(func_arr);
        this.setDefaultFColor(defFColor);
        this.setDefaultBColor(defBColor);
    }

    public boolean isBehaviour(Behaviour behaviour) {
        return this.ansi_Behaviour == behaviour;
    }

    public Behaviour getBehaviour() {
        return this.ansi_Behaviour;
    }

    public Color getDefaultFColor() {
        return this.defaultFColor;
    }

    public Color getDefaultBColor() {
        return this.defaultBColor;
    }

    public boolean matches(String line) {
        return this.ansi_Matcher.matches(line);
    }

    public ArrayList<Description> parse(String line) {
        return this.ansi_Matcher.parse(line);
    }

    public ArrayList<Description> parse(String line, boolean ignoreSequences) {
        return this.ansi_Matcher.parse(line, ignoreSequences);
    }

    public String remove(String line, CF func) {
        return this.ansi_Matcher.remove(line, func);
    }

    public String removeAll(String line) {
        return this.ansi_Matcher.removeAll(line);
    }

    public boolean touch(Behaviour behaviour, String line) {
        return this.ansi_Behaviour == behaviour && this.matches(line);
    }

    public void setBehaviour(Behaviour newBehaviour) {
        this.ansi_Behaviour = newBehaviour;
    }

    public void setDefaultFColor(Color newColor) {
        this.defaultFColor = newColor;
    }

    public void setDefaultBColor(Color newColor) {
        this.defaultBColor = newColor;
    }

    public void setFunctions(CF ... cmds) {
        this.ansi_Matcher.setPatterns(cmds);
    }

    public SimpleAttributeSet processSGRparameters(int[] parameters, SimpleAttributeSet baseAttrs) {
        SimpleAttributeSet funcAttrs = new SimpleAttributeSet(baseAttrs);
        int intensity = 0;
        Color clr = null;
        block22: for (int value : parameters) {
            paramSGR valSGR = paramSGR.getEnumValue(value);
            switch (valSGR) {
                case Reset: {
                    return null;
                }
                case Bright: {
                    intensity = 1;
                    continue block22;
                }
                case Faint: {
                    intensity = -1;
                    continue block22;
                }
                case Italic: {
                    StyleConstants.setItalic(funcAttrs, true);
                    continue block22;
                }
                case Underline_Single: 
                case Underline_Doubly: {
                    StyleConstants.setUnderline(funcAttrs, true);
                    continue block22;
                }
                case CrossedOut: {
                    StyleConstants.setStrikeThrough(funcAttrs, true);
                    continue block22;
                }
                case Normal_Int: {
                    intensity = 0;
                    continue block22;
                }
                case Normal_Style: {
                    StyleConstants.setItalic(funcAttrs, false);
                    continue block22;
                }
                case Underline_NGT: {
                    StyleConstants.setUnderline(funcAttrs, false);
                    continue block22;
                }
                case CrossedOut_NGT: {
                    StyleConstants.setStrikeThrough(funcAttrs, false);
                    continue block22;
                }
                case Color_Text_Black: 
                case Color_Text_Red: 
                case Color_Text_Green: 
                case Color_Text_Yellow: 
                case Color_Text_Blue: 
                case Color_Text_Magenta: 
                case Color_Text_Cyan: 
                case Color_Text_White: 
                case Color_Text_Reserved: {
                    clr = paramSGR.getColor(valSGR);
                    if (clr == null) {
                        clr = this.defaultFColor;
                    }
                    switch (intensity) {
                        case 1: {
                            clr = clr.darker();
                            break;
                        }
                        case -1: {
                            clr = clr.brighter();
                        }
                    }
                    StyleConstants.setForeground(funcAttrs, clr);
                    continue block22;
                }
                case Color_Bkgr_Black: 
                case Color_Bkgr_Red: 
                case Color_Bkgr_Green: 
                case Color_Bkgr_Yellow: 
                case Color_Bkgr_Blue: 
                case Color_Bkgr_Magenta: 
                case Color_Bkgr_Cyan: 
                case Color_Bkgr_White: 
                case Color_Bkgr_Reserved: {
                    clr = paramSGR.getColor(valSGR);
                    if (clr == null) {
                        clr = this.defaultBColor;
                    }
                    switch (intensity) {
                        case 1: {
                            clr = clr.darker();
                            break;
                        }
                        case -1: {
                            clr = clr.brighter();
                        }
                    }
                    StyleConstants.setBackground(funcAttrs, clr);
                    continue block22;
                }
            }
        }
        return funcAttrs;
    }

    public static enum Behaviour {
        IGNORE_ALL,
        REMOVE_ALL,
        PARSE;

    }
}

